<?php

namespace App\Http\Controllers\Admin;

use App\Models\AccreditationImages;
use App\Models\AccreditationPartnersCountriesCategoriesDetails;
use App\Models\DiplomasFiles;
use App\Models\OldUrls;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class DiplomasFilesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.diplomas_files.view');
    }


    function search(Request $request)
    {

        $data = $request->input();
        $diplomas_files = DiplomasFiles::select('diplomas_files.*','diplomas.name as diploma_name')->join('diplomas','diplomas.id','=','diplomas_files.diploma_id');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $diplomas_files = $diplomas_files->where('diplomas_files.id', '=', "$id");
        }
        if (isset($data['diploma_name']) && !empty($data['diploma_name'])) {
            $diploma_name = $data['diploma_name'];
            $diplomas_files = $diplomas_files->where('diplomas.name', 'LIKE', "%$diploma_name%");
        }
        if (isset($data['file']) && !empty($data['file'])) {
            $file = $data['file'];
            $diplomas_files = $diplomas_files->where('diplomas_files.file', 'LIKE', "%$file%");
        }
        if (isset($data['sort']) && !empty($data['sort'])) {
            $sort = $data['sort'];
            $diplomas_files = $diplomas_files->where('diplomas_files.sort', $sort);
        }
        if (isset($data['published']) && !empty($data['published'])) {
            $published = $data['published'];
            $diplomas_files = $diplomas_files->where('diplomas_files.published', $published);
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $diplomas_files = $diplomas_files->whereBetween('diplomas_files.createdtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }


        $iTotalRecords = $diplomas_files->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'diplomas_files.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'diplomas_files.id';
                break;
            case 1:
                $columnName = 'diplomas.name';
                break;
            case 2:
                $columnName = 'diplomas_files.file';
                break;
            case 3:
                $columnName = 'diplomas_files.sort';
                break;
            case 5:
                $columnName = 'diplomas_files.createdtime';
                break;

        }
        $search = $data['search']['value'];
        if ($search) {
            $diplomas_files = $diplomas_files->where(function ($q) use ($search) {
                $q->where('diplomas.name', 'LIKE', "%$search%")
                    ->orWhere('diplomas_files.file', 'LIKE', "%$search%")
                    ->orWhere('diplomas_files.id', '=', $search);
            });
        }

        $diplomas_files = $diplomas_files->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($diplomas_files as $diplomas_file) {
            $diplomas_file=makeDefaultImageGeneral($diplomas_file,'image');

            $records["data"][] = [
                $diplomas_file->id,
                $diplomas_file->diploma_name,
                $diplomas_file->file,
                $diplomas_file->sort,
                '<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $diplomas_file->id . '" type="checkbox" ' . ((!PerUser('users_active')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('users_active')) ? 'class="changeStatues"' : '') . ' ' . (($diplomas_file->published=="yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $post->id }}">
                                    <label for="checkbox-' . $diplomas_file->id . '">
                                    </label>
                                </div>
                            </td>',
                $diplomas_file->created_at->format('Y-m-d H:i:s'),

                '<div class="btn-group text-center" id="single-order-' . $diplomas_file->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('diplomas_files')) ? '<li>
                                            <a href="' . URL('admin/diplomas_files/' . $diplomas_file->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('diplomas_files')) ? '<li>
                                            <a class="delete_this" data-id="' . $diplomas_file->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('auth.diplomas_files.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $rules=array(
            'diploma_id' => 'required',
            'name' => 'required',
            'file' => 'required|mimes:pdf,doc,docx,xlsx,xls',
            'sort' => 'required',
        );
        $validator = Validator::make($request->all(),$rules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $active = (isset($data['active'])) ? 'yes' : 'no';
            $fileName = uploadFileToE3melbusiness($request->file('file'),false,'diplomas_files');
            $diplomas_files = new DiplomasFiles();
            $diplomas_files->diploma_id = $data['diploma_id'];
            $diplomas_files->name = $data['name'];
            $diplomas_files->sort = $data['sort'];
            $diplomas_files->file = $fileName;
            $diplomas_files->published = $active;
            if ($active == 'yes') {
                $diplomas_files->published_by = Auth::user()->id;
                $diplomas_files->published_at = date("Y-m-d H:i:s");
            }
            if ($active == 'no') {
                $diplomas_files->unpublished_by = Auth::user()->id;
                $diplomas_files->unpublished_at = date("Y-m-d H:i:s");
            }
            $diplomas_files->created_by = Auth::user()->id;
            if ($diplomas_files->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.diplomas_files'));
                return Redirect::to('admin/diplomas_files/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $diplomas_file = DiplomasFiles::find($id);


        return view('auth.diplomas_files.edit',compact('diplomas_file'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $diplomas_file = DiplomasFiles::find($id);
        $rules=array(
            'diploma_id' => 'required',
            'name' => 'required',
            'sort' => 'required',
        );
        if ( $request->file('file')){
            $rules['file']='required|mimes:pdf,doc,docx,xlsx,xls';
        }
        $validator = Validator::make($request->all(),$rules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            if ( $request->file('file')){
                $fileName = $request->file('file');
                $fileName = uploadFileToE3melbusiness($fileName,false,'diplomas_files');
                $diplomas_file->file = $fileName;
            }
            $published = (isset($data['active'])) ? 'yes' : 'no';
            $diplomas_file->diploma_id = $data['diploma_id'];
            $diplomas_file->name = $data['name'];
            $diplomas_file->sort = isset($data['sort'])?  $data['sort']:0;;
            if ($published == 'yes' && $diplomas_file->published=='no') {
                $diplomas_file->published_by = Auth::user()->id;
                $diplomas_file->published_at = date("Y-m-d H:i:s");
            }
            if ($published == 'no' && $diplomas_file->published=='yes') {
                $diplomas_file->unpublished_by = Auth::user()->id;
                $diplomas_file->unpublished_at = date("Y-m-d H:i:s");
            }
            $diplomas_file->published = $published;
            $diplomas_file->updated_by = Auth::user()->id;
            if ($diplomas_file->save()) {
                Session::flash('success', Lang::get('main.update') . Lang::get('main.diplomas_files'));
                return Redirect::to("admin/diplomas_files/$diplomas_file->id/edit");
            }
        }
    }

    public function deleteImage(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $accreditation_images = AccreditationImages::find($id);
            if (file_exists(assetURL($accreditation_images->image)))
                unlink(assetURL($accreditation_images->image));
            $accreditation_images->delete();
            return \response()->json(['status' => true, 'message' => 'success']);
        }
        else {
            return \response()->json(['status' => false, 'message' => 'can not delete!']);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $diplomas_file = DiplomasFiles::find($id);
        if (count($diplomas_file)) {
            $diplomas_file->deleted_by =auth()->id();
            $diplomas_file->save();
            $diplomas_file->delete();
        }
    }
    public function delete_file($id)
    {
        $diplomas_file = DiplomasFiles::find($id);
        if (count($diplomas_file)) {
            $diplomas_file->file=null;
            $diplomas_file->updated_by = Auth::user()->id;
            $diplomas_file->save();

        }
    }

    public function activation(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $active = $request->input('active');
            $diplomas_file = DiplomasFiles::find($id);
            if ($active == 'no') {
                $diplomas_file->published = 'no';
                $diplomas_file->unpublished_by = Auth::user()->id;
                $diplomas_file->unpublished_at = date("Y-m-d H:i:s");
            } elseif ($active == 'yes') {
                $diplomas_file->published = 'yes';
                $diplomas_file->published_by = Auth::user()->id;
                $diplomas_file->published_at = date("Y-m-d H:i:s");
            }
            $diplomas_file->save();
        } else {
            return redirect(404);
        }
    }
}
