<?php

namespace App\Http\Controllers\Admin;


use App\Models\Courses;
use App\Http\Controllers\Controller;
use App\Models\NormalUser;
use App\Models\DBAPreliminaryCoursesUsersPlan;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class DBAPreliminaryCoursesUserPlanController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $courses = Courses::select('courses.*')->get();
        return view('auth.dba_preliminary_courses_user_plan.view', compact('courses'));
    }

    function search(Request $request)
    {
        $data = $request->input();
        $dba_preliminary_courses_user_plan = DBAPreliminaryCoursesUsersPlan::select('dba_preliminary_courses_user_plan.*','courses.image', 'courses.name AS related_course_name',  'users.Email AS user_email')
            ->leftJoin('courses', 'related_course', '=', 'courses.id')
            ->leftJoin('users', 'user_id', '=', 'users.id');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $dba_preliminary_courses_user_plan = $dba_preliminary_courses_user_plan->where('dba_preliminary_courses_user_plan.id', '=', "$id");
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $dba_preliminary_courses_user_plan = $dba_preliminary_courses_user_plan->where('dba_preliminary_courses_user_plan.name', 'LIKE', "%$name%");
        }
        if (isset($data['pic']) && !empty($data['pic'])) {
            $pic = $data['pic'];
            $dba_preliminary_courses_user_plan = $dba_preliminary_courses_user_plan->where('courses.image', 'LIKE', "%$pic%");
        }
        if (isset($data['related_course']) && !empty($data['related_course'])) {
            $related_course_name = $data['related_course'];
            $dba_preliminary_courses_user_plan = $dba_preliminary_courses_user_plan->where('courses.name', 'LIKE', "%$related_course_name%");
        }

        if (isset($data['user']) && !empty($data['user'])) {
            $user = $data['user'];
            $dba_preliminary_courses_user_plan = $dba_preliminary_courses_user_plan->where('users.Email', 'LIKE', "%$user%");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $dba_preliminary_courses_user_plan = $dba_preliminary_courses_user_plan->whereBetween('dba_preliminary_courses_user_plan.created_at', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }


        $iTotalRecords = $dba_preliminary_courses_user_plan->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'dba_preliminary_courses_user_plan.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'dba_preliminary_courses_user_plan.id';
                break;
            case 1:
                $columnName = 'users.Email';
                break;
            case 2:
                $columnName = 'dba_preliminary_courses_user_plan.name';
                break;
            case 3:
                $columnName = 'courses.image';
                break;
            case 4:
                $columnName = 'courses.name';
                break;

            case 5:
                $columnName = 'dba_preliminary_courses_user_plan.created_at';
                break;
            case 6:
                $columnName = 'dba_preliminary_courses_user_plan.sort';
                break;

            case 7:
                $columnName = 'dba_preliminary_courses_user_plan.published';
                break;
        }
        $search = $data['search']['value'];
        if ($search) {
            $dba_preliminary_courses_user_plan = $dba_preliminary_courses_user_plan->where(function ($q) use ($search) {
                $q->where('dba_preliminary_courses_user_plan.name', 'LIKE', "%$search%")
                    ->orWhere('courses.image', 'LIKE', "%$search%")
                    ->orWhere('courses.name', 'LIKE', "%$search%")
                    ->orWhere('dba_preliminary_courses_user_plan.name', 'LIKE', "%$search%")
                    ->orWhere('users.Email', 'LIKE', "%$search%")
                    ->orWhere('dba_preliminary_courses_user_plan.id', '=', $search);
            });
        }

        $dba_preliminary_courses_user_plan = $dba_preliminary_courses_user_plan->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($dba_preliminary_courses_user_plan as $dba_preliminary_courses_user_plan) {
            $dba_preliminary_courses_user_plan=makeDefaultImageGeneral($dba_preliminary_courses_user_plan,'image');
            $related_course_name = $dba_preliminary_courses_user_plan->related_course_name;
            $user_email = $dba_preliminary_courses_user_plan->user_email;
            if(PerUser('courses_edit') && $related_course_name !=''){
                $related_course_name= '<a target="_blank" href="' . URL('admin/courses/' . $dba_preliminary_courses_user_plan->related_course . '/edit') . '">' . $related_course_name . '</a>';
            }
            if(PerUser('normal_user_edit') && $user_email !=''){
                $user_email= '<a target="_blank" href="' . URL('admin/normal_user/' . $dba_preliminary_courses_user_plan->user_id . '/edit') . '">' . $user_email . '</a>';
            }
            $records["data"][] = [
                $dba_preliminary_courses_user_plan->id,
                $user_email,
                $dba_preliminary_courses_user_plan->name,
                '<a class="image-link" href="#image-modal" data-toggle="modal"><img  style="width:100%;"  src="'.assetURL($dba_preliminary_courses_user_plan->image).'"></a>',
                $related_course_name,
                $dba_preliminary_courses_user_plan->createdtime,
                $dba_preliminary_courses_user_plan->sort,

                '<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $dba_preliminary_courses_user_plan->id . '" type="checkbox" ' . ((!PerUser('dbapcup_active')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('dbapcup_active')) ? 'class="changeStatues"' : '') . ' ' . (($dba_preliminary_courses_user_plan->published == "yes") ? 'checked="checked"' : '') . '  id="checkbox-'.$dba_preliminary_courses_user_plan->id.'">
                                    <label for="checkbox-' . $dba_preliminary_courses_user_plan->id . '">
                                    </label>
                                </div>
                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $dba_preliminary_courses_user_plan->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('dbapcup_edit')) ? '<li>
                                            <a href="' . URL('admin/dbapcup/' . $dba_preliminary_courses_user_plan->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('dbapcup_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $dba_preliminary_courses_user_plan->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));


    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $courses = Courses::select('courses.*')->get();
        return view('auth.dba_preliminary_courses_user_plan.add', compact( 'courses'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make($request->all(),
            array(
                'name' => 'required',
                 'pic' => 'required|mimes:jpeg,jpg,gif,bmp,png',
                'related_course' => 'required',
                'sort' => 'required',
                'user' => 'required|exists:mysql2.users,Email',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $active = (isset($data['active'])) ? 1 : 0;
            $user_id=NormalUser::where('Email', $data['user'])->first()->id;
            $dba_preliminary_courses_user_plan = new DBAPreliminaryCoursesUsersPlan();
            $pic = $request->file('pic');
            $picName = uploadFileToE3melbusiness($pic);
            $dba_preliminary_courses_user_plan->image = $picName;
            $dba_preliminary_courses_user_plan->name = $data['name'];
            $dba_preliminary_courses_user_plan->user_id = $user_id;
            $dba_preliminary_courses_user_plan->related_course = $data['related_course'];
            $dba_preliminary_courses_user_plan->duetime = $request->duetime;
            $dba_preliminary_courses_user_plan->sort = $request->sort;
            $dba_preliminary_courses_user_plan->published = $active;
            if ($active == 'yes') {
                $dba_preliminary_courses_user_plan->published_by = Auth::user()->id;
                $dba_preliminary_courses_user_plan->published_date = date("Y-m-d H:i:s");
            }
            if ($active == 'no') {
                $dba_preliminary_courses_user_plan->unpublished_by = Auth::user()->id;
                $dba_preliminary_courses_user_plan->unpublished_date = date("Y-m-d H:i:s");
            }
            $dba_preliminary_courses_user_plan->added_by = Auth::user()->id;
            $dba_preliminary_courses_user_plan->added_date = date("Y-m-d H:i:s");
            $dba_preliminary_courses_user_plan->lastedit_by = Auth::user()->id;
            $dba_preliminary_courses_user_plan->lastedit_date = date("Y-m-d H:i:s");
            if ($dba_preliminary_courses_user_plan->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.dba_preliminary_courses_user_plan'));
                return Redirect::to('admin/dbapcup/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $dba_preliminary_courses_user_plan  = DBAPreliminaryCoursesUsersPlan::findOrFail($id);
        $courses = Courses::select('courses.*')->get();
        $user=isset($module_course->user)?$dba_preliminary_courses_user_plan->user->Email:'';
        return view('auth.dba_preliminary_courses_user_plan.edit', compact( 'courses','dba_preliminary_courses_user_plan','user'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $dba_preliminary_courses_user_plan = DBAPreliminaryCoursesUsersPlan::findOrFail($id);
        $validator = Validator::make($request->all(),
            array(
                'name' => 'required',
                'related_course' => 'required',
                'user' => 'required|exists:mysql2.users,Email',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            if ($request->hasFile('pic')) {
                $pic = $request->file('pic');
                $picName = uploadFileToE3melbusiness($pic);
                $dba_preliminary_courses_user_plan->image = $picName;
            }
            $active = (isset($data['active'])) ? 1 : 0;
            $user_id=NormalUser::where('Email', $data['user'])->first()->id;
            $dba_preliminary_courses_user_plan->user_id = $user_id;
            $dba_preliminary_courses_user_plan->name = $data['name'];
            $dba_preliminary_courses_user_plan->duetime = $request->duetime;
            $dba_preliminary_courses_user_plan->related_course = $data['related_course'];
            $dba_preliminary_courses_user_plan->sort = $data['sort'];
            if ($active == 'yes' && $dba_preliminary_courses_user_plan->published=='no') {
                $dba_preliminary_courses_user_plan->published_by = Auth::user()->id;
                $dba_preliminary_courses_user_plan->published_date = date("Y-m-d H:i:s");
            }
            if ($active == 'no' && $dba_preliminary_courses_user_plan->published=='yes') {
                $dba_preliminary_courses_user_plan->unpublished_by = Auth::user()->id;
                $dba_preliminary_courses_user_plan->unpublished_date = date("Y-m-d H:i:s");
            }
            $dba_preliminary_courses_user_plan->published = $active;
            $dba_preliminary_courses_user_plan->lastedit_by = Auth::user()->id;
            $dba_preliminary_courses_user_plan->lastedit_date = date("Y-m-d H:i:s");
            if ($dba_preliminary_courses_user_plan->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.dba_preliminary_courses_user_plan'));
                return Redirect::to("admin/dbapcup/$dba_preliminary_courses_user_plan->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $dba_preliminary_courses_user_plan = DBAPreliminaryCoursesUsersPlan::find($id);
        if (count($dba_preliminary_courses_user_plan)) {
            $dba_preliminary_courses_user_plan->delete();

        }
    }

    public function activation(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $active = $request->input('active');
            $dba_preliminary_courses_user_plan = DBAPreliminaryCoursesUsersPlan::find($id);
            if ($active == 'no') {
                $dba_preliminary_courses_user_plan->published = 'no';
                $dba_preliminary_courses_user_plan->unpublished_by = Auth::user()->id;
                $dba_preliminary_courses_user_plan->unpublished_date = date("Y-m-d H:i:s");
            } elseif ($active == 'yes') {
                $dba_preliminary_courses_user_plan->published = 'yes';
                $dba_preliminary_courses_user_plan->published_by = Auth::user()->id;
                $dba_preliminary_courses_user_plan->published_date = date("Y-m-d H:i:s");
            }
            $dba_preliminary_courses_user_plan->save();
        } else {
            return redirect(404);
        }
    }
}
