<?php

namespace App\Http\Controllers\Admin;

use App\Models\Courses;
use App\Models\DBAPreliminaryCourses;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class DBAPreliminaryCourseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $courses=Courses::pluck('name','id')->toArray();
        return view('auth.dba_preliminary_courses.view',compact('courses'));
    }

    function search(Request $request)
    {
        $data = $request->input();
        $dba_preliminary_courses = DBAPreliminaryCourses::
           leftjoin('courses','courses.id','=','dba_preliminary_courses.related_course')
            ->select('dba_preliminary_courses.*','courses.name as related_course_name');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $dba_preliminary_courses = $dba_preliminary_courses->where('dba_preliminary_courses.id', '=', "$id");
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $dba_preliminary_courses = $dba_preliminary_courses->where('dba_preliminary_courses.name', 'LIKE', "%$name%");
        }

        if (isset($data['related_course']) && !empty($data['related_course'])) {
            $related_course = $data['related_course'];
            $dba_preliminary_courses = $dba_preliminary_courses->where('dba_preliminary_courses.related_course','=', $related_course);
        }
        if (isset($data['sort']) && !empty($data['sort'])) {
            $sort = $data['sort'];
            $dba_preliminary_courses = $dba_preliminary_courses->where('dba_preliminary_courses.sort','=', $sort);
        }

        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $dba_preliminary_courses = $dba_preliminary_courses->whereBetween('dba_preliminary_courses.created_at', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }
        $iTotalRecords = $dba_preliminary_courses->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'dba_preliminary_courses.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'dba_preliminary_courses.id';
                break;
            case 1:
                $columnName = 'dba_preliminary_courses.name';
                break;
            case 2:
                $columnName = 'dba_preliminary_courses.created_at';
                break;
            case  3:
                $columnName = 'dba_preliminary_courses.sort';
                break;

        }

        $search = $data['search']['value'];
        if ($search) {
            $dba_preliminary_courses = $dba_preliminary_courses->where(function ($q) use ($search) {
                $q->where('dba_preliminary_courses.name', 'LIKE', "%$search%")
                    ->orWhere('dba_preliminary_courses.id', '=', $search)
                    ->orWhere('courses.name', 'LIKE', "%$search%")
                    ->orWhere('dba_preliminary_courses.sort', '=', $search);
            });
        }
        $dba_preliminary_courses = $dba_preliminary_courses->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($dba_preliminary_courses as $course) {
            $course=makeDefaultImageGeneral($course,'image');
            $course_name = $course->related_course_name;

            if(PerUser('courses_edit') && $course_name !=''){
                $course_name= '<a target="_blank" href="' . URL('admin/courses/' . $course->related_course . '/edit') . '">' . $course_name . '</a>';
            }
            $records["data"][] = [
                $course->id,
                $course->name,
                $course->created_at,
                '<a class="image-link" href="#image-modal" data-toggle="modal"><img width="50%" src="' . assetURL($course->image) . '"/></a>',
                $course_name,
                $course->sort,
                '<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $course->id . '" type="checkbox" ' . ((!PerUser('dba_preliminary_courses_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('dba_preliminary_courses_publish')) ? 'class="changeStatues"' : '') . ' ' . (($course->published == "yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $post->id }}">
                                    <label for="checkbox-' . $course->id . '">
                                    </label>
                                </div>
                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $course->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('dba_preliminary_courses_edit')) ? '<li>
                                            <a href="' . URL('admin/dba_preliminary_courses/' . $course->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('dba_preliminary_courses_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $course->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $courses = Courses::get();
        return view('auth.dba_preliminary_courses.add', compact( 'courses'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();

        $rules = array(
            'name' => 'required',
            'description' => 'required',
            'image' => 'mimes:jpeg,jpg,png,gif|required|max:5000',
            'related_course' => 'required|exists:mysql2.courses,id',
            'sort' => 'required|integer',
            'type' => 'required',
        );

        if(isset($data['ksa_course'])){
            if ($data['type']=='according_to_country') {
                $rules['related_course_ksa'] = 'required_if:type,according_to_country|exists:mysql2.courses,id';
            }
        }


        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $pic = $request->file('image');
            $picName = uploadFileToE3melbusiness($pic);
            $course = new DBAPreliminaryCourses();
            $course->name = $data['name'];
            $course->type = $data['type'];
            $course->related_course = $data['related_course'];
            $course->related_course_ksa = ($data['type']=='according_to_country')?$data['related_course_ksa']:$data['related_course'];
            $course->sort = $data['sort'];
            $course->description = $data['description'];
            $course->published = $published;
            $course->image = $picName;
            $course->created_at = date("Y-m-d H:i:s");
            if ($published == 'yes') {
                $course->published_by = Auth::user()->id;
                $course->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no') {
                $course->unpublished_by = Auth::user()->id;
                $course->unpublished_date = date("Y-m-d H:i:s");
            }
            $course->lastedit_by = Auth::user()->id;
            $course->added_by = Auth::user()->id;
            $course->lastedit_date = date("Y-m-d H:i:s");
            $course->added_date = date("Y-m-d H:i:s");
            if ($course->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.dba_preliminary_courses'));
                return Redirect::to('admin/dba_preliminary_courses/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $course = DBAPreliminaryCourses::findOrFail($id);
        $courses = Courses::get();
        return view('auth.dba_preliminary_courses.edit', compact('courses','course'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $course = DBAPreliminaryCourses::findOrFail($id);
        $rules = array(
            'name' => 'required',
            'description' => 'required',
            'related_course' => 'required|exists:mysql2.courses,id',
            'sort' => 'required|integer',
            'type' => 'required',
        );
        if(isset($data['ksa_course'])){
            if ($data['type']=='according_to_country') {
                $rules['related_course_ksa'] = 'required_if:type,according_to_country|exists:mysql2.courses,id';
            }
        }


        if ($request->file('image')) {
            $rules['image'] = 'mimes:jpeg,jpg,png,gif|required|max:5000';
        }

        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $course->name = $data['name'];
            $course->type = $data['type'];
            $course->related_course = $data['related_course'];
            $course->related_course_ksa = ($data['type']=='according_to_country')?$data['related_course_ksa']:$data['related_course'];
            $course->sort = $data['sort'];
            $course->description = $data['description'];
            if ($request->file('image')) {
                $pic = $request->file('image');
                $picName = uploadFileToE3melbusiness($pic);
                $course->image = $picName;
            }
            if ($published == 'yes' && $course->published=='no') {
                $course->published_by = Auth::user()->id;
                $course->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no' && $course->published=='yes') {
                $course->unpublished_by = Auth::user()->id;
                $course->unpublished_date = date("Y-m-d H:i:s");
            }
            $course->published = $published;
            $course->lastedit_by = Auth::user()->id;
            $course->lastedit_date = date("Y-m-d H:i:s");
            if ($course->save()) {
                Session::flash('success', Lang::get('main.update') . Lang::get('main.dba_preliminary_courses'));
                return Redirect::to("admin/dba_preliminary_courses/$course->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $course = DBAPreliminaryCourses::findOrFail($id);
        $course->delete();
    }

    public function publish(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $published = $request->input('published');
            $course = DBAPreliminaryCourses::findOrFail($id);
            if ($published == 'no') {
                $course->published = 'no';
                $course->unpublished_by = Auth::user()->id;
                $course->unpublished_date = date("Y-m-d H:i:s");
            } elseif ($published == 'yes') {
                $course->published = 'yes';
                $course->published_by = Auth::user()->id;
                $course->published_date = date("Y-m-d H:i:s");
            }
            $course->save();
        } else {
            return redirect(404);
        }
    }
}
