<?php

namespace App\Http\Controllers\Admin;

use App\Models\DBAChecklist;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class DBAChecklistsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.dba_checklists.view');
    }

    function search(Request $request)
    {

        $data = $request->input();
        $dba_checklists = DBAChecklist::select('dba_checklists.*');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $dba_checklists = $dba_checklists->where('dba_checklists.id', '=', "$id");
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $dba_checklists = $dba_checklists->where('dba_checklists.name', 'LIKE', "%$name%");
        }

        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $dba_checklists = $dba_checklists->whereBetween('dba_checklists.createtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }




        $iTotalRecords = $dba_checklists->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'dba_checklists.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'dba_checklists.id';
                break;
            case 1:
                $columnName = 'dba_checklists.name';
                break;
            case 2:
                $columnName = 'dba_checklists.createtime';
                break;
        }
        $search = $data['search']['value'];
        if ($search) {
            $dba_checklists = $dba_checklists->where(function ($q) use ($search) {
                $q->where('dba_checklists.name', 'LIKE', "%$search%")
                    ->orWhere('dba_checklists.id', '=', $search);
            });
        }

        $dba_checklists = $dba_checklists->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($dba_checklists as $checklist) {
            $records["data"][] = [
                $checklist->id,
                $checklist->name,
                $checklist->createtime,
                '<div class="btn-group text-center" id="single-order-' . $checklist->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('dba_checklists_edit')) ? '<li>
                                            <a href="' . URL('admin/dba_checklists/' . $checklist->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('dba_checklists_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $checklist->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('auth.dba_checklists.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make($request->all(),
            array(
                'name' => 'required'
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $dba_checklists = new DBAChecklist();
            $dba_checklists->name = $data['name'];
            $dba_checklists->createtime = date("Y-m-d H:i:s");
            if ($dba_checklists->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.dba_checklists'));
                return Redirect::to('admin/dba_checklists/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $checklist = DBAChecklist::find($id);
        return view('auth.dba_checklists.edit',compact('checklist'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $checklist_record = DBAChecklist::find($id);
        $rules= array(
            'name' => 'required'
        );
        $validator = Validator::make($request->all(),$rules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $checklist_record->name = $data['name'];
            if ($checklist_record->save()) {
                Session::flash('success', Lang::get('main.update') . Lang::get('main.dba_checklists'));
                return Redirect::to("admin/dba_checklists/$checklist_record->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $checklist = DBAChecklist::find($id);
        if (count($checklist)) {
            $checklist->delete();

        }
    }

}
