<?php

namespace App\Http\Controllers\Admin;

use App\Models\DBACategory;
use App\Models\OldUrls;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class DBACategoriesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.dba_categories.view');
    }

    function search(Request $request)
    {

        $data = $request->input();
        $dba_categories = DBACategory::select('dba_categories.*');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $dba_categories = $dba_categories->where('dba_categories.id', '=', "$id");
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $dba_categories = $dba_categories->where('dba_categories.name', 'LIKE', "%$name%");
        }

        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $dba_categories = $dba_categories->whereBetween('dba_categories.createtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }




        $iTotalRecords = $dba_categories->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'dba_categories.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'dba_categories.id';
                break;
            case 1:
                $columnName = 'dba_categories.name';
                break;
            case 2:
                $columnName = 'dba_categories.createtime';
                break;
        }
        $search = $data['search']['value'];
        if ($search) {
            $dba_categories = $dba_categories->where(function ($q) use ($search) {
                $q->where('dba_categories.name', 'LIKE', "%$search%")
                    ->orWhere('dba_categories.id', '=', $search);
            });
        }

        $dba_categories = $dba_categories->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($dba_categories as $category) {
            $records["data"][] = [
                $category->id,
                $category->name,
                $category->createtime,
                '<div class="btn-group text-center" id="single-order-' . $category->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('dba_categories_edit')) ? '<li>
                                            <a href="' . URL('admin/dba_categories/' . $category->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('dba_categories_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $category->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '


                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('auth.dba_categories.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make($request->all(),
            array(
                'name' => 'required',
                'description' => 'required'
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $active = (isset($data['active'])) ? 'yes' : 'no';
            $dba_categories = new DBACategory();
            $dba_categories->name = $data['name'];
            $dba_categories->description = $data['description'];
            $dba_categories->createtime = date("Y-m-d H:i:s");
            if ($dba_categories->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.dba_categories'));
                return Redirect::to('admin/dba_categories/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $category = DBACategory::find($id);
        return view('auth.dba_categories.edit',compact('category'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $category = DBACategory::find($id);
        $rules= array(
            'name' => 'required',
            'description' => 'required'
        );
        $validator = Validator::make($request->all(),$rules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $category->name = $data['name'];
            $category->description = $data['description'];
            if ($category->save()) {
                Session::flash('success', Lang::get('main.update') . Lang::get('main.dba_categories'));
                return Redirect::to("admin/dba_categories/$category->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $category = DBACategory::find($id);
        if (count($category)) {
            $category->delete();

        }
    }

}
