<?php

namespace App\Http\Controllers\Admin;

use App\Models\Courses;
use App\Models\CustomChargeTransaction;
use App\Models\NormalUser;
use App\Models\Employee;
use App\Http\Controllers\Controller;
use Illuminate\Contracts\View\Factory;
use Illuminate\Foundation\Application;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\View\View;

class CustomChargeTransactionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Factory|Application|Response|View
     */
    public function index()
    {
        return view('auth.customs_charge_transaction.view');
    }

    function search(Request $request)
    {
        $data = $request->input();
        $transactions=CustomChargeTransaction::leftjoin('users', 'users.id', '=', 'custom_charge_transaction.user_id')
            ->select('custom_charge_transaction.*', 'users.Email');
        if($request->unihance){
            $transactions=$transactions->whereRaw("custom_charge_transaction.id IN(SELECT charge_id FROM unihance_custom_charge_transaction)");
        }
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $transactions = $transactions->where('custom_charge_transaction.id', '=', $id);
        }
        if (isset($data['amount']) && !empty($data['amount'])) {
            $amount = $data['amount'];
            $transactions = $transactions->where('custom_charge_transaction.amount', 'LIKE', "%$amount%");
        }
        if (isset($data['user']) && !empty($data['user'])) {
            $user = $data['user'];
            $transactions = $transactions->where('users.Email', 'LIKE', "%$user%");
        }
        if (isset($data['courses_count']) && !empty($data['courses_count'])) {
            $courses_count = $data['courses_count'];
            $transactions = $transactions->where('custom_charge_transaction.courses_count', '=', $courses_count);
        }
        if (isset($data['currency']) && !empty($data['currency'])) {
            $currency = $data['currency'];
            $transactions = $transactions->where('custom_charge_transaction.currency', 'LIKE', "%$currency%");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $transactions = $transactions->whereBetween('custom_charge_transaction.createtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }
        if (isset($data['start_date_from']) && !empty($data['start_date_from']) && isset($data['start_date_to']) && !empty($data['start_date_to'])) {
            $start_date_from = $data['start_date_from'];
            $start_date_to = $data['start_date_to'];
            $transactions = $transactions->whereBetween('custom_charge_transaction.start_date', [$start_date_from .' 00:00:00', $start_date_to.' 23:59:59']);
        }
        if (isset($data['end_date_from']) && !empty($data['end_date_from']) && isset($data['end_date_to']) && !empty($data['end_date_to'])) {
            $end_date_from = $data['end_date_from'];
            $end_date_to = $data['end_date_to'];
            $transactions = $transactions->whereBetween('custom_charge_transaction.end_date', [$end_date_from .' 00:00:00', $end_date_to.' 23:59:59']);
        }
        if (isset($data['automation_payment_method'])) {
            $automation_payment_method = $data['automation_payment_method'];
            $transactions = $transactions->where('custom_charge_transaction.automation_payment_method', '=', $automation_payment_method);
        }
        if (isset($data['suspend']) && !empty($data['suspend'])) {
            $suspend = $data['suspend'];
            $transactions = $transactions->where('custom_charge_transaction.suspend', '=', $suspend);
        }
        if (isset($data['suspend_date_from']) && !empty($data['suspend_date_from']) && isset($data['suspend_date_to']) && !empty($data['suspend_date_to'])) {
            $suspend_date_from = $data['suspend_date_from'];
            $suspend_date_to = $data['suspend_date_to'];
            $transactions = $transactions->whereBetween('custom_charge_transaction.suspend_date', [$suspend_date_from .' 00:00:00', $suspend_date_to.' 23:59:59']);
        }

        $iTotalRecords = $transactions->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'custom_charge_transaction.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'custom_charge_transaction.id';
                break;
            case 1:
                $columnName = 'users.Email';
                break;
            case 2:
                $columnName = 'custom_charge_transaction.courses_count';
                break;
            case 3:
                $columnName = 'custom_charge_transaction.amount';
                break;
            case 4:
                $columnName = 'custom_charge_transaction.currency';
                break;
            case 5:
                $columnName = 'custom_charge_transaction.createtime';
                break;
            case 6:
                $columnName = 'custom_charge_transaction.start_date';
                break;
            case 7:
                $columnName = 'custom_charge_transaction.end_date';
                break;
             case 8:
                $columnName = 'custom_charge_transaction.automation_payment_method';
                break;
            case 9:
                $columnName = 'custom_charge_transaction.suspend';
                break;
            case 10:
                $columnName = 'custom_charge_transaction.suspend_date';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $transactions = $transactions->where(function ($q) use ($search) {
                $q->where('custom_charge_transaction.amount', 'LIKE', "%$search%")
                    ->orWhere('custom_charge_transaction.currency', 'LIKE', "%$search%")
                    ->orWhere('custom_charge_transaction.courses_count', 'LIKE', "%$search%")
                    ->orWhere('users.Email', 'LIKE', "%$search%")
                    ->orWhere('custom_charge_transaction.automation_payment_method', '=', $search)
                    ->orWhere('custom_charge_transaction.id', '=', $search)
                    ->orWhere('custom_charge_transaction.suspend', '=', $search);
            });
        }

        $transactions = $transactions->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($transactions as $transaction) {
            $user = $transaction->Email;
            $custom = $transaction->custom_name;
            if(PerUser('normal_user_edit') && $user !=''){
                $user= '<a target="_blank" href="' . URL('admin/normal_user/' . $transaction->user_id . '/edit') . '">' . $user . '</a>';
            }
            $records["data"][] = [
                $transaction->id,
                $user,
                $transaction->courses_count,
               $transaction->amount,
                $transaction->currency,
                $transaction->createtime,
                $transaction->start_date,
                $transaction->end_date,
                $transaction->automation_payment_method,
                $transaction->suspend,
                $transaction->suspend_date,
//                '<td class="text-center">
//                                <div class="checkbox-nice checkbox-inline">
//                                    <input data-id="' . $transaction->id . '" type="checkbox" ' . ((!PerUser('custom_charge_transaction_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('custom_charge_transaction_publish')) ? 'class="changeStatues"' : '') . ' ' . (($transaction->published == "yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $post->id }}">
//                                    <label for="checkbox-' . $transaction->id . '">
//                                    </label>
//                                </div>
//                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $transaction->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('custom_charge_transaction_edit')) ? '<li>
                                            <a href="' . URL('admin/custom_ct/' . $transaction->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('custom_charge_transaction_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $transaction->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('custom_charge_transaction_copy')) ? '<li>
                                            <a href="'.URL('admin/custom_ct/copy/'.$transaction->id).'" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.copy') . '
                                            </a>
                                        </li>' : '') . '
                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return Factory|Application|Response|View
     */
    public function create()
    {
        $employees=Employee::pluck('username', 'id');
        return view('auth.customs_charge_transaction.add',compact('employees'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @return RedirectResponse|Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $rules=array(
            'user' => 'required|exists:mysql2.users,Email',
            'courses_count' => 'required|numeric',
            'amount' => 'required|min:0|numeric',
            'period' => 'required',
            'automation_payment_method' => 'required',
            'start_date' => 'required|date_format:"Y-m-d"',
            //'end_date' => 'required|date_format:"Y-m-d"',
            'subscribe_type' => 'required|in:free,paid,',
            'subscribe_country' => 'required|in:egy,ksa',
            'currency' => 'required',
        );
        if($request->file('attach')){
            $rules['attach']= 'mimes:jpeg,jpg,png,gif|required|max:5000';
        }
        $validator = Validator::make($request->all(),$rules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $user_id=NormalUser::where('Email', $data['user'])->first()->id;
            $custom_charge_transaction=CustomChargeTransaction::where('user_id',$user_id)
	            ->orderBy('end_date','DESC')->first();
            $start_date=date('Y-m-d H:i:s',strtotime($data['start_date']));
            $end_date=NULL;
            if(count($custom_charge_transaction)){
                if($custom_charge_transaction->end_date>$start_date){
                    $start_date=date('Y-m-d H:i:s',strtotime($custom_charge_transaction->end_date.' +1 day'));
                }
            }
            if($custom_charge_transaction->courses_count>$data['courses_count']){
                return redirect()->back()->withErrors('courses count is less than the previous charge');
            }
            $end_date=date('Y-m-d H:i:s',strtotime($start_date.' +'.$data['period'].' months'));

            $pending = (isset($data['pending'])) ? 1 : 0;
            $suspend = (isset($data['suspend'])) ? 1 : 0;
            $employee_id = (isset($data['employee'])) ? $data['employee'] : 0;
            $coupon_id = (isset($data['coupon_id'])) ? $data['coupon_id'] : 0;
            $custom_price = (isset($data['price'])) ? $data['price'] : 0;
            $transaction = new CustomChargeTransaction();
            $transaction->user_id = $user_id;
            $transaction->courses_count = $data['courses_count'] ?$data['courses_count']: 10;
            $transaction->period = $data['period'];
            $transaction->start_date = $start_date;
            $transaction->end_date = $end_date;
            $transaction->price = $custom_price;
            $transaction->pending = $pending;
            $transaction->subscrip_type = $data['subscribe_type'];
            $transaction->automation_payment_method = $data['automation_payment_method'];
            $transaction->amount = $data['amount'];
            $transaction->subscrip_country = $data['subscribe_country'];
            $transaction->currency = $data['currency'];
            $transaction->coupon_id = $coupon_id;
            $transaction->employee_id = $employee_id;
            $transaction->suspend = $suspend;
            if ($suspend == 1) {
                $transaction->suspend_date = date("Y-m-d H:i:s");
            }
            if ( $request->file('attach')){
                $attach = $request->file('attach');
                $attach_name = uploadFileToE3melbusiness($attach);
                $transaction->attach = $attach_name;
            }
            $transaction->createtime = date("Y-m-d H:i:s");
            $transaction->added_date = date("Y-m-d H:i:s");
            $transaction->added_by = Auth::user()->id;
            $transaction->lastedit_by = Auth::user()->id;
            $transaction->lastedit_date = date("Y-m-d H:i:s");
            if ($transaction->save()) {

                Session::flash('success', Lang::get('main.insert') . Lang::get('main.custom_charge_transaction'));
                return Redirect::to('admin/custom_ct/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return Factory|Application|Response|View
     */
    public function edit($id)
    {
        $transaction = CustomChargeTransaction::findOrFail($id);
        $transaction->start_date = date("Y-m-d", strtotime($transaction->start_date));
        $transaction->end_date = date("Y-m-d", strtotime($transaction->end_date));
        $employees=Employee::pluck('username', 'id');
        $user=isset($transaction->user)?$transaction->user->Email:'';
        return view('auth.customs_charge_transaction.edit', compact('transaction','employees','user'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param Request $request
     * @param  int $id
     * @return Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $transaction = CustomChargeTransaction::findOrFail($id);
        $old_custom_id = $transaction->custom_id;
        $rules=array(
            'user' => 'required|exists:mysql2.users,Email',
	        'courses_count' => 'required|numeric',
	        'amount' => 'required|min:0|numeric',
	        'period' => 'required',
            'automation_payment_method' => 'required',
            'start_date' => 'required|date_format:"Y-m-d"',
//            'end_date' => 'required|date_format:"Y-m-d"',
            'subscribe_type' => 'required|in:free,paid',
            'subscribe_country' => 'required|in:egy,ksa',
            'currency' => 'required',
        );
        if($request->file('attach')){
            $rules['attach']= 'mimes:jpeg,jpg,png,gif|required|max:5000';
        }
        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $user_id=NormalUser::where('Email', $data['user'])->first()->id;
            //$published = (isset($data['published'])) ? 'yes' : 'no';
            $pending = (isset($data['pending'])) ? 1 : 0;
            $suspend = (isset($data['suspend'])) ? 1 : 0;
            $employee_id = (isset($data['employee'])) ? $data['employee'] : 0;
            $coupon_id = (isset($data['coupon_id'])) ? $data['coupon_id'] : 0;
	        $start_date=date('Y-m-d H:i:s',strtotime($data['start_date']));
	        $end_date=$transaction->end_date;
            if($transaction->courses_count>$data['courses_count']){
                return redirect()->back()->withErrors('courses count is less than the previous charge');
            }

            $transaction->user_id = $user_id;
            $transaction->courses_count = $data['courses_count'];
            $transaction->price = $data['price'] ?:0;
            $transaction->period = $data['period'];
            $transaction->start_date = $start_date;
            $transaction->end_date = $end_date;
            $transaction->pending = $pending;
            $transaction->subscrip_type = $data['subscribe_type'];
            $transaction->automation_payment_method = $data['automation_payment_method'];
            $transaction->amount = $data['amount'];
            $transaction->subscrip_country = $data['subscribe_country'];
            $transaction->currency = $data['currency'];
            $transaction->coupon_id = $coupon_id;
            $transaction->employee_id = $employee_id;
            if ($transaction->suspend==0 && $suspend == 1) {
                $transaction->suspend_date = date("Y-m-d H:i:s");
            }
            $transaction->suspend = $suspend;
            if ( $request->file('attach')){
                $attach = $request->file('attach');
                $attach_name = uploadFileToE3melbusiness($attach);
                $transaction->attach = $attach_name;
            }
            $transaction->lastedit_by = Auth::user()->id;
            $transaction->lastedit_date = date("Y-m-d H:i:s");
            if ($transaction->save()) {
                Session::flash('success', Lang::get('main.update') . Lang::get('main.custom_charge_transaction'));
                return Redirect::to("admin/custom_ct/$transaction->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return Response
     */
    public function destroy($id)
    {
        $transaction = CustomChargeTransaction::findOrFail($id);
        $transaction->delete();
    }

//    public function publish(Request $request)
//    {
//        if ($request->ajax()) {
//            $id = $request->input('id');
//            $published = $request->input('published');
//            $transaction = CustomChargeTransaction::findOrFail($id);
//            if ($published == 'no') {
//                $transaction->published = 'no';
//                $transaction->unpublished_by = Auth::user()->id;
//                $transaction->unpublished_date = date("Y-m-d H:i:s");
//            } elseif ($published == 'yes') {
//                $transaction->published = 'yes';
//                $transaction->published_by = Auth::user()->id;
//                $transaction->published_date = date("Y-m-d H:i:s");
//            }
//            $transaction->save();
//        } else {
//            return redirect(404);
//        }
//    }
    public function copy($id)
    {
        $custom_charge_transaction = CustomChargeTransaction::findOrFail($id);
        $custom_charge_transaction->createtime = date("Y-m-d H:i:s");
        $custom_charge_transaction->replicate()->save();
        return Redirect::to('admin/custom_ct/'.$custom_charge_transaction->id.'/edit');
    }
//    public function addCourses($id,Request $request){
//        $custom_charge_transactions=CustomChargeTransaction::findOrFail($id);
//        $custom_id=$custom_charge_transactions->custom_id;
//        $user_id=$custom_charge_transactions->user_id;
//        $customs_courses=DiplomsCoursesUsersPlan::where('custom_id',$custom_id)->where('user_id',$user_id)->get();
//        foreach ($customs_courses as $customs_course){
//            $related_course=$customs_course->course_id;
//            $sort=$customs_course->sort;
//            $custom_user_course=customUserCourse::where('custom_id',$custom_id)->where('user_id',$user_id)->where('course_id',$related_course)->get();
//            if(!count($custom_user_course)){
//                $newcustomCourse=new customUserCourse();
//                $newcustomCourse->custom_id=$custom_id;
//                $newcustomCourse->course_id=$related_course;
//                $newcustomCourse->user_id=$user_id;
//                $newcustomCourse->createtime=date('Y-m-d H:i:s');
//                $newcustomCourse->sort=$sort;
//                $newcustomCourse->save();
//            }
//        }
//        return response()->json(['message'=>'<div class="alert alert-success"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>'.Lang::get('main.success_adding_custom_charge_transactions_courses').'</div>','success'=>true])->setCallback($request->input('callback'));
//    }

}
