<?php

namespace App\Http\Controllers\Admin;

use App\Models\AccreditationPartnersCountriesCategoriesDetails;
use App\Models\ActivityLog;
use App\Models\Diplomas;
use App\Exports\CurriculumQuestionsExport;
use App\Exports\WebsiteActivityReportExport;
use App\Models\NormalUser;
use App\Models\Webinars;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Lang;
use Illuminate\Http\Request;
use App\Http\Requests\SEOSiteMapRequest;
use App\Models\UsersSystems;
use App\Models\AppSettings;
use App\Models\SEOSiteMap;
use App\Models\SubscriptionPrices;
use App\Models\User;
use Maatwebsite\Excel\Facades\Excel;

class AdminController extends Controller
{
    //
    public function __construct() {
        $this->middleware('auth');
    }

    public function home() {
        return view('auth.home');
    }

    public function profile() {
        return view('auth.users.profile');
    }

    public function profilePost(Request $request) {
        $data = $request->input();
        $validator = Validator::make($request->all(),
            array(
                'name' => 'required',
                'email' => 'required|unique:admin_system_users,email,' . Auth::id(),
                'username' => 'required|unique:admin_system_users,username,' . Auth::id(),
                'old_password' => 'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            if (Hash::check($request->input('old_password'), Auth::user()->password)) {
                $user = User::find(Auth::user()->id);
                if ($request->hasFile('image')) {
                    $rules = array('image' => 'required|image|mimes:jpeg,gif,bmp,png');
                    $validator = Validator::make(array('image' => $request->file('image')), $rules);
                    if ($validator->fails()) {
                        return redirect()->back()->withErrors($validator->errors())->withInput();
                    }
                    if (file_exists(public_path() . $user->img_dir . $user->img)) {
                        unlink(public_path() . $user->img_dir . $user->img);
                    }
                    if (file_exists(public_path() . $user->img_dir . 'thumbnail/thumbnail_' . $user->img)) {
                        unlink(public_path() . $user->img_dir . 'thumbnail/thumbnail_' . $user->img);
                    }
                    $file = $request->file('image');
                    $image = FileImage($file, 'Users');
                    $user->img = $image['img'];
                    $user->img_dir = $image['img_dir'];
                }
                $user->name = $request->input('name');
                $user->username = $request->input('username');
                $user->email = $request->input('email');
                if (!empty($request->input('new_password'))) {
                    $user->password = Hash::make($request->input('new_password'));
                }
                if ($user->save()) {
                    Session::flash('success', Lang::get('main.updated'));
                    return Redirect::to('admin/profile');
                }
            } else {
                Session::flash('error', Lang::get('main.error_user_password'));
                return Redirect::to('admin/profile');
            }
        }
    }

    public function system() {
        $system = UsersSystems::where('user_id', Auth::user()->id)->first();
        if (!count((array)$system)) {
            $system = new UsersSystems();
            $system->user_id = Auth::user()->id;
            $system->save();
        }
        return view('auth.settings.system', compact('system'));
    }

    public function systemPost(Request $request) {
        $system = UsersSystems::where('user_id', Auth::user()->id)->first();
        if (!count($system)) {
            $system = new UsersSystems();
            $system->user_id = Auth::user()->id;
            $system->save();
        }

        $data = $request->input();;
        $validator = Validator::make($request->all(),
            array(
                'backend_lang' => 'required',
                'backend_color' => 'required',
                'backend_layout' => 'required',
                'backend_header' => 'required',
                'backend_top_menu_dropdown' => 'required',
                'backend_sidebar_menu_mode' => 'required',
                /*'backend_sidebar_menu_sub_show'=>'required',*/
                'backend_sidebar_menu_style' => 'required',
                'backend_sidebar_menu_position' => 'required',
                'backend_footer' => 'required',

            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $system->backend_lang = $data['backend_lang'];
            $system->backend_color = $data['backend_color'];
            $system->backend_layout = $data['backend_layout'];
            $system->backend_header = $data['backend_header'];
            $system->backend_top_menu_dropdown = $data['backend_top_menu_dropdown'];
            $system->backend_sidebar_menu_mode = $data['backend_sidebar_menu_mode'];
            /*$system->backend_sidebar_menu_sub_show=$data['backend_sidebar_menu_sub_show'];*/
            $system->backend_sidebar_menu_style = $data['backend_sidebar_menu_style'];
            $system->backend_sidebar_menu_position = $data['backend_sidebar_menu_position'];
            $system->backend_footer = $data['backend_footer'];
            $system->lastedit_by = Auth::user()->id;
            $system->lastedit_date = date('Y-m-d H:i:s');
            if ($system->save()) {
                Session::flash('success', Lang::get('main.updated'));
                return Redirect::to('admin/system');
            }
        }
    }

    public function AppSettings() {
        $app_settings = AppSettings::find(1);
        $accreditations = AccreditationPartnersCountriesCategoriesDetails::
//        where('place','outer')->
where('type','accreditaion')->
        get()->pluck('title', 'id');

        return view('auth.app_settings.edit', compact('app_settings','accreditations'));
    }

    public function AppSettingsEdit(Request $request) {
        $data = $request->input();
        $app_settings = AppSettings::find(1);
        $rules=  array(
            'easy_question_percentage' => 'required|max:3',
            'normal_question_percentage' => 'required|max:3',
            'hard_question_percentage' => 'required|max:3',
            'dollar_rate' => 'required',
        );
        if ($request->file('mba_brochure_file')) {
            $rules['mba_brochure_file'] = 'mimes:pdf,doc,docx,xlsx,xls|max:5000';
        }
        if ($request->file('website_brochure_file')) {
            $rules['website_brochure_file'] = 'mimes:pdf,doc,docx,xlsx,xls|max:5000';
        }
        $validator = Validator::make($request->all(),$rules);


        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $max = 100;
            if ($request->file('mba_brochure_file')) {
                $brochure = $request->file('mba_brochure_file');
                $brochureName = uploadFileToE3melbusiness($brochure,false,'',false,false,true);
                $app_settings->mba_brochure_file = $brochureName;
            }
            if ($request->file('website_brochure_file')) {
                $brochure1 = $request->file('website_brochure_file');
                $brochureName1 = uploadFileToE3melbusiness($brochure1,false,'',false,false,true);
                $app_settings->website_brochure_file = $brochureName1;
            }
            $app_settings->easy_question_percentage = $data['easy_question_percentage'];
            $app_settings->normal_question_percentage = $data['normal_question_percentage'];
            $app_settings->hard_question_percentage = $data['hard_question_percentage'];
            $app_settings->dollar_rate = $data['dollar_rate'];
            if (($data['easy_question_percentage'] + $data['normal_question_percentage'] + $data['hard_question_percentage']) != $max) {
                $message = 'The three inputs must be equal 100%';
                return redirect()->back()->withErrors($message)->withInput();
            } else {
                if ($app_settings->save()) {
                    if(isset($data['course_accreditation'])){
                        $accreditations=(array)$data['course_accreditation'];
                        $pivotData = array_fill(0, count($accreditations), ['type' => 'course','details_id'=>$app_settings->id]);
                        $syncData  = array_combine($accreditations, $pivotData);
                        $app_settings->courseAccreditation()->sync($syncData);

                    }

                    if(isset($data['dba_accreditation'])){
                        $dba_accreditations=(array)$data['dba_accreditation'];
                        $dba_pivotData = array_fill(0, count($dba_accreditations), ['type' => 'dba','details_id'=>$app_settings->id]);
                        $DBAsyncData  = array_combine($dba_accreditations, $dba_pivotData);
                        $app_settings->dbaAccreditation()->sync($DBAsyncData);

                    }

                    if(isset($data['mba_accreditation'])){

                        $accreditations=(array)$data['mba_accreditation'];
                        $pivotData = array_fill(0, count($accreditations), ['type' => 'mba','details_id'=>$app_settings->id]);
                        $syncData  = array_combine($accreditations, $pivotData);
                        $app_settings->mbaAccreditation()->sync($syncData);

                    }
                    if(isset($data['new_mba_accreditation'])){
                        $accreditations=(array)$data['new_mba_accreditation'];
                        $pivotData = array_fill(0, count($accreditations), ['type' => 'new_mba','details_id'=>$app_settings->id]);
                        $syncData  = array_combine($accreditations, $pivotData);
                        $app_settings->newmbaAccreditation()->sync($syncData);

                    }

                    Session::flash('success', Lang::get('main.updated'));
                    return Redirect::to('admin/app_settings');
                }
            }
        }
    }
    public function delete_file() {
        $app_settings = AppSettings::find(1);
            $app_settings->mba_brochure_file = null;
        if ($app_settings->save()) {
            Session::flash('success', Lang::get('main.updated'));
            return Redirect::to('admin/app_settings');
        }

    } public function delete_website_file() {
        $app_settings = AppSettings::find(1);
            $app_settings->website_brochure_file = null;
        if ($app_settings->save()) {
            Session::flash('success', Lang::get('main.updated'));
            return Redirect::to('admin/app_settings');
        }

    }

    public function SEOStieMap() {
        $seo_sitemap = SEOSiteMap::all();
        return view('auth.seo_sitemap.seo_sitemap', compact('seo_sitemap'));
    }

    public function SEOStieMapEdit(SEOSiteMapRequest $request) {
        foreach ($request->input('priority') as $key => $value) {
            SEOSiteMap::where('name', $key)->update(['priority' => $value]);
        }

        return response()->json('success', 200);
    }

    public function subscriptionPrices() {
        $subscription_prices = SubscriptionPrices::find(1);
        $diplomas= Diplomas::select('id','name','egy_price','ksa_price')->get();
        return view('auth.subscription_prices.edit', compact('subscription_prices','diplomas'));
    }

    public function subscriptionPricesEdit(Request $request) {
        $data = $request->input();
        $subscription_prices = SubscriptionPrices::find(1);
        $validator = Validator::make($request->all(),
            array(
                'diplomas_prices' => 'required|numeric',
                'lifetime_new' => 'required|numeric',
                'lifetime_renew' => 'required|numeric',
                'mba' => 'required|numeric',
                'dba' => 'required|numeric',
                'package' => 'required|numeric',
                'diploma_price.*' => 'required|numeric',
            ),
            array(
                'diploma_price.*.required'=>'The diplomas prices are required',
                'diploma_price.*.numeric'=>'The diploma price must be a number',
            )
        );
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $subscription_prices->diplomas_prices = $data['diplomas_prices'];
            $subscription_prices->livediplomas_prices = $data['diplomas_prices'];
            $subscription_prices->lifetime_new = $data['lifetime_new'];
            $subscription_prices->lifetime_renew = $data['lifetime_renew'];
            $subscription_prices->mba = $data['mba'];
            $subscription_prices->dba = $data['dba'];
            $subscription_prices->package = $data['package'];
            if ($subscription_prices->save()) {
                foreach ($data['diploma_price'] as $id=>$price){
                    $diploma=Diplomas::find($id);
                    if($diploma) {
                        $diploma->ksa_price = $price;
                        $diploma->save();
                    }
                }
                Session::flash('success', Lang::get('main.updated'));
                return Redirect::to('admin/subscription_prices');
            }

        }
    }
    public function websiteActivityReport(Request $request){

        if($request->ajax()||$request->type=='export'){
            $data = $request->input();
            $activity_logs=DB::table(env('DB_DATABASE2').'.activity_log')
            ;
            if (isset($data['user_id']) && !empty($data['user_id'])) {
                $user_id = $data['user_id'];
                $activity_logs = $activity_logs->where(env('DB_DATABASE2').'.activity_log.user_id',$user_id);
            }
            if (isset($data['user_name']) && !empty($data['user_name'])) {
                $user_name = $data['user_name'];
                $activity_logs = $activity_logs->where(env('DB_DATABASE2').'.activity_log.user_name', 'LIKE', "%$user_name%");
            }
            if (isset($data['user_email']) && !empty($data['user_email'])) {
                $user_email = $data['user_email'];
                $activity_logs = $activity_logs->where(env('DB_DATABASE2').'.activity_log.user_email', 'LIKE', "%$user_email%");
            }
            if (isset($data['user_action']) && !empty($data['user_action'])) {
                $user_action = $data['user_action'];
                $activity_logs = $activity_logs->where(env('DB_DATABASE2').'.activity_log.user_action', 'LIKE', "%$user_action%");
            }
            if (isset($data['ip']) && !empty($data['ip'])) {
                $ip = $data['ip'];
                $activity_logs = $activity_logs->where(env('DB_DATABASE2').'.activity_log.ip',$ip);
            }
            if (isset($data['action_link']) && !empty($data['action_link'])) {
                $action_link = $data['action_link'];
                $activity_logs = $activity_logs->where(env('DB_DATABASE2').'.activity_log.action_link', 'LIKE', "%$action_link%");
            }
            if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
                $created_time_from = $data['created_time_from'];
                $created_time_to = $data['created_time_to'];
                $activity_logs = $activity_logs->whereBetween(env('DB_DATABASE2').'.activity_log.created_at', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
            }
            if($request->type=='export'){
                //return Excel::download(new WebsiteActivityReportExport(), 'Courses_Questions.xlsx');
                return Excel::create('users-activities-'.time(), function($excel)use($activity_logs) {
                    // Set the title
                    $excel->setTitle('Our new awesome title');
                    // Chain the setters
                    $excel->setCreator('Maatwebsite')
                        ->setCompany('Maatwebsite');

                    // Call them separately
                    $excel->setDescription('A demonstration to change the file properties');
                    $excel->sheet('Sheetname', function($sheet)use($activity_logs) {

                        $sheet->fromModel(collect($activity_logs->get())->map(function ($item){
                            return get_object_vars($item);
                        })->toArray());
                        //$sheet->fromArray($activity_logs->get(), null, 'A1', false, false);
                    });
                })->download('xls');
            }
            $iTotalRecords = $activity_logs->count();

            $iDisplayLength = intval($data['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($data['start']);
            $sEcho = intval($data['draw']);
            $records = [];
            $records["data"] = [];
            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;
            $columnName = env('DB_DATABASE2').'.activity_log.user_id';
            switch ($data['order'][0]['column']) {
                case 0:
                    $columnName = env('DB_DATABASE2').'.activity_log.user_id';
                    break;
                case 1:
                    $columnName = env('DB_DATABASE2').'.activity_log.user_name';
                    break;
                case 2:
                    $columnName = env('DB_DATABASE2').'.activity_log.user_email';
                    break;
                case 3:
                    $columnName = env('DB_DATABASE2').'.activity_log.user_action';
                    break;
                case 4:
                    $columnName = env('DB_DATABASE2').'.activity_log.ip';
                    break;
                case 5:
                    $columnName = env('DB_DATABASE2').'.activity_log.action_link';
                    break;
                case 6:
                    $columnName = env('DB_DATABASE2').'.activity_log.created_at';
                    break;
            }
            $search = $data['search']['value'];
            if ($search) {
                $activity_logs = $activity_logs->where(function ($q) use ($search) {
                    $q->where(env('DB_DATABASE2').'.activity_log.user_name', 'LIKE', "%$search%")
                        ->orWhere(env('DB_DATABASE2').'.activity_log.user_email', 'LIKE', "%$search%")
                        ->orWhere(env('DB_DATABASE2').'.activity_log.ip', 'LIKE', "%$search%")
                       ;
                });
            }

            $activity_logs = $activity_logs->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
                ->get();

            foreach ($activity_logs as $activity_log) {
                $records["data"][] = [
                    $activity_log->user_id,
                    $activity_log->user_name,
                    $activity_log->user_email,
                    $activity_log->user_action,
                    $activity_log->ip,
                    $activity_log->action_link,
                    $activity_log->created_at,
                   '',
                ];
            }
            if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
                $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
            }
            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;
            $records['postData'] = $data;
            //return response()->json($data)->setCallback($request->input('callback'));
            return response()->json($records)->setCallback($request->input('callback'));
        }
        return view('auth.website_activity_report');
    }
    public function activityReport(Request $request){
        if($request->ajax()){
            $data = $request->input();
            $activity_logs=DB::table(env('DB_DATABASE2').'.activity_log')
                ->select(DB::raw('DISTINCT '.env('DB_DATABASE2').'.activity_log.user_id'),env('DB_DATABASE2').'.activity_log.user_name',env('DB_DATABASE2').'.activity_log.user_email',env('DB_DATABASE2').'.activity_log.ip')
                ->join(env('DB_DATABASE').'.admin_activity_log',env('DB_DATABASE').'.admin_activity_log.ip','=',env('DB_DATABASE2').'.activity_log.ip')
            ;

//            if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
//                $created_time_from = $data['created_time_from'];
//                $created_time_to = $data['created_time_to'];
//                $activity_logs1 = $activity_logs1->whereBetween('created_at', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
//                $activity_logs2 = $activity_logs2->whereBetween('created_at', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
//            }
            if (isset($data['user_id']) && !empty($data['user_id'])) {
                $user_id = $data['user_id'];
                $activity_logs = $activity_logs->where(env('DB_DATABASE2').'.activity_log.user_id',$user_id);
            }
            if (isset($data['user_name']) && !empty($data['user_name'])) {
                $user_name = $data['user_name'];
                $activity_logs = $activity_logs->where(env('DB_DATABASE2').'.activity_log.user_name', 'LIKE', "%$user_name%");
            }
            if (isset($data['ip']) && !empty($data['ip'])) {
                $ip = $data['ip'];
                $activity_logs = $activity_logs->where(env('DB_DATABASE2').'.activity_log.ip',$ip);
            }


            $iTotalRecords = $activity_logs->count();

            $iDisplayLength = intval($data['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($data['start']);
            $sEcho = intval($data['draw']);
            $records = [];
            $records["data"] = [];
            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;
            $columnName = env('DB_DATABASE2').'.activity_log.user_id';
            switch ($data['order'][0]['column']) {
                case 0:
                    $columnName = env('DB_DATABASE2').'.activity_log.user_id';
                    break;
                case 1:
                    $columnName = env('DB_DATABASE2').'.activity_log.user_name';
                    break;
                case 2:
                    $columnName = env('DB_DATABASE2').'.activity_log.user_email';
                    break;
                case 3:
                    $columnName = env('DB_DATABASE2').'.activity_log.ip';
                    break;
            }
            $search = $data['search']['value'];
            if ($search) {
                $activity_logs = $activity_logs->where(function ($q) use ($search) {
                    $q->where(env('DB_DATABASE2').'.activity_log.user_name', 'LIKE', "%$search%")
                        ->orWhere(env('DB_DATABASE2').'.activity_log.user_email', 'LIKE', "%$search%")
                        ->orWhere(env('DB_DATABASE2').'.activity_log.ip', 'LIKE', "%$search%")
                       ;
                });
            }

            $activity_logs = $activity_logs->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
                ->get();

            foreach ($activity_logs as $activity_log) {
                $records["data"][] = [
                    $activity_log->user_id,
                    $activity_log->user_name,
                    $activity_log->user_email,
                    $activity_log->ip,
                   '<a target="_blank" href="'.URL('admin/admin_activity_report/details?user_id='.$activity_log->user_id.'&ip_address='.$activity_log->ip).'"><i style="color: blue;" class="fa fa-external-link"></i></a>',
                ];
            }
            if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
                $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
            }
            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;
            $records['postData'] = $data;
            //return response()->json($data)->setCallback($request->input('callback'));
            return response()->json($records)->setCallback($request->input('callback'));
        }
        return view('auth.activity_report');
    }
    public function activityReportDetails(Request $request){
        if($request->user_id&&$request->ip_address){
            $user=NormalUser::find($request->user_id);
            $hasActivity=DB::table(env('DB_DATABASE2').'.activity_log')->where('user_id',$request->user_id)->where('ip',$request->ip_address)->count();
            if($user&&$hasActivity){
                if($request->ajax()){
                    $data = $request->input();
                    $table=$request->type=='website'?env('DB_DATABASE2').'.activity_log':env('DB_DATABASE').'.admin_activity_log';
                    $activity=DB::table($table)->select($table.'.created_at',$table.'.user_name',$table.'.user_action',$table.'.action_link')
                        ->where($table.'.ip',$request->ip_address);
                    if($request->type=='website'){
                        $activity=$activity->where('user_id',$user->id);
                    }

                    if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
                        $created_time_from = $data['created_time_from'];
                        $created_time_to = $data['created_time_to'];
                        $activity = $activity->whereBetween($table.'.created_at', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
                    }
                    if (isset($data['user_name']) && !empty($data['user_name'])) {
                        $user_name= $data['user_name'];
                        $activity = $activity->where($table.'.user_name', 'LIKE', "%$user_name%");
                    }
                    if (isset($data['user_action']) && !empty($data['user_action'])) {
                        $user_action= $data['user_action'];
                        $activity = $activity->where($table.'.user_action', 'LIKE', "%$user_action%");
                    }
                    if (isset($data['user_link']) && !empty($data['user_link'])) {
                        $user_link= $data['user_link'];
                        $activity = $activity->where($table.'.user_link', 'LIKE', "%$user_link%");
                    }

                    $iTotalRecords = $activity->count();
                    $iDisplayLength = intval($data['length']);
                    $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
                    $iDisplayStart = intval($data['start']);
                    $sEcho = intval($data['draw']);
                    $records = [];
                    $records["data"] = [];
                    $end = $iDisplayStart + $iDisplayLength;
                    $end = $end > $iTotalRecords ? $iTotalRecords : $end;
                    $columnName = $table.'.created_at';
                    switch ($data['order'][0]['column']) {
                        case 0:
                            $columnName = $table.'.created_at';
                            break;
                        case 1:
                            $columnName = $table.'.user_name';
                            break;
                        case 2:
                            $columnName = $table.'.user_action';
                            break;
                        case 3:
                            $columnName = $table.'.action_link';
                            break;
                    }
                    $search = $data['search']['value'];
                    if ($search) {
                        $activity = $activity->where(function ($q) use ($search,$table) {
                            $q->where($table.'.user_name', 'LIKE', "%$search%")
                                ->orWhere($table.'.user_action', 'LIKE', "%$search%")
                                ->orWhere($table.'.action_link', 'LIKE', "%$search%")
                            ;
                        });
                    }

                    $activity = $activity->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
                        ->get();

                    foreach ($activity as $item) {
                        $records["data"][] = [
                            $item->created_at,
                            $item->user_name,
                            $item->user_action,
                            $item->action_link,
                            '',
                        ];
                    }
                    if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
                        $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
                        $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
                    }
                    $records["draw"] = $sEcho;
                    $records["recordsTotal"] = $iTotalRecords;
                    $records["recordsFiltered"] = $iTotalRecords;
                    $records['postData'] = $data;
                    //return response()->json($data)->setCallback($request->input('callback'));
                    return response()->json($records)->setCallback($request->input('callback'));


                }
                return view('auth.activity_report_details',compact('user'));
            }
        }
        return abort(404);
    }
}
