<?php

namespace App\Http\Controllers\Admin;

use App\Models\AccreditationPartnersCountriesCategories;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class AccreditationPartnersCountriesCategoriesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('auth.accreditation_partners_countries_categories.view');
    }


    function search(Request $request)
    {

        $data = $request->input();

        $accreditation_partners_countries_categories = AccreditationPartnersCountriesCategories::select('accreditation_partners_countries_categories.*');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $accreditation_partners_countries_categories = $accreditation_partners_countries_categories->where('accreditation_partners_countries_categories.id', '=', "$id");
        }
        if (isset($data['title']) && !empty($data['title'])) {
            $title = $data['title'];
            $accreditation_partners_countries_categories = $accreditation_partners_countries_categories->where('accreditation_partners_countries_categories.title', 'LIKE', "%$title%");
        }
        if (isset($data['url']) && !empty($data['url'])) {
            $url = $data['url'];
            $accreditation_partners_countries_categories = $accreditation_partners_countries_categories->where('accreditation_partners_countries_categories.url', 'LIKE', "%$url%");
        }
        if (isset($data['type']) && !empty($data['type'])) {
            $type = $data['type'];
            $accreditation_partners_countries_categories = $accreditation_partners_countries_categories->where('accreditation_partners_countries_categories.type',$type);
        }if (isset($data['partner_country_type']) && !empty($data['partner_country_type'])) {
            $partner_country_type = $data['partner_country_type'];
            $accreditation_partners_countries_categories = $accreditation_partners_countries_categories->where('accreditation_partners_countries_categories.partner_country_type',$partner_country_type);
        }
        $iTotalRecords = $accreditation_partners_countries_categories->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'accreditation_partners_countries_categories.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'accreditation_partners_countries_categories.id';
                break;
            case 1:
                $columnName = 'accreditation_partners_countries_categories.type';
                break;
            case 2:
                $columnName = 'accreditation_partners_countries_categories.title';
                break;
            case 3:
                $columnName = 'accreditation_partners_countries_categories.url';
                break;

        }
        $search = $data['search']['value'];
        if ($search) {
            $accreditation_partners_countries_categories = $accreditation_partners_countries_categories->where(function ($q) use ($search) {
                $q->where('accreditation_partners_countries_categories.title', 'LIKE', "%$search%")
                    ->orWhere('accreditation_partners_countries_categories.type', 'LIKE', "%$search%")
                    ->orWhere('accreditation_partners_countries_categories.url', 'LIKE', "%$search%")
                ;
            });
        }

        $accreditation_partners_countries_categories = $accreditation_partners_countries_categories->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($accreditation_partners_countries_categories as $accreditation_partners_countries_categories) {
            $records["data"][] = [
                $accreditation_partners_countries_categories->id,
                $accreditation_partners_countries_categories->type,
                $accreditation_partners_countries_categories->title,
                $accreditation_partners_countries_categories->url,
                '<td class="text-center">
                                <div class="checkbox-nice checkbox-inline">
                                    <input data-id="' . $accreditation_partners_countries_categories->id . '" type="checkbox" ' . ((!PerUser('accreditation_partners_countries_categories_publish')) ? 'disabled="disabled"' : '') . ' ' . ((PerUser('accreditation_partners_countries_categories_publish')) ? 'class="changeStatues"' : '') . ' ' . (($accreditation_partners_countries_categories->published=="yes") ? 'checked="checked"' : '') . '  id="checkbox-{{ $post->id }}">
                                    <label for="checkbox-' . $accreditation_partners_countries_categories->id . '">
                                    </label>
                                </div>
                            </td>',
                '<div class="btn-group text-center" id="single-order-' . $accreditation_partners_countries_categories->id . '">
                                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                                        <i class="fa fa-angle-down"></i>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                    ' . ((PerUser('accreditation_partners_countries_categories_edit')) ? '<li>
                                            <a href="' . URL('admin/apcc/' . $accreditation_partners_countries_categories->id . '/edit') . '">
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                            </a>
                                        </li>' : '') . '
                                    ' . ((PerUser('accreditation_partners_countries_categories_delete')) ? '<li>
                                            <a class="delete_this" data-id="' . $accreditation_partners_countries_categories->id . '" >
                                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.delete') . '
                                            </a>
                                        </li>' : '') . '
                                    </ul>
                                </div>',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('auth.accreditation_partners_countries_categories.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make($request->all(),
            array(
                'accreditation_country_id' => 'required',
                'type' => 'required',
                'title' => 'required',
                'url' => 'required',
                'short_description' => 'required',
                'description' => 'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $accreditation_partners_countries_categories = new AccreditationPartnersCountriesCategories();
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $accreditation_partners_countries_categories->accreditation_country_id = $data['accreditation_country_id'];
            $accreditation_partners_countries_categories->type = $data['type'];
            $accreditation_partners_countries_categories->title = $data['title'];
            $accreditation_partners_countries_categories->url = $data['url'];
            $accreditation_partners_countries_categories->short_description = $data['short_description'];
            $accreditation_partners_countries_categories->description = $data['description'];
            $accreditation_partners_countries_categories->sort = $data['sort'];
            $accreditation_partners_countries_categories->added_by = Auth::user()->id;
            $accreditation_partners_countries_categories->added_date = date("Y-m-d H:i:s");
            $accreditation_partners_countries_categories->published = $published;
            if ($published == 'yes') {
                $accreditation_partners_countries_categories->published_by = Auth::user()->id;
                $accreditation_partners_countries_categories->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no') {
                $accreditation_partners_countries_categories->unpublished_by = Auth::user()->id;
                $accreditation_partners_countries_categories->unpublished_date = date("Y-m-d H:i:s");
            }
            if ($accreditation_partners_countries_categories->save()) {
                Session::flash('success', Lang::get('main.insert') . Lang::get('main.accreditation_partners_countries_categories'));
                return Redirect::to('admin/apcc/create');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $accreditation_partners_countries_categories = AccreditationPartnersCountriesCategories::find($id);
        return view('auth.accreditation_partners_countries_categories.edit',compact('accreditation_partners_countries_categories'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->input();
        $accreditation_partners_countries_categories = AccreditationPartnersCountriesCategories::find($id);
        $validator = Validator::make($request->all(),
            array(
                'accreditation_country_id' => 'required',
                'type' => 'required',
                'title' => 'required',
                'url' => 'required',
                'short_description' => 'required',
                'description' => 'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        }else {
            $published = (isset($data['published'])) ? 'yes' : 'no';
            $accreditation_partners_countries_categories->accreditation_country_id = $data['accreditation_country_id'];
            $accreditation_partners_countries_categories->type = $data['type'];
            $accreditation_partners_countries_categories->title = $data['title'];
            $accreditation_partners_countries_categories->url = $data['url'];
            $accreditation_partners_countries_categories->short_description = $data['short_description'];
            $accreditation_partners_countries_categories->description = $data['description'];
            $accreditation_partners_countries_categories->sort = $data['sort'];
            if ($published == 'yes' && $accreditation_partners_countries_categories->published=='no') {
                $accreditation_partners_countries_categories->published_by = Auth::user()->id;
                $accreditation_partners_countries_categories->published_date = date("Y-m-d H:i:s");
            }
            if ($published == 'no' && $accreditation_partners_countries_categories->published=='yes') {
                $accreditation_partners_countries_categories->unpublished_by = Auth::user()->id;
                $accreditation_partners_countries_categories->unpublished_date = date("Y-m-d H:i:s");
            }
            $accreditation_partners_countries_categories->published = $published;
            $accreditation_partners_countries_categories->lastedit_by = Auth::user()->id;
            $accreditation_partners_countries_categories->lastedit_date = date("Y-m-d H:i:s");
            if ($accreditation_partners_countries_categories->save()) {
                Session::flash('success', Lang::get('main.update') . Lang::get('main.accreditation_partners_countries_categories'));
                return Redirect::to("admin/apcc/$accreditation_partners_countries_categories->id/edit");
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $accreditation_partners_countries_categories = AccreditationPartnersCountriesCategories::findOrFail($id);
        $accreditation_partners_countries_categories->delete();
    }

    public function publish(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->input('id');
            $published = $request->input('published');
            $accreditation_partners_countries_categories = AccreditationPartnersCountriesCategories::findOrFail($id);
            if ($published == 'no') {
                $accreditation_partners_countries_categories->published = 'no';
                $accreditation_partners_countries_categories->unpublished_by = Auth::user()->id;
                $accreditation_partners_countries_categories->unpublished_date = date("Y-m-d H:i:s");
            } elseif ($published == 'yes') {
                $accreditation_partners_countries_categories->published = 'yes';
                $accreditation_partners_countries_categories->published_by = Auth::user()->id;
                $accreditation_partners_countries_categories->published_date = date("Y-m-d H:i:s");
            }
            $accreditation_partners_countries_categories->save();
        } else {
            return redirect(404);
        }
    }
}
