<?php

use App\Courses;
use App\Diplomas;
use App\Models\FuturexIntegrationCourse;
use App\Models\Instructors;

function convertToDateTimeLocal($date)
{
    return (!empty($date) && $date != '0000-00-00 00:00:00') ? date("Y-m-d", strtotime($date)) . 'T' . date("H:i:s", strtotime($date)) : '';
}

function PerUser($val)
{
    $UserPermissionsData = \Illuminate\Support\Facades\Request::get('UserPermissionsData');
    return (isset($UserPermissionsData->$val) && $UserPermissionsData->$val) ? true : false;
}

function timeAgo($time)
{
    $time = strtotime($time);
    $time = time() - $time; // to get the time since that moment
    $time = ($time < 1) ? 1 : $time;
    $tokens = array(
        31536000 => 'year',
        2592000 => 'month',
        604800 => 'week',
        86400 => 'day',
        3600 => 'hour',
        60 => 'minute',
        1 => 'second'
    );
    foreach ($tokens as $unit => $text) {
        if ($time < $unit) continue;
        $numberOfUnits = floor($time / $unit);
        return $numberOfUnits . ' ' . $text . (($numberOfUnits > 1) ? 's' : '');
    }
}

function makeDefaultImage($post, $name)
{
    if (!(!empty($post->img_dir) && !empty($post->img) && file_exists(public_path($post->img_dir . $post->img)))) {
        $post->img_dir = '/img/' . $name . '/';
        $post->img = 'default_image.png';
    }
    return $post;
}

function makeDefaultImageGeneral($post, $image_field_name,$path='')
{
    if (empty($post->$image_field_name) || !file_exists(filePath().$path.$post->$image_field_name)) {
        $post->$image_field_name='none.png';
    }
    return $post;
}


function userSystem()
{
    if(Auth::check()){
        $system = \App\Models\UsersSystems::where('user_id', Auth::user()->id)->first();
        if (!count((array)$system)) {
            $system = new \App\Models\UsersSystems();
            $system->user_id = Auth::user()->id;
            $system->backend_lang = 'en';
            $system->save();
        }
        return $system;
    }
    return ['backend_lang'=>'ar'];
}

function getUserSystem($pars)
{
    $userSystemData = \Illuminate\Support\Facades\Request::get('UserSystem');
    return (isset($userSystemData->$pars)) ? $userSystemData->$pars : '';
}

function byUser($user_id, $string = null)
{
    $user = DB::table('users')->where('id', $user_id)->first();
    if (count($user)) {
        if ($user->img_dir == '' || $user->img == '') {
            $user->img_dir = 'img/Users/';
            $user->img = 'default_user.png';
        }
        return '<div class="zoom_img"><img class="img-polaroid " src="' . asset($user->img_dir . $user->img) . '" data-toggle="tooltip" data-placement="top" title="" data-original-title="' . $string . $user->name . '"></div>';
    }
    return Lang::get('main.no_image');
}

function byAppUser($user_id, $string = null)
{
    $user = \App\Models\AppUsers::find($user_id);
    if (count($user)) {
        if ($user->img_dir == '' && $user->img == '') {
            $user->img_dir = 'img/Users/';
            $user->img = 'default_user.png';
        }
        return '<div class="zoom_img"><img class="img-polaroid " src="' . asset($user->img_dir . $user->img) . '" data-toggle="tooltip" data-placement="top" title="" data-original-title="' . $string . ' { ' . Lang::get('main.' . $user->type) . ' } ' . $user->name . '"></div>';
    }
    return Lang::get('main.no_image');
}

function FileImage($file, $folder_name, $input_name = 'image')
{
    $path = '/img/' . $folder_name . '/' . date('Y/m/d') . '/';
    if (!file_exists(public_path() . $path)) {
        File::makeDirectory(public_path() . $path, $mode = 0777, true, true);
    }
    if (!file_exists(public_path() . $path . 'thumbnail')) {
        File::makeDirectory(public_path() . $path . 'thumbnail', $mode = 0777, true, true);
    }
    //file new name
    $namefile = $folder_name . '_' . rand(0000, 9999) . '_' . time();
    //file extension
    $ext = $file->getClientOriginalExtension();
    //file old name
    $old_name = $file->getClientOriginalName();
    //convert the size of the file
    //$size = ImageUploader::GetSize($file->getSize());
    //get the mime type of the file
    $mimtype = $file->getMimeType();
    //making the new name with extension
    $mastername = $namefile . '.' . $ext;
    list($width, $height, $type, $attr) = getimagesize($_FILES[$input_name]['tmp_name']);
    $width_per = round(($width * 10) / 100);
    $height_per = round(($height * 10) / 100);
    $file->move(public_path() . $path, $mastername);
    Image::make(public_path() . $path . $mastername, array(
        'width' => $width_per,
        'height' => $height_per,
    ))->save(public_path() . $path . 'thumbnail/thumbnail_' . $mastername);
    return array('img' => $mastername, 'img_dir' => $path);
}

function FileImages($file, $folder_name, $x, $input_name = 'images')
{
    $path = '/img/' . $folder_name . '/' . date('Y/m/d') . '/';
    if (!file_exists(public_path() . $path)) {
        File::makeDirectory(public_path() . $path, $mode = 0777, true, true);
    }
    if (!file_exists(public_path() . $path . 'thumbnail')) {
        File::makeDirectory(public_path() . $path . 'thumbnail', $mode = 0777, true, true);
    }
    //file new name
    $namefile = $folder_name . '_' . rand(0000, 9999) . '_' . time();
    //file extension
    $ext = $file->getClientOriginalExtension();
    //file old name
    $old_name = $file->getClientOriginalName();
    //convert the size of the file
    //$size = ImageUploader::GetSize($file->getSize());
    //get the mime type of the file
    $mimtype = $file->getMimeType();
    //making the new name with extension
    $mastername = $namefile . '.' . $ext;
    list($width, $height, $type, $attr) = getimagesize($_FILES[$input_name]['tmp_name'][$x]);
    $width_per = round(($width * 10) / 100);
    $height_per = round(($height * 10) / 100);
    $file->move(public_path() . $path, $mastername);
    switch ($folder_name) {
        case'hotels':
            $imagesResize = [
                0 => ['width' => 60, 'height' => 60],
                1 => ['width' => 260, 'height' => 180],
                2 => ['width' => 400, 'height' => 200],
            ];
            break;
        case'flights':
            $imagesResize = [
                0 => ['width' => 60, 'height' => 60],
                1 => ['width' => 260, 'height' => 180],
                2 => ['width' => 400, 'height' => 200],
            ];
            break;
        default:
            $imagesResize = [];
            break;
    }
    foreach ($imagesResize as $imageSize) {
        $widthS = $imageSize['width'];
        $heightS = $imageSize['height'];
        Image::make(public_path() . $path . $mastername, array(
            'width' => $widthS,
            'height' => $heightS,
        ))->save(public_path() . $path . 'thumbnail/' . $widthS . '_' . $heightS . '_' . $mastername);
    }
    Image::make(public_path() . $path . $mastername, array(
        'width' => $width_per,
        'height' => $height_per,
    ))->save(public_path() . $path . 'thumbnail/thumbnail_' . $mastername);
    return array('img' => $mastername, 'img_dir' => $path);
}

function tableCount($table)
{
    if (Schema::hasTable($table)) {
        $section = DB::table($table)->count();
        return $section;
    }
    return 0;
}

function getDaysName()
{
    $timestamp = strtotime('next Sunday');
    $days = array();
    for ($i = 0; $i < 7; $i++) {
        $days[] = strtolower(strftime('%A', $timestamp));
        $timestamp = strtotime('+1 day', $timestamp);
    }
    return $days;
}

function fileNewName($name, $filePath)
{

    $actual_name = pathinfo(rawurlencode($name), PATHINFO_FILENAME);
    $original_name = rawurldecode($actual_name);
    $extension = pathinfo($name, PATHINFO_EXTENSION);
    $i = 1;
    while (file_exists($filePath . $name)) {
        $actual_name = (string)$original_name . '(' . $i . ')';
        $name = $actual_name . "." . $extension;
        $i++;
    }

    return $name;
}
function uploadFileToCustomFolderE3melbusiness($file,$filePath='assets/images/'){
    $filePath=filePath($filePath);
    $ext = $file->getClientOriginalExtension();
    //file old name
    $old_name = $file->getClientOriginalName();
    $newname = fileNewName($old_name, $filePath);
    if (!file_exists($filePath)) {
        File::makeDirectory($filePath, $mode = 0777, true, true);
    }
    $file->move($filePath, $newname);
    return $newname;
}
function uploadFileToE3melbusiness($file, $partner = false, $folder = null,$audio_books=false,$course_question=false,$brochures=false,$pdf=false)
{
    $filePath = '';
    $folder = ($folder) ? $folder . '/' : $folder;
    if ($partner == true) {
        $filePath = partnerFilePath();
    }elseif($audio_books){
        $filePath = audioBooksFilePath();
    }elseif($course_question){
        $filePath = coursesQuestionsFilePath();
    }elseif($brochures){
        $filePath = brochuresFilePath();
    }elseif($pdf){
        $filePath = pdfImagesFilePath();
    }else {
        $filePath = filePath();
    }
    $ext = $file->getClientOriginalExtension();
    //file old name
    $old_name = $file->getClientOriginalName();
    $old_name=strReplaceFileName($old_name);
    $newname = fileNewName($old_name, $filePath.$folder);
    if (!file_exists($filePath . $folder)) {
        File::makeDirectory($filePath . $folder, $mode = 0777, true, true);
    }
    $file->move($filePath . $folder, $newname);

//    dd($filePath);

    return $newname;
}
function strReplaceFileName($filename){
    $arrayReplaces=[
        'َ'=>'',
        'ً'=>'',
        'ِِ'=>'',
        'ٍ'=>'',
        'ُ'=>'',
        'ٌ'=>'',
        'ْ'=>'',
        ' '=>'-',
        '%20'=>'-'
    ];
    foreach ($arrayReplaces as $from=>$to){
        $filename=str_replace($from,$to,$filename);
    }
    return $filename;
}
function e3mURL($url)
{
    return ($_SERVER['SERVER_NAME'] == 'localhost') ? 'http://localhost/e3melbusinessV5/' . $url : 'https://www.e3melbusiness.org/' . $url;
}

function yottaURL($url)
{
    return ($_SERVER['SERVER_NAME'] == 'localhost') ? 'http://localhost/yotta/' . $url : 'https://www.yottamedicalschool.com/' . $url;
}

function assetURL($url = '',$path='assets/images/')
{
    //return 'https://www.e3melbusiness.com/assets/images/'.$url;
    return (!in_array($_SERVER['SERVER_NAME'],['e3melbusiness.com','www.e3melbusiness.com']) ) ? 'http://'.$_SERVER['SERVER_NAME'].'/e3melbusinessV5/'.$path . $url : "https://www.e3melbusiness.com/$path" . $url;
}


function assetURLNew($url = '')
{
    return (!in_array($_SERVER['SERVER_NAME'],['e3melbusiness.com','www.e3melbusiness.com']) ) ? 'http://'.$_SERVER['SERVER_NAME'].'/adminresources/publice3melbusinessV5/assets/images/' . $url : "https://www.e3melbusiness.com/assets/images/" . $url;
}

function mainAssetURL($url = '')
{
    return (!in_array($_SERVER['SERVER_NAME'],['e3melbusiness.com','www.e3melbusiness.com']) ) ? 'http://'.$_SERVER['SERVER_NAME'].'/e3melbusinessV5/assets/' . $url : "https://www.e3melbusiness.com/assets/" . $url;
}
function filePath($path='assets/images/')
{
//	dd((!in_array($_SERVER['SERVER_NAME'],['e3melbusiness.com','www.e3melbusiness.com', 'beta.e3melbusiness.com']) ) ? explode('e3melbusinessV5', public_path())[0] . 'e3melbusinessV5/assets/images/' : explode('sa.e3melbusiness.com', public_path())[0] . 'sa.e3melbusiness.com/assets/images/');
    if($_SERVER['SERVER_NAME'] == 'beta.e3melbusiness.com')
		return explode('beta.e3melbusiness.com', public_path())[0] . 'sa.e3melbusiness.com/'.$path;
	//return explode('sa.e3melbusiness.com',public_path())[0].'sa.e3melbusiness.com/assets/images/';
    return (!in_array($_SERVER['SERVER_NAME'],['e3melbusiness.com','e3melbusiness.net','www.e3melbusiness.net','www.e3melbusiness.com']) ) ? explode('e3melbusinessV5', public_path())[0] . 'e3melbusinessV5/'.$path : explode('sa.e3melbusiness.com', public_path())[0] . 'sa.e3melbusiness.com/'.$path;
}

function audioBooksFilePath()
{
    //return explode('sa.e3melbusiness.com',public_path())[0].'sa.e3melbusiness.com/assets/images/';
    return (!in_array($_SERVER['SERVER_NAME'],['e3melbusiness.com','www.e3melbusiness.com']) ) ? explode('adminResources', public_path())[0] . 'e3melbusinessV5/assets/img/audio_books/' : explode('sa.e3melbusiness.com', public_path())[0] . 'sa.e3melbusiness.com/assets/img/audio_books/';
}
function coursesQuestionsFilePath()
{
    //return explode('sa.e3melbusiness.com',public_path())[0].'sa.e3melbusiness.com/assets/images/';
    return (!in_array($_SERVER['SERVER_NAME'],['e3melbusiness.com','www.e3melbusiness.com']) ) ? explode('adminResources', public_path())[0] . 'e3melbusinessV5/assets/courses_questions/' : explode('sa.e3melbusiness.com', public_path())[0] . 'sa.e3melbusiness.com/assets/courses_questions/';
}
function brochuresFilePath()
{
    //return explode('sa.e3melbusiness.com',public_path())[0].'sa.e3melbusiness.com/assets/images/';
    return (!in_array($_SERVER['SERVER_NAME'],['e3melbusiness.com','www.e3melbusiness.com']) ) ? explode('adminResources', public_path())[0] . 'e3melbusinessV5/assets/brochures/' : explode('sa.e3melbusiness.com', public_path())[0] . 'sa.e3melbusiness.com/assets/brochures/';
}
function pdfImagesFilePath()
{
    //return explode('sa.e3melbusiness.com',public_path())[0].'sa.e3melbusiness.com/assets/images/';
    return (!in_array($_SERVER['SERVER_NAME'],['e3melbusiness.com','www.e3melbusiness.com']) ) ? explode('adminResources', public_path())[0] . 'e3melbusinessV5/assets/pdf_images/' : explode('sa.e3melbusiness.com', public_path())[0] . 'sa.e3melbusiness.com/assets/pdf_images/';
}

function partnerFilePath()
{
    return (!in_array($_SERVER['SERVER_NAME'],['e3melbusiness.com','www.e3melbusiness.com']) ) ? explode('e3melbusinessV5', public_path())[0] . 'e3melbusinessV5/assets/images/ourpartners/' : explode('sa.e3melbusiness.com', public_path())[0] . 'sa.e3melbusiness.com/assets/images/ourpartners/';
}

function sendGridEmailToUser($html,$email,$name,$subject){
    try{
        $sendEmail = new SendGrid\Mail\Mail();
        $sendEmail->setFrom('Academy@e3melbusiness.com', 'أكاديمية إعمل بيزنس');
        $sendEmail->setSubject($subject);
        $sendEmail->addTo($email, $name);
        $sendEmail->addContent("text/html", $html);
    }catch (\SendGrid\Mail\TypeException $e){
        return ['message'=>$e->getMessage(),'success'=>false];
    }
    try {
        $sendgrid = new \SendGrid(getenv('SENDGRID_API_KEY'));
    }catch (Exception $e){
        return ['message'=>$e->getMessage(),'success'=>false];
    }catch (\SendGrid\Mail\TypeException $e){
        return ['message'=>$e->getMessage(),'success'=>false];
    }
    try{
        $sendgrid->send($sendEmail);
    }catch (\SendGrid\Mail\TypeException $e){
        return ['message'=>$e->getMessage(),'success'=>false];
    }
    return ['message'=>'success','success'=>true];
}

/*chargeTransaction*/
function sendChargeTransactionToCRM($transaction_id,$tag_name,$email,$phone,$type,$name,$period,$start_date,$end_date,$price,$createdTime,$pending=null,$suspend=null,$rwaq=0){
//    $url='http://crmegy.e3melbusiness.com/webservice/subscription.php';
//    if($pending==0){
//        $date=date('Y-m-d');
//        $start_date=date('Y-m-d',strtotime($start_date));
//        $end_date=date('Y-m-d',strtotime($end_date));
//        if (!(($date >= $start_date) && ($date <= $end_date))&&!($start_date>$date&&$end_date>$date)){
//            $pending=2;
//        }
//    }
//    $data=[
//        'transaction_id'=>$transaction_id,
//        'tag_name'=>$tag_name,
//        'email'=>$email,
//        'phone'=>$phone,
//        'type'=>$type,
//        'name'=>$name,
//        'period'=>$period,
//        'start_date'=>date('Y-m-d',strtotime($start_date)),
//        'end_date'=>date('Y-m-d',strtotime($end_date)),
//        'unit_price'=>$price,
//        'createdtime'=>date('Y-m-d H:i:s',strtotime($createdTime)),
//        'pending'=>$pending,
//        'suspend'=>$suspend,
//        'rwaq'=>$rwaq,
//    ];
//    //print_r($data);
//    //print_r($url);
//    $content="";
//    foreach($data as $key=>$value) { $content .= $key.'='.$value.'&'; }
//    //echo $content;
//    $curl = curl_init($url);
//    curl_setopt($curl, CURLOPT_HEADER, false);
//    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
//    curl_setopt($curl, CURLOPT_POST, true);
//    curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
//    $json_response = curl_exec($curl);
//    $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
//    curl_close($curl);
//
//    //echo $json_response;
//    //echo '<br><br>';
//    //echo $json_response;
//    //$ip=$_SERVER['REMOTE_ADDR'];
//    //$query="INSERT INTO api_logs_send SET `ip`='$ip',`data`='$content',`url`='$url',`response`='$json_response',`createtime`='$date'";
//    //self::execquery($query);
//    $url='http://crmksa2.almoasherbiz.com/webservice/subscription.php';
//    //print_r($data);
//    //print_r($url);
//    $content="";
//    foreach($data as $key=>$value) { $content .= $key.'='.$value.'&'; }
//    //echo $content;
//    $curl = curl_init($url);
//    curl_setopt($curl, CURLOPT_HEADER, false);
//    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
//    curl_setopt($curl, CURLOPT_POST, true);
//    curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
//    $json_response = curl_exec($curl);
//    $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
//    curl_close($curl);

//    echo $json_response;
//    echo '<br><br>';
//    echo $json_response;
//    die();
    //$ip=$_SERVER['REMOTE_ADDR'];
    //$query="INSERT INTO api_logs_send SET `ip`='$ip',`data`='$content',`url`='$url',`response`='$json_response',`createtime`='$date'";
    //self::execquery($query);
}//49858
function deleteChargeTransactionFromCRM($transaction_id,$tag_name){
//    $url='http://crmegy.e3melbusiness.com/webservice/delete_subscription.php';
//    $data=[
//        'transaction_id'=>$transaction_id,
//        'tag_name'=>$tag_name,
//    ];
//    //print_r($data);
//    //print_r($url);
//    $content="";
//    foreach($data as $key=>$value) { $content .= $key.'='.$value.'&'; }
//    //echo $content;
//    $curl = curl_init($url);
//    curl_setopt($curl, CURLOPT_HEADER, false);
//    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
//    curl_setopt($curl, CURLOPT_POST, true);
//    curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
//    $json_response = curl_exec($curl);
//    $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
//    curl_close($curl);
//    //echo '<br><br>';
//    //echo $json_response;
//    //echo $json_response;
//    //$ip=$_SERVER['REMOTE_ADDR'];
//    //$query="INSERT INTO api_logs_send SET `ip`='$ip',`data`='$content',`url`='$url',`response`='$json_response',`createtime`='$date'";
//    //self::execquery($query);
//    $url='http://crmksa2.almoasherbiz.com/webservice/delete_subscription.php';
//    //print_r($data);
//    //print_r($url);
//    $content="";
//    foreach($data as $key=>$value) { $content .= $key.'='.$value.'&'; }
//    //echo $content;
//    $curl = curl_init($url);
//    curl_setopt($curl, CURLOPT_HEADER, false);
//    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
//    curl_setopt($curl, CURLOPT_POST, true);
//    curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
//    $json_response = curl_exec($curl);
//    $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
//    curl_close($curl);
//    //echo '<br><br>';
//    //echo $json_response;
//    //echo $json_response;
//    //$ip=$_SERVER['REMOTE_ADDR'];
//    //$query="INSERT INTO api_logs_send SET `ip`='$ip',`data`='$content',`url`='$url',`response`='$json_response',`createtime`='$date'";
//    //self::execquery($query);
}
 function sendChargeTransaction($charge_id){
    $charge=\App\Models\ChargeTransaction::select('charge_transaction.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','charge_transaction.user_id')->find($charge_id);
    if($charge){
        sendChargeTransactionToCRM($charge->id,'charge transaction',$charge->email,$charge->phone,$charge->subscrip_type,'charge for client',$charge->period,$charge->start_date,$charge->end_date,$charge->amount,$charge->createtime,$charge->pending,$charge->suspend);
    }


}
 function sendDiplomasChargeTransaction($charge_id){
     $charge=\App\Models\DiplomasChargeTransaction::select('diplomas_charge_transaction.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','diplomas_charge_transaction.user_id')->find($charge_id);
     if($charge){
         sendChargeTransactionToCRM($charge->id,'diplomas transaction',$charge->email,$charge->phone,$charge->subscrip_type,$charge->diploma_name,$charge->period,$charge->start_date,$charge->end_date,$charge->diploma_price,$charge->createtime,$charge->pending,$charge->suspend,$charge->rwaq);
     }


}
	function sendPackagesChargeTransaction($charge_id){
		$charge=\App\Models\PackageChargeTransaction::select('packages_charge_transaction.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','packages_charge_transaction.user_id')->find($charge_id);
		if($charge){
			sendChargeTransactionToCRM($charge->id,'packages transaction',$charge->email,$charge->phone,
				$charge->subscrip_type,$charge->package_name,$charge->period,$charge->start_date,$charge->end_date,
				$charge->package_price,$charge->createtime,$charge->pending,$charge->suspend,$charge->rwaq);
		}


	}
function sendDBAChargeTransaction($charge_id){
     $charge=\App\Models\DBAChargeTransaction::select('dba_charge_transaction.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','dba_charge_transaction.user_id')->find($charge_id);
     if($charge){
         sendChargeTransactionToCRM($charge->id,'dba transaction',$charge->email,$charge->phone,$charge->subscrip_type,$charge->diploma_name,$charge->period,$charge->start_date,$charge->end_date,$charge->diploma_price,$charge->createtime,$charge->pending,$charge->suspend,$charge->rwaq);
     }


}
function sendDBAPreliminaryChargeTransaction($charge_id){
     $charge=\App\Models\DBAPreliminaryChargeTransaction::select('dba_preliminary_charge_transaction.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','dba_preliminary_charge_transaction.user_id')->find($charge_id);
     if($charge){
         sendChargeTransactionToCRM($charge->id,'dba preliminary transaction',$charge->email,$charge->phone,$charge->subscrip_type,$charge->diploma_name,$charge->period,$charge->start_date,$charge->end_date,$charge->diploma_price,$charge->createtime,$charge->pending,$charge->suspend,$charge->rwaq);
     }


}
function sendInternationalDiplomasChargeTransaction($charge_id){
     $charge=\App\Models\InternationalDiplomasChargeTransaction::select('international_diplomas_charge_transaction.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','international_diplomas_charge_transaction.user_id')->find($charge_id);
     if($charge){
         sendChargeTransactionToCRM($charge->id,'international diplomas transaction',$charge->email,$charge->phone,$charge->subscrip_type,$charge->diploma_name,$charge->period,$charge->start_date,$charge->end_date,$charge->diploma_price,$charge->createtime,$charge->pending,$charge->suspend,$charge->rwaq);
     }


}

function sendTrainingProgramsChargeTransaction($charge_id){
    $charge=\App\Models\TrainingProgramChargeTransaction::select('training_program_charge_transaction.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','training_program_charge_transaction.user_id')->find($charge_id);
    if($charge){
        sendChargeTransactionToCRM($charge->id,'training program transaction',$charge->email,$charge->phone,$charge->subscrip_type,$charge->diploma_name,$charge->period,$charge->start_date,$charge->end_date,$charge->diploma_price,$charge->createtime,$charge->pending,$charge->suspend,$charge->rwaq);
    }


}

 function sendMbaChargeTransaction($charge_id){
    $charge=\App\Models\MbaChargeTransaction::select('mba_charge_transaction.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','mba_charge_transaction.user_id')->find($charge_id);
    if($charge){
        sendChargeTransactionToCRM($charge->id,'mba transaction',$charge->email,$charge->phone,$charge->subscrip_type,'MBA',$charge->period,$charge->start_date,$charge->end_date,$charge->mba_price,$charge->createtime,$charge->pending,$charge->suspend);
    }
}
function sendNewMbaChargeTransaction($charge_id){
    $charge=\App\Models\NewMbaChargeTransaction::select('new_mba_charge_transaction.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','new_mba_charge_transaction.user_id')->find($charge_id);
    if($charge){
        sendChargeTransactionToCRM($charge->id,'new mba transaction',$charge->email,$charge->phone,$charge->subscrip_type,'New MBA',$charge->period,$charge->start_date,$charge->end_date,$charge->mba_price,$charge->createtime,$charge->pending,$charge->suspend);
    }
}
 function sendMedicalChargeTransaction($charge_id){
     $charge=\App\Models\MedicalChargeTransactions::select('medical_charge_transactions.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','medical_charge_transactions.user_id')->find($charge_id);
     if($charge){
         sendChargeTransactionToCRM($charge->id,'medical transaction',$charge->email,$charge->phone,$charge->subscrip_type,'Medical',$charge->period,$charge->start_date,$charge->end_date,$charge->amount,$charge->createtime,$charge->pending,$charge->suspend);
     }
}
function sendLiteVersionChargeTransaction($charge_id){
    $charge=\App\Models\LiteVersionChargeTransaction::select('lite_version_charge_transaction.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','lite_version_charge_transaction.user_id')->find($charge_id);
    if($charge){
        sendChargeTransactionToCRM($charge->id,'lite version  transaction',$charge->email,$charge->phone,$charge->subscrip_type,'Lite Version',$charge->period,$charge->start_date,$charge->end_date,$charge->amount,$charge->createtime,$charge->pending,$charge->suspend);
    }
}
function updateAcademyChargeTransaction($user_id){
    $expiredDate=NULL;
    $charge=\App\Models\ChargeTransaction::where('user_id',$user_id)->orderBy('end_date','DESC')->first();
    if($charge){
        $expiredDate=($charge->end_date>$expiredDate)?$charge->end_date:$expiredDate;
    }
    $charge=\App\Models\DiplomasChargeTransaction::where('user_id',$user_id)->orderBy('end_date','DESC')->first();
    if($charge){
        $expiredDate=($charge->end_date>$expiredDate)?$charge->end_date:$expiredDate;
    }
    $charge=\App\Models\MbaChargeTransaction::where('user_id',$user_id)->orderBy('end_date','DESC')->first();
    if($charge){
        $expiredDate=($charge->end_date>$expiredDate)?$charge->end_date:$expiredDate;
    }
    $charge=\App\Models\MedicalChargeTransactions::where('user_id',$user_id)->orderBy('end_date','DESC')->first();
    if($charge){
        $expiredDate=($charge->end_date>$expiredDate)?$charge->end_date:$expiredDate;
    }
	$charge=\App\Models\PackageChargeTransaction::where('user_id',$user_id)->orderBy('end_date','DESC')->first();
	if($charge){
		$expiredDate=($charge->end_date>$expiredDate)?$charge->end_date:$expiredDate;
	}
    if($expiredDate){
        $academy_charge_transaction=\App\Models\AcademyChargeTransaction::where('user_id',$user_id)->first();
        if($academy_charge_transaction){
            $type='U';
            $academy_charge_transaction->expired_date=$expiredDate;
            $academy_charge_transaction->save();
        }else{
            $type='R';
            $academy_charge_transaction=new \App\Models\AcademyChargeTransaction();
            $academy_charge_transaction->user_id=$user_id;
            $academy_charge_transaction->expired_date=$expiredDate;
            $academy_charge_transaction->save();
        }
        RegisterOrUpdateCustomerAPI($user_id,$type);
    }

}
function getAcademyExpiredDate($user_id){
    $academy=\App\Models\AcademyChargeTransaction::where('user_id',$user_id)->first();
    if($academy){
        return $academy->expired_date;
    }
    return '';
}

function RegisterOrUpdateCustomerAPI($user_id,$type='R'){

    $type=strtoupper($type);
    $user=\App\Models\NormalUser::find($user_id);
    $country=\App\Models\Country::find($user->country);
    $countrycode=$country->code;
    $mobilewithdash= $countrycode.'-'.preg_replace('/^'.$countrycode.'/', '', $user->Mobile);
    if(isset($user->id)){
        $data=[
            'SecretKey'=>'Secret',
            'MerchantId'=>'Merchant',
            'memberId'=>$user->id ,
            'sponsorId'=>$user->sponsorId,
            'JoiningDate'=>date("d/m/Y H:i:s", strtotime($user->RegisterDate)),
            'password'=>md5($user->Password),
            'gender'=>'',
            'fullName'=>$user->FullName,
            'BirthdayDate'=>'',
            /*    'DateOfBirthDay'=>22,
                'DateOfBirthMonth'=>4,
                'DateOfBirthYear'=>1991,*/
            'mobileNo'=>$mobilewithdash,//self::getCountryName($user->country,'code').'-'.$user->Mobile
            'emailId'=>$user->Email,
            'status'=>'true',
            /* 'nomDateOfBirthDay'=>date('d',strtotime($user->RegisterDate)),
             'nomDateOfBirthMonth'=>date('m',strtotime($user->RegisterDate)),
             'nomDateOfBirthYear'=>date('Y',strtotime($user->RegisterDate)),*/

            'ValidToDate'=>date("d/m/Y", strtotime(getAcademyExpiredDate($user_id))),
            'postalAddress'=>'',
            'country'=>$country->name,
            'stateProvince'=>'',
            'city'=>'',
            'zipCode'=>'',
        ];
        if($type=='R'){
            $data['username']=$user->Email;

            /* $data['JoiningDay']=date('d',strtotime($user->RegisterDate));
             $data['JoiningMonth']=date('m',strtotime($user->RegisterDate));
             $data['JoiningYear']=date('Y',strtotime($user->RegisterDate));*/
            // $data['JoiningDate']=date("d-m-Y H:i:s", strtotime($user->RegisterDate));
            // 'JoiningDate'=>date("d-m-Y H:i:s", strtotime($user->RegisterDate)),
            //  $data['password']=md5($user->Password);
        }
        // echo json_encode( $data);

        //self::sendApiData($data,$url="https://www.e3melbusiness.com/?page=testapi&action=sendRequest");
        sendApiData($data,"https://mlm.e3melbusiness.com/API/Customer/RegisterOrUpdateCustomer");
    }
}
function sendApiData($data,$url="")
{
    $date = date('Y-m-d H:i:s');
    if ($url) {
        $user_id = (isset($data['memberId'])) ? $data['memberId'] : '';
        $content = "";
        foreach ($data as $key => $value) {
            $content .= $key . '=' . trim($value) . '&';
        }
        //    echo $content;
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
        $json_response = curl_exec($curl);
        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        //print_r($data);
        //echo '<br><br><br>';
        curl_close($curl);
        //echo $json_response;
        $ip = $_SERVER['REMOTE_ADDR'];
        $mlm_requests = new \App\Models\MlmRequests();
        $mlm_requests->user_id = $user_id;
        $mlm_requests->ip = $ip;
        $mlm_requests->data = $content;
        $mlm_requests->url = $url;
        $mlm_requests->response = $json_response;
        $mlm_requests->createtime = $date;
        $mlm_requests->save();
    }
}

function saveOldUrl($table_id,$table_name,$old_url,$new_url,$add_by,$createtime){
    $record=new \App\Models\OldUrls();
    $record->table_id=$table_id;
    $record->table_name=$table_name;
    $record->old_url=$old_url;
    $record->new_url=$new_url;
    $record->add_by=$add_by;
    $record->createtime=$createtime;
    $record->lastedit_by=$add_by;
    $record->lastedit_date=$createtime;
    $record->save();
}
function log_admin_action($user_id=null,$user_name=null,$user_action=null,$user_action_table=null,$user_action_table_id=null,$data_json=null){
    $log=new \App\Models\AdminLog();
    $log->user_id=$user_id;
    $log->user_name=$user_name;
    $log->user_action=$user_action;
    $log->user_action_table=$user_action_table;
    $log->user_action_table_id=$user_action_table_id;
    $log->data_json=$data_json;
    $log->created_at=date("Y-m-d H:i:s");
    $log->save();
}

//function checkModuleParts($module_id) {
//
//    $module_part_one = \App\Models\NewMbaExams::where([
//        ["module_id","=",$module_id],
//        ["type","=","Part One"]
//    ])->first();
//
//    if(!$module_part_one) {
//
//        $module_part_one = new \App\Models\NewMbaExams();
//        $module_part_one->module_id = $module_id;
//        $module_part_one->type = "Part One";
//        $module_part_one->save();
//
//    }
//
////    $module_part_two = \App\Models\NewMbaExams::where([
////        ["module_id","=",$module_id],
////        ["type","=","Part Two"]
////    ])->first();
////
////    if(count($module_part_two) == 0) {
////
////        \App\Models\NewMbaExams::create([
////            "module_id" => $module_id,
////            "type"      => "Part Two"
////        ]);
////
////    }
//
//}

function sendRequestData($data,$url='https://www.e3melbusiness.com/?page=api&action=sendAdminEmail',$method='POST'){
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 5000,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST =>  $method,
        CURLOPT_POSTFIELDS => $data,
        CURLOPT_HTTPHEADER => array(
        ),
    ));
    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);
    if ($err) {
        echo "cURL Error #:" . $err;
    } else {
        echo$response;
    }
}

function generateRandomString($length = 10,$small_letters='all',$capital_letters='all')
{
    $characters = '0123456789';
    if($small_letters=='all') {
        $characters .= 'abcdefghijklmnopqrstuvwxy';
    }
    if($capital_letters=='all'){
        $characters .= 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    }

    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}
function admin_activity_action( $user_action=null, $user_action_table=null, $user_action_table_id=null){
    if(auth()->check()){
        $log=new \App\Models\ActivityLog();

        $log->user_id=Auth::user()->id;
        $log->user_name=Auth::user()->name;
        $log->user_action=$user_action;
        $log->user_action_table=$user_action_table;
        $log->user_action_table_id=$user_action_table_id;
        $log->ip=request()->ip();
        $log->action_link=request()->server('HTTP_REFERER');
        $log->created_at=date("Y-m-d H:i:s");
        $log->save();
    }

}
function getEnumFiledFromTable($table,$filed,$connection='mysql2'){
    $type = \Illuminate\Support\Facades\DB::connection($connection)->select('SHOW COLUMNS FROM '.$table.' WHERE Field = "'.$filed.'"')[0]->Type;
    preg_match('/^enum\((.*)\)$/', $type, $matches);
    $values = array();
    foreach(explode(',', $matches[1]) as $value){
        $values[] = trim($value, "'");
    }
    return $values;
}
function getSuggestionCourseConditionHtml($data){
    $html='';
    foreach ($data as $if_this){
        if(str_contains($if_this,'courses')){
            $course=Courses::find(str_replace('courses_','',$if_this));
            if($course){
                $html.='<span class="label label-success" style="margin: 5px;">'.$course->name.'</span>';
            }
        }elseif(str_contains($if_this,'diplomas')){
            $diploma=Diplomas::find(str_replace('diplomas_','',$if_this));
            if($diploma){
                $html.='<span class="label label-success" style="margin: 5px;">'.$diploma->name.'</span>';
            }
        }elseif(str_contains($if_this,'training_programs')){
            $diploma=\App\Models\TrainingProgram::find(str_replace('training_programs_','',$if_this));
            if($diploma){
                $html.='<span class="label label-success" style="margin: 5px;">'.$diploma->name.'</span>';
            }
        }elseif(str_contains($if_this,'MBA')){
            $html.='<span class="label label-success" style="margin: 5px;">الماجستير المهني لإدارة الأعمال الاونلاين – MBA</span>';
        }elseif(str_contains($if_this,'DBA')){
            $html.='<span class="label label-success" style="margin: 5px;">DBA</span>';
        }elseif(str_contains($if_this,'AnnualSubscription')){
            $html.='<span class="label label-success" style="margin: 5px;">Annual Subscription</span>';
        }
    }
    return $html;
}
function return_bytes($val)
{
    $val  = trim($val);

    if (is_numeric($val))
        return $val;

    $last = strtolower($val[strlen($val)-1]);
    $val  = substr($val, 0, -1); // necessary since PHP 7.1; otherwise optional

    switch($last) {
        // The 'G' modifier is available since PHP 5.1.0
        case 'g':
            $val *= 1024;
            break;
        case 'm':
            $val *= 1024;
            break;
        case 'k':
            $val *= 1024;
    }

    return $val;
}
function getEloquentSqlWithBindings($query)
{
    return vsprintf(str_replace('?', '%s', $query->toSql()), collect($query->getBindings())->map(function ($binding) {
        return is_numeric($binding) ? $binding : "'{$binding}'";
    })->toArray());
}
function websiteUrl($url){
    return env('WEBSITE_URL').$url;
}function e3melbusinessUrl($url){
    return env('E3MELBUSINESS_URL').$url;
}
function curlRequest($url,$method='POST',$data=[],$header=[]){
    $curl = curl_init();
    $array=array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => $method,
        CURLOPT_HTTPHEADER => array_merge(['Content-Type: application/json'],$header),
    );
    if($data){
        $array[CURLOPT_POSTFIELDS]=json_encode($data);
    }

    curl_setopt_array($curl, $array);


    $response = curl_exec($curl);
    // dd($array,$url,$data,$header,$response);
    curl_close($curl);
    $response=json_decode($response);
    return $response;
}
function getAccessToken(){
    $curl = curl_init();
    $url=config('futcherx.url').'oauth/token';
    curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => 'grant_type=client_credentials&client_id='.config('futcherx.client_id').'&client_secret='.config('futcherx.client_secret'),
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/x-www-form-urlencoded'
        ),
    ));

    $response = curl_exec($curl);
    // dd($url,$response,'grant_type=client_credentials&client_id='.config('futcherx.client_id').'&client_secret='.config('futcherx.client_secret'));
    curl_close($curl);
    $response=json_decode($response);
    $access_token=$response->access_token;
    return $access_token;
}
function createCourseInFutureX($course,$futurexCourse=null,$return=false){
    $access_token=getAccessToken();
    // dd($access_token);
    $instructor=Instructors::find($course->instractor);
    $data=[
        'courseId'=>$course->id,
        'name'=>$course->name,
        'summary'=>$course->short_description,
        'description'=>$course->description,
//           'pacing'=>'self learning'
        'courseCategory'=>$futurexCourse?$futurexCourse->futurex_course_category_id??null:null,

        'estimatedLearningTime'=>$course->hours_numbers,
        'courseUrl'=>websiteUrl('courses/'.$course->url),
//               'startsAt'=>''
//               'endsAt'=>''
        'promoPhoto'=>e3melbusinessUrl('assets/images/'.$course->image),
        'courseLevel'=>$futurexCourse?$futurexCourse->futurex_course_level_id??null:null,
        'coursePricing'=>null,
        'cost'=>$course->ksa_price,
        'price'=>$course->ksa_price,
        'language'=>$futurexCourse?$futurexCourse->futurex_language_id??null:null,
        'certificateType'=>null,
//           'prerequisites'=>[['value'=>'prerequisites 1']]
        'skills'=>$futurexCourse?collect($futurexCourse->futurex_skills_ids)->map(function($item){return ['id'=>$item];})->toArray():[],
        'translations'=>$futurexCourse?($futurexCourse->futurex_language_id?[['id'=>$futurexCourse->futurex_language_id]]:[]):[],
        'instructors'=>[
            [
                'name'=>$instructor->name,
                'title'=>$instructor->description,
                'photoUrl'=>e3melbusinessUrl('assets/images/'.$instructor->pic),
            ]
        ],
//           'courseObjectives'=>[]
//           'coursePlans'=>[]
        'tags'=>$futurexCourse?collect($futurexCourse->futurex_tags_ids)->map(function($item){return ['id'=>$item];})->toArray():[],
    ];
    $url=config('futcherx.url').'create-course?_format=json';
    $response=curlRequest($url,'POST',$data,['Authorization: Bearer '.$access_token]);
    \Illuminate\Support\Facades\DB::connection('mysql2')->table('futcherx_request_logs')->insert([
        'url'=>$url,
        'data'=>json_encode($data),
        'response'=>json_encode($response),
        'user_id'=>auth()->check()?auth()->id():0,
        'created_at'=>now(),
    ]);
    if($futurexCourse){
        $futurexCourse->update([
            'futurex_course_json'=>json_encode($response),
            'futurex_course_id'=>isset($response->content->id)?$response->content->id:$futurexCourse->futurex_course_id,
            'futurex_course_link'=>isset($response->content->link)?$response->content->link:null,
        ]);
    }else{
        FuturexIntegrationCourse::create([
            'course_id'=>$course->id,
            'futurex_course_json'=>json_encode($response),
            'futurex_course_id'=>isset($response->content->id)?$response->content->id:0,
            'futurex_course_link'=>isset($response->content->link)?$response->content->link:null,
        ]);
    }
    if($return){
        return [
            'url'=>$url,
            'response'=>$response,
            'data'=>$data,
        ];
    }

}
