<?php

namespace App\Exports;

use App\CoursesCurriculum;
use App\CoursesQuestions;
use Illuminate\Support\Facades\DB;

class WebsiteActivityReportExport

{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $request =Request();
        $data=$request->input();

        $activity_logs=DB::table(env('DB_DATABASE2').'.activity_log')
            ->select('user_id','user_name','user_email','user_action','ip','action_link','created_at')
        ;
        if (isset($data['user_id']) && !empty($data['user_id'])) {
            $user_id = $data['user_id'];
            $activity_logs = $activity_logs->where(env('DB_DATABASE2').'.activity_log.user_id',$user_id);
        }
        if (isset($data['user_name']) && !empty($data['user_name'])) {
            $user_name = $data['user_name'];
            $activity_logs = $activity_logs->where(env('DB_DATABASE2').'.activity_log.user_name', 'LIKE', "%$user_name%");
        }
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $user_email = $data['user_email'];
            $activity_logs = $activity_logs->where(env('DB_DATABASE2').'.activity_log.user_email', 'LIKE', "%$user_email%");
        }
        if (isset($data['user_action']) && !empty($data['user_action'])) {
            $user_action = $data['user_action'];
            $activity_logs = $activity_logs->where(env('DB_DATABASE2').'.activity_log.user_action', 'LIKE', "%$user_action%");
        }
        if (isset($data['ip']) && !empty($data['ip'])) {
            $ip = $data['ip'];
            $activity_logs = $activity_logs->where(env('DB_DATABASE2').'.activity_log.ip',$ip);
        }
        if (isset($data['action_link']) && !empty($data['action_link'])) {
            $action_link = $data['action_link'];
            $activity_logs = $activity_logs->where(env('DB_DATABASE2').'.activity_log.action_link', 'LIKE', "%$action_link%");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $activity_logs = $activity_logs->whereBetween(env('DB_DATABASE2').'.activity_log.created_at', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }

        return $activity_logs->get();


    }
    public function headings()
    {
        return [
            'User ID',
            'User Name',
            'User Email',
            'User Action',
            'IP',
            'Action Link',
            'Created time'
        ];
    }
}
