<?php

namespace App\Exports;

use App\CoursesCurriculum;
use App\CoursesQuestions;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class CurriculumQuestionsExport implements FromCollection, WithHeadings

{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $request =Request();
        $data=$request->input();

        $courses_questions = DB::table('curriculum_questions')->whereNull('curriculum_questions.deleted_at')->select('curriculum_questions.id',
            'courses.name AS course_name',
            'curriculum_questions.name',
            'curriculum_questions.type',
             'curriculum_questions.createdtime'
        )
            ->leftJoin('cources_curriculum','cources_curriculum.id','=','curriculum_questions.curriculum_id')
            ->leftJoin('courses_sections','courses_sections.id','=','cources_curriculum.section_id')
            ->leftJoin('courses', 'cources_curriculum.course_id', '=', 'courses.id')->whereIn('cources_curriculum.type', ['exam', 'training']);
        if(PerUser('remove_medical')){
            $courses_questions=$courses_questions->where('courses.show_on','!=','medical');
        }
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $courses_questions = $courses_questions->where('cources_curriculum.id', '=', "$id");
        }
        if (isset($data['course_name']) && !empty($data['course_name'])) {
            $course_name = $data['course_name'];
            $courses_questions = $courses_questions->where('courses.name', 'LIKE', "%$course_name%");
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $courses_questions = $courses_questions->where('cources_curriculum.name', 'LIKE', "%$name%");
        }
        if (isset($data['type']) && !empty($data['type'])) {
            $type = $data['type'];
            $courses_questions = $courses_questions->where('cources_curriculum.type', '=', $type);
        }
        if (isset($data['description']) && !empty($data['description'])) {
            $description = $data['description'];
            $courses_questions = $courses_questions->where('cources_curriculum.description', 'LIKE', "%$description%");
        }
        if (isset($data['section_name']) && !empty($data['section_name'])) {
            $section_name = $data['section_name'];
            $courses_questions = $courses_questions->where('courses_sections.name', 'LIKE', "%$section_name%");
        }
        if (isset($data['questions_numbers']) && !empty($data['questions_numbers'])) {
            $questions_numbers = $data['questions_numbers'];
            $courses_questions = $courses_questions->where('cources_curriculum.questions_numbers', '=', $questions_numbers);
        }
        if (isset($data['questions_count']) && !empty($data['questions_count'])) {
            $questions_count = $data['questions_count'];
            $courses_questions = $courses_questions->where('cources_curriculum.questions_count', '=', $questions_count);
        }

        return $courses_questions->get();


    }
    public function headings()
    {
        return [
            '#',
            'Course Name',
            'Name',
            'Type',
            'Created time'
        ];
    }
}
