<?php $__env->startPush('headScript'); ?>
    <!-- Tailwind Configuration -->
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        alexandria: ["Alexandria", "sans-serif"],
                        tajawal: ["Tajawal", "sans-serif"],
                    },
                    colors: {
                        "brand-primary-light": "#E8ECF4",
                        "brand-secondary-normal": "#00B34F",
                        "brand-primary-normal": "#144394",
                        "brand-primary-bg": "#F2F4F9",
                        title: "#102844",
                        "neutral-n20": "#F5F5F5",
                        "neutral-n10": "#FAFAFA",
                        "neutral-n100": "#757575",
                        "gray-shade": "#F8F8FB",
                        "orange": "#e2a73c",
                        "error-light": "#fdeaea",
                        "error-red": "#f15353",
                        "success-light": "#e6f7ed",
                        "success-border": "#d9f4e5",
                    },
                },
            },
        };
    </script>

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            /* border: 1px solid red !important; */
        }

        body {
            font-family: "Tajawal", -apple-system, Roboto, Helvetica, sans-serif;
            direction: rtl;
        }

        /* Mobile Menu Styles */
        .mobile-menu {
            animation-duration: 0.3s;
            animation-timing-function: ease-out;
        }

        .mobile-menu.show {
            animation-name: slideDown;
        }

        .mobile-menu.hide {
            animation-name: slideUp;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes slideUp {
            from {
                opacity: 1;
                transform: translateY(0);
            }

            to {
                opacity: 0;
                transform: translateY(-10px);
            }
        }

        .mobile-menu-backdrop.show {
            animation: fadeIn 0.3s ease-out;
        }

        .mobile-menu-backdrop.hide {
            animation: fadeOut 0.3s ease-out;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        @keyframes fadeOut {
            from {
                opacity: 1;
            }

            to {
                opacity: 0;
            }
        }

        /* Hover effects for navigation links */
        .nav-link:hover {
            transform: translateY(-1px);
            transition: all 0.2s ease;
        }

        .mobile-nav-link:hover {
            background-color: rgba(255, 255, 255, 0.1);
            border-radius: 8px;
        }

        .mobile-cta-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        }

        /* Quiz Answer Selection Styles */

        /* Multiple Choice Checkbox Selection */
        input[type="checkbox"]:checked {
            background-color: #144394 !important;
            border-color: #144394 !important;
            accent-color: #144394 !important;
        }

        /* Multiple Choice Radio Selection */
        input[type="radio"]:checked {
            background-color: #144394 !important;
            border-color: transparent !important;
            accent-color: #144394 !important;
        }

        /* True/False Label Container Selection */
        .true-false-label:has(input:checked) {
            background-color: #e8ecf4 !important;
            border-color: #144394 !important;
        }

        /* Multiple Choice Label Selection */
        .mcq-label:has(input:checked) {
            background-color: #e8ecf4 !important;
            border-color: #144394 !important;
            color: #144394 !important;
        }

        /* Responsive Design using Tailwind breakpoints */
        @media (max-width: 1200px) {
            .main-layout {
                flex-direction: column;
            }
        }

        @media (max-width: 768px) {
            .nav-bar {
                flex-direction: column;
                gap: 16px;
            }
        }

        /* Tablet specific adjustments */
        @media (min-width: 768px) and (max-width: 1024px) {
            .nav-link {
                font-size: 0.875rem;
                padding: 0.5rem 0.75rem;
            }
        }

        /* Small mobile adjustments */
        @media (max-width: 480px) {
            .mobile-nav-link {
                font-size: 1rem;
                padding: 0.75rem 1rem;
            }

            .mobile-cta-btn {
                font-size: 0.875rem;
                padding: 0.75rem 1rem;
            }
        }

        /* Quiz Specific Styles */
        .question-card {
            transition: all 0.3s ease;
        }

        .question-card:hover {
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .option-button {
            transition: all 0.2s ease;
        }

        .progress-bar {
            transition: width 0.5s ease;
        }

        .timer {
            font-variant-numeric: tabular-nums;
        }

        /* Loading Spinner Styles */
        .quiz-loader {
            animation: spin 2s linear infinite;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        .loader-overlay {
            -webkit-backdrop-filter: blur(4px);
            backdrop-filter: blur(4px);
        }

        /* Fade in animation for loader */
        .fade-in {
            animation: fadeInLoader 0.3s ease-out;
        }

        @keyframes fadeInLoader {
            from {
                opacity: 0;
                transform: scale(0.95);
            }

            to {
                opacity: 1;
                transform: scale(1);
            }
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="max-w-[1536px] mx-auto px-4">
        <!-- Breadcrumb -->
        <nav class="mb-6 text-right flex justify-start breadcrumb mt-4">
            <div class="flex gap-[9px] items-center justify-center">

                <a href="<?php echo e(route('home_page')); ?>" class="font-tajawal text-base font-medium leading-6 text-[#757575] text-center">
                    الرئيسية
                </a>
                <div class="w-6 h-6 flex items-center justify-center">
                    <svg width="8" height="14" viewBox="0 0 8 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M7 13L1 7L7 1" stroke="#858585" stroke-width="2" stroke-linecap="round"
                              stroke-linejoin="round" />
                    </svg>
                </div>



                <div class="font-tajawal text-base font-medium leading-6 text-[#00B34F] text-right">
                    تدريب علي
                    <?php echo e($currentCurriculum->Section->name); ?>

                </div>
            </div>
        </nav>

        <!-- Page Title -->
        <div class="mb-8 text-right flex justify-start page-title">
            <h1 class="text-title font-tajawal text-2xl font-medium leading-8 max-md:text-xl max-md:leading-7">
                تدريب علي
                <?php echo e($currentCurriculum->Section->name); ?>

            </h1>
        </div>

        <!-- Timer Section -->
        <div id="timer-section"
             class="bg-[#fff8ec] rounded-lg p-4 mb-8 border border-[#ebebeb] shadow-[0px_1px_4px_0px_rgba(12,12,13,0.05)]">
            <div class="flex flex-col gap-2.5 items-center justify-center">
                <div class="flex gap-[9px] items-center justify-center">
                    <div class="font-tajawal text-lg font-medium leading-7 text-[#e2a73c] text-right">
                        الوقت المحدد للتدريب
                    </div>
                    <div class="w-6 h-6 flex items-center justify-center">
                        <svg width="23" height="23" viewBox="0 0 23 23" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M6.99436 19.2778L5.496 21.9813" stroke="#FBB943" stroke-linecap="round"
                                  stroke-linejoin="round" />
                            <path d="M15.9863 19.2778L17.4847 21.9814" stroke="#FBB943" stroke-linecap="round"
                                  stroke-linejoin="round" />
                            <path
                                d="M11.4901 20.4827C16.4562 20.4827 20.4821 16.4569 20.4821 11.4907C20.4821 6.52453 16.4562 2.49866 11.4901 2.49866C6.52392 2.49866 2.49805 6.52453 2.49805 11.4907C2.49805 16.4569 6.52392 20.4827 11.4901 20.4827Z"
                                stroke="#FBB943" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M11.4902 6.99463V11.4906" stroke="#FBB943" stroke-linecap="round"
                                  stroke-linejoin="round" />
                            <path d="M11.4902 11.4906L14.6694 14.6698" stroke="#FBB943" stroke-linecap="round"
                                  stroke-linejoin="round" />
                        </svg>
                    </div>
                </div>
                <div id="timer" class="font-tajawal text-xl font-bold leading-[30px] text-[#e2a73c] text-right timer">
                    0:00:00 / 0:00:00
                </div>
            </div>
        </div>

        <!-- Quiz Content Container -->
        <form id="quiz-form" class="quiz-form">
            <input type="hidden" id="duration_time" name="duration_time">
            <div id="quiz-content">
                <!-- Main Layout -->
                <?php $__currentLoopData = $questions->groupBy('type'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type=>$items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($type=='true_false'): ?>
                        <div class="bg-[#f2f4f9] rounded-lg p-4 md:p-[30px] mb-8">
                            <!-- Quiz Instructions -->
                            <div class="flex flex-col gap-2.5 items-start justify-start mb-6">
                                <div class="flex flex-wrap gap-1 items-center justify-start text-center md:text-right">
                                    <div
                                        class="font-tajawal text-base md:text-lg font-medium leading-6 md:leading-7 text-[#1c1c1c] text-right">
                                        ضع علامة صح (
                                    </div>
                                    <div class="w-5 h-5 md:w-6 md:h-6">
                                        <img src="<?php echo e(asset('frontend/images')); ?>/true-icon.svg" alt="True" class="w-full h-full" />
                                    </div>
                                    <div
                                        class="font-tajawal text-base md:text-lg font-medium leading-6 md:leading-7 text-black text-right">
                                        )</div>
                                    <div
                                        class="font-tajawal text-base md:text-lg font-medium leading-6 md:leading-7 text-[#1c1c1c] text-right">
                                        امام الإجابة الصحيحة
                                    </div>
                                    <div
                                        class="font-tajawal text-base md:text-lg font-medium leading-6 md:leading-7 text-[#1c1c1c] text-right">
                                        و علامة (
                                    </div>
                                    <div class="w-5 h-5 md:w-6 md:h-6">
                                        <img src="<?php echo e(asset('frontend/images')); ?>/false-icon.svg" alt="False" class="w-full h-full" />
                                    </div>
                                    <div
                                        class="font-tajawal text-base md:text-lg font-medium leading-6 md:leading-7 text-black text-right">
                                        )</div>
                                    <div
                                        class="font-tajawal text-base md:text-lg font-medium leading-6 md:leading-7 text-[#1c1c1c] text-right">
                                        امام الإجابة الخطأ
                                    </div>
                                </div>
                            </div>

                            <!-- True/False Questions -->
                            <div class="space-y-4 md:space-y-6">
                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <!-- Question 1 -->
                                    <div class="bg-[#f8f8fb] rounded-xl md:rounded-2xl p-6 md:p-10">
                                        <div class="flex flex-col gap-2.5 items-start justify-start">
                                            <div class="flex gap-4 md:gap-[30px] items-center justify-start w-full">
                                                <div class="flex flex-col gap-2 md:gap-[13px] items-start justify-start">
                                                    <div
                                                        class="font-tajawal text-base md:text-lg font-medium leading-6 md:leading-7 text-[#102844] text-right w-full md:w-[668px]">
                                                        <?php echo e($question->name); ?>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="flex flex-row-reverse gap-3 md:gap-[17px] items-center justify-start">
                                                <label class="true-false-label cursor-pointer bg-[#fdeaea] border border-[#f8aaaa] rounded-[32px] w-8 h-8 md:w-[38px] md:h-[38px] flex items-center justify-center hover:bg-[#fccccc] transition-colors">
                                                    <input type="radio" name="questions[<?php echo e($question->id); ?>]" value="0" class="hidden" />
                                                    <img src="<?php echo e(asset('frontend/images')); ?>/false-icon.svg" alt="False" class="w-5 h-5 md:w-6 md:h-6" />
                                                </label>
                                                <label class="true-false-label cursor-pointer bg-[#e6f7ed] border border-[#d9f4e5] rounded-[32px] w-8 h-8 md:w-[38px] md:h-[38px] flex items-center justify-center hover:bg-[#d0ead8] transition-colors">
                                                    <input type="radio" name="questions[<?php echo e($question->id); ?>]" value="1" class="hidden" />
                                                    <img src="<?php echo e(asset('frontend/images')); ?>/true-icon.svg" alt="True" class="w-5 h-5 md:w-6 md:h-6" />
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php else: ?>
                        <!-- Multiple Choice Questions Section -->
                        <div class="bg-[#f2f4f9] rounded-lg p-4 md:p-[30px] mb-8">
                            <!-- Section Title -->
                            <div class="flex flex-col gap-2.5 items-start justify-start mb-6">
                                <div class="flex gap-1 items-start justify-start">
                                    <div
                                        class="font-tajawal text-base md:text-lg font-medium leading-6 md:leading-7 text-[#1c1c1c] text-right">
                                        اختر الإجابة الصحيحة:
                                    </div>
                                </div>
                            </div>

                            <!-- Multiple Choice Questions -->
                            <div class="space-y-4 md:space-y-6">
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <!-- MCQ <?php echo e($loop->index+1); ?> -->
                                <div class="bg-[#f8f8fb] rounded-xl md:rounded-2xl p-6 md:p-10 min-h-[120px] md:min-h-[180px]">
                                    <div class="flex flex-col gap-2.5 items-end justify-start">
                                        <div class="flex gap-4 md:gap-[30px] items-center justify-start w-full">
                                            <div class="flex flex-col gap-2 md:gap-[13px] items-start justify-start">
                                                <div
                                                    class="font-tajawal text-base md:text-lg font-medium leading-6 md:leading-7 text-[#102844] text-right w-full max-w-[668px]">
                                                    <?php echo e($question->name); ?>

                                                </div>
                                                <?php if($question->type=='chose_multiple'): ?>
                                                    <div class="font-tajawal text-xs text-[#666] text-right">
                                                        (يمكن اختيار أكثر من إجابة)
                                                    </div>
                                                <?php else: ?>
                                                    <div class="font-tajawal text-xs text-[#144394] text-right">
                                                        (اختيار واحد فقط)
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="space-y-2 w-full">
                                            <?php $__currentLoopData = $question->Details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <label class="mcq-label cursor-pointer flex flex-row-reverse gap-2 md:gap-[7px] items-center justify-end hover:bg-gray-50 p-2 rounded transition-colors">
                                                <div class="font-tajawal text-sm md:text-lg font-medium text-black text-right"><?php echo e($detail->name); ?></div>
                                                <input type="<?php echo e($question->type=='chose_multiple'?'checkbox':'radio'); ?>" name="<?php echo $question->type=='chose_multiple'?'questions['.$question->id.'][]':'questions['.$question->id.']'; ?>" value="<?php echo e($detail->id); ?>" class="w-4 h-4 bg-white border border-[#d0d5dd] rounded-[4px] text-[#144394] focus:ring-[#144394]" />
                                            </label>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                <!-- Action Buttons -->
                <div class="flex flex-col gap-2.5 items-center justify-center mb-8">
                    <button type="submit" id="submit-quiz-btn"
                            class="bg-[#144394] text-white px-[30px] py-4 rounded-lg font-tajawal text-sm font-medium leading-5 hover:bg-[#0f3680] transition-colors">
                        إرسال الإجابة
                    </button>
                    <button type="button"
                            class="bg-[#fdeaea] text-[#f15353] px-[30px] py-4 rounded-lg font-tajawal text-sm font-medium leading-5 hover:bg-[#fccccc] transition-colors">
                        إلغاء الإختبار
                    </button>
                </div>
            </div>
        </form>

        <!-- Loading Section (Initially Hidden) -->
        <div id="loading-section" class="hidden">
            <div class=" mb-8 min-h-[600px] flex items-center justify-center">
                <div class="flex flex-col gap-12 items-center justify-center fade-in">
                    <!-- Animated Spinner -->
                    <div class="relative w-[229px] h-[229px]">
                        <div class="absolute inset-0 border-4 border-gray-200 rounded-full"></div>
                        <div
                            class="absolute inset-0 border-4 border-[#144394] border-t-transparent rounded-full quiz-loader">
                        </div>
                    </div>

                    <!-- Loading Text -->
                    <div class="font-tajawal font-medium text-[24px] leading-8 text-[#2e2e2e] text-center">
                        من فضلك انتظر حتي تحصل علي نتيجة إختبارك
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('footerScript'); ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        window.Toast= Swal.mixin({
            toast: true,
            position: "top-end",
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.onmouseenter = Swal.stopTimer;
                toast.onmouseleave = Swal.resumeTimer;
            }
        });
    </script>
    <script>
        // Timer functionality (display only)
        // let timeLeft = 167; // 2:47 in seconds
        let timeLeft = <?php echo e(($currentCurriculum->question_time?$currentCurriculum->question_time:1)*$currentCurriculum->questions_numbers*60); ?>; // 2:47 in seconds

        let totalTime = <?php echo e(($currentCurriculum->question_time?$currentCurriculum->question_time:1)*$currentCurriculum->questions_numbers*60); ?>; // 5:00:00 in seconds

        window.updateTimerDisplay=function updateTimerDisplay() {
            const currentMinutes = Math.floor(timeLeft / 60);
            const currentSeconds = timeLeft % 60;
            const totalHours = Math.floor(totalTime / 3600);
            const totalMinutes = Math.floor((totalTime % 3600) / 60);
            const totalSecs = totalTime % 60;

            const currentTime = `${currentMinutes}:${currentSeconds.toString().padStart(2, '0')}`;
            const totalTimeStr = `${totalHours}:${totalMinutes.toString().padStart(2, '0')}:${totalSecs.toString().padStart(2, '0')}`;
            document.getElementById('duration_time').setAttribute('value',`${currentTime} / ${totalTimeStr}`)
            document.getElementById('timer').textContent = `${currentTime} / ${totalTimeStr}`;
        }

        function startTimer() {
            setInterval(() => {
                if (timeLeft > 0) {
                    timeLeft--;
                    updateTimerDisplay();
                }
            }, 1000);
        }
        // Submit Quiz Handler
        document.getElementById('submit-quiz-btn').addEventListener('click', function (e) {
            e.preventDefault();
            showLoader();
            let formData=new FormData(document.getElementById('quiz-form'));
            fetch("<?php echo e(route('course_training_end_page',['url'=>$course->url,'id'=>$currentCurriculum->id])); ?>", {
                method: "POST",
                body: formData,
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                    "Accept": "application/json"
                }
            }).then(response => {
                return response.json();
            }).then(data => {
                Toast.fire({
                    icon: data.success ? "success" : "error",
                    title: data.message
                });
                if(data.redirect){
                    setTimeout(function(){
                        window.location.href=data.redirect;
                    },3000)

                }else{
                    hideLoader();
                }

            });
            // // Simulate quiz submission (replace with actual submission logic)
            // setTimeout(() => {
            //     // Redirect to test results page after loading completes
            //     window.location.href = 'test-result.html';
            // }, 3000); // 30 seconds simulation
        });

        // Loader functions
        function showLoader() {
            const quizContent = document.getElementById('quiz-content');
            const loadingSection = document.getElementById('loading-section');
            const pageTitle = document.querySelector('.page-title');
            const timer = document.getElementById('timer-section');
            const breadcrumb = document.querySelector('.breadcrumb');


            breadcrumb.scrollIntoView({ behavior: 'smooth', block: 'center' });
            quizContent.classList.add('hidden');
            loadingSection.classList.remove('hidden');
            pageTitle.classList.add('hidden');
            timer.classList.add('hidden');
        }
        function hideLoader() {
            const quizContent = document.getElementById('quiz-content');
            const loadingSection = document.getElementById('loading-section');
            const pageTitle = document.querySelector('.page-title');
            const timer = document.getElementById('timer-section');
            const breadcrumb = document.querySelector('.breadcrumb');

            breadcrumb.scrollIntoView({ behavior: 'smooth', block: 'center' });
            quizContent.classList.remove('hidden');
            loadingSection.classList.add('hidden');
            pageTitle.classList.remove('hidden');
            timer.classList.remove('hidden');
        }

        // Initialize timer when page loads
        document.addEventListener('DOMContentLoaded', () => {
            updateTimerDisplay();
            startTimer();
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ebacademy/public_html/beta.e3melbusiness.org/resources/views/frontend/training.blade.php ENDPATH**/ ?>