<?php $__env->startPush('headScript'); ?>
    <link
        rel="stylesheet"
        href="<?php echo e(asset('assets/plugins/itl-tel-input/css/intlTelInput.min.css')); ?>"
    />
    <style>
        .iti{
            display: block!important;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Hero Section for Search Certificate Page -->
    <div class="relative overflow-hidden min-h-[700px]">
        <!-- Background Image -->
        <div class="absolute left-0 bottom-0 z-0">
            <img src="<?php echo e(asset('frontend/images')); ?>/hero-book-demo.png" alt="Background" />
        </div>

        <!-- Background Gradient Overlay -->
        <div class="absolute inset-0">
            <svg
                class="w-full h-full"
                viewBox="0 0 1600 808"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
                preserveAspectRatio="xMidYMid slice"
            >
                <path
                    d="M0 0H1600V808H0V0Z"
                    fill="url(#paint0_linear_gradient_overlay)"
                />
                <defs>
                    <linearGradient
                        id="paint0_linear_gradient_overlay"
                        x1="205.022"
                        y1="0"
                        x2="1573.65"
                        y2="664.405"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop offset="0%" stop-color="#0C2959" stop-opacity="0.45" />
                        <stop offset="18.28%" stop-color="#0C2959" stop-opacity="0.55" />
                        <stop offset="31.41%" stop-color="#0C2959" stop-opacity="0.62" />
                        <stop offset="49.65%" stop-color="#0C2959" stop-opacity="0.72" />
                        <stop offset="74.35%" stop-color="#0C2959" stop-opacity="0.86" />
                        <stop offset="100%" stop-color="#0C2959" />
                    </linearGradient>
                </defs>
            </svg>
        </div>

        <!-- Background Ellipses -->
        <div class="absolute -top-96 -left-96">
            <img
                src="<?php echo e(asset('frontend/images')); ?>/hero-background.png"
                alt="Background Ellipses"
                class="w-[1179px] h-[1101px] object-contain"
            />
        </div>

        <!-- Wave at bottom -->
        <div class="absolute bottom-0 left-0 w-full">
            <svg
                class="w-full h-52"
                viewBox="0 0 1600 202"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
                preserveAspectRatio="none"
            >
                <path
                    fill-rule="evenodd"
                    clip-rule="evenodd"
                    d="M0 79.458C0 79.458 226.389 186.741 381.052 178.06C535.714 169.378 628.364 133.594 798.309 151.486C968.253 169.378 1461.17 124.238 1600 0V209.034H0V79.458Z"
                    fill="#FDFDFF"
                />
            </svg>
        </div>
        <!-- Content Container -->
        <div
            class="relative z-10 pt-32 pb-32 px-4 md:px-8 lg:px-16 min-h-[700px] flex items-center justify-center"
        >
            <div class="max-w-4xl mx-auto text-center">
                <!-- Breadcrumb Navigation -->
                <div class="flex items-center justify-center gap-2 mb-6">
                    <div
                        class="font-alexandria font-normal text-white text-[20px] leading-[36px]"
                    >
                        الرئيسية
                    </div>
                    <div class="w-6 h-6 flex items-center justify-center">
                        <svg
                            width="8"
                            height="14"
                            viewBox="0 0 8 14"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                        >
                            <path
                                d="M7 13L1 7L7 1"
                                stroke="white"
                                stroke-width="2"
                                stroke-linecap="round"
                                stroke-linejoin="round"
                            />
                        </svg>
                    </div>
                    <div
                        class="font-alexandria font-normal text-white text-[20px] leading-[36px]"
                    >
                        الدورات
                    </div>
                    <div class="w-6 h-6 flex items-center justify-center">
                        <svg
                            width="8"
                            height="14"
                            viewBox="0 0 8 14"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                        >
                            <path
                                d="M7 13L1 7L7 1"
                                stroke="white"
                                stroke-width="2"
                                stroke-linecap="round"
                                stroke-linejoin="round"
                            />
                        </svg>
                    </div>
                    <div
                        class="font-alexandria font-bold text-[#00B34F] text-[20px] leading-[36px]"
                    >
                        تواصل معنا
                    </div>
                </div>

                <!-- Main Title -->
                <h1
                    class="font-alexandria font-bold text-white leading-[72px] tracking-tight mb-4 text-[48px] text-center"
                >
                    احجز عرضك التوضيحي
                </h1>

                <!-- Subtitle -->
                <p
                    class="font-alexandria font-medium text-[#DEDEDE] text-[18px] leading-[27px] text-center mb-8"
                >
                    دعنا نرشدك خطوة بخطوة نحو تجربة تدريب احترافية
                </p>
            </div>
        </div>
    </div>

    <!-- Contact Form Section -->
    <section
        class="py-16 px-4 md:px-8 lg:px-16 bg-[#F2F4F9] w-[95%] mx-auto my-24 rounded-[8px]"
    >
        <div class="max-w-4xl mx-auto">
            <!-- Section Header -->
            <div class="text-center mb-12">
                <p class="font-alexandria text-[#144394] text-base font-medium mb-3">
                    تواصل معنا
                </p>
                <h2
                    class="font-alexandria text-[#1C1C1C] text-3xl md:text-4xl font-bold mb-4 leading-tight"
                >
                    احجز عرضك التوضيحي الآن
                </h2>
                <p
                    class="font-alexandria text-[#757575] text-lg md:text-xl leading-relaxed"
                >
                    يسعدنا سماعك! يُرجى تعبئة النموذج وسنقوم بالتواصل معك لمساعدتك
                    واختيار الحل الأنسب <br />
                    لتدريب فريقك
                </p>
            </div>

            <!-- Contact Form -->
            <div class="max-w-lg mx-auto">
              <?php echo $__env->make('frontend.include.book_demo_form', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>

            <!-- Success Message (Initially Hidden) -->
            <div
                id="success-message"
                class="max-w-2lg mx-auto text-center hidden my-[10rem]"
            >
                <div class="flex flex-col items-center gap-8">
                    <!-- Success Icon -->
                    <img src="<?php echo e(asset('frontend/images')); ?>/success-icon.svg" alt="Success Icon" class="" />

                    <!-- Success Title -->
                    <div class="space-y-2">
                        <h3 class="font-alexandria text-[#00B34F] text-2xl font-semibold">
                            تم حجز عرضك التوضيحي بنجاح!
                        </h3>
                    </div>

                    <!-- Success Description -->
                    <div class="space-y-4">
                        <p
                            class="font-alexandria text-[#4A4A4A] text-xl leading-relaxed max-w-[654px]"
                        >
                            شكرًا لك، سيتواصل معك أحد ممثلي فريقنا في خلال 24 ساعة لتأكيد
                            التفاصيل وتقديم الدعم المناسب لاحتياجاتك
                        </p>
                    </div>

                    <!-- LinkedIn Message -->
                    <div class="flex items-start justify-center gap-2">
                        <!-- Speaker Icon -->
                        <div class="">
                            <img
                                src="<?php echo e(asset('frontend/images')); ?>/speaker-icon.svg"
                                alt="Speaker Icon"
                                class="w-full h-full"
                            />
                        </div>
                        <p class="font-alexandria text-[#3B3B3B] text-lg">
                            تابعنا على LinkedIn للتعرف على قصص نجاح عملائنا وآخر التحديثات
                        </p>
                    </div>

                    <!-- LinkedIn Button -->
                    <a
                        href="https://linkedin.com/company/e3melbusiness"
                        target="_blank"
                        rel="noopener"
                        class="bg-[#0076B2] text-white font-alexandria font-medium text-base px-8 py-3 rounded-3xl hover:bg-[#005a86] transition-colors duration-200 flex items-center justify-between gap-3 max-w-[474px] w-full"
                    >
                        <span>تابعنا علي Linkedin</span>
                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24">
                            <path
                                d="M19 3C19.5304 3 20.0391 3.21071 20.4142 3.58579C20.7893 3.96086 21 4.46957 21 5V19C21 19.5304 20.7893 20.0391 20.4142 20.4142C20.0391 20.7893 19.5304 21 19 21H5C4.46957 21 3.96086 20.7893 3.58579 20.4142C3.21071 20.0391 3 19.5304 3 19V5C3 4.46957 3.21071 3.96086 3.58579 3.58579C3.96086 3.21071 4.46957 3 5 3H19ZM18.5 18.5V13.2C18.5 12.3354 18.1565 11.5062 17.5452 10.8948C16.9338 10.2835 16.1046 9.94 15.24 9.94C14.39 9.94 13.4 10.46 12.92 11.24V10.13H10.13V18.5H12.92V13.57C12.92 12.8 13.54 12.17 14.31 12.17C14.6813 12.17 15.0374 12.3175 15.2999 12.5801C15.5625 12.8426 15.71 13.1987 15.71 13.57V18.5H18.5ZM6.88 8.56C7.32556 8.56 7.75288 8.383 8.06794 8.06794C8.383 7.75288 8.56 7.32556 8.56 6.88C8.56 5.95 7.81 5.19 6.88 5.19C6.43178 5.19 6.00193 5.36805 5.68499 5.68499C5.36805 6.00193 5.19 6.43178 5.19 6.88C5.19 7.81 5.95 8.56 6.88 8.56ZM8.27 18.5V10.13H5.5V18.5H8.27Z"
                            />
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('footerScript'); ?>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="assets/plugins/itl-tel-input/js/intlTelInput.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/jquery.validate.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        window.Toast= Swal.mixin({
            toast: true,
            position: "top-end",
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.onmouseenter = Swal.stopTimer;
                toast.onmouseleave = Swal.resumeTimer;
            }
        });
    </script>
    <script type="module">
        import ar from "<?php echo e(asset('assets/plugins/itl-tel-input/js/i18n/ar/index.js')); ?>";
        (function () {
            const phone_tel_input = document.getElementById("phone_tel_input");
            if(phone_tel_input) {
                const iti_phone_input = window.intlTelInput(phone_tel_input, {
                    initialCountry: "auto",
                    geoIpLookup: function (success, failure) {
                        fetch("https://ipapi.co/json")
                            .then(function (res) {
                                return res.json();
                            })
                            .then(function (data) {
                                success(data.country_code);
                            })
                            .catch(function () {
                                failure();
                            });
                    },
                    i18n: {
                        ...ar,
                        <?php foreach ($countries as $x=>$country){$country = (object)$country?>
                            <?=strtolower($country->iso)?>: "<?=(strlen($x) == 1 ? '000' : (strlen($x) == 2 ? '00' : (strlen($x) == 3 ? '0' : ''))) . ($x + 1)?> - <?=$country->name?>",
                        <?php }?>
                        // eg: "01 - جمهورية مصر العربية",
                        // sa: "02 - المملكة العربية السعودية",
                        // ae: "03 - الإمارات العربية المتخدة",
                        // kw: "04 - الكويت",
                        // qa: "05 - قطر",
                        // om: "06 - عمان",
                        // iq: "07 - العراق",
                        // ly: "08 - ليبيا",
                        // ma: "10 - المغرب",
                        // ps: "11 - فلسطين",
                        // jo: "12 - الأردن",
                        // bh: "13 - مملكة البحرين",
                        // tn: "14 - تونس",
                        // us: "15 - الولايات المتحدة",
                    },
                    onlyCountries: [
                        <?php foreach ($countries as $country){$country = (object)$country?>
                            "<?=strtolower($country->iso)?>",
                        <?php }?>
                        // "eg",
                        // "kw",
                        // "sa",
                        // "qa",
                        // "bh",
                        // "iq",
                        // "ae",
                        // "om",
                        // "ly",
                        // "ma",
                        // "ps",
                        // "jo",
                        // "tn",
                        // "us",
                    ],
                    separateDialCode: true,
                    strictMode: true,
                });
                const country_el = document.getElementById("country");
                const dial_el = document.getElementById("dialCode");
                const phone_el = document.getElementById("phone");
                phone_tel_input.addEventListener("countrychange", function () {
                    handleInputs();
                });
                phone_tel_input.addEventListener("change", function () {
                    handleInputs();
                });
                handleInputs();

                function handleInputs() {
                    if (country_el)
                        country_el.value = iti_phone_input.getSelectedCountryData().iso2;
                    if (dial_el)
                        dial_el.value = iti_phone_input.getSelectedCountryData().dialCode;
                    if (phone_el)
                        phone_el.value =
                            iti_phone_input.getSelectedCountryData().dialCode +
                            phone_tel_input.value;
                }
            }
            // Validation

            jQuery.validator.addMethod(
                "validate_email",
                function (value, element, param) {
                    if (!value) return true;
                    return value.match(
                        /^[a-zA-Z0-9_\.%\+\-]+@[a-zA-Z0-9\.\-]+\.[a-zA-Z]{2,}$/
                    );
                },
                "Enter a valid email address"
            );
            $('#saveBookDemo').validate({
                rules: {
                    name: {
                        required: true,
                        minlength: 3,
                    },
                    email: {
                        required: true,
                        validate_email: true,
                    },
                    phone_tel_input: {
                        required: true,
                        minlength: 6,
                    },
                    company: {
                        required: true,
                        minlength: 3,
                    },
                },
                messages: {
                    name: {
                        required: "يجب ادخال الاسم",
                        minlength: "من فضلك ادخل اسم صحيح",
                    },
                    email: {
                        required: "يجب ادخال البريد الإلكتروني",
                        validate_email: "من فضلك ادخل بريد الكتروني صالح",
                    },
                    phone_tel_input: {
                        required: "يجب ادخال رقم الجوال",
                        digits: "رقم الجوال غير صالح",
                        minlength: "رقم الجوال غير صالح",
                    },
                    company: {
                        required: "يجب ادخال اسم الشركة",
                        minlength: "من فضلك ادخل اسم صحيح",
                    },
                },
                errorElement: "p",
                errorClass: "mt-1 text-sm text-red-600", // Tailwind classes for error text
                highlight: function(element) {
                    $(element).addClass("border-red-500 focus:border-red-500 focus:ring-red-200");
                },
                unhighlight: function(element) {
                    $(element).removeClass("border-red-500 focus:border-red-500 focus:ring-red-200");
                },
                errorPlacement: function(error, element) {
                    error.insertAfter(element.parent()); // ضع رسالة الخطأ تحت الـ input
                },
                submitHandler: function(form) {
                    $(form).addClass('loading');
                    let formData=new FormData(form);
                    fetch("<?php echo e(route('register_page')); ?>", {
                        method: "POST",
                        body: formData,
                        headers: {
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                            "Accept": "application/json"
                        }
                    })
                        .then(async response => {
                            // Laravel بيرجع JSON غالبًا
                            // if (!response.ok) {
                            //     throw new Error("يوجد خطء في الوقت الحالي حاول مره اخري لاحقا او تواصل معنا");
                            // }
                            return response.json();
                        })
                        .then(data => {
                            $(form).removeClass('loading')

                            if (data.success) {
                                $(form)[0].reset();
                                // Hide section header (تواصل معنا part)
                                document.querySelector(".text-center.mb-12").classList.add("hidden");

                                // Hide form and show success message
                                document
                                    .getElementById("saveBookDemo")
                                    .parentElement.classList.add("hidden");
                                document.getElementById("success-message").classList.remove("hidden");

                                // Scroll to success message
                                document.getElementById("success-message").scrollIntoView({
                                    behavior: "smooth",
                                    block: "center",
                                });
                            }

                            if (typeof data.message === 'object') {
                                for(let key in data.message){
                                    $(form).find("[name='"+key+"']").parent().append('<label id="'+key+'-error" class="error" for="'+key+'">'+data.message[key]+'</label>');
                                }
                            }
                            Toast.fire({
                                icon: data.success ? "success" : "error",
                                title: data.message
                            });

                        })
                        .catch(error => {
                            $(form).removeClass('loading')
                            console.error("Fetch error:", error);
                            Toast.fire({
                                icon: "error",
                                title:error.toString().replaceAll('Error:','')
                            });
                        });
                }
            });

        })();
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ebacademy/public_html/beta.e3melbusiness.org/resources/views/frontend/book_demo.blade.php ENDPATH**/ ?>