<?php $__env->startPush('headScript'); ?>
    <!-- Tailwind Configuration -->
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        alexandria: ["Alexandria", "sans-serif"],
                        tajawal: ["Tajawal", "sans-serif"],
                    },
                    colors: {
                        "brand-success": "#00B34F",
                        "brand-secondary-normal": "#00B34F",
                        "brand-secondary-light": "#E6F7ED",
                        "brand-primary-normal": "#144394",
                        "brand-primary-light": "#E8ECF4",
                    },
                },
            },
        };
    </script>

    <style>
        body {
            font-family: "Alexandria", sans-serif;
        }

        /* Mobile Menu Styles */
        .mobile-menu {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.4s ease-in-out, opacity 0.3s ease-in-out;
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
        }

        .mobile-menu.open {
            max-height: 600px;
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        /* Ensure mobile menu is above other elements */
        .mobile-menu .bg-white\/95 {
            background-color: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
        }

        /* Mobile menu animation */
        .mobile-menu .mobile-menu-content {
            transform: translateY(-20px);
            transition: transform 0.3s ease-out;
        }

        .mobile-menu.open .mobile-menu-content {
            transform: translateY(0);
        }

        /* Mobile responsive button adjustments */
        @media (max-width: 768px) {
            .responsive-button-text {
                display: none;
            }

            .responsive-button-icon {
                margin: 0 !important;
            }
        }

        @media (max-width: 640px) {
            .hero-title-mobile {
                font-size: 2.5rem !important;
                line-height: 3rem !important;
            }
        }
    </style>
    <!-- CSS for FAQ Animations -->
    <style>
        .faq-answer {
            transition: max-height 0.4s ease-in-out, opacity 0.3s ease-in-out, padding 0.4s ease-in-out;
        }

        .faq-answer.hidden {
            max-height: 0;
            overflow: hidden;
            opacity: 0;
            padding-top: 0;
        }

        .faq-answer.open {
            max-height: 200px;
            overflow: hidden;
            opacity: 1;
            padding-top: 8px;
        }

        .faq-item {
            transition: background-color 0.3s ease-in-out, border-color 0.3s ease-in-out;
        }

        .faq-icon {
            transition: transform 0.3s ease-in-out;
        }

        .faq-icon img {
            transition: opacity 0.2s ease-in-out;
        }

        .faq-button:hover .faq-icon {
            transform: scale(1.1);
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Hero Section for Pricing Page -->
    <div class="relative overflow-hidden min-h-[700px]">
        <!-- Background Image -->
        <div class="absolute left-0 bottom-0 z-0">
            <img src="<?php echo e(asset('frontend/images')); ?>/hero-our-prices.png" alt="Hero Image" />
        </div>

        <!-- Background Gradient Overlay -->
        <div class="absolute inset-0">
            <svg class="w-full h-full" viewBox="0 0 1600 808" fill="none" xmlns="http://www.w3.org/2000/svg"
                 preserveAspectRatio="xMidYMid slice">
                <path d="M0 0H1600V808H0V0Z" fill="url(#paint0_linear_gradient_overlay)" />
                <defs>
                    <linearGradient id="paint0_linear_gradient_overlay" x1="205.022" y1="0" x2="1573.65" y2="664.405"
                                    gradientUnits="userSpaceOnUse">
                        <stop offset="0%" stop-color="#0C2959" stop-opacity="0.45" />
                        <stop offset="18.28%" stop-color="#0C2959" stop-opacity="0.55" />
                        <stop offset="31.41%" stop-color="#0C2959" stop-opacity="0.62" />
                        <stop offset="49.65%" stop-color="#0C2959" stop-opacity="0.72" />
                        <stop offset="74.35%" stop-color="#0C2959" stop-opacity="0.86" />
                        <stop offset="100%" stop-color="#0C2959" />
                    </linearGradient>
                </defs>
            </svg>
        </div>

        <!-- Background Ellipses -->
        <div class="absolute -top-96 -left-96">
            <img src="<?php echo e(asset('frontend/images')); ?>/hero-background.png" alt="Background Ellipses"
                 class="w-[1179px] h-[1101px] object-contain" />
        </div>

        <!-- Wave at bottom -->
        <div class="absolute bottom-0 left-0 w-full">
            <svg class="w-full h-52" viewBox="0 0 1600 202" fill="none" xmlns="http://www.w3.org/2000/svg"
                 preserveAspectRatio="none">
                <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M0 79.458C0 79.458 226.389 186.741 381.052 178.06C535.714 169.378 628.364 133.594 798.309 151.486C968.253 169.378 1461.17 124.238 1600 0V209.034H0V79.458Z"
                      fill="#FDFDFF" />
            </svg>
        </div>
        <!-- Content Container -->
        <div class="relative z-10 pt-32 pb-32 px-4 md:px-8 lg:px-16 min-h-[700px] flex items-center justify-center">
            <div class="max-w-4xl mx-auto text-center">
                <!-- Breadcrumb Navigation -->
                <div class="flex items-center justify-center gap-2 mb-6">
                    <div class="font-alexandria font-normal text-white text-[20px]">
                        الرئيسية
                    </div>
                    <div class="w-6 h-6 flex items-center justify-center">
                        <svg width="8" height="14" viewBox="0 0 8 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M7 13L1 7L7 1" stroke="white" stroke-width="2" stroke-linecap="round"
                                  stroke-linejoin="round" />
                        </svg>
                    </div>

                    <div class="font-alexandria font-medium text-[#00B34F] text-[20px]">
                        اسعارنا
                    </div>
                </div>

                <!-- Main Title -->
                <h1 class="font-alexandria font-bold text-white leading-[72px] mb-6 text-[48px] hero-title-mobile">
                    اسعارنا
                </h1>

                <!-- Subtitle -->
                <p class="font-alexandria font-medium text-[#DEDEDE] text-[18px] leading-[27px] mb-8 max-w-4xl mx-auto">
                    خطط واضحة ومرنة تناسب احتياجات شركتك وتواكب نموها. اختر الخطة الأنسب
                    وابدأ في تطوير <br /> فريقك اليوم
                </p>
            </div>
        </div>
    </div>

    <!-- ====================================== Pricing Section ===================================-->
    <div class="bg-[#F4F7FA] pt-16 pb-[200px] px-4 md:px-8 lg:px-16 relative overflow-hidden my-[5.25rem]" dir="rtl">
        <!-- Decorative Pattern -->
        <div class="absolute bottom-0 right-0">
            <img src="<?php echo e(asset('frontend/images')); ?>/pricing-decorative-pattern.png" alt="Decorative Pattern" class="w-full h-full" />
        </div>

        <div class="max-w-7xl mx-auto relative z-10">
            <!-- Header Section -->
            <div class="text-center mb-16 space-y-5">
                <h2 class="font-alexandria font-semibold text-4xl md:text-5xl text-[#1C1C1C] leading-tight"
                    style="letter-spacing: -1.8px">
                    اختر الخطة الأنسب لنمو شركتك
                </h2>
                <p class="font-alexandria text-lg text-[#3B3B3B]/70 max-w-4xl mx-auto leading-relaxed"
                   style="letter-spacing: -0.2px">
                    خطط مصممة لتناسب احتياجات المؤسسات من مختلف الأحجام — مع إمكانية
                    التوسع، والمزيد من التحكم، وتجربة تدريب احترافية.
                </p>
            </div>

            <!-- Pricing Cards Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 max-w-6xl mx-auto">
                <!-- Corporate Plan -->
                <div class="bg-white rounded-lg border border-[#EAECF0] shadow-lg p-8 space-y-6 h-fit order-3" style="
              box-shadow: 0 12px 16px -4px rgba(16, 24, 40, 0.08),
                0 4px 6px -2px rgba(16, 24, 40, 0.03);
            ">
                    <!-- Header -->
                    <div class="text-center space-y-4">
                        <div class="">
                            <img src="<?php echo e(asset('frontend/images')); ?>/corporate-plan-icon.png" alt="Corporate Plan Icon"
                                 class="w-[56px] h-[56px] mx-auto mb-2" />
                        </div>
                        <div>
                            <h3 class="font-alexandria font-semibold text-2xl text-[#101828] mb-2">
                                خطة الشركات الكبرى
                            </h3>
                            <p class="font-alexandria text-base text-[#667085]">
                                طوّر فرقك بخطة مرنة </p>
                        </div>
                    </div>

                    <!-- Features -->
                    <div class="space-y-4">
                        <div class="flex items-start gap-3 justify-start">
                            <div class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M10.6667 12.6673H13.3333C13.5101 12.6673 13.6797 12.5971 13.8047 12.4721C13.9298 12.347 14 12.1775 14 12.0007V11.334C14 10.8036 13.7893 10.2948 13.4142 9.91977C13.0391 9.5447 12.5304 9.33399 12 9.33399H10.6667M9.176 6.66732C9.44603 6.96922 9.80137 7.18202 10.195 7.27756C10.5886 7.37309 11.002 7.34686 11.3804 7.20233C11.7587 7.0578 12.0843 6.80178 12.314 6.46816C12.5437 6.13454 12.6667 5.73904 12.6667 5.33398C12.6667 4.92893 12.5437 4.53343 12.314 4.19981C12.0843 3.86619 11.7587 3.61017 11.3804 3.46564C11.002 3.32111 10.5886 3.29488 10.195 3.39041C9.80137 3.48594 9.44603 3.69874 9.176 4.00065M2 12.0007V11.334C2 10.8036 2.21071 10.2948 2.58579 9.91977C2.96086 9.5447 3.46957 9.33399 4 9.33399H6.66667C7.1971 9.33399 7.70581 9.5447 8.08088 9.91977C8.45595 10.2948 8.66667 10.8036 8.66667 11.334V12.0007C8.66667 12.1775 8.59643 12.347 8.4714 12.4721C8.34638 12.5971 8.17681 12.6673 8 12.6673H2.66667C2.48986 12.6673 2.32029 12.5971 2.19526 12.4721C2.07024 12.347 2 12.1775 2 12.0007ZM7.33333 5.33398C7.33333 5.86442 7.12262 6.37313 6.74755 6.7482C6.37247 7.12327 5.86377 7.33398 5.33333 7.33398C4.8029 7.33398 4.29419 7.12327 3.91912 6.7482C3.54405 6.37313 3.33333 5.86442 3.33333 5.33398C3.33333 4.80355 3.54405 4.29484 3.91912 3.91977C4.29419 3.5447 4.8029 3.33398 5.33333 3.33398C5.86377 3.33398 6.37247 3.5447 6.74755 3.91977C7.12262 4.29484 7.33333 4.80355 7.33333 5.33398Z"
                                        stroke="#00B34F" stroke-linecap="round" />
                                </svg>
                            </div>
                            <span class="font-alexandria text-sm text-[#575757] text-right">عدد المستخدمين: 15
                                مستخدم</span>
                        </div>

                        <div class="flex items-start gap-3 justify-start">
                            <div class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M8.00001 14V8M8.00001 4.66667H5.30001C3.45334 4.66667 3.34001 2 5.30001 2C7.40001 2 8.00001 4.66667 8.00001 4.66667ZM8.00001 4.66667H10.7C12.6307 4.66667 12.6307 2 10.7 2C8.60001 2 8.00001 4.66667 8.00001 4.66667Z"
                                        stroke="#00B34F" stroke-linecap="round" stroke-linejoin="round" />
                                    <path
                                        d="M13.3333 7.99935V12.666C13.3333 13.0196 13.1929 13.3588 12.9428 13.6088C12.6928 13.8589 12.3536 13.9993 12 13.9993H4C3.64638 13.9993 3.30724 13.8589 3.05719 13.6088C2.80714 13.3588 2.66667 13.0196 2.66667 12.666V7.99935M14 7.99935V5.99935C14 5.64573 13.8595 5.30659 13.6095 5.05654C13.3594 4.80649 13.0203 4.66602 12.6667 4.66602H3.33333C2.97971 4.66602 2.64057 4.80649 2.39052 5.05654C2.14048 5.30659 2 5.64573 2 5.99935V7.99935H14Z"
                                        stroke="#00B34F" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </div>
                            <span class="font-alexandria text-sm text-[#575757] text-right">مستخدمين مجانيين: 5
                                مجانا</span>
                        </div>

                        <div class="flex items-start gap-3 justify-start">
                            <div class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path d="M7.99967 3.33398V12.6673M3.33301 8.00065H12.6663" stroke="#00B34F"
                                          stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </div>
                            <span class="font-alexandria text-sm text-[#575757] text-right">رسوم المستخدم الإضافي:
                                174$</span>
                        </div>

                        <div class="flex items-start gap-3 justify-start">
                            <div class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M13.3 7.33329C13.1314 6.04712 12.4999 4.86648 11.5235 4.01237C10.5472 3.15827 9.29313 2.68926 7.99596 2.69314C6.69879 2.69702 5.4475 3.17352 4.47632 4.03345C3.50514 4.89337 2.88065 6.07777 2.71976 7.36493C2.55886 8.65209 2.87259 9.95376 3.60221 11.0263C4.33183 12.0988 5.42733 12.8687 6.68363 13.1917C7.93994 13.5148 9.27091 13.3689 10.4274 12.7814C11.5839 12.1939 12.4867 11.2051 12.9667 9.99996M13.3 13.3333V9.99996H9.96667"
                                        stroke="#00B34F" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </div>
                            <span class="font-alexandria text-sm text-[#575757] text-right">عدد مرات الاستبدال: مرة
                                واحدة لكل مستخدم</span>
                        </div>
                    </div>

                    <!-- CTA Button -->
                    <a href="<?php echo e(route('book_demo_page')); ?>"
                        class="w-full flex items-center justify-center gap-3 px-6 py-3 bg-[#00B34F] border border-[#00B34F] rounded-lg text-white font-alexandria font-medium hover:bg-[#00A047] transition-colors">
                        <span class="text-base">احجز عرضًا توضيحيًا الآن</span>

                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M8.414 13.3431L12.364 17.2931C12.5462 17.4817 12.647 17.7343 12.6447 17.9965C12.6424 18.2587 12.5372 18.5095 12.3518 18.6949C12.1664 18.8803 11.9156 18.9855 11.6534 18.9878C11.3912 18.99 11.1386 18.8892 10.95 18.7071L5.293 13.0501C5.19982 12.9574 5.12587 12.8473 5.07541 12.7259C5.02494 12.6046 4.99897 12.4745 4.99897 12.3431C4.99897 12.2117 5.02494 12.0816 5.07541 11.9602C5.12587 11.8389 5.19982 11.7287 5.293 11.6361L10.95 5.97908C11.0422 5.88357 11.1526 5.80739 11.2746 5.75498C11.3966 5.70257 11.5278 5.67498 11.6606 5.67383C11.7934 5.67268 11.9251 5.69798 12.048 5.74826C12.1709 5.79854 12.2825 5.87279 12.3764 5.96669C12.4703 6.06058 12.5445 6.17223 12.5948 6.29513C12.6451 6.41802 12.6704 6.5497 12.6693 6.68248C12.6681 6.81526 12.6405 6.94648 12.5881 7.06849C12.5357 7.19049 12.4595 7.30083 12.364 7.39308L8.414 11.3431H18C18.2652 11.3431 18.5196 11.4484 18.7071 11.636C18.8946 11.8235 19 12.0779 19 12.3431C19 12.6083 18.8946 12.8627 18.7071 13.0502C18.5196 13.2377 18.2652 13.3431 18 13.3431H8.414Z"
                                fill="white" />
                        </svg>
                    </a>
                </div>

                <!-- Business Plan -->
                <div class="bg-white rounded-lg border border-[#EAECF0] shadow-lg p-8 space-y-6 h-fit order-2" style="
              box-shadow: 0 12px 16px -4px rgba(16, 24, 40, 0.08),
                0 4px 6px -2px rgba(16, 24, 40, 0.03);
            ">
                    <!-- Header -->
                    <div class="text-center space-y-4 flex flex-col items-center">
                        <div class="">
                            <img src="<?php echo e(asset('frontend/images')); ?>/business-plan-icon.png" alt="Business Plan Icon"
                                 class="w-[60px] h-[60px] mx-auto" />
                        </div>
                        <div>
                            <h3 class="font-alexandria font-semibold text-2xl text-[#101828] mb-2">
                                خطة الأعمال
                            </h3>
                            <p class="font-alexandria text-base text-[#667085]">
                                خطة ذكية لنمو مستدام
                            </p>
                        </div>
                    </div>

                    <!-- Features -->
                    <div class="space-y-4">
                        <div class="flex items-start gap-3 justify-start">
                            <div class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M10.6667 12.6673H13.3333C13.5101 12.6673 13.6797 12.5971 13.8047 12.4721C13.9298 12.347 14 12.1775 14 12.0007V11.334C14 10.8036 13.7893 10.2948 13.4142 9.91977C13.0391 9.5447 12.5304 9.33399 12 9.33399H10.6667M9.176 6.66732C9.44603 6.96922 9.80137 7.18202 10.195 7.27756C10.5886 7.37309 11.002 7.34686 11.3804 7.20233C11.7587 7.0578 12.0843 6.80178 12.314 6.46816C12.5437 6.13454 12.6667 5.73904 12.6667 5.33398C12.6667 4.92893 12.5437 4.53343 12.314 4.19981C12.0843 3.86619 11.7587 3.61017 11.3804 3.46564C11.002 3.32111 10.5886 3.29488 10.195 3.39041C9.80137 3.48594 9.44603 3.69874 9.176 4.00065M2 12.0007V11.334C2 10.8036 2.21071 10.2948 2.58579 9.91977C2.96086 9.5447 3.46957 9.33399 4 9.33399H6.66667C7.1971 9.33399 7.70581 9.5447 8.08088 9.91977C8.45595 10.2948 8.66667 10.8036 8.66667 11.334V12.0007C8.66667 12.1775 8.59643 12.347 8.4714 12.4721C8.34638 12.5971 8.17681 12.6673 8 12.6673H2.66667C2.48986 12.6673 2.32029 12.5971 2.19526 12.4721C2.07024 12.347 2 12.1775 2 12.0007ZM7.33333 5.33398C7.33333 5.86442 7.12262 6.37313 6.74755 6.7482C6.37247 7.12327 5.86377 7.33398 5.33333 7.33398C4.8029 7.33398 4.29419 7.12327 3.91912 6.7482C3.54405 6.37313 3.33333 5.86442 3.33333 5.33398C3.33333 4.80355 3.54405 4.29484 3.91912 3.91977C4.29419 3.5447 4.8029 3.33398 5.33333 3.33398C5.86377 3.33398 6.37247 3.5447 6.74755 3.91977C7.12262 4.29484 7.33333 4.80355 7.33333 5.33398Z"
                                        stroke="#00B34F" stroke-linecap="round" />
                                </svg>
                            </div>
                            <span class="font-alexandria text-sm text-[#575757] text-right">عدد المستخدمين: 15
                                مستخدم</span>
                        </div>

                        <div class="flex items-start gap-3 justify-start">
                            <div class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M8.00001 14V8M8.00001 4.66667H5.30001C3.45334 4.66667 3.34001 2 5.30001 2C7.40001 2 8.00001 4.66667 8.00001 4.66667ZM8.00001 4.66667H10.7C12.6307 4.66667 12.6307 2 10.7 2C8.60001 2 8.00001 4.66667 8.00001 4.66667Z"
                                        stroke="#00B34F" stroke-linecap="round" stroke-linejoin="round" />
                                    <path
                                        d="M13.3333 7.99935V12.666C13.3333 13.0196 13.1929 13.3588 12.9428 13.6088C12.6928 13.8589 12.3536 13.9993 12 13.9993H4C3.64638 13.9993 3.30724 13.8589 3.05719 13.6088C2.80714 13.3588 2.66667 13.0196 2.66667 12.666V7.99935M14 7.99935V5.99935C14 5.64573 13.8595 5.30659 13.6095 5.05654C13.3594 4.80649 13.0203 4.66602 12.6667 4.66602H3.33333C2.97971 4.66602 2.64057 4.80649 2.39052 5.05654C2.14048 5.30659 2 5.64573 2 5.99935V7.99935H14Z"
                                        stroke="#00B34F" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </div>
                            <span class="font-alexandria text-sm text-[#575757] text-right">مستخدمين مجانيين: 5
                                مجانا</span>
                        </div>

                        <div class="flex items-start gap-3 justify-start">
                            <div class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path d="M7.99967 3.33398V12.6673M3.33301 8.00065H12.6663" stroke="#00B34F"
                                          stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </div>
                            <span class="font-alexandria text-sm text-[#575757] text-right">رسوم المستخدم الإضافي:
                                174$</span>
                        </div>

                        <div class="flex items-start gap-3 justify-start">
                            <div class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M13.3 7.33329C13.1314 6.04712 12.4999 4.86648 11.5235 4.01237C10.5472 3.15827 9.29313 2.68926 7.99596 2.69314C6.69879 2.69702 5.4475 3.17352 4.47632 4.03345C3.50514 4.89337 2.88065 6.07777 2.71976 7.36493C2.55886 8.65209 2.87259 9.95376 3.60221 11.0263C4.33183 12.0988 5.42733 12.8687 6.68363 13.1917C7.93994 13.5148 9.27091 13.3689 10.4274 12.7814C11.5839 12.1939 12.4867 11.2051 12.9667 9.99996M13.3 13.3333V9.99996H9.96667"
                                        stroke="#00B34F" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </div>
                            <span class="font-alexandria text-sm text-[#575757] text-right">عدد مرات الاستبدال: مرة
                                واحدة لكل مستخدم</span>
                        </div>
                    </div>

                    <!-- CTA Button -->
                    <a href="<?php echo e(route('book_demo_page')); ?>"
                        class="w-full flex items-center justify-center gap-3 px-6 py-3 bg-[#00B34F] border border-[#00B34F] rounded-lg text-white font-alexandria font-medium hover:bg-[#00A047] transition-colors">
                        <span class="text-base">احجز عرضًا توضيحيًا الآن</span>

                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M8.414 13.3431L12.364 17.2931C12.5462 17.4817 12.647 17.7343 12.6447 17.9965C12.6424 18.2587 12.5372 18.5095 12.3518 18.6949C12.1664 18.8803 11.9156 18.9855 11.6534 18.9878C11.3912 18.99 11.1386 18.8892 10.95 18.7071L5.293 13.0501C5.19982 12.9574 5.12587 12.8473 5.07541 12.7259C5.02494 12.6046 4.99897 12.4745 4.99897 12.3431C4.99897 12.2117 5.02494 12.0816 5.07541 11.9602C5.12587 11.8389 5.19982 11.7287 5.293 11.6361L10.95 5.97908C11.0422 5.88357 11.1526 5.80739 11.2746 5.75498C11.3966 5.70257 11.5278 5.67498 11.6606 5.67383C11.7934 5.67268 11.9251 5.69798 12.048 5.74826C12.1709 5.79854 12.2825 5.87279 12.3764 5.96669C12.4703 6.06058 12.5445 6.17223 12.5948 6.29513C12.6451 6.41802 12.6704 6.5497 12.6693 6.68248C12.6681 6.81526 12.6405 6.94648 12.5881 7.06849C12.5357 7.19049 12.4595 7.30083 12.364 7.39308L8.414 11.3431H18C18.2652 11.3431 18.5196 11.4484 18.7071 11.636C18.8946 11.8235 19 12.0779 19 12.3431C19 12.6083 18.8946 12.8627 18.7071 13.0502C18.5196 13.2377 18.2652 13.3431 18 13.3431H8.414Z"
                                fill="white" />
                        </svg>
                    </a>
                </div>

                <!-- Basic Plan (Most Popular) -->
                <div class="bg-white rounded-lg border border-[#EAECF0] shadow-lg p-8 space-y-6 relative h-fit -order-1 relative"
                     style=" box-shadow: 0 12px 16px -4px rgba(16, 24, 40, 0.08), 0 4px 6px -2px rgba(16, 24, 40, 0.03);">
                    <!-- Popular Badge -->
                    <div class="absolute absolute -top-[74px] -right-[24px]">
                        <div class="">
                            <span
                                class="px-2 py-1 rounded text-[#144394] text-sm font-alexandria font-medium relative">الاكثر
                                شهرة لدينا</span>
                            <img src="<?php echo e(asset('frontend/images')); ?>/popular-arrow.png" alt="Popular Badge"
                                 class="w-[40px] h-[40px] absolute left-[-40px] " />
                        </div>
                    </div>

                    <!-- Header -->
                    <div class="text-center">
                        <div class="text-[#144394] font-alexandria font-semibold text-5xl leading-tight"
                             style="letter-spacing: -0.96px">
                            2,600$
                        </div>
                        <div>
                            <h3 class="font-alexandria font-semibold text-2xl text-[#101828] mb-2">
                                الخطة الأساسية
                            </h3>
                            <p class="font-alexandria text-base text-[#667085]">
                                انطلق بتدريب فريقك
                            </p>
                        </div>
                    </div>

                    <!-- Features -->
                    <div class="space-y-4">
                        <div class="flex items-start gap-3 justify-start">
                            <div class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M10.6667 12.6673H13.3333C13.5101 12.6673 13.6797 12.5971 13.8047 12.4721C13.9298 12.347 14 12.1775 14 12.0007V11.334C14 10.8036 13.7893 10.2948 13.4142 9.91977C13.0391 9.5447 12.5304 9.33399 12 9.33399H10.6667M9.176 6.66732C9.44603 6.96922 9.80137 7.18202 10.195 7.27756C10.5886 7.37309 11.002 7.34686 11.3804 7.20233C11.7587 7.0578 12.0843 6.80178 12.314 6.46816C12.5437 6.13454 12.6667 5.73904 12.6667 5.33398C12.6667 4.92893 12.5437 4.53343 12.314 4.19981C12.0843 3.86619 11.7587 3.61017 11.3804 3.46564C11.002 3.32111 10.5886 3.29488 10.195 3.39041C9.80137 3.48594 9.44603 3.69874 9.176 4.00065M2 12.0007V11.334C2 10.8036 2.21071 10.2948 2.58579 9.91977C2.96086 9.5447 3.46957 9.33399 4 9.33399H6.66667C7.1971 9.33399 7.70581 9.5447 8.08088 9.91977C8.45595 10.2948 8.66667 10.8036 8.66667 11.334V12.0007C8.66667 12.1775 8.59643 12.347 8.4714 12.4721C8.34638 12.5971 8.17681 12.6673 8 12.6673H2.66667C2.48986 12.6673 2.32029 12.5971 2.19526 12.4721C2.07024 12.347 2 12.1775 2 12.0007ZM7.33333 5.33398C7.33333 5.86442 7.12262 6.37313 6.74755 6.7482C6.37247 7.12327 5.86377 7.33398 5.33333 7.33398C4.8029 7.33398 4.29419 7.12327 3.91912 6.7482C3.54405 6.37313 3.33333 5.86442 3.33333 5.33398C3.33333 4.80355 3.54405 4.29484 3.91912 3.91977C4.29419 3.5447 4.8029 3.33398 5.33333 3.33398C5.86377 3.33398 6.37247 3.5447 6.74755 3.91977C7.12262 4.29484 7.33333 4.80355 7.33333 5.33398Z"
                                        stroke="#00B34F" stroke-linecap="round" />
                                </svg>
                            </div>
                            <span class="font-alexandria text-sm text-[#575757] text-right">عدد المستخدمين: 15
                                مستخدم</span>
                        </div>

                        <div class="flex items-start gap-3 justify-start">
                            <div class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M8.00001 14V8M8.00001 4.66667H5.30001C3.45334 4.66667 3.34001 2 5.30001 2C7.40001 2 8.00001 4.66667 8.00001 4.66667ZM8.00001 4.66667H10.7C12.6307 4.66667 12.6307 2 10.7 2C8.60001 2 8.00001 4.66667 8.00001 4.66667Z"
                                        stroke="#00B34F" stroke-linecap="round" stroke-linejoin="round" />
                                    <path
                                        d="M13.3333 7.99935V12.666C13.3333 13.0196 13.1929 13.3588 12.9428 13.6088C12.6928 13.8589 12.3536 13.9993 12 13.9993H4C3.64638 13.9993 3.30724 13.8589 3.05719 13.6088C2.80714 13.3588 2.66667 13.0196 2.66667 12.666V7.99935M14 7.99935V5.99935C14 5.64573 13.8595 5.30659 13.6095 5.05654C13.3594 4.80649 13.0203 4.66602 12.6667 4.66602H3.33333C2.97971 4.66602 2.64057 4.80649 2.39052 5.05654C2.14048 5.30659 2 5.64573 2 5.99935V7.99935H14Z"
                                        stroke="#00B34F" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </div>
                            <span class="font-alexandria text-sm text-[#575757] text-right">مستخدمين مجانيين: 5
                                مجانا</span>
                        </div>

                        <div class="flex items-start gap-3 justify-start">
                            <div class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path d="M7.99967 3.33398V12.6673M3.33301 8.00065H12.6663" stroke="#00B34F"
                                          stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </div>
                            <span class="font-alexandria text-sm text-[#575757] text-right">رسوم المستخدم الإضافي:
                                174$</span>
                        </div>

                        <div class="flex items-start gap-3 justify-start">
                            <div class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M13.3 7.33329C13.1314 6.04712 12.4999 4.86648 11.5235 4.01237C10.5472 3.15827 9.29313 2.68926 7.99596 2.69314C6.69879 2.69702 5.4475 3.17352 4.47632 4.03345C3.50514 4.89337 2.88065 6.07777 2.71976 7.36493C2.55886 8.65209 2.87259 9.95376 3.60221 11.0263C4.33183 12.0988 5.42733 12.8687 6.68363 13.1917C7.93994 13.5148 9.27091 13.3689 10.4274 12.7814C11.5839 12.1939 12.4867 11.2051 12.9667 9.99996M13.3 13.3333V9.99996H9.96667"
                                        stroke="#00B34F" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </div>
                            <span class="font-alexandria text-sm text-[#575757] text-right">عدد مرات الاستبدال: مرة
                                واحدة لكل مستخدم</span>
                        </div>
                    </div>

                    <!-- CTA Button -->
                    <a href="<?php echo e(route('book_demo_page')); ?>"
                        class="w-full flex items-center justify-center gap-3 px-6 py-3 bg-[#144394] border border-[#144394] rounded-lg text-white font-alexandria font-medium hover:bg-[#0f3677] transition-colors">
                        <span class="text-base">احجز عرضًا توضيحيًا الآن</span>

                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M8.414 13.3431L12.364 17.2931C12.5462 17.4817 12.647 17.7343 12.6447 17.9965C12.6424 18.2587 12.5372 18.5095 12.3518 18.6949C12.1664 18.8803 11.9156 18.9855 11.6534 18.9878C11.3912 18.99 11.1386 18.8892 10.95 18.7071L5.293 13.0501C5.19982 12.9574 5.12587 12.8473 5.07541 12.7259C5.02494 12.6046 4.99897 12.4745 4.99897 12.3431C4.99897 12.2117 5.02494 12.0816 5.07541 11.9602C5.12587 11.8389 5.19982 11.7287 5.293 11.6361L10.95 5.97908C11.0422 5.88357 11.1526 5.80739 11.2746 5.75498C11.3966 5.70257 11.5278 5.67498 11.6606 5.67383C11.7934 5.67268 11.9251 5.69798 12.048 5.74826C12.1709 5.79854 12.2825 5.87279 12.3764 5.96669C12.4703 6.06058 12.5445 6.17223 12.5948 6.29513C12.6451 6.41802 12.6704 6.5497 12.6693 6.68248C12.6681 6.81526 12.6405 6.94648 12.5881 7.06849C12.5357 7.19049 12.4595 7.30083 12.364 7.39308L8.414 11.3431H18C18.2652 11.3431 18.5196 11.4484 18.7071 11.636C18.8946 11.8235 19 12.0779 19 12.3431C19 12.6083 18.8946 12.8627 18.7071 13.0502C18.5196 13.2377 18.2652 13.3431 18 13.3431H8.414Z"
                                fill="white" />
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </div>


    <!-- ====================================== Features Section ===================================== -->
    <div class="bg-[#F2F4F9] flex items-center justify-center px-4 md:px-8 py-16 md:py-24 relative w-[95%] mx-auto"
         dir="rtl">
        <div class="flex items-center justify-center relative w-full max-w-[1280px]">
            <div
                class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8 md:gap-6 lg:gap-8 items-start justify-center relative w-full">
                <!-- Feature 1: صلاحيات مخصصة لكل مستخدم -->
                <div class="flex flex-col gap-4 md:gap-5 items-center justify-center text-center">
                    <div
                        class="bg-[#E8ECF4] rounded-3xl w-12 h-12 md:w-14 md:h-14 flex items-center justify-center flex-shrink-0">
                        <img src="<?php echo e(asset('frontend/images')); ?>/our-prices-feature1.png" alt="Feature 1" class="w-6 h-6 md:w-8 md:h-8" />
                    </div>
                    <div class="flex flex-col gap-2 items-center justify-start w-full">
                        <h3
                            class="font-alexandria font-medium text-[#101828] text-sm md:text-[16px] leading-6 md:leading-[30px] text-center">
                            صلاحيات مخصصة لكل مستخدم
                        </h3>
                        <p
                            class="font-alexandria font-normal text-[#667085] text-xs md:text-[14px] leading-5 md:leading-[24px] text-center max-w-[280px]">
                            وصول آمن ومنفصل لكل من المدير والموظف لعرض المحتوى والمعلومات المناسبة
                        </p>
                    </div>
                </div>

                <!-- Feature 2: متابعة تطوّر كل موظف لحظيًا -->
                <div class="flex flex-col gap-4 md:gap-5 items-center justify-center text-center">
                    <div
                        class="bg-[#E8ECF4] rounded-3xl w-12 h-12 md:w-14 md:h-14 flex items-center justify-center flex-shrink-0">
                        <img src="<?php echo e(asset('frontend/images')); ?>/our-prices-feature2.png" alt="Feature 2" class="w-6 h-6 md:w-8 md:h-8" />
                    </div>
                    <div class="flex flex-col gap-2 items-center justify-start w-full">
                        <h3
                            class="font-alexandria font-medium text-[#1C1C1C] text-sm md:text-[16px] leading-6 md:leading-[30px] text-center">
                            متابعة تطوّر كل موظف لحظيًا
                        </h3>
                        <p
                            class="font-alexandria font-normal text-[#757575] text-xs md:text-[14px] leading-5 md:leading-[24px] text-center max-w-[280px]">
                            راقب تقدم الفرق ونجاح كل موظف على مستوى كل دورة تدريبية
                        </p>
                    </div>
                </div>

                <!-- Feature 3: تعيين الدورات حسب الفريق أو الموظف -->
                <div class="flex flex-col gap-4 md:gap-5 items-center justify-center text-center">
                    <div
                        class="bg-[#E8ECF4] rounded-3xl w-12 h-12 md:w-14 md:h-14 flex items-center justify-center flex-shrink-0">
                        <img src="<?php echo e(asset('frontend/images')); ?>/our-prices-feature3.png" alt="Feature 3" class="w-6 h-6 md:w-8 md:h-8" />
                    </div>
                    <div class="flex flex-col gap-2 items-center justify-start w-full">
                        <h3
                            class="font-alexandria font-medium text-[#1C1C1C] text-sm md:text-[16px] leading-6 md:leading-[30px] text-center">
                            تعيين الدورات حسب الفريق أو الموظف
                        </h3>
                        <p
                            class="font-alexandria font-normal text-[#757575] text-xs md:text-[14px] leading-5 md:leading-[24px] text-center max-w-[280px]">
                            سهولة في تخصيص الدبلومات التدريبية لكل موظف حسب الاحتياج والوظيفة
                        </p>
                    </div>
                </div>

                <!-- Feature 4: لوحات تحكم تحليلة شاملة -->
                <div class="flex flex-col gap-4 md:gap-5 items-center justify-center text-center">
                    <div
                        class="bg-[#E8ECF4] rounded-3xl w-12 h-12 md:w-14 md:h-14 flex items-center justify-center flex-shrink-0">
                        <img src="<?php echo e(asset('frontend/images')); ?>/our-prices-feature4-icon.png" alt="Feature Icon"
                             class="w-5 h-5 md:w-6 md:h-6" />
                    </div>
                    <div class="flex flex-col gap-2 items-center justify-start w-full">
                        <h3
                            class="font-alexandria font-medium text-[#1C1C1C] text-sm md:text-[16px] leading-6 md:leading-[30px] text-center">
                            لوحات تحكم تحليلة شاملة
                        </h3>
                        <p
                            class="font-alexandria font-normal text-[#757575] text-xs md:text-[14px] leading-5 md:leading-[24px] text-center max-w-[280px]">
                            احصل على نظرة فورية لأداء الموظفين ونتائجهم التدريبية عبر تقارير مرئية مفصّلة
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- ===================================== FAQ ===================================================== -->
    <div class="bg-white flex flex-col gap-16 items-center justify-start px-0 py-24 relative" dir="rtl">
        <!-- Header Section -->
        <div class="flex flex-col gap-8 items-center justify-start max-w-[1280px] px-8 py-0 relative w-full">
            <div class="flex flex-col gap-8 items-center justify-start relative w-full">
                <div class="flex flex-col gap-5 items-center justify-center max-w-[768px] relative text-center w-full">
                    <h2
                        class="font-alexandria font-semibold text-[#101828] text-[36px] leading-[44px] tracking-[-0.72px] w-full">
                        الاسئلة الاكثر شيوعا
                    </h2>
                    <p class="font-alexandria font-normal text-[#475467] text-[20px] leading-[30px] w-full">
                        كل شئ تريد معرفته عن البرنامج
                    </p>
                </div>
            </div>
        </div>

        <!-- FAQ Items Container -->
        <div class="flex flex-col gap-16 items-center justify-start max-w-[1280px] px-8 py-0 relative w-full">
            <div class="flex flex-col gap-4 items-start justify-start max-w-[768px] relative w-full">

                <!-- FAQ Item 1 (Open by default) -->
                <div
                    class="bg-[#F2F4F9] flex flex-col items-start justify-start p-8 relative rounded-2xl w-full faq-item">
                    <button class="flex flex-col items-center justify-start relative w-full faq-button"
                            onclick="toggleFAQ(this)">
                        <div class="flex flex-row-reverse gap-6 items-start justify-end relative w-full">
                            <div
                                class="flex flex-col items-start justify-start pb-0 pt-0.5 px-0 relative flex-shrink-0">
                                <div class="relative w-6 h-6 flex-shrink-0 faq-icon">
                                    <!-- Minus Circle (shown when open) -->
                                    <img src="<?php echo e(asset('frontend/images')); ?>/minus-icon.svg" alt="Minus Icon"
                                         class="block w-full h-full minus-icon" />
                                    <!-- Plus Circle (shown when closed) -->
                                    <img src="<?php echo e(asset('frontend/images')); ?>/plus-icon.svg" alt="Plus Icon"
                                         class="hidden w-full h-full plus-icon" />
                                </div>
                            </div>
                            <div
                                class="flex-1 flex flex-col gap-2 items-start justify-start text-right font-alexandria">
                                <div
                                    class="relative w-full text-[#101828] text-[18px] leading-[28px] font-medium faq-question">
                                    هل هناك نسخة تجريبية مجانية متاحة؟
                                </div>
                                <div
                                    class="relative w-full text-[#475467] text-[18px] leading-[28px] font-normal faq-answer open">
                                    نعم، يمكنك تجربتها مجانًا لمدة 30 يومًا. إذا كنت تريد ذلك، فسنزودك بمكالمة تأهيل
                                    مجانية وشخصية مدتها 30 دقيقة لإعدادك وتشغيلك في أقرب وقت ممكن.
                                </div>
                            </div>
                        </div>
                    </button>
                </div>

                <!-- FAQ Item 2 -->
                <div
                    class="bg-white flex flex-col items-start justify-start p-8 relative rounded-2xl w-full faq-item border border-[#EAECF0]">
                    <button class="flex flex-col items-center justify-start relative w-full faq-button"
                            onclick="toggleFAQ(this)">
                        <div class="flex flex-row-reverse gap-6 items-start justify-end relative w-full">
                            <div
                                class="flex flex-col items-start justify-start pb-0 pt-0.5 px-0 relative flex-shrink-0">
                                <div class="relative w-6 h-6 flex-shrink-0 faq-icon">
                                    <!-- Minus Circle (shown when open) -->
                                    <img src="<?php echo e(asset('frontend/images')); ?>/minus-icon.svg" alt="Minus Circle"
                                         class="hidden w-full h-full minus-icon" />
                                    <!-- Plus Circle (shown when closed) -->
                                    <img src="<?php echo e(asset('frontend/images')); ?>/plus-icon.svg" alt="Plus Circle"
                                         class="block w-full h-full plus-icon" />
                                </div>
                            </div>
                            <div
                                class="flex-1 flex flex-col gap-2 items-start justify-start text-right font-alexandria">
                                <div
                                    class="relative w-full text-[#101828] text-[18px] leading-[28px] font-medium faq-question">
                                    هل يمكنني تغيير خطتي لاحقًا؟
                                </div>
                                <div
                                    class="hidden relative w-full text-[#475467] text-[18px] leading-[28px] font-normal faq-answer">
                                    بالطبع! يمكنك ترقية أو تخفيض خطتك في أي وقت من خلال لوحة التحكم الخاصة بك. التغييرات
                                    ستدخل حيز التنفيذ في دورة الفوترة التالية.
                                </div>
                            </div>
                        </div>
                    </button>
                </div>

                <!-- FAQ Item 3 -->
                <div
                    class="bg-white flex flex-col items-start justify-start p-8 relative rounded-2xl w-full faq-item border border-[#EAECF0]">
                    <button class="flex flex-col items-center justify-start relative w-full faq-button"
                            onclick="toggleFAQ(this)">
                        <div class="flex flex-row-reverse gap-6 items-start justify-end relative w-full">
                            <div
                                class="flex flex-col items-start justify-start pb-0 pt-0.5 px-0 relative flex-shrink-0">
                                <div class="relative w-6 h-6 flex-shrink-0 faq-icon">
                                    <!-- Minus Circle (shown when open) -->
                                    <img src="<?php echo e(asset('frontend/images')); ?>/minus-icon.svg" alt="Minus Circle"
                                         class="hidden w-full h-full minus-icon" />
                                    <!-- Plus Circle (shown when closed) -->
                                    <img src="<?php echo e(asset('frontend/images')); ?>/plus-icon.svg" alt="Plus Circle"
                                         class="block w-full h-full plus-icon" />
                                </div>
                            </div>
                            <div
                                class="flex-1 flex flex-col gap-2 items-start justify-start text-right font-alexandria">
                                <div
                                    class="relative w-full text-[#101828] text-[18px] leading-[28px] font-medium faq-question">
                                    ما هي سياسة الإلغاء الخاصة بك؟
                                </div>
                                <div
                                    class="hidden relative w-full text-[#475467] text-[18px] leading-[28px] font-normal faq-answer">
                                    يمكنك إلغاء اشتراكك في أي وقت بدون رسوم إضافية. سيستمر وصولك إلى المنصة حتى نهاية
                                    دورة الفوترة الحالية. لن يتم تجديد الاشتراك تلقائياً بعد الإلغاء.
                                </div>
                            </div>
                        </div>
                    </button>
                </div>

                <!-- FAQ Item 4 -->
                <div
                    class="bg-white flex flex-col items-start justify-start p-8 relative rounded-2xl w-full faq-item border border-[#EAECF0]">
                    <button class="flex flex-col items-center justify-start relative w-full faq-button"
                            onclick="toggleFAQ(this)">
                        <div class="flex flex-row-reverse gap-6 items-start justify-end relative w-full">
                            <div
                                class="flex flex-col items-start justify-start pb-0 pt-0.5 px-0 relative flex-shrink-0">
                                <div class="relative w-6 h-6 flex-shrink-0 faq-icon">
                                    <!-- Minus Circle (shown when open) -->
                                    <img src="<?php echo e(asset('frontend/images')); ?>/minus-icon.svg" alt="Minus Circle"
                                         class="hidden w-full h-full minus-icon" />
                                    <!-- Plus Circle (shown when closed) -->
                                    <img src="<?php echo e(asset('frontend/images')); ?>/plus-icon.svg" alt="Plus Circle"
                                         class="block w-full h-full plus-icon" />
                                </div>
                            </div>
                            <div
                                class="flex-1 flex flex-col gap-2 items-start justify-start text-right font-alexandria">
                                <div
                                    class="relative w-full text-[#101828] text-[18px] leading-[28px] font-medium faq-question">
                                    هل يمكن إضافة معلومات أخرى إلى الفاتورة؟
                                </div>
                                <div
                                    class="hidden relative w-full text-[#475467] text-[18px] leading-[28px] font-normal faq-answer">
                                    نعم، يمكنك إضافة معلومات إضافية مثل رقم الضريبة، عنوان الشركة، أو أي تفاصيل محاسبية
                                    أخرى من خلال إعدادات الفوترة في حسابك.
                                </div>
                            </div>
                        </div>
                    </button>
                </div>

                <!-- FAQ Item 5 -->
                <div
                    class="bg-white flex flex-col items-start justify-start p-8 relative rounded-2xl w-full faq-item border border-[#EAECF0]">
                    <button class="flex flex-col items-center justify-start relative w-full faq-button"
                            onclick="toggleFAQ(this)">
                        <div class="flex flex-row-reverse gap-6 items-start justify-end relative w-full">
                            <div
                                class="flex flex-col items-start justify-start pb-0 pt-0.5 px-0 relative flex-shrink-0">
                                <div class="relative w-6 h-6 flex-shrink-0 faq-icon">
                                    <!-- Minus Circle (shown when open) -->
                                    <img src="<?php echo e(asset('frontend/images')); ?>/minus-icon.svg" alt="Minus Circle"
                                         class="hidden w-full h-full minus-icon" />
                                    <!-- Plus Circle (shown when closed) -->
                                    <img src="<?php echo e(asset('frontend/images')); ?>/plus-icon.svg" alt="Plus Circle"
                                         class="block w-full h-full plus-icon" />
                                </div>
                            </div>
                            <div
                                class="flex-1 flex flex-col gap-2 items-start justify-start text-right font-alexandria">
                                <div
                                    class="relative w-full text-[#101828] text-[18px] leading-[28px] font-medium faq-question">
                                    كيف تعمل الفواتير؟
                                </div>
                                <div
                                    class="hidden relative w-full text-[#475467] text-[18px] leading-[28px] font-normal faq-answer">
                                    يتم إرسال الفواتير تلقائياً في بداية كل دورة فوترة عبر البريد الإلكتروني. يمكنك
                                    أيضاً تحميل الفواتير من لوحة التحكم الخاصة بك في أي وقت.
                                </div>
                            </div>
                        </div>
                    </button>
                </div>

                <!-- FAQ Item 6 -->
                <div
                    class="bg-white flex flex-col items-start justify-start p-8 relative rounded-2xl w-full faq-item border border-[#EAECF0]">
                    <button class="flex flex-col items-center justify-start relative w-full faq-button"
                            onclick="toggleFAQ(this)">
                        <div class="flex flex-row-reverse gap-6 items-center justify-end relative w-full">
                            <div
                                class="flex flex-col items-start justify-start pb-0 pt-0.5 px-0 relative flex-shrink-0">
                                <div class="relative w-6 h-6 flex-shrink-0 faq-icon">
                                    <!-- Minus Circle (shown when open) -->
                                    <img src="<?php echo e(asset('frontend/images')); ?>/minus-icon.svg" alt="Minus Circle"
                                         class="hidden w-full h-full minus-icon" />
                                    <!-- Plus Circle (shown when closed) -->
                                    <img src="<?php echo e(asset('frontend/images')); ?>/plus-icon.svg" alt="Plus Circle"
                                         class="block w-full h-full plus-icon" />
                                </div>
                            </div>
                            <div class="flex-1 flex flex-col gap-2 items-end justify-center text-right font-alexandria">
                                <div
                                    class="relative w-full text-[#101828] text-[18px] leading-[28px] font-medium faq-question">
                                    كيف أغير البريد الإلكتروني لحسابي؟
                                </div>
                                <div
                                    class="hidden relative w-full text-[#475467] text-[18px] leading-[28px] font-normal faq-answer">
                                    يمكنك تغيير البريد الإلكتروني من إعدادات الحساب. ستحتاج إلى تأكيد البريد الإلكتروني
                                    الجديد قبل أن يصبح ساري المفعول لأغراض الأمان.
                                </div>
                            </div>
                        </div>
                    </button>
                </div>

            </div>
        </div>
    </div>

    <!-- ===================================== CTA Section ===================================================== -->
    <section class="bg-[#E8ECF4] py-16 lg:py-20">
        <div class="max-w-7xl mx-auto px-6">
            <div class="flex flex-col items-center justify-center text-center max-w-4xl mx-auto">
                <!-- Heading and Supporting Text -->
                <div class="flex flex-col gap-4 items-center justify-center mb-8">
                    <h2 class="text-[#1C1C1C] text-2xl md:text-3xl lg:text-4xl font-bold leading-tight font-alexandria">
                        يمكنك الآن تنمية فريقك في اي مجال
                    </h2>
                    <p class="text-[#2E2E2E] text-lg md:text-xl leading-relaxed font-tajawal">
                        تعلّم وتطوّر في الموارد البشرية، الإدارة، التسويق، وغيرها.
                    </p>
                </div>

                <!-- CTA Button -->
                <div class="inline-flex">
                    <a href="<?php echo e(route('book_demo_page')); ?>"
                        class="bg-[#00B34F] hover:bg-[#009542] transition-colors duration-300 flex items-center justify-center gap-3 px-6 py-3 rounded-lg text-white font-medium text-base tracking-wide font-alexandria group">
                        <!-- Button Text -->
                        <span>احجز عرضًا توضيحيًا الآن</span>
                        <!-- Arrow Icon -->
                        <div class="duration-300 group-hover:translate-x-1">
                            <svg width="20" height="20" viewBox="0 0 24 25" fill="none"
                                 xmlns="http://www.w3.org/2000/svg" class="responsive-button-icon lg:w-6 lg:h-6">
                                <path
                                    d="M8.414 13.843L12.364 17.793C12.5462 17.9816 12.647 18.2342 12.6447 18.4964C12.6424 18.7586 12.5372 19.0094 12.3518 19.1948C12.1664 19.3802 11.9156 19.4854 11.6534 19.4876C11.3911 19.4899 11.1386 19.3891 10.95 19.207L5.293 13.55C5.19982 13.4573 5.12587 13.3471 5.07541 13.2258C5.02494 13.1045 4.99891 12.9744 4.99891 12.843C4.99891 12.7116 5.02494 12.5814 5.07541 12.4601C5.12587 12.3388 5.19982 12.2286 5.293 12.136L10.95 6.479C11.0422 6.38349 11.1526 6.30731 11.2746 6.2549C11.3966 6.20249 11.5278 6.1749 11.6606 6.17375C11.7934 6.1726 11.9251 6.1979 12.048 6.24818C12.1709 6.29846 12.2825 6.37271 12.3764 6.4666C12.4703 6.5605 12.5445 6.67215 12.5948 6.79505C12.6451 6.91794 12.6704 7.04962 12.6693 7.1824C12.6681 7.31518 12.6405 7.4464 12.5881 7.5684C12.5357 7.69041 12.4595 7.80075 12.364 7.893L8.414 11.843H18C18.2652 11.843 18.5196 11.9483 18.7071 12.1359C18.8946 12.3234 19 12.5777 19 12.843C19 13.1082 18.8946 13.3625 18.7071 13.5501C18.5196 13.7376 18.2652 13.843 18 13.843H8.414Z"
                                    fill="white" />
                            </svg>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('footerScript'); ?>
    <!-- JavaScript for Mobile Menu Toggle and FAQ Functionality -->
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const mobileMenuButton = document.getElementById("mobile-menu-button");
            const mobileMenu = document.getElementById("mobile-menu");
            const menuIcon = document.getElementById("menu-icon");
            const closeIcon = document.getElementById("close-icon");

            // Mobile menu toggle
            if (mobileMenuButton) {
                mobileMenuButton.addEventListener("click", function () {
                    mobileMenu.classList.toggle("open");
                    menuIcon.classList.toggle("hidden");
                    closeIcon.classList.toggle("hidden");
                });
            }
        });

        // FAQ Toggle Function with Smooth Animations
        function toggleFAQ(button) {
            const faqItem = button.closest('.faq-item');
            const answer = faqItem.querySelector('.faq-answer');
            const minusIcon = faqItem.querySelector('.minus-icon');
            const plusIcon = faqItem.querySelector('.plus-icon');

            // Check if the answer is currently open (either has 'open' class or is not hidden)
            const isOpen = answer.classList.contains('open') || !answer.classList.contains('hidden');

            if (isOpen) {
                // Closing the FAQ
                answer.classList.remove('open');
                answer.classList.add('hidden');

                // Toggle icons
                minusIcon.classList.add('hidden');
                minusIcon.classList.remove('block');
                plusIcon.classList.remove('hidden');
                plusIcon.classList.add('block');

                // Toggle background color with animation
                setTimeout(() => {
                    faqItem.classList.remove('bg-[#F2F4F9]');
                    faqItem.classList.add('bg-white');
                    if (!faqItem.classList.contains('border')) {
                        faqItem.classList.add('border', 'border-[#EAECF0]');
                    }
                }, 200);

            } else {
                // Opening the FAQ
                answer.classList.remove('hidden');
                answer.classList.add('open');

                // Toggle icons
                plusIcon.classList.add('hidden');
                plusIcon.classList.remove('block');
                minusIcon.classList.remove('hidden');
                minusIcon.classList.add('block');

                // Toggle background color with animation
                faqItem.classList.remove('bg-white', 'border', 'border-[#EAECF0]');
                faqItem.classList.add('bg-[#F2F4F9]');
            }
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ebacademy/public_html/beta.e3melbusiness.org/resources/views/frontend/our_prices.blade.php ENDPATH**/ ?>