<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <?php echo app('seotools')->generate(); ?>


    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- Google Fonts for Arabic -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
        href="https://fonts.googleapis.com/css2?family=Alexandria:wght@300;400;500;600;700;800&display=swap"
        rel="stylesheet"
    />
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('/apple-touch-icon.png')); ?>">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('/favicon-32x32.png')); ?>">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('/favicon-16x16.png')); ?>">
    <link rel="manifest" href="<?php echo e(asset('/site.webmanifest')); ?>">



    <style>
        .loading {
            position: relative;
        }
        .loading::after {
            position: absolute;
            background: center 1.7857142857rem no-repeat rgba(255, 255, 255, .5);
            background-image: url('<?php echo e(asset('assets/images/loading.gif')); ?>');
            background-repeat: no-repeat;
            background-position: center center;
            background-color: rgba(250, 250, 250, .8);
            background-size: 4.7857142857rem auto;
        }
        .loading::after {
            display: block!important;
            width: 100%;
            height: 100%;
            left: 0;
            top: 0;
            z-index: 148;
            content: ' '!important;
            line-height: 0;
        }
    </style>
    <?php echo $__env->yieldPushContent('headScript'); ?>
</head>

<body class="min-h-screen bg-white" dir="rtl">
<?php if (! empty(trim($__env->yieldContent('headerScript')))): ?>
    <?php echo $__env->yieldContent('headerScript'); ?>
<?php else: ?>
<?php echo $__env->make('frontend.include.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php endif; ?>

<?php echo $__env->yieldContent('content'); ?>

<!--=============================================== Footer =====================================-->
<footer class="bg-[#144394] text-white" dir="rtl">
    <div class="max-w-7xl mx-auto px-6 py-16 lg:py-20">
        <!-- Main Footer Content -->
        <div
            class="flex flex-col lg:flex-row items-center justify-between gap-8 lg:gap-10"
        >
            <!-- About Us Section -->
            <div
                class="flex flex-col sm:flex-row items-center sm:items-start gap-4 sm:gap-6 lg:gap-8 w-full lg:w-auto"
            >
                <div class="flex-shrink-0 order-1 sm:order-1">
                    <img
                        src="<?php echo e(asset('frontend')); ?>/images/footer-logo.png"
                        alt="شعار إعمل بيزنس"
                        class="w-16 h-16 sm:w-18 sm:h-18 md:w-20 md:h-20 rounded-2xl object-cover mx-auto sm:mx-0"
                    />
                </div>

                <div
                    class="flex flex-col items-center sm:items-end text-center sm:text-right w-full sm:max-w-sm md:max-w-md lg:max-w-sm order-2 sm:order-2"
                >
                    <p
                        class="font-alexandria text-sm sm:text-base text-white leading-relaxed"
                    >
                        أكاديمية إعمل بيزنس هي حلم لم يفارق عقل وقلب كل فرد منا في فريق
                        إعمل بيزنس وسعينا جميعاً بكل قوة وإيمان إلى تحقيقه ونقله من عالم
                        الأحلام إلى الواقع الملموس.
                    </p>
                </div>
            </div>

            <!-- Quick Links Section -->
            <div class="flex flex-col items-start gap-8 w-full lg:w-auto">
                <h3 class="font-alexandria text-xl font-semibold text-white">
                    روابط سريعة
                </h3>
                <div class="flex gap-8 lg:gap-12">
                    <div class="flex flex-col items-start gap-4">
                        <a
                            href="<?php echo e(route('instructors_page')); ?>"
                            class="font-alexandria text-sm text-white hover:text-gray-200 transition-colors"
                        >المحاضرين</a
                        >
                        <a
                            href="<?php echo e(route('faq_page')); ?>"
                            class="font-alexandria text-sm text-white hover:text-gray-200 transition-colors"
                        >الأسئلة الشائعة</a
                        >
                        <a
                            href="<?php echo e(route('our_prices_page')); ?>"
                            class="font-alexandria text-sm text-white hover:text-gray-200 transition-colors"
                        >اسعارنا</a
                        >
                        <a
                            href="<?php echo e(route('courses_page')); ?>"
                            class="font-alexandria text-sm text-white hover:text-gray-200 transition-colors"
                        >الدورات التدريبية</a
                        >
                    </div>

                    <div class="flex flex-col items-start gap-4">
                        <a
                            href="<?php echo e(route('our_solution_page')); ?>"
                            class="font-alexandria text-sm text-white hover:text-gray-200 transition-colors"
                        >حلولنا لك</a
                        >
                        <a
                            href="<?php echo e(route('contact_us_page')); ?>"
                            class="font-alexandria text-sm text-white hover:text-gray-200 transition-colors"
                        >تواصل معنا</a
                        >
                        <a
                            href="<?php echo e(route('about_us_page')); ?>"
                            class="font-alexandria text-sm text-white hover:text-gray-200 transition-colors"
                        >عن الأكاديمية</a
                        >
                    </div>
                </div>
            </div>

            <!-- Payment Methods Section -->
            <div class="flex flex-col items-start gap-8 w-full lg:w-auto">
                <h3 class="font-alexandria text-xl font-semibold text-white">
                    طرق الدفع
                </h3>
                <div class="grid grid-cols-4 gap-3 lg:gap-2 max-w-sm">
                    <img
                        src="<?php echo e(asset('frontend')); ?>/images/tamara.png"
                        alt="Payment Method"
                        class="w-full h-7 object-contain"
                    />
                    <img
                        src="<?php echo e(asset('frontend')); ?>/images/tabby.png"
                        alt="Payment Method"
                        class="w-full h-7 object-contain"
                    />
                    <img
                        src="<?php echo e(asset('frontend')); ?>/images/vodafone.png"
                        alt="Payment Method"
                        class="w-full h-7 object-contain"
                    />
                    <img
                        src="<?php echo e(asset('frontend')); ?>/images/alahly.png"
                        alt="Payment Method"
                        class="w-full h-7 object-contain"
                    />
                    <img
                        src="<?php echo e(asset('frontend')); ?>/images/fawry.png"
                        alt="Payment Method"
                        class="w-full h-7 object-contain"
                    />
                    <img
                        src="<?php echo e(asset('frontend')); ?>/images/visa.png"
                        alt="Payment Method"
                        class="w-full h-7 object-contain"
                    />
                    <img
                        src="<?php echo e(asset('frontend')); ?>/images/mastercard.png"
                        alt="Payment Method"
                        class="w-full h-7 object-contain"
                    />
                </div>
            </div>
        </div>
    </div>

    <!-- Footer Bottom -->
    <div class="border-t border-[#BFBFBF]/30">
        <div class="max-w-7xl mx-auto px-6 py-8">
            <div
                class="flex flex-col-reverse lg:flex-row items-center justify-between gap-6"
            >
                <!-- Copyright -->
                <div class="text-center lg:text-right">
                    <p class="font-alexandria text-base text-[#BFBFBF]">
                        © جميع الحقوق محفوظة لإعمل بيزنس منذ عام 2016
                    </p>
                </div>

                <!-- Social Media Icons -->
                <div class="flex items-center gap-4">
                    <!-- WhatsApp -->
                    <a
                        href="#"
                        class="text-white hover:text-gray-200 transition-colors"
                    >
                        <img
                            src="<?php echo e(asset('frontend')); ?>/images/whatsapp.png"
                            alt="WhatsApp"
                            class="w-6 h-6"
                        />
                    </a>

                    <!-- Telegram -->
                    <a
                        href="#"
                        class="text-white hover:text-gray-200 transition-colors"
                    >
                        <img
                            src="<?php echo e(asset('frontend')); ?>/images/telegram.png"
                            alt="Telegram"
                            class="w-6 h-6"
                        />
                    </a>

                    <!-- LinkedIn -->
                    <a
                        href="#"
                        class="text-white hover:text-gray-200 transition-colors"
                    >
                        <img
                            src="<?php echo e(asset('frontend')); ?>/images/linkedin.png"
                            alt="LinkedIn"
                            class="w-6 h-6"
                        />
                    </a>

                    <!-- Instagram -->
                    <a
                        href="#"
                        class="text-white hover:text-gray-200 transition-colors"
                    >
                        <img
                            src="<?php echo e(asset('frontend')); ?>/images/instagram.png"
                            alt="Instagram"
                            class="w-6 h-6"
                        />
                    </a>

                    <!-- Facebook -->
                    <a
                        href="#"
                        class="text-white hover:text-gray-200 transition-colors"
                    >
                        <img
                            src="<?php echo e(asset('frontend')); ?>/images/facebook.png"
                            alt="Facebook"
                            class="w-6 h-6"
                        />
                    </a>
                </div>
            </div>
        </div>
    </div>
</footer>



<!-- Mobile Menu JavaScript -->
<script>
    function toggleMobileMenu() {
        const mobileMenu = document.getElementById("mobile-menu");
        const hamburgerIcon = document.getElementById("hamburger-icon");
        const closeIcon = document.getElementById("close-icon");

        mobileMenu.classList.toggle("hidden");
        hamburgerIcon.classList.toggle("hidden");
        closeIcon.classList.toggle("hidden");
    }

    function toggleSearch() {
        const searchContainer = document.getElementById("search-container");
        const searchInput = document.getElementById("search-input");

        if (searchContainer.classList.contains("w-16")) {
            // Expand - responsive width based on screen size
            searchContainer.classList.remove("w-16");
            // Use different widths for different screen sizes
            if (window.innerWidth < 640) {
                // Mobile: smaller width to fit screen
                searchContainer.classList.add("w-48");
            } else if (window.innerWidth < 1024) {
                // Tablet: medium width
                searchContainer.classList.add("w-56");
            } else {
                // Desktop: full width
                searchContainer.classList.add("w-64");
            }
            searchInput.classList.remove("opacity-0", "w-0");
            searchInput.classList.add("opacity-100", "w-full");
            setTimeout(() => {
                searchInput.focus();
            }, 300);
        } else {
            // Collapse
            searchContainer.classList.remove("w-48", "w-56", "w-64");
            searchContainer.classList.add("w-16");
            searchInput.classList.remove("opacity-100", "w-full");
            searchInput.classList.add("opacity-0", "w-0");
            searchInput.blur();
        }
    }

    // Close search when clicking outside
    document.addEventListener("click", function (event) {
        const searchContainer = document.getElementById("search-container");
        const searchInput = document.getElementById("search-input");

        if (!searchContainer.contains(event.target) && !searchContainer.classList.contains("w-16")) {
            searchContainer.classList.remove("w-48", "w-56", "w-64");
            searchContainer.classList.add("w-16");
            searchInput.classList.remove("opacity-100", "w-full");
            searchInput.classList.add("opacity-0", "w-0");
            searchInput.blur();
        }
    });

    // Close mobile menu when clicking outside
    document.addEventListener("click", function (event) {
        const mobileMenu = document.getElementById("mobile-menu");
        const mobileMenuButton = document.getElementById("mobile-menu-button");

        if (
            !mobileMenu.contains(event.target) &&
            !mobileMenuButton.contains(event.target)
        ) {
            mobileMenu.classList.add("hidden");
            document.getElementById("hamburger-icon").classList.remove("hidden");
            document.getElementById("close-icon").classList.add("hidden");
        }
    });

    // Handle search input enter key
    document.getElementById("search-input").addEventListener("keypress", function(event) {
        if (event.key === "Enter") {
            const searchTerm = event.target.value.trim();
            if (searchTerm) {
                // Handle search functionality here
                console.log("Searching for:", searchTerm);
                // You can add your search logic here
            }
        }
    });

    // Handle mobile search input enter key
    document.getElementById("mobile-search-input").addEventListener("keypress", function(event) {
        if (event.key === "Enter") {
            const searchTerm = event.target.value.trim();
            if (searchTerm) {
                // Handle search functionality here
                console.log("Mobile searching for:", searchTerm);
                // You can add your search logic here
            }
        }
    });

    // Handle window resize to adjust search container width
    window.addEventListener("resize", function() {
        const searchContainer = document.getElementById("search-container");

        // If search is expanded, adjust width based on new screen size
        if (!searchContainer.classList.contains("w-16")) {
            // Remove all width classes first
            searchContainer.classList.remove("w-48", "w-56", "w-64");

            // Apply appropriate width for current screen size
            if (window.innerWidth < 640) {
                searchContainer.classList.add("w-48");
            } else if (window.innerWidth < 1024) {
                searchContainer.classList.add("w-56");
            } else {
                searchContainer.classList.add("w-64");
            }
        }
    });
</script>
<?php echo $__env->yieldPushContent('footerScript'); ?>


</body>
</html>
<?php /**PATH /home/ebacademy/public_html/beta.e3melbusiness.org/resources/views/frontend/layouts/app.blade.php ENDPATH**/ ?>