<?php $__env->startPush('headScript'); ?>
    <!-- Tailwind Configuration -->
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        alexandria: ["Alexandria", "sans-serif"],
                        tajawal: ["Tajawal", "sans-serif"],
                    },
                    colors: {
                        "brand-primary": "#144394",
                        "brand-primary-light": "#E8ECF4",
                        "neutral-n10": "#FAFAFA",
                        "neutral-n30": "#EBEBEB",
                        "neutral-n40": "#DEDEDE",
                        "neutral-n50": "#BFBFBF",
                        "neutral-n300": "#575757",
                        "neutral-n600": "#2E2E2E",
                        "gray-300": "#D0D5DD",
                        "gray-500": "#667085",
                        "gray-900": "#101828",
                        "blue-gray-300": "#CBD5E1",
                        "success-green": "#00B34F",
                        "success-green-light": "#E6F7ED",
                    },
                },
            },
        };
    </script>

    <style>
        body {
            font-family: "Alexandria", sans-serif;
        }

        .forgot-password-container {
            min-height: 100vh;
        }

        .forgot-password-form-section {
            flex: 1;
            min-height: 100vh;
            background: #fff;
        }

        .forgot-password-hero-section {
            flex: 1;
            min-height: 100vh;
            background: linear-gradient(
                106deg,
                rgba(12, 41, 89, 0.45) -26.44%,
                rgba(12, 41, 89, 0.55) -12.52%,
                rgba(12, 41, 89, 0.62) -2.51%,
                rgba(12, 41, 89, 0.72) 11.38%,
                rgba(12, 41, 89, 0.86) 30.19%,
                #0c2959 49.73%
            );
            position: relative;
            overflow: hidden;
        }

        /* Success message styles */
        .success-message {
            display: none;
            margin-top: 24px;
            padding: 16px;
        }

        .success-message.show {
            display: block;
            animation: slideDown 0.3s ease-out;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Responsive adjustments */
        @media (max-width: 1024px) {
            .forgot-password-hero-section {
                min-height: 50vh;
            }

            .forgot-password-form-section {
                min-height: auto;
            }
        }

        @media (max-width: 768px) {
            .forgot-password-container {
                flex-direction: column;
            }

            .forgot-password-hero-section {
                min-height: 40vh;
            }

            .hero-image {
                width: 80%;
                height: auto;
            }
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>

    <div
        class="forgot-password-container flex flex-row-reverse justify-center items-center"
    >
        <!-- Left Section - Hero Content -->
        <div
            class="forgot-password-hero-section relative flex items-center justify-center overflow-hidden h-screen md:block hidden"
        >
            <!-- Decorative Green Dots - Top Right -->
            <div class="absolute top-0 right-0 z-10">
                <img src="<?php echo e(asset('frontend/images')); ?>/top-green-dots.png" alt="Decorative Green Dots" />
            </div>

            <!-- Decorative Green Dots - Bottom Left -->
            <div class="absolute bottom-0 left-0 z-10">
                <img src="<?php echo e(asset('frontend/images')); ?>/green-dots.png" alt="Decorative Green Dots" />
            </div>

            <!-- wave left -->
            <div class="absolute inset-y-0 left-0">
                <img src="<?php echo e(asset('frontend/images')); ?>/wave-left.png" alt="Wave Left" />
            </div>

            <!-- Main Content Container -->
            <div
                class="relative z-20 flex flex-col items-center justify-end px-6 md:px-12 max-w-4xl mx-auto h-full"
            >
                <!-- Text Content Above Image -->
                <div class="text-center">
                    <h1
                        class="font-alexandria text-2xl md:text-3xl lg:text-2xl font-normal text-white leading-relaxed mb-4"
                    >
                        هل نسيت كلمة المرور؟
                    </h1>
                    <p
                        class="font-alexandria text-base md:text-lg text-neutral-n40 leading-relaxed max-w-3xl mx-auto w-full md:w-3/4 lg:w-[90%]"
                    >
                        يتعين عليك ان تتبع الخطوات حتي يتم تغيير كلمة المرور الخاصة بك!
                    </p>
                </div>

                <!-- Hero Image -->
                <div class="hero-image">
                    <img
                        src="<?php echo e(asset('frontend/images')); ?>/teamwork.png"
                        alt="فريق العمل - رجل وامرأة ينظران إلى جهاز لوحي"
                        class="w-4/5 max-w-xl mx-auto object-contain"
                    />
                </div>
            </div>
        </div>

        <!-- Right Section - Forgot Password Form -->
        <div
            class="forgot-password-form-section flex flex-col items-center justify-center px-6 md:px-8 gap-20"
        >
            <div class="w-full max-w-md">
                <!-- Form Header and Content -->
                <div class="flex flex-col items-center gap-8">
                    <!-- Header -->
                    <div class="flex flex-col items-end gap-6 w-full">
                        <div class="flex flex-col items-start gap-3 w-full">
                            <h2
                                class="font-tajawal text-xl font-bold leading-[30px] text-gray-900 text-right w-full"
                            >
                                تعيين كلمة المرور
                            </h2>
                            <p
                                class="font-tajawal text-base font-normal leading-6 text-gray-500 text-right w-full"
                            >
                                اكتب بريدك الالكترونى لإعادة تعيين كلمة المرور
                            </p>
                        </div>
                    </div>

                    <!-- Form Content -->
                    <div class="flex flex-col items-center gap-6 w-full">
                        <!-- Form -->
                        <form
                            id="forgotPasswordForm"
                            class="flex flex-col items-start gap-5 w-full"
                        >
                            <!-- Email Input Field -->
                            <div class="flex flex-col items-end gap-2 w-full">
                                <label class="flex justify-start items-start gap-1.5 w-full">
                    <span
                        class="font-tajawal text-sm font-normal leading-5 text-neutral-n600 text-right"
                    >
                      بريدك الإلكتروني
                    </span>
                                </label>
                                <div
                                    class="flex h-[42px] px-3 items-center gap-2 w-full border border-blue-gray-300 rounded-lg bg-white relative"
                                >
                                    <svg
                                        width="18"
                                        height="18"
                                        viewBox="0 0 18 18"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                        class="flex-shrink-0"
                                    >
                                        <g clip-path="url(#clip0_2619_6110)">
                                            <path
                                                fill-rule="evenodd"
                                                clip-rule="evenodd"
                                                d="M16.8237 4.43766L9.75101 10.2948C9.55004 10.4613 9.29724 10.5524 9.03624 10.5524C8.77525 10.5524 8.52245 10.4613 8.32147 10.2948L1.25218 4.43766C1.21424 4.55184 1.19495 4.67138 1.19504 4.79169V13.7543C1.19504 14.0515 1.31307 14.3364 1.52318 14.5465C1.73328 14.7566 2.01824 14.8747 2.31537 14.8747H15.7594C16.0565 14.8747 16.3414 14.7566 16.5515 14.5465C16.7617 14.3364 16.8797 14.0515 16.8797 13.7543V4.79169C16.8801 4.67144 16.8612 4.5519 16.8237 4.43766ZM2.31537 2.55103H15.7594C16.3536 2.55103 16.9235 2.78709 17.3437 3.2073C17.7639 3.62751 18 4.19743 18 4.79169V13.7543C18 14.3486 17.7639 14.9185 17.3437 15.3387C16.9235 15.7589 16.3536 15.995 15.7594 15.995H2.31537C1.72111 15.995 1.15119 15.7589 0.730982 15.3387C0.310776 14.9185 0.074707 14.3486 0.074707 13.7543V4.79169C0.074707 4.19743 0.310776 3.62751 0.730982 3.2073C1.15119 2.78709 1.72111 2.55103 2.31537 2.55103ZM2.0801 3.67136L8.32707 8.82825C8.52715 8.9935 8.77838 9.08418 9.03788 9.08479C9.29738 9.0854 9.54904 8.99591 9.74989 8.83161L16.0596 3.67136H2.0801Z"
                                                fill="#BFBFBF"
                                            />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_2619_6110">
                                                <rect
                                                    width="17.9253"
                                                    height="17.9253"
                                                    fill="white"
                                                    transform="translate(0.074707 0.0373535)"
                                                />
                                            </clipPath>
                                        </defs>
                                    </svg>

                                    <input
                                        type="email"
                                        id="email"
                                        name="email"
                                        placeholder="بريد إلكتروني للتواصل"
                                        required
                                        class="flex-1 font-tajawal text-xs font-normal leading-[18px] text-neutral-n50 placeholder:text-neutral-n50 text-right bg-transparent border-0 outline-none focus:ring-0"
                                    />
                                </div>
                            </div>

                            <!-- Submit Button -->
                            <div class="flex flex-col items-start gap-4 w-full">
                                <button
                                    type="submit"
                                    class="flex px-[18px] py-[10px] justify-center items-center gap-2 w-full rounded-lg border border-brand-primary bg-brand-primary hover:bg-blue-800 focus:ring-2 focus:ring-brand-primary focus:ring-offset-2 transition-colors"
                                >
                    <span
                        class="font-tajawal text-base font-normal leading-6 text-neutral-n10 text-center"
                    >
                      إعادة تعيين
                    </span>
                                </button>
                            </div>
                        </form>

                        <!-- Contact Link -->
                        <div class="flex justify-center items-start gap-1 w-full">
                <span
                    class="font-tajawal text-sm font-normal leading-5 text-neutral-n300"
                >
                  ليس لديك حساب؟
                </span>
                            <a
                                href="#"
                                class="font-tajawal text-sm font-normal leading-5 text-brand-primary underline hover:text-blue-800 text-center"
                            >
                                تواصل معنا
                            </a>
                        </div>

                        <!-- Success Message -->
                        <div id="successMessage" class="success-message w-full p-4">
                            <div
                                class="flex p-4 items-start gap-3 w-full rounded-lg border border-success-green bg-success-green-light relative"
                            >
                                <!-- Close Button -->
                                <div
                                    class="flex justify-center items-center absolute left-1 top-1"
                                >
                                    <button
                                        id="closeSuccessMessage"
                                        class="flex p-2 justify-center items-center rounded-lg w-9 h-9 hover:bg-gray-100 transition-colors"
                                    >
                                        <svg
                                            width="20"
                                            height="20"
                                            viewBox="0 0 20 20"
                                            fill="none"
                                            xmlns="http://www.w3.org/2000/svg"
                                        >
                                            <path
                                                d="M15 5L5 15M5 5L15 15"
                                                stroke="#00B34F"
                                                stroke-width="1.67"
                                                stroke-linecap="round"
                                                stroke-linejoin="round"
                                            />
                                        </svg>
                                    </button>
                                </div>
                                <!-- Check Circle Icon -->
                                <svg
                                    width="20"
                                    height="20"
                                    viewBox="0 0 20 20"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg"
                                    class="flex-shrink-0"
                                >
                                    <g clip-path="url(#clip0_2621_8360)">
                                        <path
                                            d="M18.3332 9.2333V9.99997C18.3321 11.797 17.7503 13.5455 16.6743 14.9848C15.5983 16.4241 14.0859 17.477 12.3626 17.9866C10.6394 18.4961 8.79755 18.4349 7.1119 17.8121C5.42624 17.1894 3.98705 16.0384 3.00897 14.5309C2.03089 13.0233 1.56633 11.24 1.68457 9.4469C1.80281 7.65377 2.49751 5.94691 3.66507 4.58086C4.83263 3.21482 6.41049 2.26279 8.16333 1.86676C9.91617 1.47073 11.7501 1.65192 13.3915 2.3833M18.3332 3.3333L9.99984 11.675L7.49984 9.17497"
                                            stroke="#00B34F"
                                            stroke-width="2"
                                            stroke-linecap="round"
                                            stroke-linejoin="round"
                                        />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_2621_8360">
                                            <rect width="20" height="20" fill="white" />
                                        </clipPath>
                                    </defs>
                                </svg>

                                <!-- Message Content -->
                                <div class="flex flex-col items-end gap-1 flex-1">
                                    <div
                                        class="font-tajawal text-sm font-medium leading-5 text-success-green text-right w-full"
                                    >
                                        تم إرسال رسالة لتغيير كلمة المرور عبر بريدك الإلكتروني
                                    </div>
                                    <div
                                        class="font-tajawal text-sm font-normal leading-5 text-neutral-n300 text-right w-full"
                                    >
                                        برجاء فحص بريدك الإلكترونى للإسترجاع كلمة المرور، قد يصل
                                        البريد الإلكترونى فى مجلد الرسائل الغير مرغوب بها (Spam أو
                                        Junk)
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('footerScript'); ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        window.Toast= Swal.mixin({
            toast: true,
            position: "top-end",
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.onmouseenter = Swal.stopTimer;
                toast.onmouseleave = Swal.resumeTimer;
            }
        });
    </script>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const forgotPasswordForm =
                document.getElementById("forgotPasswordForm");
            const emailInput = document.getElementById("email");
            const successMessage = document.getElementById("successMessage");

            // Handle form submission
            forgotPasswordForm.addEventListener("submit", function (e) {
                e.preventDefault();

                const email = emailInput.value.trim();

                // Basic email validation
                if (!email || !isValidEmail(email)) {
                    showError("يرجى إدخال بريد إلكتروني صحيح");
                    return;
                }

                // Simulate sending reset email
                sendResetEmail(email);
            });

            function isValidEmail(email) {
                const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                return emailRegex.test(email);
            }

            function sendResetEmail(email) {
                // Show loading state
                const submitButton = forgotPasswordForm.querySelector(
                    'button[type="submit"]'
                );
                const originalText = submitButton.textContent;
                submitButton.textContent = "جاري الإرسال...";
                submitButton.disabled = true;

                // Simulate API call
                forgotPasswordForm.classList.add('loading')
                let formData=new FormData(forgotPasswordForm)
                fetch("<?php echo e(route('forget_password_page')); ?>", {
                    method: "POST",
                    body: formData,
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                        "Accept": "application/json"
                    }
                }) .then(async response => {
                    // Laravel بيرجع JSON غالبًا
                    // if (!response.ok) {
                    //     throw new Error("يوجد خطء في الوقت الحالي حاول مره اخري لاحقا او تواصل معنا");
                    // }
                    return response.json();
                })
                    .then(data => {
                        forgotPasswordForm.classList.remove('loading')

                        if (data.success) {
                            forgotPasswordForm.reset();
                            // Show success message
                            successMessage.classList.add("show");
                            // Change button appearance after success
                            submitButton.style.backgroundColor = "#757575";
                            submitButton.style.color = "white";
                            submitButton.style.borderColor = "#757575";
                            submitButton.textContent = "تم الإرسال";
                            submitButton.disabled = true;
                            // Hide success message after 10 seconds
                            setTimeout(() => {
                                successMessage.classList.remove("show");
                            }, 10000000000000000);

                            // Here you would normally make an actual API call to your backend
                            console.log("Password reset email would be sent to:", email);
                        }else{
                            submitButton.textContent = originalText;
                            submitButton.disabled = false;
                        }

                        if (typeof data.message === 'object') {
                            for(let key in data.message){
                                const field = forgotPasswordForm.querySelector("[name='" + key + "']");
                                if (field) {
                                    const parent = field.parentNode;
                                    const label = document.createElement("label");
                                    label.id = key + "-error";
                                    label.className = "error";
                                    label.setAttribute("for", key);
                                    label.textContent = data.message[key];

                                    parent.appendChild(label);
                                }
                            }
                        }
                        Toast.fire({
                            icon: data.success ? "success" : "error",
                            title: data.message
                        });
                        if(data.redirect){
                            setTimeout(function(){
                                window.location.href=data.redirect;
                            },3000)

                        }

                    })
                    .catch(error => {
                        forgotPasswordForm.classList.remove('loading')
                        console.error("Fetch error:", error);
                        Toast.fire({
                            icon: "error",
                            title:error.toString().replaceAll('Error:','')
                        });
                    });

            }

            function showError(message) {
                // Remove any existing error messages
                const existingError = document.querySelector(".error-message");
                if (existingError) {
                    existingError.remove();
                }

                // Create error message
                const errorDiv = document.createElement("div");
                errorDiv.className =
                    "error-message bg-red-50 border border-red-200 rounded-lg p-4 mb-6";
                errorDiv.innerHTML = `
            <div class="flex items-start gap-3">
              <div class="flex-shrink-0">
                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M10 18C14.4183 18 18 14.4183 18 10C18 5.58172 14.4183 2 10 2C5.58172 2 2 5.58172 2 10C2 14.4183 5.58172 18 10 18Z" stroke="#DC2626" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                  <path d="M10 6V10" stroke="#DC2626" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                  <path d="M10 14H10.01" stroke="#DC2626" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
              </div>
              <div>
                <p class="font-alexandria text-sm text-red-700 text-right">${message}</p>
              </div>
            </div>
          `;

                // Insert before form
                forgotPasswordForm.parentNode.insertBefore(
                    errorDiv,
                    forgotPasswordForm
                );

                // Remove error message after 5 seconds
                setTimeout(() => {
                    errorDiv.remove();
                }, 5000);
            }

            // Auto-hide success message when typing
            emailInput.addEventListener("input", function () {
                if (successMessage.classList.contains("show")) {
                    successMessage.classList.remove("show");
                }
            });

            // Handle close button click
            document.addEventListener("click", function (e) {
                if (e.target.closest("#closeSuccessMessage")) {
                    successMessage.classList.remove("show");
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.app_empty', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ebacademy/public_html/beta.e3melbusiness.org/resources/views/frontend/forget_password.blade.php ENDPATH**/ ?>