<nav
    class="bg-[#e8ecf4] w-full px-4 py-2.5"
    data-name="Navigation bar"
    data-node-id="3144:12388"
>
    <div class="flex items-center justify-between w-full">
        <div class="flex items-center gap-6">
            <!-- Logo (Always visible) -->
            <div
                class="flex flex-col font-tajawal gap-1 items-center justify-start text-center w-[80px] md:w-[119.657px]"
                data-name="Icon"
            >
                <img
                    src="<?php echo e(asset('frontend/images')); ?>/e3mel-business-logo.png"
                    alt="E3mel Business Logo"
                    class="w-[80px] md:w-[119.657px] h-auto"
                />
            </div>

            <!-- Desktop Navigation (Hidden on mobile) -->
            <div
                class="flex gap-6 items-center"
                data-name="Nav Links Container"
            >
                <!-- Search Button/Input - HIDDEN on very small screens -->
                <form action="<?php echo e(route('search_page')); ?>"
                    id="search-container"
                    class="bg-[#f7f7f7] h-12 w-16 rounded-lg flex items-center overflow-hidden transition-all duration-300 ease-in-out cursor-pointer hidden sm:flex"
                    data-name="Search Box"
                >
                    <button
                        type="button"
                        id="search-button"
                        class="h-12 w-16 flex items-center justify-center flex-shrink-0"
                        title="البحث"
                        aria-label="البحث"
                        onclick="toggleSearch()"
                    >
                        <div class="w-6 h-6">
                            <svg
                                width="24"
                                height="24"
                                viewBox="0 0 24 24"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                            >
                                <circle
                                    cx="11"
                                    cy="11"
                                    r="8"
                                    stroke="#666"
                                    stroke-width="2"
                                />
                                <path
                                    d="m21 21-4.35-4.35"
                                    stroke="#666"
                                    stroke-width="2"
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                />
                            </svg>
                        </div>
                    </button>
                    <input
                        name="search"
                        value="<?php echo e(request('search')); ?>"
                        id="search-input"
                        type="text"
                        placeholder="ابحث هنا..."
                        class="h-full bg-transparent border-none outline-none text-right font-tajawal text-sm px-2 opacity-0 w-0 transition-all duration-300 ease-in-out"
                    />
                </form>

                <!-- Navigation Links -->
                <div class="flex gap-6 items-center hidden lg:flex" data-name="Nav Links">
                    <div
                        class="flex gap-2.5 items-center justify-center p-2 hover:border-b-2 hover:border-[#103676] cursor-pointer <?php if(request()->routeIs('home_page')): ?><?php echo e('border-brand-secondary-normal border-b-2'); ?><?php endif; ?>"
                    >
                        <a href="<?php echo e(route('home_page')); ?>"
                            class="font-tajawal font-medium text-[#103676] text-[14px] leading-5 whitespace-nowrap"
                        >
                            الرئيسية
                        </a>
                    </div>
                    <div
                        class="flex gap-2.5 items-center justify-center p-2 hover:border-b-2 hover:border-[#103676] cursor-pointer <?php if(request()->routeIs('courses_page')): ?><?php echo e('border-brand-secondary-normal border-b-2'); ?><?php endif; ?>"
                    >
                        <a   href="<?php echo e(route('courses_page')); ?>" class="font-tajawal font-medium text-[#144394] text-[14px] leading-5 whitespace-nowrap"
                        >
                            الدورات التدريبية
                        </a>
                    </div>
                    <div class="flex gap-2.5 items-center justify-center p-2 hover:border-b-2 hover:border-[#103676] cursor-pointer <?php if(request()->routeIs('our_prices_page')): ?><?php echo e('border-brand-secondary-normal border-b-2'); ?><?php endif; ?>"
                    >
                        <a href="<?php echo e(route('our_prices_page')); ?>"
                            class="font-tajawal font-medium text-[#144394] text-[14px] leading-5 whitespace-nowrap"
                        >
                            اسعارنا
                        </a>
                    </div>
                    <div
                        class="flex gap-2.5 items-center justify-center p-2 hover:border-b-2 hover:border-[#103676] cursor-pointer <?php if(request()->routeIs('our_solution_page')): ?><?php echo e('border-brand-secondary-normal border-b-2'); ?><?php endif; ?>"
                    >
                        <a href="<?php echo e(route('our_solution_page')); ?>"
                            class="font-tajawal font-medium text-[#144394] text-[14px] leading-5 whitespace-nowrap"
                        >
                            حلولنا لك
                        </a>
                    </div>
                    <div
                        class="flex gap-2.5 items-center justify-center p-2 hover:border-b-2 hover:border-[#103676] cursor-pointer <?php if(request()->routeIs('contact_us_page')): ?><?php echo e('border-brand-secondary-normal border-b-2'); ?><?php endif; ?>"
                    >
                        <a href="<?php echo e(route('contact_us_page')); ?>"
                            class="font-tajawal font-medium text-[#144394] text-[14px] leading-5 whitespace-nowrap"
                        >
                            تواصل معنا
                        </a>
                    </div>
                </div>
            </div>

        </div>

        <!-- Mobile & Desktop Action Buttons -->
        <div class="flex items-center gap-2">


            <!-- Demo Button hidden on mobile and small tablets -->
            <a href="<?php echo e(route('book_demo_page')); ?>"
                class="hidden md:flex items-center gap-1 md:gap-2 lg:gap-3 px-2 md:px-3 lg:px-6 py-2 lg:py-3 bg-[#00B34F] border border-[#00B34F] rounded-lg text-white font-alexandria hover:bg-[#00A047] transition-colors"
            >
            <span
                class="text-xs md:text-sm lg:text-base font-medium whitespace-nowrap"
            >
              احجز عرضًا توضيحيًا الآن
            </span>
                <svg
                    width="16"
                    height="16"
                    viewBox="0 0 24 25"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                    class="md:w-5 md:h-5 lg:w-6 lg:h-6"
                >
                    <path
                        d="M8.414 13.843L12.364 17.793C12.5462 17.9816 12.647 18.2342 12.6447 18.4964C12.6424 18.7586 12.5372 19.0094 12.3518 19.1948C12.1664 19.3802 11.9156 19.4854 11.6534 19.4876C11.3911 19.4899 11.1386 19.3891 10.95 19.207L5.293 13.55C5.19982 13.4573 5.12587 13.3471 5.07541 13.2258C5.02494 13.1045 4.99891 12.9744 4.99891 12.843C4.99891 12.7116 5.02494 12.5814 5.07541 12.4601C5.12587 12.3388 5.19982 12.2286 5.293 12.136L10.95 6.479C11.0422 6.38349 11.1526 6.30731 11.2746 6.2549C11.3966 6.20249 11.5278 6.1749 11.6606 6.17375C11.7934 6.1726 11.9251 6.1979 12.048 6.24818C12.1709 6.29846 12.2825 6.37271 12.3764 6.4666C12.4703 6.5605 12.5445 6.67215 12.5948 6.79505C12.6451 6.91794 12.6704 7.04962 12.6693 7.1824C12.6681 7.31518 12.6405 7.4464 12.5881 7.5684C12.5357 7.69041 12.4595 7.80075 12.364 7.893L8.414 11.843H18C18.2652 11.843 18.5196 11.9483 18.7071 12.1359C18.8946 12.3234 19 12.5777 19 12.843C19 13.1082 18.8946 13.3625 18.7071 13.5501C18.5196 13.7376 18.2652 13.843 18 13.843H8.414Z"
                        fill="white"
                    />
                </svg>
            </a>
        <?php if(auth()->guard()->check()): ?>
                <form id="logoutForm" method="POST" class="d-none" action="<?php echo e(route('logout_page')); ?>"><input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>"></form>
                <a href="#" onclick="$('#logoutForm').submit();return false;"
                   class="hidden lg:flex items-center gap-3 px-6 py-3 border-2 border-[#00B34F] rounded-lg text-[#00B34F] font-alexandria transition-colors"
                >
                    <span class="text-base font-medium">تسجيل خروج</span>
                    <svg
                        width="22"
                        height="23"
                        viewBox="0 0 22 23"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                    >
                        <path
                            fill-rule="evenodd"
                            clip-rule="evenodd"
                            d="M9.5 19.763H1.95C1.89696 19.763 1.84609 19.7419 1.80858 19.7044C1.77107 19.6669 1.75 19.616 1.75 19.563V18.113C1.75 17.282 2.343 16.55 3.257 15.928C4.889 14.814 7.53 14.112 10.5 14.112C10.99 14.112 11.471 14.132 11.941 14.169C12.0404 14.179 12.1407 14.1691 12.2362 14.1398C12.3316 14.1105 12.4203 14.0624 12.4969 13.9984C12.5736 13.9344 12.6367 13.8557 12.6825 13.767C12.7283 13.6783 12.756 13.5813 12.7638 13.4818C12.7717 13.3822 12.7596 13.2821 12.7282 13.1873C12.6969 13.0925 12.6469 13.0049 12.5813 12.9297C12.5156 12.8544 12.4356 12.7931 12.3459 12.7492C12.2562 12.7053 12.1587 12.6797 12.059 12.674C11.5404 12.6324 11.0203 12.6117 10.5 12.612C7.178 12.612 4.237 13.443 2.411 14.688C1.018 15.638 0.25 16.845 0.25 18.112V19.563C0.250265 20.0137 0.429489 20.4458 0.748272 20.7644C1.06706 21.083 1.49931 21.262 1.95 21.262L9.5 21.263C9.69891 21.263 9.88968 21.184 10.0303 21.0433C10.171 20.9027 10.25 20.7119 10.25 20.513C10.25 20.3141 10.171 20.1233 10.0303 19.9827C9.88968 19.842 9.69891 19.763 9.5 19.763ZM10.5 0.75C7.464 0.75 5 3.214 5 6.25C5 9.286 7.464 11.75 10.5 11.75C13.536 11.75 16 9.286 16 6.25C16 3.214 13.536 0.75 10.5 0.75ZM10.5 2.25C12.708 2.25 14.5 4.042 14.5 6.25C14.5 8.458 12.708 10.25 10.5 10.25C8.292 10.25 6.5 8.458 6.5 6.25C6.5 4.042 8.292 2.25 10.5 2.25ZM17.152 19.708C17.8282 19.8105 18.5194 19.738 19.1596 19.4975C19.7999 19.257 20.3678 18.8565 20.8093 18.3341C21.2507 17.8117 21.551 17.185 21.6814 16.5136C21.8119 15.8422 21.7681 15.1486 21.5543 14.499C21.3405 13.8493 20.9639 13.2653 20.4603 12.8025C19.9566 12.3398 19.3429 12.0138 18.6775 11.8557C18.0121 11.6975 17.3173 11.7125 16.6593 11.8992C16.0014 12.0859 15.4022 12.438 14.919 12.922C14.4756 13.3649 14.1426 13.9058 13.9469 14.5011C13.7511 15.0964 13.6981 15.7294 13.792 16.349L11.47 18.67C11.4002 18.7397 11.3449 18.8225 11.3071 18.9136C11.2694 19.0047 11.25 19.1024 11.25 19.201V21.5C11.25 21.914 11.586 22.25 12 22.25H14.299C14.3976 22.25 14.4953 22.2306 14.5864 22.1929C14.6775 22.1551 14.7603 22.0998 14.83 22.03L17.152 19.708ZM17.1 18.168C16.9731 18.1342 16.8395 18.1343 16.7126 18.1683C16.5857 18.2024 16.47 18.2692 16.377 18.362L13.989 20.75H12.75V19.511L15.138 17.123C15.2308 17.03 15.2976 16.9143 15.3317 16.7874C15.3657 16.6605 15.3658 16.5269 15.332 16.4C15.1908 15.8683 15.2286 15.3048 15.4397 14.7967C15.6507 14.2887 16.0232 13.8642 16.4996 13.589C16.976 13.3138 17.5298 13.2032 18.0754 13.2742C18.621 13.3453 19.1279 13.594 19.518 13.982C19.906 14.3721 20.1547 14.879 20.2258 15.4246C20.2968 15.9702 20.1862 16.524 19.911 17.0004C19.6358 17.4768 19.2113 17.8493 18.7033 18.0603C18.1952 18.2714 17.6317 18.3092 17.1 18.168Z"
                            fill="#E6F7ED"
                        />
                    </svg>
                </a>
            <?php else: ?>
            <!-- Login Button (Hidden on mobile and small tablets) -->
            <a href="<?php echo e(route('login_page')); ?>"
                class="hidden lg:flex items-center gap-3 px-6 py-3 border-2 border-[#00B34F] rounded-lg text-[#00B34F] font-alexandria transition-colors"
            >
                <span class="text-base font-medium">تسجيل الدخول</span>
                <svg
                    width="22"
                    height="23"
                    viewBox="0 0 22 23"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <path
                        fill-rule="evenodd"
                        clip-rule="evenodd"
                        d="M9.5 19.763H1.95C1.89696 19.763 1.84609 19.7419 1.80858 19.7044C1.77107 19.6669 1.75 19.616 1.75 19.563V18.113C1.75 17.282 2.343 16.55 3.257 15.928C4.889 14.814 7.53 14.112 10.5 14.112C10.99 14.112 11.471 14.132 11.941 14.169C12.0404 14.179 12.1407 14.1691 12.2362 14.1398C12.3316 14.1105 12.4203 14.0624 12.4969 13.9984C12.5736 13.9344 12.6367 13.8557 12.6825 13.767C12.7283 13.6783 12.756 13.5813 12.7638 13.4818C12.7717 13.3822 12.7596 13.2821 12.7282 13.1873C12.6969 13.0925 12.6469 13.0049 12.5813 12.9297C12.5156 12.8544 12.4356 12.7931 12.3459 12.7492C12.2562 12.7053 12.1587 12.6797 12.059 12.674C11.5404 12.6324 11.0203 12.6117 10.5 12.612C7.178 12.612 4.237 13.443 2.411 14.688C1.018 15.638 0.25 16.845 0.25 18.112V19.563C0.250265 20.0137 0.429489 20.4458 0.748272 20.7644C1.06706 21.083 1.49931 21.262 1.95 21.262L9.5 21.263C9.69891 21.263 9.88968 21.184 10.0303 21.0433C10.171 20.9027 10.25 20.7119 10.25 20.513C10.25 20.3141 10.171 20.1233 10.0303 19.9827C9.88968 19.842 9.69891 19.763 9.5 19.763ZM10.5 0.75C7.464 0.75 5 3.214 5 6.25C5 9.286 7.464 11.75 10.5 11.75C13.536 11.75 16 9.286 16 6.25C16 3.214 13.536 0.75 10.5 0.75ZM10.5 2.25C12.708 2.25 14.5 4.042 14.5 6.25C14.5 8.458 12.708 10.25 10.5 10.25C8.292 10.25 6.5 8.458 6.5 6.25C6.5 4.042 8.292 2.25 10.5 2.25ZM17.152 19.708C17.8282 19.8105 18.5194 19.738 19.1596 19.4975C19.7999 19.257 20.3678 18.8565 20.8093 18.3341C21.2507 17.8117 21.551 17.185 21.6814 16.5136C21.8119 15.8422 21.7681 15.1486 21.5543 14.499C21.3405 13.8493 20.9639 13.2653 20.4603 12.8025C19.9566 12.3398 19.3429 12.0138 18.6775 11.8557C18.0121 11.6975 17.3173 11.7125 16.6593 11.8992C16.0014 12.0859 15.4022 12.438 14.919 12.922C14.4756 13.3649 14.1426 13.9058 13.9469 14.5011C13.7511 15.0964 13.6981 15.7294 13.792 16.349L11.47 18.67C11.4002 18.7397 11.3449 18.8225 11.3071 18.9136C11.2694 19.0047 11.25 19.1024 11.25 19.201V21.5C11.25 21.914 11.586 22.25 12 22.25H14.299C14.3976 22.25 14.4953 22.2306 14.5864 22.1929C14.6775 22.1551 14.7603 22.0998 14.83 22.03L17.152 19.708ZM17.1 18.168C16.9731 18.1342 16.8395 18.1343 16.7126 18.1683C16.5857 18.2024 16.47 18.2692 16.377 18.362L13.989 20.75H12.75V19.511L15.138 17.123C15.2308 17.03 15.2976 16.9143 15.3317 16.7874C15.3657 16.6605 15.3658 16.5269 15.332 16.4C15.1908 15.8683 15.2286 15.3048 15.4397 14.7967C15.6507 14.2887 16.0232 13.8642 16.4996 13.589C16.976 13.3138 17.5298 13.2032 18.0754 13.2742C18.621 13.3453 19.1279 13.594 19.518 13.982C19.906 14.3721 20.1547 14.879 20.2258 15.4246C20.2968 15.9702 20.1862 16.524 19.911 17.0004C19.6358 17.4768 19.2113 17.8493 18.7033 18.0603C18.1952 18.2714 17.6317 18.3092 17.1 18.168Z"
                        fill="#00B34F"
                    />
                </svg>
            </a>
            <?php endif; ?>

            <!-- Mobile Menu Button (Hamburger) -->
            <button
                id="mobile-menu-button"
                class="lg:hidden flex items-center justify-center w-10 h-10 rounded-lg text-[#144394] hover:bg-[#f0f0f0] transition-colors"
                aria-label="القائمة"
                onclick="toggleMobileMenu()"
            >
                <svg
                    id="hamburger-icon"
                    width="24"
                    height="24"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <path
                        d="M3 12H21M3 6H21M3 18H21"
                        stroke="currentColor"
                        stroke-width="2"
                        stroke-linecap="round"
                        stroke-linejoin="round"
                    />
                </svg>
                <svg
                    id="close-icon"
                    class="hidden"
                    width="24"
                    height="24"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <path
                        d="M18 6L6 18M6 6L18 18"
                        stroke="currentColor"
                        stroke-width="2"
                        stroke-linecap="round"
                        stroke-linejoin="round"
                    />
                </svg>
            </button>
        </div>
    </div>

    <!-- Mobile Menu (Hidden by default) -->
    <div
        id="mobile-menu"
        class="lg:hidden hidden mt-4 p-4 bg-white rounded-lg shadow-lg border border-gray-200"
    >
        <!-- Mobile Search (Alternative for very small screens) -->
        <div class="sm:hidden mb-4">
            <div class="relative">
                <input
                    type="text"
                    placeholder="ابحث هنا..."
                    class="w-full h-12 bg-[#f7f7f7] border-none outline-none text-right font-tajawal text-sm px-4 pr-12 rounded-lg"
                    id="mobile-search-input"
                />
                <div class="absolute left-3 top-1/2 transform -translate-y-1/2">
                    <svg
                        width="20"
                        height="20"
                        viewBox="0 0 24 24"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                    >
                        <circle
                            cx="11"
                            cy="11"
                            r="8"
                            stroke="#666"
                            stroke-width="2"
                        />
                        <path
                            d="m21 21-4.35-4.35"
                            stroke="#666"
                            stroke-width="2"
                            stroke-linecap="round"
                            stroke-linejoin="round"
                        />
                    </svg>
                </div>
            </div>
        </div>

        <!-- Mobile Navigation Links -->
        <div class="flex flex-col gap-4">
            <a
                href="<?php echo e(route('home_page')); ?>"
                class="flex items-center p-3 text-[#103676] font-tajawal font-medium text-base hover:bg-[#f0f0f0] rounded-lg transition-colors"
            >
                الرئيسية
            </a>
            <a
                href="<?php echo e(route('courses_page')); ?>"
                class="flex items-center p-3 text-[#144394] font-tajawal font-medium text-base hover:bg-[#f0f0f0] rounded-lg transition-colors"
            >
                الدورات التدريبية
            </a>
            <a
                href="<?php echo e(route('our_prices_page')); ?>"
                class="flex items-center p-3 text-[#144394] font-tajawal font-medium text-base hover:bg-[#f0f0f0] rounded-lg transition-colors"
            >
                اسعارنا
            </a>
            <a
                href="<?php echo e(route('our_solution_page')); ?>"
                class="flex items-center p-3 text-[#144394] font-tajawal font-medium text-base hover:bg-[#f0f0f0] rounded-lg transition-colors"
            >
                حلولنا لك
            </a>
            <a
                href="<?php echo e(route('contact_us_page')); ?>"
                class="flex items-center p-3 text-[#144394] font-tajawal font-medium text-base hover:bg-[#f0f0f0] rounded-lg transition-colors"
            >
                تواصل معنا
            </a>
            <?php if(auth()->guard()->check()): ?>
                <form id="logoutForm" method="POST" class="d-none" action="<?php echo e(route('logout_page')); ?>"><input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>"></form>
                <a href="#" onclick="$('#logoutForm').submit();return false;"
                    class="flex items-center justify-between gap-3 p-3 border-2 border-[#00B34F] rounded-lg text-[#00B34F] font-alexandria font-medium text-base hover:bg-[#00B34F] hover:text-white transition-colors"
                >
                    <span>تسجيل خروج</span>
                    <svg
                        width="20"
                        height="21"
                        viewBox="0 0 22 23"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                    >
                        <path
                            fill-rule="evenodd"
                            clip-rule="evenodd"
                            d="M9.5 19.763H1.95C1.89696 19.763 1.84609 19.7419 1.80858 19.7044C1.77107 19.6669 1.75 19.616 1.75 19.563V18.113C1.75 17.282 2.343 16.55 3.257 15.928C4.889 14.814 7.53 14.112 10.5 14.112C10.99 14.112 11.471 14.132 11.941 14.169C12.0404 14.179 12.1407 14.1691 12.2362 14.1398C12.3316 14.1105 12.4203 14.0624 12.4969 13.9984C12.5736 13.9344 12.6367 13.8557 12.6825 13.767C12.7283 13.6783 12.756 13.5813 12.7638 13.4818C12.7717 13.3822 12.7596 13.2821 12.7282 13.1873C12.6969 13.0925 12.6469 13.0049 12.5813 12.9297C12.5156 12.8544 12.4356 12.7931 12.3459 12.7492C12.2562 12.7053 12.1587 12.6797 12.059 12.674C11.5404 12.6324 11.0203 12.6117 10.5 12.612C7.178 12.612 4.237 13.443 2.411 14.688C1.018 15.638 0.25 16.845 0.25 18.112V19.563C0.250265 20.0137 0.429489 20.4458 0.748272 20.7644C1.06706 21.083 1.49931 21.262 1.95 21.262L9.5 21.263C9.69891 21.263 9.88968 21.184 10.0303 21.0433C10.171 20.9027 10.25 20.7119 10.25 20.513C10.25 20.3141 10.171 20.1233 10.0303 19.9827C9.88968 19.842 9.69891 19.763 9.5 19.763ZM10.5 0.75C7.464 0.75 5 3.214 5 6.25C5 9.286 7.464 11.75 10.5 11.75C13.536 11.75 16 9.286 16 6.25C16 3.214 13.536 0.75 10.5 0.75ZM10.5 2.25C12.708 2.25 14.5 4.042 14.5 6.25C14.5 8.458 12.708 10.25 10.5 10.25C8.292 10.25 6.5 8.458 6.5 6.25C6.5 4.042 8.292 2.25 10.5 2.25ZM17.152 19.708C17.8282 19.8105 18.5194 19.738 19.1596 19.4975C19.7999 19.257 20.3678 18.8565 20.8093 18.3341C21.2507 17.8117 21.551 17.185 21.6814 16.5136C21.8119 15.8422 21.7681 15.1486 21.5543 14.499C21.3405 13.8493 20.9639 13.2653 20.4603 12.8025C19.9566 12.3398 19.3429 12.0138 18.6775 11.8557C18.0121 11.6975 17.3173 11.7125 16.6593 11.8992C16.0014 12.0859 15.4022 12.438 14.919 12.922C14.4756 13.3649 14.1426 13.9058 13.9469 14.5011C13.7511 15.0964 13.6981 15.7294 13.792 16.349L11.47 18.67C11.4002 18.7397 11.3449 18.8225 11.3071 18.9136C11.2694 19.0047 11.25 19.1024 11.25 19.201V21.5C11.25 21.914 11.586 22.25 12 22.25H14.299C14.3976 22.25 14.4953 22.2306 14.5864 22.1929C14.6775 22.1551 14.7603 22.0998 14.83 22.03L17.152 19.708ZM17.1 18.168C16.9731 18.1342 16.8395 18.1343 16.7126 18.1683C16.5857 18.2024 16.47 18.2692 16.377 18.362L13.989 20.75H12.75V19.511L15.138 17.123C15.2308 17.03 15.2976 16.9143 15.3317 16.7874C15.3657 16.6605 15.3658 16.5269 15.332 16.4C15.1908 15.8683 15.2286 15.3048 15.4397 14.7967C15.6507 14.2887 16.0232 13.8642 16.4996 13.589C16.976 13.3138 17.5298 13.2032 18.0754 13.2742C18.621 13.3453 19.1279 13.594 19.518 13.982C19.906 14.3721 20.1547 14.879 20.2258 15.4246C20.2968 15.9702 20.1862 16.524 19.911 17.0004C19.6358 17.4768 19.2113 17.8493 18.7033 18.0603C18.1952 18.2714 17.6317 18.3092 17.1 18.168Z"
                            fill="currentColor"
                        />
                    </svg>
                </a>
                <?php else: ?>
            <!-- Mobile Login Button -->
            <a
                href="<?php echo e(route('login_page')); ?>"
                class="flex items-center justify-between gap-3 p-3 border-2 border-[#00B34F] rounded-lg text-[#00B34F] font-alexandria font-medium text-base hover:bg-[#00B34F] hover:text-white transition-colors"
            >
                <span>تسجيل الدخول</span>
                <svg
                    width="20"
                    height="21"
                    viewBox="0 0 22 23"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <path
                        fill-rule="evenodd"
                        clip-rule="evenodd"
                        d="M9.5 19.763H1.95C1.89696 19.763 1.84609 19.7419 1.80858 19.7044C1.77107 19.6669 1.75 19.616 1.75 19.563V18.113C1.75 17.282 2.343 16.55 3.257 15.928C4.889 14.814 7.53 14.112 10.5 14.112C10.99 14.112 11.471 14.132 11.941 14.169C12.0404 14.179 12.1407 14.1691 12.2362 14.1398C12.3316 14.1105 12.4203 14.0624 12.4969 13.9984C12.5736 13.9344 12.6367 13.8557 12.6825 13.767C12.7283 13.6783 12.756 13.5813 12.7638 13.4818C12.7717 13.3822 12.7596 13.2821 12.7282 13.1873C12.6969 13.0925 12.6469 13.0049 12.5813 12.9297C12.5156 12.8544 12.4356 12.7931 12.3459 12.7492C12.2562 12.7053 12.1587 12.6797 12.059 12.674C11.5404 12.6324 11.0203 12.6117 10.5 12.612C7.178 12.612 4.237 13.443 2.411 14.688C1.018 15.638 0.25 16.845 0.25 18.112V19.563C0.250265 20.0137 0.429489 20.4458 0.748272 20.7644C1.06706 21.083 1.49931 21.262 1.95 21.262L9.5 21.263C9.69891 21.263 9.88968 21.184 10.0303 21.0433C10.171 20.9027 10.25 20.7119 10.25 20.513C10.25 20.3141 10.171 20.1233 10.0303 19.9827C9.88968 19.842 9.69891 19.763 9.5 19.763ZM10.5 0.75C7.464 0.75 5 3.214 5 6.25C5 9.286 7.464 11.75 10.5 11.75C13.536 11.75 16 9.286 16 6.25C16 3.214 13.536 0.75 10.5 0.75ZM10.5 2.25C12.708 2.25 14.5 4.042 14.5 6.25C14.5 8.458 12.708 10.25 10.5 10.25C8.292 10.25 6.5 8.458 6.5 6.25C6.5 4.042 8.292 2.25 10.5 2.25ZM17.152 19.708C17.8282 19.8105 18.5194 19.738 19.1596 19.4975C19.7999 19.257 20.3678 18.8565 20.8093 18.3341C21.2507 17.8117 21.551 17.185 21.6814 16.5136C21.8119 15.8422 21.7681 15.1486 21.5543 14.499C21.3405 13.8493 20.9639 13.2653 20.4603 12.8025C19.9566 12.3398 19.3429 12.0138 18.6775 11.8557C18.0121 11.6975 17.3173 11.7125 16.6593 11.8992C16.0014 12.0859 15.4022 12.438 14.919 12.922C14.4756 13.3649 14.1426 13.9058 13.9469 14.5011C13.7511 15.0964 13.6981 15.7294 13.792 16.349L11.47 18.67C11.4002 18.7397 11.3449 18.8225 11.3071 18.9136C11.2694 19.0047 11.25 19.1024 11.25 19.201V21.5C11.25 21.914 11.586 22.25 12 22.25H14.299C14.3976 22.25 14.4953 22.2306 14.5864 22.1929C14.6775 22.1551 14.7603 22.0998 14.83 22.03L17.152 19.708ZM17.1 18.168C16.9731 18.1342 16.8395 18.1343 16.7126 18.1683C16.5857 18.2024 16.47 18.2692 16.377 18.362L13.989 20.75H12.75V19.511L15.138 17.123C15.2308 17.03 15.2976 16.9143 15.3317 16.7874C15.3657 16.6605 15.3658 16.5269 15.332 16.4C15.1908 15.8683 15.2286 15.3048 15.4397 14.7967C15.6507 14.2887 16.0232 13.8642 16.4996 13.589C16.976 13.3138 17.5298 13.2032 18.0754 13.2742C18.621 13.3453 19.1279 13.594 19.518 13.982C19.906 14.3721 20.1547 14.879 20.2258 15.4246C20.2968 15.9702 20.1862 16.524 19.911 17.0004C19.6358 17.4768 19.2113 17.8493 18.7033 18.0603C18.1952 18.2714 17.6317 18.3092 17.1 18.168Z"
                        fill="currentColor"
                    />
                </svg>
            </a>
            <?php endif; ?>

            <!-- Mobile Demo Button -->
            <a
                href="<?php echo e(route('book_demo_page')); ?>"
                class="flex items-center justify-between gap-1 md:gap-2 lg:gap-3 px-2 md:px-3 lg:px-6 py-2 lg:py-3 bg-[#00B34F] border border-[#00B34F] rounded-lg text-white font-alexandria hover:bg-[#00A047] transition-colors"
            >
            <span class="text-base font-medium whitespace-nowrap">
                احجز عرضًا توضيحيًا الآن
                </span>
                <svg
                    width="20"
                    height="21"
                    viewBox="0 0 24 25"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                    class="md:w-5 md:h-5 lg:w-6 lg:h-6"
                >
                    <path
                        d="M8.414 13.843L12.364 17.793C12.5462 17.9816 12.647 18.2342 12.6447 18.4964C12.6424 18.7586 12.5372 19.0094 12.3518 19.1948C12.1664 19.3802 11.9156 19.4854 11.6534 19.4876C11.3911 19.4899 11.1386 19.3891 10.95 19.207L5.293 13.55C5.19982 13.4573 5.12587 13.3471 5.07541 13.2258C5.02494 13.1045 4.99891 12.9744 4.99891 12.843C4.99891 12.7116 5.02494 12.5814 5.07541 12.4601C5.12587 12.3388 5.19982 12.2286 5.293 12.136L10.95 6.479C11.0422 6.38349 11.1526 6.30731 11.2746 6.2549C11.3966 6.20249 11.5278 6.1749 11.6606 6.17375C11.7934 6.1726 11.9251 6.1979 12.048 6.24818C12.1709 6.29846 12.2825 6.37271 12.3764 6.4666C12.4703 6.5605 12.5445 6.67215 12.5948 6.79505C12.6451 6.91794 12.6704 7.04962 12.6693 7.1824C12.6681 7.31518 12.6405 7.4464 12.5881 7.5684C12.5357 7.69041 12.4595 7.80075 12.364 7.893L8.414 11.843H18C18.2652 11.843 18.5196 11.9483 18.7071 12.1359C18.8946 12.3234 19 12.5777 19 12.843C19 13.1082 18.8946 13.3625 18.7071 13.5501C18.5196 13.7376 18.2652 13.843 18 13.843H8.414Z"
                        fill="white"
                    />
                </svg>
            </a>
        </div>
    </div>
</nav>
<?php /**PATH /home/ebacademy/public_html/beta.e3melbusiness.org/resources/views/frontend/include/header.blade.php ENDPATH**/ ?>