<?php $__env->startPush('headScript'); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Hero Section for Search Page -->
    <div class="relative overflow-hidden">
        <!-- Background Image -->
        <div class="absolute left-0 bottom-0 z-0">
            <img src="<?php echo e(asset($category->banner)); ?>" alt="Background" />
        </div>

        <!-- Background Gradient Overlay -->
        <div class="absolute inset-0">
            <svg class="w-full h-full" viewBox="0 0 1600 808" fill="none" xmlns="http://www.w3.org/2000/svg"
                 preserveAspectRatio="xMidYMid slice">
                <path d="M0 0H1600V808H0V0Z" fill="url(#paint0_linear_gradient_overlay)" />
                <defs>
                    <linearGradient id="paint0_linear_gradient_overlay" x1="205.022" y1="0" x2="1573.65" y2="664.405"
                                    gradientUnits="userSpaceOnUse">
                        <stop offset="0%" stop-color="#0C2959" stop-opacity="0.45" />
                        <stop offset="18.28%" stop-color="#0C2959" stop-opacity="0.55" />
                        <stop offset="31.41%" stop-color="#0C2959" stop-opacity="0.62" />
                        <stop offset="49.65%" stop-color="#0C2959" stop-opacity="0.72" />
                        <stop offset="74.35%" stop-color="#0C2959" stop-opacity="0.86" />
                        <stop offset="100%" stop-color="#0C2959" />
                    </linearGradient>
                </defs>
            </svg>
        </div>

        <!-- Background Ellipses -->
        <div class="absolute -top-96 -left-96">
            <img src="<?php echo e(asset('frontend/images')); ?>/hero-background.png" alt="Background Ellipses"
                 class="w-[1179px] h-[1101px] object-contain" />
        </div>

        <!-- Wave at bottom -->
        <div class="absolute bottom-0 left-0 w-full">
            <svg class="w-full h-52" viewBox="0 0 1600 202" fill="none" xmlns="http://www.w3.org/2000/svg"
                 preserveAspectRatio="none">
                <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M0 79.458C0 79.458 226.389 186.741 381.052 178.06C535.714 169.378 628.364 133.594 798.309 151.486C968.253 169.378 1461.17 124.238 1600 0V209.034H0V79.458Z"
                      fill="#FDFDFF" />
            </svg>
        </div>

        <!-- Content Container -->
        <div class="relative z-10 pt-32 pb-32 px-4 md:px-8 lg:px-16 min-h-[700px] flex items-center justify-center">
            <div class="max-w-4xl mx-auto text-center">
                <!-- Breadcrumb Navigation -->
                <div class="flex items-center justify-center gap-2 mb-6">
                    <a href="<?php echo e(route('home_page')); ?>" class="font-tajawal font-medium text-white text-base text-center w-20">
                        الرئيسية
                    </a>
                    <div class="w-6 h-6 flex items-center justify-center">
                        <svg width="8" height="14" viewBox="0 0 8 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M7 13L1 7L7 1" stroke="white" stroke-width="2" stroke-linecap="round"
                                  stroke-linejoin="round" />
                        </svg>
                    </div>
                    <a href="<?php echo e(route('courses_page')); ?>" class="font-tajawal font-medium text-white text-base text-center w-32">
                        الدورات التدريبية
                    </a>
                    <div class="w-6 h-6 flex items-center justify-center">
                        <svg width="8" height="14" viewBox="0 0 8 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M7 13L1 7L7 1" stroke="white" stroke-width="2" stroke-linecap="round"
                                  stroke-linejoin="round" />
                        </svg>
                    </div>
                    <div class="font-tajawal font-medium text-[#00B34F] text-base text-center w-24">
                        <?php echo e($category->name); ?>

                    </div>
                </div>

                <!-- Main Title -->
                <h1 class="font-tajawal font-bold text-white leading-tight tracking-tight mb-4 text-4xl">
                    مجالات
                    <?php echo e($category->name); ?>

                </h1>

                <!-- Subtitle -->
                <p class="font-tajawal font-medium text-[#DEDEDE] text-lg mb-8">
                    يمكنك البحث سريعا عن اي شيء تريده
                </p>
            </div>
        </div>
    </div>

    <!-- Search and Courses Section -->
    <section class="py-16 px-4 md:px-8 lg:px-16 bg-white" dir="rtl">
        <div class="max-w-7xl mx-auto">
            <!-- Enhanced Search Container -->
            <div class="mb-12">
                <form action="<?php echo e(route('category_courses_page',$category->url)); ?>" class="flex flex-col lg:flex-row items-center gap-6">
                    <!-- Search Input Container -->
                    <div class="flex-1 w-full order-1 lg:order-1">
                        <div class="relative">
                            <input type="text" name="search" value="<?php echo e(request('search')); ?>" id="searchInput" placeholder="ابحث عن دورة تدريبية"
                                   class="search-input w-full py-6 px-6 pr-14 pl-12 rounded-2xl border-2 border-[#E8ECF4] bg-white font-alexandria text-base placeholder:text-[#8F99AB] focus:outline-none focus:border-[#144394] transition-colors" />
                            <div class="absolute right-6 top-1/2 transform -translate-y-1/2">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M21.5 21.5L17.014 17.006M19.5 11C19.5 13.2543 18.6045 15.4163 17.0104 17.0104C15.4163 18.6045 13.2543 19.5 11 19.5C8.74566 19.5 6.58365 18.6045 4.98959 17.0104C3.39553 15.4163 2.5 13.2543 2.5 11C2.5 8.74566 3.39553 6.58365 4.98959 4.98959C6.58365 3.39553 8.74566 2.5 11 2.5C13.2543 2.5 15.4163 3.39553 17.0104 4.98959C18.6045 6.58365 19.5 8.74566 19.5 11Z"
                                        stroke="#8F99AB" stroke-width="2" stroke-linecap="round" />
                                </svg>
                            </div>
                            <!-- Clear button -->
                            <button id="clearButton" type="button"
                                    class="absolute left-4 top-1/2 transform -translate-y-1/2 w-6 h-6 bg-[#8F99AB] hover:bg-[#6B7280] text-white rounded-full flex items-center justify-center clear-button-hidden transition-opacity duration-200"
                                    title="مسح البحث">
                                <svg width="14" height="14" viewBox="0 0 24 24" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path d="M18 6L6 18M6 6L18 18" stroke="currentColor" stroke-width="2"
                                          stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </button>
                        </div>
                    </div>

                    <!-- Search Button -->
                    <button id="searchButton"
                            class="flex items-center justify-center gap-2 px-20 py-4 bg-[#E8ECF4] hover:bg-[#0f3a7f] text-[#144394] hover:text-white font-alexandria font-bold text-base rounded-3xl transition-colors shadow-md order-2 lg:order-2">
                        <span>بحث</span>
                    </button>
                </form>
            </div>

            <!-- Results Header -->
            <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-8 text-right">
                <div>
                    <h2 class="font-alexandria text-2xl lg:text-3xl font-bold text-[#2E2E2E] mb-2">
                        <span id="headerTitle">الدورات التدريبية</span>
                        <span id="resultsCountNumber" class="text-brand-success hidden">(<?php echo e($courses->total()); ?>)</span>
                    </h2>
                    <p id="resultsCount" class="font-alexandria text-lg text-[#575757]">
                        اكثر من
                        <?php echo e($coursesCount>10?$coursesCount-10:$coursesCount); ?>

                        + دورة تدريبية متاحة لجميع طلابنا
                    </p>
                </div>
            </div>
            <?php if(!$courses->count()): ?>
            <!-- No Results Message -->
            <div id="noResultsMessage" class=" text-center py-20">
                <div class="flex flex-col items-center justify-center space-y-6">
                    <!-- No Results Icon -->
                    <div class="w-24 h-24 bg-[#F5F5F5] rounded-full flex items-center justify-center">
                        <img src="<?php echo e(asset('frontend/images/no-results.png')); ?>" alt="No Results" />
                    </div>

                    <!-- No Results Text -->
                    <div class="space-y-2">
                        <h3 class="font-alexandria text-2xl font-bold text-[#2E2E2E]">
                            لا يوجد نتائج !
                        </h3>
                        <p class="font-alexandria text-lg text-[#8F99AB] max-w-md">
                            لم نعثر على نتائج لهذا البحث
                        </p>
                    </div>
                </div>
            </div>
            <?php else: ?>

            <!-- Course Cards Grid -->
            <div id="coursesGrid" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
                <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <!-- Course Card <?php echo e($loop->index+1); ?> -->
                    <?php if (isset($component)) { $__componentOriginal0a1b9827ce04f2b2ad6eeae95024b702 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal0a1b9827ce04f2b2ad6eeae95024b702 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.course-card','data' => ['course' => $course]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('course-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['course' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($course)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal0a1b9827ce04f2b2ad6eeae95024b702)): ?>
<?php $attributes = $__attributesOriginal0a1b9827ce04f2b2ad6eeae95024b702; ?>
<?php unset($__attributesOriginal0a1b9827ce04f2b2ad6eeae95024b702); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal0a1b9827ce04f2b2ad6eeae95024b702)): ?>
<?php $component = $__componentOriginal0a1b9827ce04f2b2ad6eeae95024b702; ?>
<?php unset($__componentOriginal0a1b9827ce04f2b2ad6eeae95024b702); ?>
<?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Pagination -->
            <div class="flex items-center justify-center gap-2 mt-8">
                <?php echo $courses->appends(request()->only('search'))->links('vendor.pagination.custom-tailwind'); ?>

            </div>
           <?php endif; ?>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('footerScript'); ?>
    <!-- JavaScript for Mobile Menu Toggle and Search Functionality -->
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const mobileMenuButton = document.getElementById("mobile-menu-button");
            const mobileMenu = document.getElementById("mobile-menu");
            const menuIcon = document.getElementById("menu-icon");
            const closeIcon = document.getElementById("close-icon");
            const searchInput = document.getElementById("searchInput");
            const searchButton = document.getElementById("searchButton");
            const clearButton = document.getElementById("clearButton");
            const coursesGrid = document.getElementById("coursesGrid");
            const noResultsMessage = document.getElementById("noResultsMessage");
            const resultsCount = document.getElementById("resultsCount");
            const resultsCountNumber =
                document.getElementById("resultsCountNumber");
            const headerTitle = document.getElementById("headerTitle");
            const clearSearchButton = document.getElementById("clearSearch");

            // Mobile menu toggle
            mobileMenuButton.addEventListener("click", function () {
                mobileMenu.classList.toggle("open");
                menuIcon.classList.toggle("hidden");
                closeIcon.classList.toggle("hidden");
            });

            // Show/hide clear button based on input content
            function updateClearButton() {
                if (searchInput.value.trim() !== "") {
                    clearButton.classList.remove("clear-button-hidden");
                    clearButton.classList.add("clear-button-visible");
                } else {
                    clearButton.classList.remove("clear-button-visible");
                    clearButton.classList.add("clear-button-hidden");
                }
            }

            // Search functionality
            function performSearch() {
                const searchTerm = searchInput.value.trim().toLowerCase();
                const courseCards = document.querySelectorAll(".course-card");
                let visibleCount = 0;

                courseCards.forEach((card) => {
                    const title = card.getAttribute("data-title").toLowerCase();
                    const category = card.getAttribute("data-category").toLowerCase();
                    const instructor = card
                        .getAttribute("data-instructor")
                        .toLowerCase();
                    const description = card
                        .getAttribute("data-description")
                        .toLowerCase();

                    // Check if search term matches any of the course data
                    const isMatch =
                        title.includes(searchTerm) ||
                        category.includes(searchTerm) ||
                        instructor.includes(searchTerm) ||
                        description.includes(searchTerm);

                    if (searchTerm === "" || isMatch) {
                        card.classList.remove("hidden");
                        visibleCount++;
                    } else {
                        card.classList.add("hidden");
                    }
                });

                // Update results count and show/hide no results message
                if (visibleCount === 0 && searchTerm !== "") {
                    coursesGrid.classList.add("hidden");
                    noResultsMessage.classList.remove("hidden");
                    noResultsMessage.classList.add("no-results-fade-in");
                    headerTitle.textContent = "نتائج البحث";
                    resultsCount.textContent = "لم يتم العثور على نتائج";
                    resultsCountNumber.textContent = "(0)";
                    resultsCountNumber.classList.remove("hidden");
                } else {
                    coursesGrid.classList.remove("hidden");
                    noResultsMessage.classList.add("hidden");
                    noResultsMessage.classList.remove("no-results-fade-in");

                    if (searchTerm === "") {
                        // Default state - no search
                        headerTitle.textContent = "الدورات التدريبية";
                        resultsCount.textContent =
                            "اكثر من 400+ دورة تدريبية متاحة لجميع طلابنا";
                        resultsCountNumber.classList.add("hidden");
                    } else {
                        // Search results state
                        headerTitle.textContent = "نتائج البحث";
                        resultsCount.textContent = `نتائج البحث ل "${searchInput.value}"`;
                        resultsCountNumber.textContent = `(${visibleCount})`;
                        resultsCountNumber.classList.remove("hidden");
                    }
                }

                // Update clear button visibility
                updateClearButton();
            }



            // Clear button functionality
            clearButton.addEventListener("click", function () {
                searchInput.value = "";

                searchInput.focus();
            });

            // Clear search button (in no results message)
            clearSearchButton.addEventListener("click", function () {
                searchInput.value = "";
                searchInput.focus();
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ebacademy/public_html/beta.e3melbusiness.org/resources/views/frontend/category_courses.blade.php ENDPATH**/ ?>