<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
'course'
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
'course'
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>
<a href="<?php echo e(route('course_page',$course->url)); ?>" class="course-card bg-[#FAFAFA] rounded-lg border border-[#EBEBEB] shadow-sm p-4 hover:shadow-md transition-shadow cursor-pointer"
   data-title="<?php echo e($course->name); ?>" data-category="<?php echo e($course->Category?->name); ?>" data-instructor="<?php echo e($course->Instructor?->name); ?>"
   data-description="<?php echo e($course->short_description); ?>"
>
    <div class="relative mb-4">
        <img src="<?php echo e(asset('assets/images/'.$course->image)); ?>" alt="<?php echo e($course->name); ?>"
             class="w-full h-28 object-cover rounded-lg" />
    </div>

    <div class="space-y-3">
                        <span class="bg-[#5F43FB] text-[#FFF8EC] px-2 py-1 rounded-lg text-sm font-alexandria">
                            <?php echo e($course->Category?->name); ?>

                        </span>

        <h3 class="font-alexandria text-lg font-medium text-[#1C1C1C] text-right">
            <?php echo e(\Illuminate\Support\Str::limit($course->name,20)); ?>

        </h3>
        <p class="font-alexandria text-sm text-[#757575] text-right leading-relaxed">
            <?php echo e(\Illuminate\Support\Str::limit($course->short_description)); ?>

        </p>

        <div class="border-t border-[#EBEBEB] pt-3">
            <div class="flex items-center justify-between mb-3">
                <div class="flex items-center gap-2">
                    <img src="<?php echo e(asset('assets/images/'.$course->Instructor?->pic)); ?>"
                         alt="<?php echo e($course->Instructor?->name); ?>" class="w-8 h-8 rounded-full object-cover" />
                    <div>
                        <div class="font-alexandria text-sm font-medium text-[#202020]">
                            <?php echo e($course->Instructor?->name); ?>

                        </div>
                        <div class="font-alexandria text-xs text-[#202020]">
                            <?php echo e($course->Instructor?->title); ?>

                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-[#F5F5F5] rounded-lg p-3 mb-3">
                <div class="flex flex-row-reverse items-center justify-between text-sm">
                    <div class="flex items-center gap-2">
                        <svg class="w-5 h-5 text-[#2E2E2E]" fill="none" stroke="currentColor"
                             viewBox="0 0 24 24">
                            <circle cx="12" cy="12" r="10"></circle>
                            <polyline points="12,6 12,12 16,14"></polyline>
                        </svg>
                        <span class="font-alexandria text-[#2E2E2E]"><?php echo e(ceil($course->hours_numbers)); ?> ساعة</span>
                    </div>
                    <div class="flex items-center gap-2">
                        <svg class="w-5 h-5 text-[#2E2E2E]" fill="none" stroke="currentColor"
                             viewBox="0 0 24 24">
                            <path
                                d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                            </path>
                        </svg>
                        <span class="font-alexandria text-[#2E2E2E]"><?php echo e($course->curriculum_number); ?> محاضرات</span>
                    </div>
                </div>
            </div>

            <div class="flex flex-row-reverse items-center gap-3">
                <button aria-label="Add to Wishlist"
                        class="w-8 h-8 bg-[#FDEAEA] rounded-lg flex items-center justify-center"
                        onclick="event.stopPropagation()">
                    <svg class="w-5 h-5 text-[#EE3030]" fill="none" stroke="currentColor"
                         viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                              d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z">
                        </path>
                    </svg>
                </button>
                <button
                    class="flex-1 bg-[#00B34F] text-white py-2 px-4 rounded-lg font-alexandria font-medium hover:bg-[#00A047] transition-colors flex items-center justify-between gap-2"
                    onclick="event.stopPropagation()">
                    <span>اشترك الآن</span>
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                        <path
                            d="M8.414 13.343L12.364 17.293C12.546 17.482 12.647 17.734 12.645 17.996C12.642 18.259 12.537 18.51 12.352 18.695C12.166 18.88 11.916 18.985 11.653 18.988C11.391 18.99 11.139 18.889 10.95 18.707L5.293 13.05C5.2 12.957 5.126 12.847 5.075 12.726C5.025 12.605 4.999 12.474 4.999 12.343C4.999 12.212 5.025 12.082 5.075 11.96C5.126 11.839 5.2 11.729 5.293 11.636L10.95 5.979C11.042 5.884 11.153 5.807 11.275 5.755C11.397 5.703 11.528 5.675 11.661 5.674C11.793 5.673 11.925 5.698 12.048 5.748C12.171 5.799 12.283 5.873 12.376 5.967C12.47 6.061 12.545 6.172 12.595 6.295C12.645 6.418 12.67 6.55 12.669 6.682C12.668 6.815 12.64 6.946 12.588 7.068C12.536 7.19 12.46 7.301 12.364 7.393L8.414 11.343H18C18.265 11.343 18.52 11.448 18.707 11.636C18.895 11.823 19 12.078 19 12.343C19 12.608 18.895 12.863 18.707 13.05C18.52 13.238 18.265 13.343 18 13.343H8.414Z" />
                    </svg>
                </button>
            </div>
        </div>
    </div>
</a>
<?php /**PATH /home/ebacademy/public_html/beta.e3melbusiness.org/resources/views/components/course-card.blade.php ENDPATH**/ ?>