<?php

use Illuminate\Support\Facades\Route;
use \Illuminate\Support\Facades\DB;
use \Illuminate\Support\Facades\Schema;
Route::get('/check-id-columns', function () {
    $tables = DB::select('SHOW TABLES');
    $dbName = DB::getDatabaseName();
    $key = "Tables_in_" . $dbName;
    foreach ($tables as $table) {
        $tableName = $table->$key;
        if (Schema::hasColumn($tableName, 'id')) {
            echo "🔍 Checking table <b>{$tableName}</b>...<br>";
            // فحص إذا id هو Primary Key
            $primary = DB::select("
                SHOW KEYS FROM `{$tableName}` WHERE Key_name = 'PRIMARY'
            ");

            $isPrimary = false;
            foreach ($primary as $p) {
                if ($p->Column_name === 'id') {
                    $isPrimary = true;
                    break;
                }
            }

            if (!$isPrimary) {
                // لو id مش Primary → نخليه Primary
                DB::statement("ALTER TABLE `{$tableName}` ADD PRIMARY KEY (`id`)");
                echo "✅ id set as PRIMARY KEY in `{$tableName}`.<br>";
            }
            // فحص إذا id عمود Auto Increment
            $column = DB::select("
                SHOW COLUMNS FROM `{$tableName}` WHERE Field = 'id'
            ");

            if (!empty($column)) {
                $extra = $column[0]->Extra; // فيه Auto_increment أو لا
                if (strpos($extra, 'auto_increment') === false) {
                    // تعديل العمود ليكون Auto Increment
                    DB::statement("
                        ALTER TABLE `{$tableName}`
                        MODIFY COLUMN id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT
                    ");
                    echo "✅ id set as AUTO_INCREMENT in {$tableName}.<br>";
                }
            }
        }
    }
});
Route::get('generateCoursesTags',function(){
   foreach (\App\Models\FuturexIntegrationCourse::get() as $fCourse){
       if($fCourse->futurex_tags_ids) {
           foreach ($fCourse->futurex_tags_ids as $fTags_id) {
               $fTag = \App\Models\FuturexTag::find($fTags_id);
               $courseTag = \App\Models\CourseTag::where('name', $fTag->name)->first();
               if ($courseTag) {
                   $array=[
                       'course_id' => $fCourse->course_id,
                       'course_tag_id' => $courseTag->id,
                   ];
                   if(!\App\Models\CoursesTags::where($array)->count()){
                       \App\Models\CoursesTags::create($array);
                   }

               }
           }
       }
   }
});
Route::get('getAllImages/{type}',function($type){
   foreach (\App\Models\Course::where('published','yes')->where('image_downloaded',0)
                ->where('type',$type)
                ->orderBy('id','DESC')
//                ->limit(5)
                ->get() as $course){
       try {
           switch ($course->type){
               case 'e3business':
                   if(!\Illuminate\Support\Facades\File::exists(public_path('assets/images/'.$course->image))){
                       $url='https://e3-business.com/'.str_replace(' ','%20',$course->image);
                       $content=file_get_contents($url);
                       $imageName=basename($course->image);
                       $path=pathinfo($course->image, PATHINFO_DIRNAME);;
                       if(!\Illuminate\Support\Facades\File::exists(public_path('assets/images/'.$path))){
                           \Illuminate\Support\Facades\File::makeDirectory(public_path('assets/images/'.$path), 0777, true, true);
                       }
                       file_put_contents(public_path('assets/images/'.$path.'/'.$imageName),$content);
                   }
                   break;
               case 'e3melbusiness':
                   if(!\Illuminate\Support\Facades\File::exists(public_path('assets/images/'.$course->image))){
                       $url='https://www.e3melbusiness.com/assets/images/'.str_replace(' ','%20',$course->image);
//                       $url='/home/ebacademy/public_html/sa.e3melbusiness.com/assets/images/'.$course->image;
                       $content=file_get_contents($url);
                       $imageName=basename($course->image);
                       $path=pathinfo($course->image, PATHINFO_DIRNAME);;
                       if(!\Illuminate\Support\Facades\File::exists(public_path('assets/images/'.$path))){
                           \Illuminate\Support\Facades\File::makeDirectory(public_path('assets/images/'.$path),0777, true, true);
                       }
                       file_put_contents(public_path('assets/images/'.$path.'/'.$imageName),$content);
                   }
                   break;
               case 'yotta':
                   if(!\Illuminate\Support\Facades\File::exists(public_path('assets/images/'.$course->image))){
                       $url='https://www.e3melbusinessmedical.com/assets/images/'.str_replace(' ','%20',$course->image);
                       $content=file_get_contents($url);
                       $imageName=basename($course->image);
                       $path=pathinfo($course->image, PATHINFO_DIRNAME);;
                       if(!\Illuminate\Support\Facades\File::exists(public_path('assets/images/'.$path))){
                           \Illuminate\Support\Facades\File::makeDirectory(public_path('assets/images/'.$path),0777, true, true);
                       }
                       file_put_contents(public_path('assets/images/'.$path.'/'.$imageName),$content);
                   }
                   break;
               case 'maharaty':
                   if(!\Illuminate\Support\Facades\File::exists(public_path('assets/images/'.$course->image))){
                       $url='https://mahrati.com/assets/images/'.str_replace(' ','%20',$course->image);
                       $content=file_get_contents($url);
                       $imageName=basename($course->image);
                       $path=pathinfo($course->image, PATHINFO_DIRNAME);;
                       if(!\Illuminate\Support\Facades\File::exists(public_path('assets/images/'.$path))){
                           \Illuminate\Support\Facades\File::makeDirectory(public_path('assets/images/'.$path),0777, true, true);
                       }
                       file_put_contents(public_path('assets/images/'.$path.'/'.$imageName),$content);
                   }
                   break;
           }
           $course->update(['image_downloaded'=>1]);
       }catch (ErrorException $e){
            dd($course->image);
       }

   }
});
Route::get('getAllInstructorsImages/{type}',function($type){
   foreach (\App\Models\Instructor::where('published','yes')->where('image_downloaded',0)
                ->where('type',$type)
                ->orderBy('id','DESC')
//                ->limit(5)
                ->get() as $course){
       try {
           switch ($course->type){
               case 'e3business':
                   if(!\Illuminate\Support\Facades\File::exists(public_path('assets/images/'.$course->pic))){
                       $url='https://e3-business.com/'.str_replace(' ','%20',$course->pic);
                       $content=file_get_contents($url);
                       $imageName=basename($course->pic);
                       $path=pathinfo($course->pic, PATHINFO_DIRNAME);;
                       if(!\Illuminate\Support\Facades\File::exists(public_path('assets/images/'.$path))){
                           \Illuminate\Support\Facades\File::makeDirectory(public_path('assets/images/'.$path), 0777, true, true);
                       }
                       file_put_contents(public_path('assets/images/'.$path.'/'.$imageName),$content);
                   }
                   break;
               case 'e3melbusiness':
                   if(!\Illuminate\Support\Facades\File::exists(public_path('assets/images/'.$course->pic))){
//                       $url='https://www.e3melbusiness.com/assets/images/'.str_replace(' ','%20',$course->pic);
                       $url='/home/ebacademy/public_html/sa.e3melbusiness.com/assets/images/'.$course->pic;
                       $content=file_get_contents($url);
                       $imageName=basename($course->pic);
                       $path=pathinfo($course->pic, PATHINFO_DIRNAME);;
                       if(!\Illuminate\Support\Facades\File::exists(public_path('assets/images/'.$path))){
                           \Illuminate\Support\Facades\File::makeDirectory(public_path('assets/images/'.$path),0777, true, true);
                       }
                       file_put_contents(public_path('assets/images/'.$path.'/'.$imageName),$content);
                   }
                   break;
               case 'yotta':
                   if(!\Illuminate\Support\Facades\File::exists(public_path('assets/images/'.$course->pic))){
                       $url='https://www.e3melbusinessmedical.com/assets/images/'.str_replace(' ','%20',$course->pic);
                       $content=file_get_contents($url);
                       $imageName=basename($course->pic);
                       $path=pathinfo($course->pic, PATHINFO_DIRNAME);;
                       if(!\Illuminate\Support\Facades\File::exists(public_path('assets/images/'.$path))){
                           \Illuminate\Support\Facades\File::makeDirectory(public_path('assets/images/'.$path),0777, true, true);
                       }
                       file_put_contents(public_path('assets/images/'.$path.'/'.$imageName),$content);
                   }
                   break;
               case 'maharaty':
                   if(!\Illuminate\Support\Facades\File::exists(public_path('assets/images/'.$course->pic))){
                       $url='https://mahrati.com/assets/images/'.str_replace(' ','%20',$course->pic);
                       $content=file_get_contents($url);
                       $imageName=basename($course->pic);
                       $path=pathinfo($course->pic, PATHINFO_DIRNAME);;
                       if(!\Illuminate\Support\Facades\File::exists(public_path('assets/images/'.$path))){
                           \Illuminate\Support\Facades\File::makeDirectory(public_path('assets/images/'.$path),0777, true, true);
                       }
                       file_put_contents(public_path('assets/images/'.$path.'/'.$imageName),$content);
                   }
                   break;
           }
           $course->update(['image_downloaded'=>1]);
       }catch (ErrorException $e){
            dd($course->pic);
       }

   }
});
Route::group(['middleware'=>\App\Http\Middleware\FrontendMiddleware::class],function(){
    Route::get('/',[\App\Http\Controllers\Frontend\HomePageController::class,'index'])->name('home_page');
//Route::get('register',[\App\Http\Controllers\Frontend\RegisterPageController::class,'index'])->name('register_page');
    Route::post('register',[\App\Http\Controllers\Frontend\RegisterPageController::class,'save'])->name('register_page');
    Route::get('/login',[\App\Http\Controllers\Frontend\LoginPageController::class,'index'])->name('login_page');
    Route::post('/login',[\App\Http\Controllers\Frontend\LoginPageController::class,'login'])->name('login_page');
    Route::post('/logout',[\App\Http\Controllers\Frontend\LogoutPageController::class,'logout'])->name('logout_page');
    Route::get('/book-demo',[\App\Http\Controllers\Frontend\RegisterPageController::class,'bookDemo'])->name('book_demo_page');
    Route::get('/our-prices',[\App\Http\Controllers\Frontend\OurPricesPageController::class,'index'])->name('our_prices_page');
    Route::get('/forget-password',[\App\Http\Controllers\Frontend\ForgetPasswordPageController::class,'index'])->name('forget_password_page');
    Route::post('/forget-password',[\App\Http\Controllers\Frontend\ForgetPasswordPageController::class,'send'])->name('forget_password_page');
    Route::get('/category/courses/{url}',[\App\Http\Controllers\Frontend\CategoriesPageController::class,'categoryCourses'])->name('category_courses_page');
    Route::get('/courses',[\App\Http\Controllers\Frontend\CoursesPageController::class,'index'])->name('courses_page');
    Route::get('/course/{url}',[\App\Http\Controllers\Frontend\CoursesPageController::class,'single'])->name('course_page');
    Route::post('/course/{url}/save_comment',[\App\Http\Controllers\Frontend\CoursesPageController::class,'saveComment'])->name('course_save_comment');
    Route::post('/course/{url}/get_curriculums',[\App\Http\Controllers\Frontend\CoursesPageController::class,'getCurriculums'])->name('course_get_curriculums');
    Route::post('/course/{url}/save_question',[\App\Http\Controllers\Frontend\CoursesPageController::class,'saveQuestion'])->name('course_save_question');
    Route::get('/course/{url}/curriculum_video/{id}',[\App\Http\Controllers\Frontend\CoursesPageController::class,'singleCurriculum'])->name('course_curriculum_video_page');
    Route::get('/course/{url}/exam/{id}',[\App\Http\Controllers\Frontend\CoursesPageController::class,'singleExam'])->name('course_exam_page');
    Route::get('/course/{url}/exam/{id}/result/{resultId}',[\App\Http\Controllers\Frontend\CoursesPageController::class,'singleExamResult'])->name('course_exam_result_page');
    Route::post('/course/{url}/exam/{id}/end',[\App\Http\Controllers\Frontend\CoursesPageController::class,'endExam'])->name('course_exam_end_page');

    Route::get('/course/{url}/training/{id}',[\App\Http\Controllers\Frontend\CoursesPageController::class,'singleTraining'])->name('course_training_page');
    Route::get('/course/{url}/training/{id}/result/{resultId}',[\App\Http\Controllers\Frontend\CoursesPageController::class,'singleTrainingResult'])->name('course_training_result_page');
    Route::post('/course/{url}/training/{id}/end',[\App\Http\Controllers\Frontend\CoursesPageController::class,'endTraining'])->name('course_training_end_page');
    Route::post('/save_progress',[\App\Http\Controllers\Frontend\CoursesPageController::class,'saveProgress'])->name('save_course_progress');


    Route::get('/search',[\App\Http\Controllers\Frontend\CoursesPageController::class,'search'])->name('search_page');
    Route::get('/terms-and-conditions',[\App\Http\Controllers\Frontend\TermsPageController::class,'index'])->name('terms_page');
    Route::get('/futcherx-login',[\App\Http\Controllers\Frontend\FutcherxPageController::class,'login'])->name('futcherx_login_page');
    Route::get('/faq',[\App\Http\Controllers\Frontend\FaqPageController::class,'index'])->name('faq_page');
    Route::get('/instructors',[\App\Http\Controllers\Frontend\InstructorsPageController::class,'index'])->name('instructors_page');
    Route::get('/about-us',[\App\Http\Controllers\Frontend\AboutUsPageController::class,'index'])->name('about_us_page');
    Route::get('/search-certificates',[\App\Http\Controllers\Frontend\SearchCertificatesPageController::class,'index'])->name('search_certificates_page');
    Route::get('/instructor/{url}',[\App\Http\Controllers\Frontend\InstructorsPageController::class,'single'])->name('instructor_page');







    Route::get('/course/{url}/curriculum_audio/{id}',[\App\Http\Controllers\Frontend\CoursesPageController::class,'singleCurriculum'])->name('course_curriculum_audio_page');


    Route::get('/contact-us',[\App\Http\Controllers\Frontend\HomePageController::class,'index'])->name('contact_us_page');
    Route::get('/our-solution',[\App\Http\Controllers\Frontend\HomePageController::class,'index'])->name('our_solution_page');
    Route::get('/privacy',[\App\Http\Controllers\Frontend\HomePageController::class,'index'])->name('privacy_page');




});
