@if ($paginator->hasPages())
    <button
        class="bg-[#E8ECF4] text-[#144394] px-4 py-2 rounded-lg font-alexandria text-sm font-medium hover:bg-[#B6C5DE] transition-colors">
        السابق
    </button>
    <div class="flex items-center gap-1">
        @foreach ($elements as $element)
            {{-- "Three Dots" Separator --}}
            @if (is_string($element))
                <a href="javascript:void(0)" class="w-10 h-10 flex items-center justify-center bg-[#B6C5DE] text-[#144394] text-sm rounded-lg font-medium">
                    {{ $element }}
                </a>
            @endif

            {{-- Array Of Links --}}
            @if (is_array($element))
                @foreach ($element as $page => $url)
                    @if ($page == $paginator->currentPage())
                        <a href="javascript:void(0)" class="w-10 h-10 flex items-center justify-center bg-[#B6C5DE] text-[#144394] text-sm rounded-lg font-medium">
                            {{ $page }}
                        </a>
                    @else
                        <a href="{{ $url }}" class="w-10 h-10 flex items-center justify-center text-[#666] text-sm hover:bg-gray-100 rounded-lg transition-colors" aria-label="{{ __('Go to page :page', ['page' => $page]) }}">
                            {{ $page }}
                        </a>
                    @endif
                @endforeach
            @endif
        @endforeach
    </div>
    @if ($paginator->hasMorePages())
        <a href="{{ $paginator->nextPageUrl() }}" rel="next" class="bg-[#E8ECF4] text-[#144394] px-4 py-2 rounded-lg font-alexandria text-sm font-medium hover:bg-[#B6C5DE] transition-colors" aria-label="{{ __('pagination.next') }}">
            التالي
        </a>
    @else
        <a href="javascript:void(0)" aria-disabled="true" aria-label="{{ __('pagination.next') }}">
                            التالي
                        </a>
    @endif
@endif
