@extends('frontend.layouts.app_empty')
@push('headScript')
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        alexandria: ["Alexandria", "sans-serif"],
                        tajawal: ["Tajawal", "sans-serif"],
                    },
                    colors: {
                        "brand-primary-light": "#E8ECF4",
                        "brand-secondary-normal": "#00B34F",
                        "brand-primary-normal": "#144394",
                        "brand-primary-bg": "#F2F4F9",
                        title: "#102844",
                        "neutral-n20": "#F5F5F5",
                        "neutral-n10": "#FAFAFA",
                        "neutral-n100": "#757575",
                        "gray-shade": "#F8F8FB",
                        "orange": "#e2a73c",
                        "error-light": "#fdeaea",
                        "error-red": "#f15353",
                        "success-light": "#e6f7ed",
                        "success-border": "#d9f4e5",
                    },
                },
            },
        };
    </script>

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            /* border: 1px solid red !important; */
        }

        body {
            font-family: "Tajawal", -apple-system, Roboto, Helvetica, sans-serif;
            direction: rtl;
        }

        /* Mobile Menu Styles */
        .mobile-menu {
            animation-duration: 0.3s;
            animation-timing-function: ease-out;
        }

        .mobile-menu.show {
            animation-name: slideDown;
        }

        .mobile-menu.hide {
            animation-name: slideUp;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes slideUp {
            from {
                opacity: 1;
                transform: translateY(0);
            }

            to {
                opacity: 0;
                transform: translateY(-10px);
            }
        }

        .mobile-menu-backdrop.show {
            animation: fadeIn 0.3s ease-out;
        }

        .mobile-menu-backdrop.hide {
            animation: fadeOut 0.3s ease-out;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        @keyframes fadeOut {
            from {
                opacity: 1;
            }

            to {
                opacity: 0;
            }
        }

        /* Hover effects for navigation links */
        .nav-link:hover {
            transform: translateY(-1px);
            transition: all 0.2s ease;
        }

        .mobile-nav-link:hover {
            background-color: rgba(255, 255, 255, 0.1);
            border-radius: 8px;
        }

        .mobile-cta-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        }

        /* Responsive Design using Tailwind breakpoints */
        @media (max-width: 1200px) {
            .main-layout {
                flex-direction: column;
            }
        }

        @media (max-width: 768px) {
            .nav-bar {
                flex-direction: column;
                gap: 16px;
            }
        }

        /* Tablet specific adjustments */
        @media (min-width: 768px) and (max-width: 1024px) {
            .nav-link {
                font-size: 0.875rem;
                padding: 0.5rem 0.75rem;
            }
        }

        /* Small mobile adjustments */
        @media (max-width: 480px) {
            .mobile-nav-link {
                font-size: 1rem;
                padding: 0.75rem 1rem;
            }

            .mobile-cta-btn {
                font-size: 0.875rem;
                padding: 0.75rem 1rem;
            }
        }

        /* Quiz Specific Styles */
        .question-card {
            transition: all 0.3s ease;
        }

        .question-card:hover {
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .option-button {
            transition: all 0.2s ease;
        }

        .option-button:hover {
            background-color: #f0f4ff;
            border-color: #144394;
        }

        .option-button.selected {
            background-color: #144394;
            color: white;
            border-color: #144394;
        }

        .option-button.correct {
            background-color: #00B34F;
            color: white;
            border-color: #00B34F;
        }

        .option-button.incorrect {
            background-color: #dc2626;
            color: white;
            border-color: #dc2626;
        }

        .progress-bar {
            transition: width 0.5s ease;
        }

        .timer {
            font-variant-numeric: tabular-nums;
        }

        /* Loading Spinner Styles */
        .quiz-loader {
            animation: spin 2s linear infinite;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        .loader-overlay {
            -webkit-backdrop-filter: blur(4px);
            backdrop-filter: blur(4px);
        }

        /* Fade in animation for loader */
        .fade-in {
            animation: fadeInLoader 0.3s ease-out;
        }

        @keyframes fadeInLoader {
            from {
                opacity: 0;
                transform: scale(0.95);
            }

            to {
                opacity: 1;
                transform: scale(1);
            }
        }
    </style>
@endpush
@section('content')
    <div class="max-w-[1536px] mx-auto px-4">
        <!-- Navigation Bar -->
        <nav class="relative w-full rounded-lg bg-brand-primary-light mb-8">
            <!-- Desktop Navigation -->
            <div class="flex flex-row-reverse w-full p-2.5 justify-between items-center lg:flex md:flex max-md:hidden">
                <!-- Action Buttons -->
                <div class="flex flex-row-reverse items-center gap-4">
                    <a href="login.html"
                       class="flex p-3 justify-between items-center rounded-lg border-2 border-brand-secondary-normal bg-transparent text-brand-secondary-normal no-underline w-48 h-12 font-tajawal text-base font-medium">
                        <span class="flex-1 text-center px-4">تسجيل الدخول</span>
                        <img src="{{ asset('frontend/images') }}/course-curriculum/login-icon.svg" alt="Icon" class="" />
                    </a>

                    <div class="flex items-center gap-4 rounded-3xl">
                        <a href="book-demo.html"
                           class="flex p-3 justify-center items-center gap-4 rounded-lg border border-brand-secondary-normal bg-brand-secondary-normal text-white no-underline font-tajawal text-base font-medium h-12">
                            <span>احجز عرضًا توضيحيًا الآن</span>
                            <svg width="24" height="25" viewBox="0 0 24 25" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M8.41302 13.8431L12.363 17.7931C12.5452 17.9817 12.646 18.2343 12.6437 18.4965C12.6414 18.7587 12.5363 19.0095 12.3508 19.1949C12.1654 19.3803 11.9146 19.4855 11.6524 19.4878C11.3902 19.49 11.1376 19.3892 10.949 19.2071L5.29202 13.5501C5.19884 13.4574 5.12489 13.3473 5.07443 13.2259C5.02397 13.1046 4.99799 12.9745 4.99799 12.8431C4.99799 12.7117 5.02397 12.5816 5.07443 12.4602C5.12489 12.2387 5.19884 12.2287 5.29202 12.1361L10.949 6.47908C11.0413 6.38357 11.1516 6.30739 11.2736 6.25498C11.3956 6.20257 11.5268 6.17498 11.6596 6.17383C11.7924 6.17268 11.9241 6.19798 12.047 6.24826C12.1699 6.29854 12.2815 6.37279 12.3754 6.46669C12.4693 6.56058 12.5436 6.67223 12.5938 6.79513C12.6441 6.91802 12.6694 7.0497 12.6683 7.18248C12.6671 7.31526 12.6395 7.44648 12.5871 7.56849C12.5347 7.69049 12.4585 7.80083 12.363 7.89308L8.41302 11.8431H17.999C18.2642 11.8431 18.5186 11.9484 18.7061 12.136C18.8937 12.3235 18.999 12.5779 18.999 12.8431C18.999 13.1083 18.8937 13.3627 18.7061 13.5502C18.5186 13.7377 18.2642 13.8431 17.999 13.8431H8.41302Z"
                                    fill="white" />
                            </svg>
                        </a>
                    </div>
                </div>

                <!-- Logo and Navigation Links -->
                <div class="flex flex-row-reverse">
                    <div class="flex flex-row-reverse justify-end items-center gap-6">
                        <a href="#"
                           class="nav-link text-brand-secondary-normal font-tajawal text-base font-medium leading-6 no-underline py-2.5 px-2 whitespace-nowrap hover:text-brand-primary-normal transition-colors">تواصل
                            معنا</a>
                        <a href="#"
                           class="nav-link text-brand-secondary-normal font-tajawal text-base font-medium leading-6 no-underline py-2.5 px-2 whitespace-nowrap hover:text-brand-primary-normal transition-colors">حلولنا
                            لك</a>
                        <a href="our-prices.html"
                           class="nav-link text-brand-secondary-normal font-tajawal text-base font-medium leading-6 no-underline py-2.5 px-2 whitespace-nowrap hover:text-brand-primary-normal transition-colors">اسعارنا</a>
                        <a href="courses.html"
                           class="nav-link text-brand-secondary-normal font-tajawal text-base font-medium leading-6 no-underline py-2.5 px-2 whitespace-nowrap border-b-2 border-brand-secondary-normal shadow-[0_4px_4px_0_rgba(255,255,255,0.50)]">الدورات
                            التدريبية</a>
                        <a href="index.html"
                           class="nav-link text-brand-secondary-normal font-tajawal text-base font-medium leading-6 no-underline py-2.5 px-2 whitespace-nowrap hover:text-brand-primary-normal transition-colors">الرئيسية</a>
                    </div>

                    <div class="flex flex-col items-center gap-1 w-[119.657px] text-center ml-6">
                        <img class="w-20 h-20 object-contain" src="{{ asset('frontend/images') }}/course-curriculum/logo.png"
                             alt="اعمل بيزنس" />
                    </div>
                </div>
            </div>

            <!-- Mobile Navigation -->
            <div class="md:hidden">
                <!-- Mobile Header -->
                <div class="flex justify-between items-center p-4">
                    <!-- Logo -->
                    <div class="flex items-center">
                        <img class="w-16 h-16 object-contain" src="{{ asset('frontend/images') }}/course-curriculum/logo.png"
                             alt="اعمل بيزنس" />
                    </div>

                    <!-- Mobile Menu Button -->
                    <button id="mobile-menu-toggle"
                            class="mobile-menu-btn p-2 rounded-lg hover:bg-brand-primary-light focus:outline-none"
                            aria-label="Toggle mobile menu">
                        <svg id="menu-icon" class="w-6 h-6 text-brand-primary-normal" fill="none" stroke="currentColor"
                             viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                  d="M4 6h16M4 12h16M4 18h16"></path>
                        </svg>
                        <svg id="close-icon" class="w-6 h-6 text-brand-primary-normal hidden" fill="none"
                             stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                  d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>

                <!-- Mobile Menu Overlay -->
                <div id="mobile-menu"
                     class="mobile-menu hidden absolute top-full left-0 right-0 bg-brand-primary-light border-t border-gray-200 shadow-lg z-50 rounded-b-lg">
                    <div class="p-4 space-y-4">
                        <!-- Navigation Links -->
                        <div class="space-y-2">
                            <a href="index.html"
                               class="mobile-nav-link block text-brand-secondary-normal font-tajawal text-lg font-medium py-3 px-4 rounded-lg hover:bg-white hover:text-brand-primary-normal transition-all duration-300 text-right">الرئيسية</a>
                            <a href="courses.html"
                               class="mobile-nav-link block text-brand-secondary-normal font-tajawal text-lg font-medium py-3 px-4 rounded-lg hover:bg-white hover:text-brand-primary-normal transition-all duration-300 text-right border-r-4 border-brand-secondary-normal">الدورات
                                التدريبية</a>
                            <a href="our-prices.html"
                               class="mobile-nav-link block text-brand-secondary-normal font-tajawal text-lg font-medium py-3 px-4 rounded-lg hover:bg-white hover:text-brand-primary-normal transition-all duration-300 text-right">اسعارنا</a>
                            <a href="#"
                               class="mobile-nav-link block text-brand-secondary-normal font-tajawal text-lg font-medium py-3 px-4 rounded-lg hover:bg-white hover:text-brand-primary-normal transition-all duration-300 text-right">حلولنا
                                لك</a>
                            <a href="#"
                               class="mobile-nav-link block text-brand-secondary-normal font-tajawal text-lg font-medium py-3 px-4 rounded-lg hover:bg-white hover:text-brand-primary-normal transition-all duration-300 text-right">تواصل
                                معنا</a>
                        </div>

                        <!-- Mobile Action Buttons -->
                        <div class="border-t border-gray-200 pt-4 space-y-3">
                            <a href="book-demo.html"
                               class="mobile-cta-btn block w-full text-center bg-brand-secondary-normal text-white py-3 px-4 rounded-lg font-tajawal text-base font-medium hover:bg-brand-secondary-normal/90 transition-colors">
                                احجز عرضًا توضيحيًا الآن
                            </a>
                            <a href="login.html"
                               class="mobile-cta-btn block w-full text-center border-2 border-brand-secondary-normal bg-transparent text-brand-secondary-normal py-3 px-4 rounded-lg font-tajawal text-base font-medium hover:bg-brand-secondary-normal hover:text-white transition-colors">
                                تسجيل الدخول
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Mobile Menu Backdrop -->
            <div id="mobile-menu-backdrop"
                 class="mobile-menu-backdrop hidden fixed inset-0 bg-black bg-opacity-50 z-40 md:hidden"></div>
        </nav>

        <!-- Breadcrumb -->
        <nav class="mb-6 text-right flex justify-start breadcrumb">
            <div class="flex gap-[9px] items-center justify-center">

                <div class="font-tajawal text-base font-medium leading-6 text-[#757575] text-center">
                    الرئيسية
                </div>
                <div class="w-6 h-6 flex items-center justify-center">
                    <svg width="8" height="14" viewBox="0 0 8 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M7 13L1 7L7 1" stroke="#858585" stroke-width="2" stroke-linecap="round"
                              stroke-linejoin="round" />
                    </svg>
                </div>



                <div class="font-tajawal text-base font-medium leading-6 text-[#00B34F] text-right">
                    اختبار علي المحاضرة الاولي
                </div>
            </div>
        </nav>

        <!-- Page Title -->
        <div class="mb-8 text-right flex justify-start page-title">
            <h1 class="text-title font-tajawal text-2xl font-medium leading-8 max-md:text-xl max-md:leading-7">
                اختبار علي المحاضرة الاولي
            </h1>
        </div>

        <!-- Timer Section -->
        <div id="timer-section"
             class="bg-[#fff8ec] rounded-lg p-4 mb-8 border border-[#ebebeb] shadow-[0px_1px_4px_0px_rgba(12,12,13,0.05)]">
            <div class="flex flex-col gap-2.5 items-center justify-center">
                <div class="flex gap-[9px] items-center justify-center">
                    <div class="font-tajawal text-lg font-medium leading-7 text-[#e2a73c] text-right">
                        الوقت المحدد للإختبار
                    </div>
                    <div class="w-6 h-6 flex items-center justify-center">
                        <svg width="23" height="23" viewBox="0 0 23 23" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M6.99436 19.2778L5.496 21.9813" stroke="#FBB943" stroke-linecap="round"
                                  stroke-linejoin="round" />
                            <path d="M15.9863 19.2778L17.4847 21.9814" stroke="#FBB943" stroke-linecap="round"
                                  stroke-linejoin="round" />
                            <path
                                d="M11.4901 20.4827C16.4562 20.4827 20.4821 16.4569 20.4821 11.4907C20.4821 6.52453 16.4562 2.49866 11.4901 2.49866C6.52392 2.49866 2.49805 6.52453 2.49805 11.4907C2.49805 16.4569 6.52392 20.4827 11.4901 20.4827Z"
                                stroke="#FBB943" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M11.4902 6.99463V11.4906" stroke="#FBB943" stroke-linecap="round"
                                  stroke-linejoin="round" />
                            <path d="M11.4902 11.4906L14.6694 14.6698" stroke="#FBB943" stroke-linecap="round"
                                  stroke-linejoin="round" />
                        </svg>
                    </div>
                </div>
                <div id="timer" class="font-tajawal text-xl font-bold leading-[30px] text-[#e2a73c] text-right timer">
                    0:02:47 / 5:00:00
                </div>
            </div>
        </div>

        <!-- Quiz Content Container -->
        <div id="quiz-content">
            <!-- Main Layout -->
            <div class="bg-[#f2f4f9] rounded-lg p-4 md:p-[30px] mb-8">
                @foreach($questions->groupBy('type') as $type=>$items)
                   @if($type=='true_false')
                       <!-- Quiz Instructions -->
                           <div class="flex flex-col gap-2.5 items-start justify-start mb-6">
                               <div class="flex flex-wrap gap-1 items-center justify-start text-center md:text-right">
                                   <div
                                       class="font-tajawal text-base md:text-lg font-medium leading-6 md:leading-7 text-[#1c1c1c] text-right">
                                       ضع علامة صح (
                                   </div>
                                   <div class="w-5 h-5 md:w-6 md:h-6">
                                       <img src="{{ asset('frontend/images') }}/true-icon.svg" alt="True" class="w-full h-full" />
                                   </div>
                                   <div
                                       class="font-tajawal text-base md:text-lg font-medium leading-6 md:leading-7 text-black text-right">
                                       )</div>
                                   <div
                                       class="font-tajawal text-base md:text-lg font-medium leading-6 md:leading-7 text-[#1c1c1c] text-right">
                                       امام الإجابة الصحيحة
                                   </div>
                                   <div
                                       class="font-tajawal text-base md:text-lg font-medium leading-6 md:leading-7 text-[#1c1c1c] text-right">
                                       و علامة (
                                   </div>
                                   <div class="w-5 h-5 md:w-6 md:h-6">
                                       <img src="{{ asset('frontend/images') }}/false-icon.svg" alt="False" class="w-full h-full" />
                                   </div>
                                   <div
                                       class="font-tajawal text-base md:text-lg font-medium leading-6 md:leading-7 text-black text-right">
                                       )</div>
                                   <div
                                       class="font-tajawal text-base md:text-lg font-medium leading-6 md:leading-7 text-[#1c1c1c] text-right">
                                       امام الإجابة الخطأ
                                   </div>
                               </div>
                           </div>
                           <!-- True/False Questions -->
                           <div class="space-y-4 md:space-y-6">
                               @foreach($items as $question)
                               <!-- Question {{ $loop->index+1}} -->
                               <div class="bg-[#f8f8fb] rounded-xl md:rounded-2xl p-6 md:p-10">
                                   <div class="flex flex-col gap-2.5 items-start justify-start">
                                       <div class="flex gap-4 md:gap-[30px] items-center justify-start w-full">
                                           <div class="flex flex-col gap-2 md:gap-[13px] items-start justify-start">
                                               <div
                                                   class="font-tajawal text-base md:text-lg font-medium leading-6 md:leading-7 text-[#102844] text-right w-full md:w-[668px]">
                                                  {{ $question->name }}
                                               </div>
                                           </div>
                                       </div>
                                       <div class="flex flex-row-reverse gap-3 md:gap-[17px] items-center justify-start">
                                           <div
                                               class="bg-[#fdeaea] border border-[#f8aaaa] rounded-[32px] w-8 h-8 md:w-[38px] md:h-[38px] flex items-center justify-center">
                                               <img src="{{ asset('frontend/images') }}/false-icon.svg" alt="False" class="w-5 h-5 md:w-6 md:h-6" />
                                           </div>
                                           <div
                                               class="bg-[#e6f7ed] border border-[#d9f4e5] rounded-[32px] w-8 h-8 md:w-[38px] md:h-[38px] flex items-center justify-center">
                                               <img src="{{ asset('frontend/images') }}/true-icon.svg" alt="True" class="w-5 h-5 md:w-6 md:h-6" />
                                           </div>
                                       </div>
                                   </div>
                               </div>
                               @endforeach
                           </div>
                   @else
                       <!-- Multiple Choice Questions Section -->
                           <div class="bg-[#f2f4f9] rounded-lg p-4 md:p-[30px] mb-8">
                               <!-- Section Title -->
                               <div class="flex flex-col gap-2.5 items-start justify-start mb-6">
                                   <div class="flex gap-1 items-start justify-start">
                                       <div
                                           class="font-tajawal text-base md:text-lg font-medium leading-6 md:leading-7 text-[#1c1c1c] text-right">
                                           اختر الإجابة الصحية:
                                       </div>
                                   </div>
                               </div>

                               <!-- Multiple Choice Questions -->
                               <div class="space-y-4 md:space-y-6">
                                   @foreach($items as $question)
                                   <!-- MCQ {{ $loop->index+1 }} -->
                                       <div class="bg-[#f8f8fb] rounded-xl md:rounded-2xl p-6 md:p-10 min-h-[120px] md:min-h-[180px]">
                                           <div class="flex flex-col gap-2.5 items-end justify-start">
                                               <div class="flex gap-4 md:gap-[30px] items-center justify-start w-full">
                                                   <div class="flex flex-col gap-2 md:gap-[13px] items-start justify-start">
                                                       <div
                                                           class="font-tajawal text-base md:text-lg font-medium leading-6 md:leading-7 text-[#102844] text-right w-full max-w-[668px]">
                                                           {{ $question->name }}
                                                       </div>
                                                   </div>
                                               </div>
                                               <div class="space-y-2 w-full">
                                                   <div class="mcq-option cursor-pointer flex flex-row-reverse gap-2 md:gap-[7px] items-center justify-end hover:bg-gray-50 p-2 rounded transition-colors"
                                                        data-question="4" data-answer="MIN">
                                                       <div class="font-tajawal text-sm md:text-lg font-medium text-black text-right">MIN</div>
                                                       <div class="mcq-checkbox w-4 h-4 bg-white border border-[#d0d5dd] rounded-[4px]"></div>
                                                   </div>
                                                   <div class="mcq-option cursor-pointer flex flex-row-reverse gap-2 md:gap-[7px] items-center justify-end hover:bg-gray-50 p-2 rounded transition-colors"
                                                        data-question="4" data-answer="MAX">
                                                       <div class="font-tajawal text-sm md:text-lg font-medium text-black text-right">MAX</div>
                                                       <div class="mcq-checkbox w-4 h-4 bg-white border border-[#d0d5dd] rounded-[4px]"></div>
                                                   </div>
                                                   <div class="mcq-option cursor-pointer flex flex-row-reverse gap-2 md:gap-[7px] items-center justify-end hover:bg-gray-50 p-2 rounded transition-colors"
                                                        data-question="4" data-answer="AVERAGE">
                                                       <div class="font-tajawal text-sm md:text-lg font-medium text-black text-right">AVERAGE</div>
                                                       <div class="mcq-checkbox w-4 h-4 bg-white border border-[#d0d5dd] rounded-[4px]"></div>
                                                   </div>
                                               </div>
                                           </div>
                                       </div>

                                       @endforeach
                               </div>
                           </div>
                   @endif
                @endforeach



            </div>



            <!-- Action Buttons -->
            <div class="flex flex-col gap-2.5 items-center justify-center mb-8">
                <button id="submit-quiz-btn"
                        class="bg-[#144394] text-white px-[30px] py-4 rounded-lg font-tajawal text-sm font-medium leading-5 hover:bg-[#0f3680] transition-colors">
                    إرسال الإجابة
                </button>
                <button
                    class="bg-[#fdeaea] text-[#f15353] px-[30px] py-4 rounded-lg font-tajawal text-sm font-medium leading-5 hover:bg-[#fccccc] transition-colors">
                    إلغاء الإختبار
                </button>
            </div>
        </div>

        <!-- Loading Section (Initially Hidden) -->
        <div id="loading-section" class="hidden">
            <div class=" mb-8 min-h-[600px] flex items-center justify-center">
                <div class="flex flex-col gap-12 items-center justify-center fade-in">
                    <!-- Animated Spinner -->
                    <div class="relative w-[229px] h-[229px]">
                        <div class="absolute inset-0 border-4 border-gray-200 rounded-full"></div>
                        <div
                            class="absolute inset-0 border-4 border-[#144394] border-t-transparent rounded-full quiz-loader">
                        </div>
                    </div>

                    <!-- Loading Text -->
                    <div class="font-tajawal font-medium text-[24px] leading-8 text-[#2e2e2e] text-center">
                        من فضلك انتظر حتي تحصل علي نتيجة إختبارك
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('footerScript')
    <script>
        // Timer functionality (display only)
        // let timeLeft = 167; // 2:47 in seconds
        let timeLeft = {{ ($currentCurriculum->question_time?$currentCurriculum->question_time:1)*$currentCurriculum->questions_numbers*60 }}; // 2:47 in seconds

        let totalTime = {{ ($currentCurriculum->question_time?$currentCurriculum->question_time:1)*$currentCurriculum->questions_numbers*60 }}; // 5:00:00 in seconds

        function updateTimerDisplay() {
            const currentMinutes = Math.floor(timeLeft / 60);
            const currentSeconds = timeLeft % 60;
            const totalHours = Math.floor(totalTime / 3600);
            const totalMinutes = Math.floor((totalTime % 3600) / 60);
            const totalSecs = totalTime % 60;

            const currentTime = `${currentMinutes}:${currentSeconds.toString().padStart(2, '0')}`;
            const totalTimeStr = `${totalHours}:${totalMinutes.toString().padStart(2, '0')}:${totalSecs.toString().padStart(2, '0')}`;

            document.getElementById('timer').textContent = `${currentTime} / ${totalTimeStr}`;
        }

        function startTimer() {
            setInterval(() => {
                if (timeLeft > 0) {
                    timeLeft--;
                    updateTimerDisplay();
                }
            }, 1000);
        }
        // Submit Quiz Handler
        document.getElementById('submit-quiz-btn').addEventListener('click', function () {
            showLoader();

            // Simulate quiz submission (replace with actual submission logic)
            setTimeout(() => {
                // Redirect to test results page after loading completes
                window.location.href = 'test-result.html';
            }, 3000); // 30 seconds simulation
        });

        // Loader functions
        function showLoader() {
            const quizContent = document.getElementById('quiz-content');
            const loadingSection = document.getElementById('loading-section');
            const pageTitle = document.querySelector('.page-title');
            const timer = document.getElementById('timer-section');
            const breadcrumb = document.querySelector('.breadcrumb');


            breadcrumb.scrollIntoView({ behavior: 'smooth', block: 'center' });
            quizContent.classList.add('hidden');
            loadingSection.classList.remove('hidden');
            pageTitle.classList.add('hidden');
            timer.classList.add('hidden');
        }

        // Initialize timer when page loads
        document.addEventListener('DOMContentLoaded', () => {
            updateTimerDisplay();
            startTimer();
        });
    </script>
@endpush
