@extends('frontend.layouts.app')
@push('headScript')
    <!-- Tailwind Configuration -->
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        alexandria: ["Alexandria", "sans-serif"],
                        tajawal: ["Tajawal", "sans-serif"],
                    },
                    colors: {
                        "brand-success": "#00B34F",
                        "brand-secondary-normal": "#00B34F",
                        "brand-secondary-light": "#E6F7ED",
                        "brand-primary-normal": "#144394",
                        "brand-primary-light": "#E8ECF4",
                    },
                },
            },
        };
    </script>

    <style>
        body {
            font-family: "Alexandria", sans-serif;
        }

        /* Mobile Menu Styles */
        .mobile-menu {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.4s ease-in-out, opacity 0.3s ease-in-out;
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
        }

        .mobile-menu.open {
            max-height: 600px;
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        /* Ensure mobile menu is above other elements */
        .mobile-menu .bg-white\/95 {
            background-color: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
        }

        /* Mobile menu animation */
        .mobile-menu .mobile-menu-content {
            transform: translateY(-20px);
            transition: transform 0.3s ease-out;
        }

        .mobile-menu.open .mobile-menu-content {
            transform: translateY(0);
        }

        /* Mobile responsive button adjustments */
        @media (max-width: 768px) {
            .responsive-button-text {
                display: none;
            }

            .responsive-button-icon {
                margin: 0 !important;
            }
        }

        @media (max-width: 640px) {
            .hero-title-mobile {
                font-size: 2.5rem !important;
                line-height: 3rem !important;
            }
        }
    </style>
@endpush
@section('content')

    <!-- Hero Section for Search Certificate Page -->
    <div class="relative overflow-hidden min-h-[700px]">
        <!-- Background Image -->
        <div class="absolute left-0 bottom-0 z-0">
            <img src="{{ asset('frontend/images') }}/hero-terms-and-conditions.png" alt="Background" />
        </div>

        <!-- Background Gradient Overlay -->
        <div class="absolute inset-0">
            <svg
                class="w-full h-full"
                viewBox="0 0 1600 808"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
                preserveAspectRatio="xMidYMid slice"
            >
                <path
                    d="M0 0H1600V808H0V0Z"
                    fill="url(#paint0_linear_gradient_overlay)"
                />
                <defs>
                    <linearGradient
                        id="paint0_linear_gradient_overlay"
                        x1="205.022"
                        y1="0"
                        x2="1573.65"
                        y2="664.405"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop offset="0%" stop-color="#0C2959" stop-opacity="0.45" />
                        <stop offset="18.28%" stop-color="#0C2959" stop-opacity="0.55" />
                        <stop offset="31.41%" stop-color="#0C2959" stop-opacity="0.62" />
                        <stop offset="49.65%" stop-color="#0C2959" stop-opacity="0.72" />
                        <stop offset="74.35%" stop-color="#0C2959" stop-opacity="0.86" />
                        <stop offset="100%" stop-color="#0C2959" />
                    </linearGradient>
                </defs>
            </svg>
        </div>

        <!-- Background Ellipses -->
        <div class="absolute -top-96 -left-96">
            <img
                src="{{ asset('frontend/images') }}/hero-background.png"
                alt="Background Ellipses"
                class="w-[1179px] h-[1101px] object-contain"
            />
        </div>

        <!-- Wave at bottom -->
        <div class="absolute bottom-0 left-0 w-full">
            <svg
                class="w-full h-52"
                viewBox="0 0 1600 202"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
                preserveAspectRatio="none"
            >
                <path
                    fill-rule="evenodd"
                    clip-rule="evenodd"
                    d="M0 79.458C0 79.458 226.389 186.741 381.052 178.06C535.714 169.378 628.364 133.594 798.309 151.486C968.253 169.378 1461.17 124.238 1600 0V209.034H0V79.458Z"
                    fill="#FDFDFF"
                />
            </svg>
        </div>
        <!-- Content Container -->
        <div
            class="relative z-10 pt-32 pb-32 px-4 md:px-8 lg:px-16 min-h-[700px] flex items-center justify-center"
        >
            <div class="max-w-4xl mx-auto text-center">
                <!-- Breadcrumb Navigation -->
                <div class="flex items-center justify-center gap-2 mb-6">
                    <a class="font-tajawal font-medium text-white text-base" href="/">
                        الرئيسية
                    </a>
                    <div class="w-6 h-6 flex items-center justify-center">
                        <svg
                            width="6"
                            height="10"
                            viewBox="0 0 6 10"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                            style="transform: rotate(180deg)"
                        >
                            <path
                                d="M1 1L5 5L1 9"
                                stroke="white"
                                stroke-width="1.5"
                                stroke-linecap="round"
                                stroke-linejoin="round"
                            />
                        </svg>
                    </div>
                    <div class="font-tajawal font-medium text-[#00B34F] text-base">
                        الشروط و الاحكام
                    </div>
                </div>

                <!-- Main Title -->
                <h1
                    class="font-tajawal font-bold text-white leading-tight tracking-tight mb-4 text-4xl hero-title-mobile"
                >
                    الشروط و الاحكام
                </h1>

                <!-- Subtitle -->
                <p class="font-tajawal font-medium text-[#DEDEDE] text-lg mb-8">
                    الشروط و الاحكام لدي الاكاديمية
                </p>
            </div>
        </div>
    </div>

    <!-- Terms and Conditions Content Section -->
    <section class="bg-[#FDFDFF] py-16 px-4 md:px-8 lg:px-16" dir="rtl">
        <div class="max-w-7xl mx-auto">
            <!-- Navigation Pills -->
            <div
                class="content-center flex flex-wrap gap-6 items-center justify-start mb-20"
            >
                <!-- Tab Buttons -->
                <button
                    data-tab="overview"
                    class="tab-button bg-[#144394] content-stretch flex gap-2.5 items-center justify-center p-[16px] relative rounded-[80px] shrink-0"
                >
                    <div
                        class="font-alexandria font-medium leading-[34px] relative shrink-0 text-[#fdfdfd] text-[20px] text-center text-nowrap"
                    >
                        لمحة عن أكاديمية إعمل بيزنس
                    </div>
                </button>

                <button
                    data-tab="content-rights"
                    class="tab-button bg-white box-border content-stretch flex gap-2.5 items-center justify-center p-[16px] relative rounded-[80px] shrink-0 hover:bg-gray-50 transition-colors"
                >
                    <div
                        aria-hidden="true"
                        class="absolute border border-[#e8ecf4] border-solid inset-0 pointer-events-none rounded-[80px]"
                    ></div>
                    <div
                        class="font-alexandria font-medium leading-[34px] relative shrink-0 text-[#03183c] text-[20px] text-center text-nowrap"
                    >
                        حقوق استخدام المحتوى
                    </div>
                </button>

                <button
                    data-tab="online-conduct"
                    class="tab-button bg-white box-border content-stretch flex gap-2.5 items-center justify-center p-[16px] relative rounded-[80px] shrink-0 hover:bg-gray-50 transition-colors"
                >
                    <div
                        aria-hidden="true"
                        class="absolute border border-[#e8ecf4] border-solid inset-0 pointer-events-none rounded-[80px]"
                    ></div>
                    <div
                        class="font-alexandria font-medium leading-[34px] relative shrink-0 text-[#03183c] text-[20px] text-center text-nowrap"
                    >
                        قواعد السلوك عبر الإنترنت
                    </div>
                </button>

                <button
                    data-tab="user-accounts"
                    class="tab-button bg-white box-border content-stretch flex gap-2.5 items-center justify-center p-[16px] relative rounded-[80px] shrink-0 hover:bg-gray-50 transition-colors"
                >
                    <div
                        aria-hidden="true"
                        class="absolute border border-[#e8ecf4] border-solid inset-0 pointer-events-none rounded-[80px]"
                    ></div>
                    <div
                        class="font-alexandria font-medium leading-[34px] relative shrink-0 text-[#03183c] text-[20px] text-center text-nowrap"
                    >
                        حسابات المستخدمين والصلاحيات
                    </div>
                </button>

                <button
                    data-tab="refund-policy"
                    class="tab-button bg-white box-border content-stretch flex gap-2.5 items-center justify-center p-[16px] relative rounded-[80px] shrink-0 hover:bg-gray-50 transition-colors"
                >
                    <div
                        aria-hidden="true"
                        class="absolute border border-[#e8ecf4] border-solid inset-0 pointer-events-none rounded-[80px]"
                    ></div>
                    <div
                        class="font-alexandria font-medium leading-[34px] relative shrink-0 text-[#03183c] text-[20px] text-center text-nowrap"
                    >
                        سياسة استرداد الرسوم و المصاري
                    </div>
                </button>

                <button
                    data-tab="miscellaneous"
                    class="tab-button bg-white box-border content-stretch flex gap-2.5 items-center justify-center p-[16px] relative rounded-[80px] shrink-0 hover:bg-gray-50 transition-colors"
                >
                    <div
                        aria-hidden="true"
                        class="absolute border border-[#e8ecf4] border-solid inset-0 pointer-events-none rounded-[80px]"
                    ></div>
                    <div
                        class="font-alexandria font-medium leading-[34px] relative shrink-0 text-[#03183c] text-[20px] text-center text-nowrap"
                    >
                        متفرقات
                    </div>
                </button>

                <button
                    data-tab="compensations"
                    class="tab-button bg-white box-border content-stretch flex gap-2.5 items-center justify-center p-[16px] relative rounded-[80px] shrink-0 hover:bg-gray-50 transition-colors"
                >
                    <div
                        aria-hidden="true"
                        class="absolute border border-[#e8ecf4] border-solid inset-0 pointer-events-none rounded-[80px]"
                    ></div>
                    <div
                        class="font-alexandria font-medium leading-[34px] relative shrink-0 text-[#03183c] text-[20px] text-center text-nowrap"
                    >
                        التعويضات
                    </div>
                </button>

                <button
                    data-tab="warranty-disclaimer"
                    class="tab-button bg-white box-border content-stretch flex gap-2.5 items-center justify-center p-[16px] relative rounded-[80px] shrink-0 hover:bg-gray-50 transition-colors"
                >
                    <div
                        aria-hidden="true"
                        class="absolute border border-[#e8ecf4] border-solid inset-0 pointer-events-none rounded-[80px]"
                    ></div>
                    <div
                        class="font-alexandria font-medium leading-[34px] relative shrink-0 text-[#03183c] text-[20px] text-center text-nowrap"
                    >
                        التنازل عن الضمان
                    </div>
                </button>

                <button
                    data-tab="trademark"
                    class="tab-button bg-white box-border content-stretch flex gap-2.5 items-center justify-center p-[16px] relative rounded-[80px] shrink-0 hover:bg-gray-50 transition-colors"
                >
                    <div
                        aria-hidden="true"
                        class="absolute border border-[#e8ecf4] border-solid inset-0 pointer-events-none rounded-[80px]"
                    ></div>
                    <div
                        class="font-alexandria font-medium leading-[34px] relative shrink-0 text-[#03183c] text-[20px] text-center text-nowrap"
                    >
                        العلامة التجارية
                    </div>
                </button>

                <button
                    data-tab="prohibited-materials"
                    class="tab-button bg-white box-border content-stretch flex gap-2.5 items-center justify-center p-[16px] relative rounded-[80px] shrink-0 hover:bg-gray-50 transition-colors"
                >
                    <div
                        aria-hidden="true"
                        class="absolute border border-[#e8ecf4] border-solid inset-0 pointer-events-none rounded-[80px]"
                    ></div>
                    <div
                        class="font-alexandria font-medium leading-[34px] relative shrink-0 text-[#03183c] text-[20px] text-center text-nowrap"
                    >
                        قائمة المواد الممنوع تداولها
                    </div>
                </button>
            </div>

            <!-- Content Area -->
            <div class="text-right" id="tab-content">
                <!-- Overview Tab Content -->
                <div data-content="overview" class="tab-content">
                    <h2
                        class="font-alexandria font-bold text-[32px] leading-[63px] text-black mb-8"
                    >
                        مرحباً بكم في أكاديمية إعمل بيزنس
                    </h2>

                    <div
                        class="space-y-6 text-[#475467] text-2xl font-alexandria leading-relaxed"
                    >
                        <p>
                            يرجى أن تتم قراءة شروط الخدمة وسياسة الخصوصية الخاصة بأكاديمية
                            إعمل بيزنس قبل إتمام عملية التسجيل لدينا أو استخدام أي جزء من
                            محتويات الموقع (ونعني بكلمة "الموقع" هنا جميع المحتويات والصفحات
                            التي تقع ضمن نطاق موقع أكاديمية إعمل بيزنس الإلكتروني عبر شبكة
                            الإنترنت).
                        </p>

                        <p>
                            تعتبر كل من هذه شروط الخدمة وسياسة الخصوصية بمثابة اتفاقيات (قد
                            يتم الإشارة إليها فيما بعد، مجتمعةً، باسم "اتفاقيات") بينك وبين
                            أكاديمية إعمل بيزنس.
                        </p>

                        <p>
                            كما أنك تقبل وتوافق من خلال استخدامك للموقع الإلكتروني الخاص
                            بأكاديمية إعمل بيزنس على الالتزام قانوناً بالاتفاقيات، سواء كنت
                            مستخدماً مسجلاً على الموقع أم لا.
                        </p>

                        <p>
                            تحتفظ أكاديمية إعمل بيزنس بحق تعديل هذه الشروط في أي وقت دون أن
                            ترسل لك أي إشعارات مسبقة.
                        </p>

                        <p>
                            تعتبر التغييرات التي تتم على هذه الشروط نافذةً فور نشرها على هذه
                            الصفحة أو ضمن أي قسم آخر من الموقع.
                        </p>

                        <p>
                            يعد دخولك إلى الموقع بعد إجراء أية تغييرات موافقة منك على الشروط
                            المعدّلة وكافة التغييرات الواردة فيه.
                        </p>

                        <p>
                            تأكّد من أن تقوم بالاطلاع على هذه الصفحة بشكل دوري لتبقى مطلعاً
                            على الإصدار الأحدث لهذه الشروط.
                        </p>
                    </div>
                </div>

                <!-- Content Rights Tab Content -->
                <div data-content="content-rights" class="tab-content hidden">
                    <h2
                        class="font-alexandria font-bold text-[32px] leading-[63px] text-black mb-8"
                    >
                        حقوق استخدام المحتوى
                    </h2>

                    <div
                        class="space-y-6 text-[#475467] text-2xl font-alexandria leading-relaxed"
                    >
                        <p>
                            جميع المحتويات المعروضة على موقع أكاديمية إعمل بيزنس محمية بموجب
                            قوانين حقوق الطبع والنشر والملكية الفكرية.
                        </p>

                        <p>
                            لا يحق لك نسخ أو توزيع أو تعديل أو نشر أي محتوى من الموقع دون
                            الحصول على إذن كتابي مسبق من أكاديمية إعمل بيزنس.
                        </p>

                        <p>
                            يُسمح لك باستخدام المحتوى لأغراض التعلم الشخصي فقط وليس لأغراض
                            تجارية.
                        </p>

                        <p>
                            أي انتهاك لحقوق الملكية الفكرية سيعرضك للمساءلة القانونية وفقاً
                            للقوانين المعمول بها.
                        </p>
                    </div>
                </div>

                <!-- Online Conduct Tab Content -->
                <div data-content="online-conduct" class="tab-content hidden">
                    <h2
                        class="font-alexandria font-bold text-[32px] leading-[63px] text-black mb-8"
                    >
                        قواعد السلوك عبر الإنترنت
                    </h2>

                    <div
                        class="space-y-6 text-[#475467] text-2xl font-alexandria leading-relaxed"
                    >
                        <p>
                            يجب على جميع المستخدمين الالتزام بالسلوك المهذب والمحترم عند
                            التفاعل على المنصة.
                        </p>

                        <p>
                            ممنوع منعاً باتاً استخدام لغة مسيئة أو نشر محتوى غير لائق أو
                            مخالف للآداب العامة.
                        </p>

                        <p>
                            لا يُسمح بنشر أي محتوى يحتوي على تمييز عنصري أو ديني أو جنسي أو
                            أي شكل من أشكال التحريض.
                        </p>

                        <p>
                            يحق لإدارة الأكاديمية حظر أي مستخدم يخالف هذه القواعد دون سابق
                            إنذار.
                        </p>
                    </div>
                </div>

                <!-- User Accounts Tab Content -->
                <div data-content="user-accounts" class="tab-content hidden">
                    <h2
                        class="font-alexandria font-bold text-[32px] leading-[63px] text-black mb-8"
                    >
                        حسابات المستخدمين والصلاحيات
                    </h2>

                    <div
                        class="space-y-6 text-[#475467] text-2xl font-alexandria leading-relaxed"
                    >
                        <p>
                            أنت مسؤول عن الحفاظ على سرية بيانات حسابك وكلمة المرور الخاصة
                            بك.
                        </p>

                        <p>
                            لا يحق لك مشاركة بيانات حسابك مع أي شخص آخر أو السماح لأي شخص
                            آخر بالوصول إلى حسابك.
                        </p>

                        <p>
                            يجب عليك إبلاغ إدارة الأكاديمية فوراً في حالة اشتباهك في وصول
                            غير مصرح به إلى حسابك.
                        </p>

                        <p>
                            تحتفظ الأكاديمية بالحق في إلغاء أو تعليق أي حساب في حالة مخالفة
                            الشروط والأحكام.
                        </p>
                    </div>
                </div>

                <!-- Refund Policy Tab Content -->
                <div data-content="refund-policy" class="tab-content hidden">
                    <h2
                        class="font-alexandria font-bold text-[32px] leading-[63px] text-black mb-8"
                    >
                        سياسة استرداد الرسوم والمصاري
                    </h2>

                    <div
                        class="space-y-6 text-[#475467] text-2xl font-alexandria leading-relaxed"
                    >
                        <p>
                            يحق للطالب طلب استرداد الرسوم خلال 14 يوماً من تاريخ التسجيل في
                            الدورة.
                        </p>

                        <p>
                            لا يحق استرداد الرسوم في حالة إتمام أكثر من 25% من محتوى الدورة
                            التدريبية.
                        </p>

                        <p>
                            يتم معالجة طلبات الاسترداد خلال 7-10 أيام عمل من تاريخ الموافقة
                            على الطلب.
                        </p>

                        <p>
                            في حالة الإلغاء من قبل الأكاديمية، سيتم استرداد كامل المبلغ
                            المدفوع دون أي خصومات.
                        </p>
                    </div>
                </div>

                <!-- Miscellaneous Tab Content -->
                <div data-content="miscellaneous" class="tab-content hidden">
                    <h2
                        class="font-alexandria font-bold text-[32px] leading-[63px] text-black mb-8"
                    >
                        متفرقات
                    </h2>

                    <div
                        class="space-y-6 text-[#475467] text-2xl font-alexandria leading-relaxed"
                    >
                        <p>تخضع هذه الشروط والأحكام لقوانين المملكة العربية السعودية.</p>

                        <p>
                            في حالة وجود أي نزاع، يتم حله وفقاً للأنظمة القضائية المعمول بها
                            في المملكة.
                        </p>

                        <p>
                            إذا تبين أن أي بند من هذه الشروط غير قابل للتنفيذ، فإن باقي
                            البنود تبقى سارية المفعول.
                        </p>

                        <p>
                            تحتفظ الأكاديمية بالحق في تعديل هذه الشروط في أي وقت دون إشعار
                            مسبق.
                        </p>
                    </div>
                </div>

                <!-- Compensations Tab Content -->
                <div data-content="compensations" class="tab-content hidden">
                    <h2
                        class="font-alexandria font-bold text-[32px] leading-[63px] text-black mb-8"
                    >
                        التعويضات
                    </h2>

                    <div
                        class="space-y-6 text-[#475467] text-2xl font-alexandria leading-relaxed"
                    >
                        <p>
                            أكاديمية إعمل بيزنس غير مسؤولة عن أي أضرار مباشرة أو غير مباشرة
                            قد تنتج عن استخدام الموقع.
                        </p>

                        <p>
                            لا تتحمل الأكاديمية مسؤولية أي خسائر مالية أو تجارية قد تحدث
                            نتيجة الاعتماد على المحتوى المقدم.
                        </p>

                        <p>
                            الحد الأقصى للمسؤولية المالية للأكاديمية لا يتجاوز قيمة الرسوم
                            المدفوعة للدورة التدريبية المحددة.
                        </p>

                        <p>
                            المستخدم مسؤول عن أي أضرار قد تلحق بالموقع أو بالمستخدمين
                            الآخرين نتيجة سوء استخدامه للمنصة.
                        </p>
                    </div>
                </div>

                <!-- Warranty Disclaimer Tab Content -->
                <div data-content="warranty-disclaimer" class="tab-content hidden">
                    <h2
                        class="font-alexandria font-bold text-[32px] leading-[63px] text-black mb-8"
                    >
                        التنازل عن الضمان
                    </h2>

                    <div
                        class="space-y-6 text-[#475467] text-2xl font-alexandria leading-relaxed"
                    >
                        <p>
                            يتم تقديم الخدمات "كما هي" دون أي ضمانات صريحة أو ضمنية من أي
                            نوع.
                        </p>

                        <p>
                            لا تضمن الأكاديمية دقة أو اكتمال أو حداثة المعلومات المقدمة في
                            الدورات التدريبية.
                        </p>

                        <p>
                            لا تضمن الأكاديمية أن الموقع سيعمل بشكل مستمر أو خالٍ من الأخطاء
                            أو الانقطاعات.
                        </p>

                        <p>
                            المستخدم يتحمل المسؤولية الكاملة عن استخدام الموقع والاعتماد على
                            المحتوى المقدم.
                        </p>
                    </div>
                </div>

                <!-- Trademark Tab Content -->
                <div data-content="trademark" class="tab-content hidden">
                    <h2
                        class="font-alexandria font-bold text-[32px] leading-[63px] text-black mb-8"
                    >
                        العلامة التجارية
                    </h2>

                    <div
                        class="space-y-6 text-[#475467] text-2xl font-alexandria leading-relaxed"
                    >
                        <p>
                            "إعمل بيزنس" علامة تجارية مسجلة ومحمية بموجب قوانين الملكية
                            الفكرية.
                        </p>

                        <p>
                            لا يحق لأي شخص استخدام الاسم أو الشعار أو أي عنصر من عناصر
                            الهوية البصرية دون إذن كتابي.
                        </p>

                        <p>
                            أي استخدام غير مصرح به للعلامة التجارية يعرض المخالف للمساءلة
                            القانونية.
                        </p>

                        <p>
                            تحتفظ الأكاديمية بجميع الحقوق المتعلقة بعلامتها التجارية وهويتها
                            البصرية.
                        </p>
                    </div>
                </div>

                <!-- Prohibited Materials Tab Content -->
                <div data-content="prohibited-materials" class="tab-content hidden">
                    <h2
                        class="font-alexandria font-bold text-[32px] leading-[63px] text-black mb-8"
                    >
                        قائمة المواد الممنوع تداولها
                    </h2>

                    <div
                        class="space-y-6 text-[#475467] text-2xl font-alexandria leading-relaxed"
                    >
                        <p>
                            ممنوع نشر أو مشاركة أي محتوى يحتوي على مواد إباحية أو عنف أو
                            محتوى مخل بالآداب العامة.
                        </p>

                        <p>
                            لا يُسمح بنشر معلومات شخصية أو بيانات حساسة لأشخاص آخرين دون
                            موافقتهم.
                        </p>

                        <p>
                            ممنوع تداول أي محتوى يروج للأنشطة غير القانونية أو المضرة
                            بالمجتمع.
                        </p>

                        <p>
                            لا يُسمح بنشر محتوى يحتوي على فيروسات أو برامج ضارة أو أي كود
                            يهدف إلى إلحاق الضرر بالنظام.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@push('footerScript')
    <script>
        // Tab functionality
        const tabButtons = document.querySelectorAll(".tab-button");
        const tabContents = document.querySelectorAll(".tab-content");

        // Function to switch tabs
        function switchTab(targetTab) {
            // Remove active class from all buttons and reset to inactive state
            tabButtons.forEach((button) => {
                // Reset to inactive state
                button.className =
                    "tab-button bg-white box-border content-stretch flex gap-2.5 items-center justify-center p-[16px] relative rounded-[80px] shrink-0 hover:bg-gray-50 transition-colors";

                // Add the border div if it doesn't exist
                const borderDiv = button.querySelector(".absolute.border");
                if (!borderDiv) {
                    const newBorderDiv = document.createElement("div");
                    newBorderDiv.setAttribute("aria-hidden", "true");
                    newBorderDiv.className =
                        "absolute border border-[#e8ecf4] border-solid inset-0 pointer-events-none rounded-[80px]";
                    button.insertBefore(newBorderDiv, button.firstChild);
                }

                // Reset text color to inactive
                const textDiv = button.querySelector("div:last-child");
                if (textDiv) {
                    textDiv.className =
                        "font-alexandria font-medium leading-[34px] relative shrink-0 text-[#03183c] text-[20px] text-center text-nowrap";
                }
            });

            // Hide all content
            tabContents.forEach((content) => {
                content.classList.add("hidden");
            });

            // Activate clicked button
            const activeButton = document.querySelector(
                `[data-tab="${targetTab}"]`
            );
            if (activeButton) {
                // Set active state
                activeButton.className =
                    "tab-button bg-[#144394] content-stretch flex gap-2.5 items-center justify-center p-[16px] relative rounded-[80px] shrink-0";

                // Remove border div for active state
                const borderDiv = activeButton.querySelector(".absolute.border");
                if (borderDiv) {
                    borderDiv.remove();
                }

                // Set active text color
                const textDiv = activeButton.querySelector("div:last-child");
                if (textDiv) {
                    textDiv.className =
                        "font-alexandria font-medium leading-[34px] relative shrink-0 text-[#fdfdfd] text-[20px] text-center text-nowrap";
                }
            }

            // Show target content
            const targetContent = document.querySelector(
                `[data-content="${targetTab}"]`
            );
            if (targetContent) {
                targetContent.classList.remove("hidden");
            }
        }

        // Add click event listeners to tab buttons
        tabButtons.forEach((button) => {
            button.addEventListener("click", function () {
                const tabName = this.getAttribute("data-tab");
                switchTab(tabName);
            });
        });

        // Initialize first tab as active
        switchTab("overview");
    </script>
@endpush
