@extends('frontend.layouts.app')
@push('headScript')
    <!-- Tailwind Configuration -->
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        alexandria: ["Alexandria", "sans-serif"],
                        tajawal: ["Tajawal", "sans-serif"],
                    },
                    colors: {
                        "brand-success": "#00B34F",
                        "brand-secondary-normal": "#00B34F",
                        "brand-secondary-light": "#E6F7ED",
                        "brand-primary-normal": "#144394",
                        "brand-primary-light": "#E8ECF4",
                    },
                },
            },
        };
    </script>

    <style>
        body {
            font-family: "Alexandria", sans-serif;
        }

        /* Mobile Menu Styles */
        .mobile-menu {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.4s ease-in-out, opacity 0.3s ease-in-out;
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
        }

        .mobile-menu.open {
            max-height: 600px;
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        /* Ensure mobile menu is above other elements */
        .mobile-menu .bg-white\/95 {
            background-color: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
        }

        /* Mobile menu animation */
        .mobile-menu .mobile-menu-content {
            transform: translateY(-20px);
            transition: transform 0.3s ease-out;
        }

        .mobile-menu.open .mobile-menu-content {
            transform: translateY(0);
        }

        /* Search box focus styles */
        .search-input:focus {
            box-shadow: 0 0 0 3px rgba(0, 179, 79, 0.3);
        }

        /* Mobile responsive button adjustments */
        @media (max-width: 768px) {
            .responsive-button-text {
                display: none;
            }

            .responsive-button-icon {
                margin: 0 !important;
            }
        }

        @media (max-width: 640px) {
            .hero-title-mobile {
                font-size: 2.5rem !important;
                line-height: 3rem !important;
            }
        }
    </style>
@endpush
@section('content')
    <!-- Hero Section for Search Certificate Page -->
    <div class="relative overflow-hidden min-h-[700px]">
        <!-- Background Image -->
        <div class="absolute left-0 bottom-0 z-0">
            <img src="{{ asset('frontend/images') }}/hero-search-certificate.png" alt="Background" />
        </div>

        <!-- Background Gradient Overlay -->
        <div class="absolute inset-0">
            <svg
                class="w-full h-full"
                viewBox="0 0 1600 808"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
                preserveAspectRatio="xMidYMid slice"
            >
                <path
                    d="M0 0H1600V808H0V0Z"
                    fill="url(#paint0_linear_gradient_overlay)"
                />
                <defs>
                    <linearGradient
                        id="paint0_linear_gradient_overlay"
                        x1="205.022"
                        y1="0"
                        x2="1573.65"
                        y2="664.405"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop offset="0%" stop-color="#0C2959" stop-opacity="0.45" />
                        <stop offset="18.28%" stop-color="#0C2959" stop-opacity="0.55" />
                        <stop offset="31.41%" stop-color="#0C2959" stop-opacity="0.62" />
                        <stop offset="49.65%" stop-color="#0C2959" stop-opacity="0.72" />
                        <stop offset="74.35%" stop-color="#0C2959" stop-opacity="0.86" />
                        <stop offset="100%" stop-color="#0C2959" />
                    </linearGradient>
                </defs>
            </svg>
        </div>

        <!-- Background Ellipses -->
        <div class="absolute -top-96 -left-96">
            <img
                src="{{ asset('frontend/images') }}/hero-background.png"
                alt="Background Ellipses"
                class="w-[1179px] h-[1101px] object-contain"
            />
        </div>

        <!-- Wave at bottom -->
        <div class="absolute bottom-0 left-0 w-full">
            <svg
                class="w-full h-52"
                viewBox="0 0 1600 202"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
                preserveAspectRatio="none"
            >
                <path
                    fill-rule="evenodd"
                    clip-rule="evenodd"
                    d="M0 79.458C0 79.458 226.389 186.741 381.052 178.06C535.714 169.378 628.364 133.594 798.309 151.486C968.253 169.378 1461.17 124.238 1600 0V209.034H0V79.458Z"
                    fill="#FDFDFF"
                />
            </svg>
        </div>
        <!-- Content Container -->
        <div
            class="relative z-10 pt-32 pb-32 px-4 md:px-8 lg:px-16 min-h-[700px] flex items-center justify-center"
        >
            <div class="max-w-4xl mx-auto text-center">
                <!-- Breadcrumb Navigation -->
                <div class="flex items-center justify-center gap-2 mb-6">
                    <div class="font-tajawal font-medium text-white text-base">
                        الرئيسية
                    </div>
                    <div class="w-6 h-6 flex items-center justify-center">
                        <svg
                            width="6"
                            height="10"
                            viewBox="0 0 6 10"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                            style="transform: rotate(180deg)"
                        >
                            <path
                                d="M1 1L5 5L1 9"
                                stroke="white"
                                stroke-width="1.5"
                                stroke-linecap="round"
                                stroke-linejoin="round"
                            />
                        </svg>
                    </div>
                    <div class="font-tajawal font-medium text-[#00B34F] text-base">
                        البحث عن شهادة
                    </div>
                </div>

                <!-- Main Title -->
                <h1
                    class="font-tajawal font-bold text-white leading-tight tracking-tight mb-4 text-4xl hero-title-mobile"
                >
                    البحث عن الشهادات
                </h1>

                <!-- Subtitle -->
                <p class="font-tajawal font-medium text-[#DEDEDE] text-lg mb-8">
                    يمكنك البحث سريعا عن اي شيء تريده
                </p>
            </div>
        </div>
    </div>

    <!-- Search Container -->
    <section class="py-16 px-4 md:px-8 lg:px-16 bg-[#FDFDFF]" dir="rtl">
        <div class="max-w-7xl mx-auto">
            <!-- Search Container -->
            <div class="flex flex-col lg:flex-row items-center gap-6 mb-16">
                <!-- Search Input Container -->
                <div class="flex-1 w-full order-1 lg:order-1">
                    <div class="relative">
                        <input
                            type="text"
                            id="certificateSearchInput"
                            placeholder="ادخل كود الشهادة"
                            class="search-input w-full py-6 px-6 pr-14 pl-12 rounded-2xl border-2 border-[#E8ECF4] bg-white font-tajawal text-base placeholder:text-[#8F99AB] focus:outline-none focus:border-[#00B34F] transition-colors"
                        />
                        <div class="absolute right-6 top-1/2 transform -translate-y-1/2">
                            <svg
                                width="24"
                                height="24"
                                viewBox="0 0 24 24"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                            >
                                <path
                                    d="M21.5 21.5L17.014 17.006M19.5 11C19.5 13.2543 18.6045 15.4163 17.0104 17.0104C15.4163 18.6045 13.2543 19.5 11 19.5C8.74566 19.5 6.58365 18.6045 4.98959 17.0104C3.39553 15.4163 2.5 13.2543 2.5 11C2.5 8.74566 3.39553 6.58365 4.98959 4.98959C6.58365 3.39553 8.74566 2.5 11 2.5C13.2543 2.5 15.4163 3.39553 17.0104 4.98959C18.6045 6.58365 19.5 8.74566 19.5 11Z"
                                    stroke="#8F99AB"
                                    stroke-width="2"
                                    stroke-linecap="round"
                                />
                            </svg>
                        </div>
                    </div>
                </div>

                <!-- Search Button -->
                <div class="order-2 lg:order-2">
                    <button
                        id="searchCertificateButton"
                        class="bg-[#E8ECF4] hover:bg-[#D0D8E7] transition-colors px-16 py-4 rounded-full shadow-sm"
                    >
              <span class="font-tajawal font-bold text-[#144394] text-base">
                بحث
              </span>
                    </button>
                </div>
            </div>

            <!-- Certificate Icon and Text -->
            <div class="text-center my-24">
                <!-- Certificate Icon Placeholder -->
                <div class="flex justify-center mb-8">
                    <img
                        src="{{ asset('frontend/images') }}/certificate-icon.svg"
                        alt="Certificate Icon"
                    />
                </div>

                <!-- Search Text -->
                <h2
                    class="font-tajawal font-medium text-[#1C1C1C] text-5xl leading-[60px] tracking-[-0.96px] mb-8"
                >
                    ابحث عن شهادتك
                </h2>
            </div>
        </div>
    </section>
@endsection
@push('footerScript')
@endpush
