@extends('frontend.layouts.app')
@push('headScript')
    <!-- Tailwind Configuration -->
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        alexandria: ["Alexandria", "sans-serif"],
                    },
                    colors: {
                        "brand-success": "#00B34F",
                        "brand-secondary-normal": "#00B34F",
                        "brand-secondary-light": "#E8F5FF",
                        "brand-primary-light": "#E8ECF4",
                    },
                },
            },
        };
    </script>

    <style>
        * {
            /* border: 1px solid red !important; */
        }

        body {
            font-family: "Alexandria", sans-serif;
        }

        /* Mobile Menu Styles */
        .mobile-menu {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.4s ease-in-out, opacity 0.3s ease-in-out;
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
        }

        .mobile-menu.open {
            max-height: 600px;
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        /* Ensure mobile menu is above other elements */
        .mobile-menu .bg-white\/95 {
            background-color: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
        }

        /* Mobile menu animation */
        .mobile-menu .mobile-menu-content {
            transform: translateY(-20px);
            transition: transform 0.3s ease-out;
        }

        .mobile-menu.open .mobile-menu-content {
            transform: translateY(0);
        }

        /* Search box focus styles */
        .search-input:focus {
            box-shadow: 0 0 0 3px rgba(0, 179, 79, 0.3);
        }

        /* Clear button styles */
        .clear-button-hidden {
            display: none !important;
            opacity: 0;
        }

        .clear-button-visible {
            display: flex !important;
            opacity: 1;
        }

        /* Course card animation */
        .course-card {
            transition: all 0.3s ease;
        }

        .course-card.hidden {
            display: none !important;
        }

        /* No results animation */
        .no-results-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Mobile responsive button adjustments */
        @media (max-width: 768px) {
            .responsive-button-text {
                display: none;
            }

            .responsive-button-icon {
                margin: 0 !important;
            }
        }

        @media (max-width: 640px) {
            .hero-title-mobile {
                font-size: 2.5rem !important;
                line-height: 3rem !important;
            }
        }
    </style>
@endpush
@section('content')
    <!-- Hero Section for Search Page -->
    <div class="relative overflow-hidden">
        <!-- Background Image -->
        <div class="absolute left-0 bottom-0 z-0">
            <img src="{{ asset('frontend/images') }}/hero-main.png" alt="Background" />
        </div>

        <!-- Background Gradient Overlay -->
        <div class="absolute inset-0">
            <svg
                class="w-full h-full"
                viewBox="0 0 1600 808"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
                preserveAspectRatio="xMidYMid slice"
            >
                <path
                    d="M0 0H1600V808H0V0Z"
                    fill="url(#paint0_linear_gradient_overlay)"
                />
                <defs>
                    <linearGradient
                        id="paint0_linear_gradient_overlay"
                        x1="205.022"
                        y1="0"
                        x2="1573.65"
                        y2="664.405"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop offset="0%" stop-color="#0C2959" stop-opacity="0.45" />
                        <stop offset="18.28%" stop-color="#0C2959" stop-opacity="0.55" />
                        <stop offset="31.41%" stop-color="#0C2959" stop-opacity="0.62" />
                        <stop offset="49.65%" stop-color="#0C2959" stop-opacity="0.72" />
                        <stop offset="74.35%" stop-color="#0C2959" stop-opacity="0.86" />
                        <stop offset="100%" stop-color="#0C2959" />
                    </linearGradient>
                </defs>
            </svg>
        </div>

        <!-- Background Ellipses -->
        <div class="absolute -top-96 -left-96">
            <img
                src="{{ asset('frontend/images') }}/hero-background.png"
                alt="Background Ellipses"
                class="w-[1179px] h-[1101px] object-contain"
            />
        </div>

        <!-- Wave at bottom -->
        <div class="absolute bottom-0 left-0 w-full">
            <svg
                class="w-full h-52"
                viewBox="0 0 1600 202"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
                preserveAspectRatio="none"
            >
                <path
                    fill-rule="evenodd"
                    clip-rule="evenodd"
                    d="M0 79.458C0 79.458 226.389 186.741 381.052 178.06C535.714 169.378 628.364 133.594 798.309 151.486C968.253 169.378 1461.17 124.238 1600 0V209.034H0V79.458Z"
                    fill="#FDFDFF"
                />
            </svg>
        </div>

        <!-- Content Container -->
        <div
            class="relative z-10 pt-32 pb-32 px-4 md:px-8 lg:px-16 min-h-[700px] flex items-center justify-center"
        >
            <div class="max-w-4xl mx-auto text-center">
                <!-- Breadcrumb Navigation -->
                <div class="flex items-center justify-center gap-2 mb-6">
                    <a href="{{ route('home_page') }}" class="font-alexandria font-medium text-white text-base">
                        الرئيسية
                    </a>
                    <div class="w-6 h-6 flex items-center justify-center">
                        <svg
                            width="6"
                            height="10"
                            viewBox="0 0 6 10"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                            style="transform: rotate(180deg)"
                        >
                            <path
                                d="M1 1L5 5L1 9"
                                stroke="white"
                                stroke-width="1.5"
                                stroke-linecap="round"
                                stroke-linejoin="round"
                            />
                        </svg>
                    </div>
                    <div class="font-alexandria font-medium text-[#00B34F] text-base">
                        البحث
                    </div>
                </div>

                <!-- Main Title -->
                <h1
                    class="font-alexandria font-bold text-white leading-tight tracking-tight mb-4 text-4xl"
                >
                    البحث عن جميع المجالات
                </h1>

                <!-- Subtitle -->
                <p class="font-alexandria font-medium text-[#DEDEDE] text-lg mb-8">
                    يمكنك البحث سريعا عن اي شيء تريده
                </p>
            </div>
        </div>
    </div>

    <!-- Search and Courses Section -->
    <section class="py-16 px-4 md:px-8 lg:px-16 bg-white" dir="rtl">
        <div class="max-w-7xl mx-auto">
            <!-- Enhanced Search Container -->
            <div class="mb-12">
                <form action="{{ request()->fullUrlWithQuery([]) }}" class="flex flex-col lg:flex-row items-center gap-6">
                    <!-- Search Input Container -->
                    <div class="flex-1 w-full order-1 lg:order-1">
                        <div class="relative">
                            <input
                                type="text"
                                name="search"
                                value="{{ request('search') }}"
                                id="searchInput"
                                placeholder="ابحث عن دورة تدريبية"
                                class="search-input w-full py-6 px-6 pr-14 pl-12 rounded-2xl border-2 border-[#E8ECF4] bg-white font-alexandria text-base placeholder:text-[#8F99AB] focus:outline-none focus:border-[#144394] transition-colors"
                            />
                            <div
                                class="absolute right-6 top-1/2 transform -translate-y-1/2"
                            >
                                <svg
                                    width="24"
                                    height="24"
                                    viewBox="0 0 24 24"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg"
                                >
                                    <path
                                        d="M21.5 21.5L17.014 17.006M19.5 11C19.5 13.2543 18.6045 15.4163 17.0104 17.0104C15.4163 18.6045 13.2543 19.5 11 19.5C8.74566 19.5 6.58365 18.6045 4.98959 17.0104C3.39553 15.4163 2.5 13.2543 2.5 11C2.5 8.74566 3.39553 6.58365 4.98959 4.98959C6.58365 3.39553 8.74566 2.5 11 2.5C13.2543 2.5 15.4163 3.39553 17.0104 4.98959C18.6045 6.58365 19.5 8.74566 19.5 11Z"
                                        stroke="#8F99AB"
                                        stroke-width="2"
                                        stroke-linecap="round"
                                    />
                                </svg>
                            </div>
                            <!-- Clear button -->
                            <button
                                id="clearButton"
                                type="button"
                                class="absolute left-4 top-1/2 transform -translate-y-1/2 w-6 h-6 bg-[#8F99AB] hover:bg-[#6B7280] text-white rounded-full flex items-center justify-center  transition-opacity duration-200"
                                title="مسح البحث"
                            >
                                <svg
                                    width="14"
                                    height="14"
                                    viewBox="0 0 24 24"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg"
                                >
                                    <path
                                        d="M18 6L6 18M6 6L18 18"
                                        stroke="currentColor"
                                        stroke-width="2"
                                        stroke-linecap="round"
                                        stroke-linejoin="round"
                                    />
                                </svg>
                            </button>
                        </div>
                    </div>

                    <!-- Search Button -->
                    <button
                        id="searchButton"
                        class="flex items-center justify-center gap-2 px-20 py-4 bg-[#E8ECF4] hover:bg-[#0f3a7f] text-[#144394] hover:text-white font-alexandria font-bold text-base rounded-3xl transition-colors shadow-md order-2 lg:order-2"
                    >
                        <span>بحث</span>
                    </button>
                </form>
            </div>
            <div id="search-result" class="hidden">
                <!-- Results Header -->
                <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-8 text-right">
                    <div>
                        <h2 class="font-alexandria text-2xl lg:text-3xl font-bold text-[#2E2E2E] mb-2">
                            <span id="headerTitle">نتائج البحث</span>
                            <span id="resultsCountNumber" class="text-brand-success">(...)</span>
                        </h2>
                        <p id="resultsCount" class="font-alexandria text-lg text-[#575757]">نتائج البحث ل
                            "<span id="searchKey"></span>"
                        </p>
                    </div>
                </div>
                <div id="search-items">

                </div>
            </div>
            <div id="page-result">
                <!-- Results Header -->
                <div
                    class="flex flex-col md:flex-row md:items-center md:justify-between mb-8 text-right"
                >
                    <div>
                        <h2
                            class="font-alexandria text-2xl lg:text-3xl font-bold text-[#2E2E2E] mb-2"
                        >
                            <span id="headerTitle">الدورات التدريبية</span>
                            <span id="resultsCountNumber" class="text-brand-success hidden"
                            >(6)</span
                            >
                        </h2>
                        <p id="resultsCount" class="font-alexandria text-lg text-[#575757]">
                            اكثر من
                            {{ $coursesCount }}
                            + دورة تدريبية متاحة لجميع طلابنا
                        </p>
                    </div>
                </div>


            @if(!$courses->count())
                <!-- No Results Message -->
                    <div id="noResultsMessage" class=" text-center py-20">
                        <div class="flex flex-col items-center justify-center space-y-6">
                            <!-- No Results Icon -->
                            <div
                                class="w-24 h-24 bg-[#F5F5F5] rounded-full flex items-center justify-center"
                            >
                                <img src="{{ asset('frontend/images') }}/no-results.png" alt="No Results" />
                            </div>

                            <!-- No Results Text -->
                            <div class="space-y-2">
                                <h3 class="font-alexandria text-2xl font-bold text-[#2E2E2E]">
                                    لا يوجد نتائج !
                                </h3>
                                <p class="font-alexandria text-lg text-[#8F99AB] max-w-md">
                                    لم نعثر على نتائج لهذا البحث
                                </p>
                            </div>
                        </div>
                    </div>
            @else

                <!-- Course Cards Grid -->
                    <div
                        id="coursesGrid"
                        class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6"
                    >
                    @foreach($courses as $course)
                        <!-- Course Card {{ $loop->index+1 }} -->
                            <x-course-card :course="$course"/>
                        @endforeach
                    </div>

                    <!-- Pagination -->
                    <div class="flex items-center justify-center gap-2 mt-8">
                        {!! $courses->appends(request()->only('search'))->links('vendor.pagination.custom-tailwind') !!}
                    </div>
                @endif
            </div>

        </div>
    </section>
@endsection
@push('footerScript')
    <script>
        const searchInput = document.getElementById("searchInput");
        const clearButton = document.getElementById("clearButton");
        // Clear button functionality
        clearButton.addEventListener("click", function () {
            searchInput.value = "";
            performSearch();
            searchInput.focus();
        });
        searchInput.addEventListener("keypress", function (e) {
            if (e.key === "Enter") {
                performSearch();
            }
        });

        // Real-time search as user types
        searchInput.addEventListener("input", function () {
            performSearch();
        });
        function performSearch(){
            const searchResult = document.getElementById("search-result");
            const resultsCountNumber = document.getElementById("resultsCountNumber");
            const searchKey = document.getElementById("searchKey");
            const searchItems = document.getElementById("search-items");
            const pageResult = document.getElementById("page-result");

            searchKey.innerText=searchInput.value;
            const searchTerm = searchInput.value.trim().toLowerCase();
            if (searchTerm === "") {
                pageResult.classList.remove('hidden')
                searchResult.classList.add('hidden');
            }else{
                pageResult.classList.add('hidden')
                let svg=`<svg
  role="img"
  width="100%"
  height="100%"
  aria-labelledby="loading-aria"
  viewBox="0 0 302 471"
  preserveAspectRatio="none"
>
  <title id="loading-aria">Loading...</title>
  <rect
    x="0"
    y="0"
    width="100%"
    height="100%"
    clip-path="url(#clip-path)"
    style='fill: url("#fill");'
  ></rect>
  <defs>
    <clipPath id="clip-path">
        <rect x="10" y="7" rx="0" ry="0" width="281" height="183" />
        <rect x="124" y="207" rx="8" ry="8" width="176" height="15" />
        <rect x="49" y="236" rx="8" ry="8" width="245" height="15" />
        <rect x="47" y="265" rx="8" ry="8" width="245" height="15" />
        <rect x="44" y="290" rx="8" ry="8" width="245" height="15" />
        <rect x="27" y="337" rx="8" ry="8" width="191" height="15" />
        <circle cx="255" cy="339" r="29" />
        <rect x="158" y="398" rx="8" ry="8" width="113" height="14" />
        <rect x="20" y="399" rx="8" ry="8" width="113" height="14" />
        <rect x="39" y="443" rx="0" ry="0" width="232" height="12" />
    </clipPath>
    <linearGradient id="fill">
      <stop
        offset="0.599964"
        stop-color="#c2c2c2"
        stop-opacity="1"
      >
        <animate
          attributeName="offset"
          values="-2; -2; 1"
          keyTimes="0; 0.25; 1"
          dur="2s"
          repeatCount="indefinite"
        ></animate>
      </stop>
      <stop
        offset="1.59996"
        stop-color="#ecebeb"
        stop-opacity="1"
      >
        <animate
          attributeName="offset"
          values="-1; -1; 2"
          keyTimes="0; 0.25; 1"
          dur="2s"
          repeatCount="indefinite"
        ></animate>
      </stop>
      <stop
        offset="2.59996"
        stop-color="#c2c2c2"
        stop-opacity="1"
      >
        <animate
          attributeName="offset"
          values="0; 0; 3"
          keyTimes="0; 0.25; 1"
          dur="2s"
          repeatCount="indefinite"
        ></animate>
      </stop>
    </linearGradient>
  </defs>
</svg>`;
                let html='';
                for (let i = 1; i <= 20; i++) {
                    html+='<div class="course-card bg-[#FAFAFA] rounded-lg border border-[#EBEBEB] shadow-sm p-4 hover:shadow-md transition-shadow cursor-pointer">'+svg+'</div>';
                }
                searchItems.innerHTML=`<div id="coursesGrid" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">${html}</div>`;
                searchResult.classList.remove('hidden');
                fetch("{{ route('search_page') }}?search="+searchTerm+'&searchData=ture', {
                    method: "GET",
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                        "Accept": "application/json"
                    }
                })
                    .then(async response => {
                        // Laravel بيرجع JSON غالبًا
                        // if (!response.ok) {
                        //     throw new Error("يوجد خطء في الوقت الحالي حاول مره اخري لاحقا او تواصل معنا");
                        // }
                        return response.json();
                    })
                    .then(data => {
                        console.log(data)
                        searchItems.innerHTML=data.html;
                        resultsCountNumber.innerText=`(${data.count})`;
                    })
                    .catch(error => {
                        console.log(error)
                    });
            }


        }
    </script>
@endpush
