@extends('frontend.layouts.app_empty')
@push('headScript')
    <!-- Tailwind Configuration -->
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        alexandria: ["Alexandria", "sans-serif"],
                    },
                    colors: {
                        "brand-primary": "#144394",
                        "brand-primary-light": "#E8ECF4",
                        "neutral-n10": "#FAFAFA",
                        "neutral-n30": "#EBEBEB",
                        "neutral-n40": "#DEDEDE",
                        "neutral-n50": "#BFBFBF",
                        "neutral-n300": "#575757",
                        "neutral-n600": "#2E2E2E",
                        "gray-300": "#D0D5DD",
                        "gray-500": "#667085",
                        "gray-900": "#101828",
                        "blue-gray-300": "#CBD5E1",
                    },
                },
            },
        };
    </script>
    <style>
        * {
            /* border: 1px solid red !important; */
        }

        body {
            font-family: "Alexandria", sans-serif;
        }

        .login-container {
            min-height: 100vh;
        }

        .login-form-section {
            flex: 1;
            min-height: 100vh;
            background: #fff;
        }

        .login-hero-section {
            flex: 1;
            min-height: 100vh;
            background: linear-gradient(
                106deg,
                rgba(12, 41, 89, 0.45) -26.44%,
                rgba(12, 41, 89, 0.55) -12.52%,
                rgba(12, 41, 89, 0.62) -2.51%,
                rgba(12, 41, 89, 0.72) 11.38%,
                rgba(12, 41, 89, 0.86) 30.19%,
                #0c2959 49.73%
            );
            position: relative;
            overflow: hidden;
        }

        .password-toggle {
            cursor: pointer;
        }

        .remember-checkbox:checked {
            background-color: #144394;
            border-color: #144394;
        }

        /* Responsive adjustments */
        @media (max-width: 1024px) {
            .login-hero-section {
                min-height: 50vh;
            }

            .login-form-section {
                min-height: auto;
            }
        }

        @media (max-width: 768px) {
            .login-container {
                flex-direction: column;
            }

            .login-hero-section {
                min-height: 40vh;
            }

            .hero-image {
                width: 80%;
                height: auto;
            }
        }
    </style>
    @endpush
@section('content')
    <div
        class="login-container flex flex-row-reverse justify-center items-center"
    >
        <!-- Left Section - Hero Content -->
        <div
            class="login-hero-section relative flex items-center justify-center overflow-hidden h-screen md:block hidden"
        >
            <!-- Decorative Green Dots - Top Right -->
            <div class="absolute top-0 right-0 z-10">
                <img src="{{ asset('frontend/images') }}/top-green-dots.png" alt="Decorative Green Dots" />
            </div>

            <!-- Decorative Green Dots - Bottom Left -->
            <div class="absolute bottom-0 left-0 z-10">
                <img src="{{ asset('frontend/images') }}/green-dots.png" alt="Decorative Green Dots" />
            </div>

            <!-- wave left -->
            <div class="absolute inset-y-0 left-0">
                <img src="{{ asset('frontend/images') }}/wave-left.png" alt="Wave Left" />
            </div>
            <!-- Main Content Container -->
            <div
                class="relative z-20 flex flex-col items-center justify-end px-6 md:px-12 max-w-4xl mx-auto h-full"
            >
                <!-- Text Content Above Image -->
                <div class="text-center">
                    <h1
                        class="font-alexandria text-2xl md:text-3xl lg:text-2xl font-normal text-white leading-relaxed mb-4"
                    >
                        تسجيل الدخول إلى منصة شركتك التدريبية
                    </h1>
                    <p
                        class="font-alexandria text-base md:text-lg text-neutral-n40 leading-relaxed max-w-2xl mx-auto w-full md:w-3/4 lg:w-4/3"
                    >
                        تابع تقدم فريقك، قم بإدارة المحتوى، وحقق أهداف التعلم بفعالية.
                    </p>
                </div>

                <!-- Hero Image -->
                <div class="hero-image">
                    <img
                        src="{{ asset('frontend/images') }}/teamwork.png"
                        alt="فريق العمل - رجل وامرأة ينظران إلى جهاز لوحي"
                        class="w-4/5 max-w-xl mx-auto object-contain"
                    />
                </div>
            </div>
        </div>

        <!-- Right Section - Login Form -->
        <div
            class="login-form-section flex items-center justify-center px-6 md:px-8"
        >
            <div class="w-full max-w-md">
                <!-- Form Header -->
                <div class="text-right mb-8">
                    <h2
                        class="font-alexandria text-2xl md:text-3xl font-semibold text-gray-900 mb-3"
                    >
                        تسجيل الدخول
                    </h2>
                    <p class="font-alexandria text-base text-gray-500 leading-relaxed">
                        اهلا بعودتك، يرجي ملئ البيانات حتي تتمكن من الدخول
                    </p>
                </div>

                <!-- Login Form -->
                <form id="loginForm" class="space-y-6">
                    <!-- Email Field -->
                    <div class="form-group">
                        <label
                            class="block text-sm font-medium text-neutral-n600 mb-2 text-right"
                        >
                            بريدك الإلكتروني
                        </label>
                        <div class="relative">
                            <input
                                type="email"
                                id="email"
                                name="email"
                                placeholder="بريد ألكتروني للتواصل"
                                class="w-full px-4 py-3 pr-12 text-right border border-blue-gray-300 rounded-lg focus:ring-2 focus:ring-brand-primary focus:border-brand-primary placeholder:text-neutral-n50 text-sm"
                            />
                            <div class="absolute left-3 top-1/2 transform -translate-y-1/2">
                                <svg
                                    width="18"
                                    height="18"
                                    viewBox="0 0 18 18"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg"
                                >
                                    <g clip-path="url(#clip0_email)">
                                        <path
                                            fill-rule="evenodd"
                                            clip-rule="evenodd"
                                            d="M16.8237 4.43766L9.75101 10.2948C9.55004 10.4613 9.29724 10.5524 9.03624 10.5524C8.77525 10.5524 8.52245 10.4613 8.32147 10.2948L1.25218 4.43766C1.21424 4.55184 1.19495 4.67138 1.19504 4.79169V13.7543C1.19504 14.0515 1.31307 14.3364 1.52318 14.5465C1.73328 14.7566 2.01824 14.8747 2.31537 14.8747H15.7594C16.0565 14.8747 16.3414 14.7566 16.5515 14.5465C16.7617 14.3364 16.8797 14.0515 16.8797 13.7543V4.79169C16.8801 4.67144 16.8612 4.5519 16.8237 4.43766ZM2.31537 2.55103H15.7594C16.3536 2.55103 16.9235 2.78709 17.3437 3.2073C17.7639 3.62751 18 4.19743 18 4.79169V13.7543C18 14.3486 17.7639 14.9185 17.3437 15.3387C16.9235 15.7589 16.3536 15.995 15.7594 15.995H2.31537C1.72111 15.995 1.15119 15.7589 0.730982 15.3387C0.310776 14.9185 0.074707 14.3486 0.074707 13.7543V4.79169C0.074707 4.19743 0.310776 3.62751 0.730982 3.2073C1.15119 2.78709 1.72111 2.55103 2.31537 2.55103ZM2.0801 3.67136L8.32707 8.82825C8.52715 8.9935 8.77838 9.08418 9.03788 9.08479C9.29738 9.0854 9.54904 8.99591 9.74989 8.83161L16.0596 3.67136H2.0801Z"
                                            fill="#BFBFBF"
                                        />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_email">
                                            <rect
                                                width="17.9253"
                                                height="17.9253"
                                                fill="white"
                                                transform="translate(0.074707 0.0373535)"
                                            />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </div>
                        </div>
                    </div>

                    <!-- Password Field -->
                    <div class="form-group">
                        <label
                            class="block text-sm font-medium text-neutral-n600 mb-2 text-right"
                        >
                            كلمة المرور
                        </label>
                        <div class="relative">
                            <input
                                type="password"
                                id="password"
                                name="password"
                                placeholder="••••••••"
                                class="w-full px-4 py-3 pr-12 pl-12 text-right border border-gray-300 rounded-lg focus:ring-2 focus:ring-brand-primary focus:border-brand-primary placeholder:text-neutral-n50 text-base shadow-sm"
                            />

                            <!-- Password Icon (Left) -->
                            <div
                                class="absolute right-4 top-1/2 transform -translate-y-1/2"
                            >
                                <svg
                                    width="16"
                                    height="16"
                                    viewBox="0 0 16 16"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg"
                                >
                                    <path
                                        d="M10.5 1C9.7973 0.999839 9.10433 1.16428 8.47662 1.48015C7.84892 1.79603 7.30393 2.25454 6.88533 2.81896C6.46673 3.38337 6.18617 4.038 6.06611 4.73037C5.94606 5.42274 5.98986 6.1336 6.194 6.806L1 12V15H4L9.194 9.806C9.81295 9.99388 10.4651 10.0461 11.1061 9.95914C11.7471 9.87217 12.3617 9.64804 12.9082 9.30202C13.4548 8.95601 13.9202 8.49624 14.273 7.95405C14.6257 7.41187 14.8575 6.8 14.9524 6.16016C15.0472 5.52033 15.0031 4.86755 14.8229 4.24632C14.6427 3.62509 14.3307 3.05002 13.9081 2.56028C13.4855 2.07054 12.9624 1.67766 12.3742 1.40841C11.7861 1.13915 11.1468 0.99985 10.5 1ZM10.5 9C10.1558 8.99991 9.8134 8.94902 9.484 8.849L8.9105 8.675L8.487 9.0985L6.8965 10.689L6.207 10L5.5 10.707L6.1895 11.3965L5.3965 12.1895L4.707 11.5L4 12.207L4.6895 12.8965L3.586 14H2V12.414L6.901 7.513L7.325 7.0895L7.151 6.516C6.93729 5.8115 6.95117 5.05754 7.19068 4.36138C7.43018 3.66522 7.8831 3.06231 8.48502 2.63841C9.08694 2.21451 9.8072 1.99121 10.5433 2.00027C11.2795 2.00932 11.994 2.25028 12.5854 2.68886C13.1767 3.12744 13.6146 3.74131 13.8369 4.44315C14.0592 5.14499 14.0545 5.89906 13.8236 6.59809C13.5926 7.29712 13.1471 7.90553 12.5504 8.33675C11.9537 8.76797 11.2362 9.00006 10.5 9Z"
                                        fill="#BFBFBF"
                                    />
                                    <path
                                        d="M11 6C11.5523 6 12 5.55228 12 5C12 4.44772 11.5523 4 11 4C10.4477 4 10 4.44772 10 5C10 5.55228 10.4477 6 11 6Z"
                                        fill="#BFBFBF"
                                    />
                                </svg>
                            </div>

                            <!-- Eye Icon (Left) -->
                            <div
                                class="absolute left-4 top-1/2 transform -translate-y-1/2 password-toggle"
                                onclick="togglePassword()"
                            >
                                <svg
                                    width="24"
                                    height="24"
                                    viewBox="0 0 24 24"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg"
                                >
                                    <path
                                        d="M15 12C15 12.7956 14.6839 13.5587 14.1213 14.1213C13.5587 14.6839 12.7956 15 12 15C11.2044 15 10.4413 14.6839 9.87868 14.1213C9.31607 13.5587 9 12.7956 9 12C9 11.2044 9.31607 10.4413 9.87868 9.87868C10.4413 9.31607 11.2044 9 12 9C12.7956 9 13.5587 9.31607 14.1213 9.87868C14.6839 10.4413 15 11.2044 15 12Z"
                                        stroke="#1C1C1C"
                                        stroke-linecap="round"
                                        stroke-linejoin="round"
                                    />
                                    <path
                                        d="M2 12C3.6 7.903 7.336 5 12 5C16.664 5 20.4 7.903 22 12C20.4 16.097 16.664 19 12 19C7.336 19 3.6 16.097 2 12Z"
                                        stroke="#1C1C1C"
                                        stroke-linecap="round"
                                        stroke-linejoin="round"
                                    />
                                </svg>
                            </div>
                        </div>
                    </div>

                    <!-- Remember Me and Forgot Password -->
                    <div class="flex items-center justify-between flex-row-reverse">
                        <a
                            href="{{ route('forget_password_page') }}"
                            class="text-sm font-normal text-brand-primary underline hover:text-blue-800"
                        >
                            نسيت كلمة المرور؟
                        </a>

                        <div class="flex items-center gap-2">
                            <input
                                type="checkbox"
                                id="remember"
                                name="remember"
                                title="تذكرني"
                                aria-label="تذكرني"
                                class="remember-checkbox w-4 h-4 rounded border border-neutral-n30 bg-neutral-n10 focus:ring-2 focus:ring-brand-primary"
                            />

                            <label
                                for="remember"
                                class="text-sm font-normal text-neutral-n600"
                            >تذكرني</label
                            >
                        </div>
                    </div>

                    <!-- Login Button -->
                    <button
                        type="submit"
                        class="w-full bg-brand-primary text-neutral-n10 py-3 px-6 rounded-lg font-medium text-base hover:bg-blue-800 focus:ring-2 focus:ring-brand-primary focus:ring-offset-2 transition-colors shadow-sm"
                    >
                        تسجيل الدخول
                    </button>
                    <!-- Alternative Login Text -->
                    <div class="text-center pt-4">
                        <p class="font-medium text-base text-neutral-n600 leading-6">
                            او يمكنك تسجيل الدخول عبر:
                        </p>
                    </div>

                    <!-- FutureX Login Button -->
                    <a
                        href="{{ URL('simplesaml') }}"
                        type="button"
                        class="w-full bg-brand-primary-light text-brand-primary py-3 px-6 rounded-lg font-medium text-base hover:bg-blue-100 focus:ring-2 focus:ring-brand-primary focus:ring-offset-2 transition-colors border border-neutral-n30 flex items-center justify-center gap-2"
                    >
                        فيوتشر اكس
                        <img src="{{ asset('frontend/images') }}/futurex-logo.svg" alt="FuturX Logo" />
                    </a>
                    <!-- Contact Us Link -->
                    <div class="text-center pt-4">
                        <span class="text-sm text-neutral-n300">ليس لديك حساب؟</span>
                        <a
                            href="{{ route('contact_us_page') }}"
                            class="text-sm font-normal text-brand-primary hover:text-blue-800 mr-1"
                        >
                            تواصل معنا
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection
@push('footerScript')
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/jquery.validate.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        window.Toast= Swal.mixin({
            toast: true,
            position: "top-end",
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.onmouseenter = Swal.stopTimer;
                toast.onmouseleave = Swal.resumeTimer;
            }
        });
    </script>
    <script>
        function togglePassword() {
            const passwordInput = document.getElementById("password");
            const type =
                passwordInput.getAttribute("type") === "password"
                    ? "text"
                    : "password";
            passwordInput.setAttribute("type", type);
        }

        // Mobile menu functionality (if needed for header)
        document.addEventListener("DOMContentLoaded", function () {
            const mobileMenuButton = document.getElementById("mobile-menu-button");
            const mobileMenu = document.getElementById("mobile-menu");
            const menuIcon = document.getElementById("menu-icon");
            const closeIcon = document.getElementById("close-icon");

            if (mobileMenuButton && mobileMenu) {
                mobileMenuButton.addEventListener("click", function () {
                    mobileMenu.classList.toggle("open");
                    menuIcon.classList.toggle("hidden");
                    closeIcon.classList.toggle("hidden");
                });
            }
        });
    </script>
    <script>
        jQuery.validator.addMethod(
            "validate_email",
            function (value, element, param) {
                if (!value) return true;
                return value.match(
                    /^[a-zA-Z0-9_\.%\+\-]+@[a-zA-Z0-9\.\-]+\.[a-zA-Z]{2,}$/
                );
            },
            "Enter a valid email address"
        );
        $('#loginForm').validate({
            rules: {
                email: {
                    required: true,
                    validate_email: true,
                },
                password: {
                    required: true,
                    minlength: 6,
                },
            },
            messages: {
                email: {
                    required: "يجب ادخال البريد الإلكتروني",
                    validate_email: "من فضلك ادخل بريد الكتروني صالح",
                },
                password: {
                    required: "يجب ادخال كلمة المرور",
                    minlength: "كلمة المرور لا تقل عن ٦",
                },
            },
            errorElement: "p",
            errorClass: "mt-1 text-sm text-red-600", // Tailwind classes for error text
            highlight: function(element) {
                $(element).addClass("border-red-500 focus:border-red-500 focus:ring-red-200");
            },
            unhighlight: function(element) {
                $(element).removeClass("border-red-500 focus:border-red-500 focus:ring-red-200");
            },
            errorPlacement: function(error, element) {
                error.insertAfter(element.parent()); // ضع رسالة الخطأ تحت الـ input
            },
            submitHandler: function(form) {
                $(form).addClass('loading');
                let formData=new FormData(form);
                fetch("{{ route('login_page') }}", {
                    method: "POST",
                    body: formData,
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                        "Accept": "application/json"
                    }
                })
                    .then(async response => {
                        // Laravel بيرجع JSON غالبًا
                        // if (!response.ok) {
                        //     throw new Error("يوجد خطء في الوقت الحالي حاول مره اخري لاحقا او تواصل معنا");
                        // }
                        return response.json();
                    })
                    .then(data => {
                        $(form).removeClass('loading')

                        if (data.success) {
                            $(form)[0].reset();
                        }

                        if (typeof data.message === 'object') {
                            for(let key in data.message){
                                $(form).find("[name='"+key+"']").parent().append('<label id="'+key+'-error" class="error" for="'+key+'">'+data.message[key]+'</label>');
                            }
                        }
                        Toast.fire({
                            icon: data.success ? "success" : "error",
                            title: data.message
                        });
                        if(data.redirect){
                            setTimeout(function(){
                                window.location.href=data.redirect;
                            },3000)

                        }

                    })
                    .catch(error => {
                        $(form).removeClass('loading')
                        console.error("Fetch error:", error);
                        Toast.fire({
                            icon: "error",
                            title:error.toString().replaceAll('Error:','')
                        });
                    });
            }
        });
    </script>
@endpush
