@extends('frontend.layouts.app')
@push('headScript')
    <!-- Tailwind Configuration -->
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        alexandria: ["Alexandria", "sans-serif"],
                        tajawal: ["Tajawal", "sans-serif"],
                    },
                    colors: {
                        "brand-success": "#00B34F",
                        "brand-secondary-normal": "#00B34F",
                        "brand-secondary-light": "#E6F7ED",
                        "brand-primary-normal": "#144394",
                        "brand-primary-light": "#E8ECF4",
                    },
                },
            },
        };
    </script>

    <style>
        * {
            /* border: 1px solid red !important; */
        }

        body {
            font-family: "Alexandria", sans-serif;
        }

        /* Mobile Menu Styles */
        .mobile-menu {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.4s ease-in-out, opacity 0.3s ease-in-out;
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
        }

        .mobile-menu.open {
            max-height: 600px;
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        /* Ensure mobile menu is above other elements */
        .mobile-menu .bg-white\/95 {
            background-color: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
        }

        /* Mobile menu animation */
        .mobile-menu .mobile-menu-content {
            transform: translateY(-20px);
            transition: transform 0.3s ease-out;
        }

        .mobile-menu.open .mobile-menu-content {
            transform: translateY(0);
        }

        /* Mobile responsive button adjustments */
        @media (max-width: 768px) {
            .responsive-button-text {
                display: none;
            }

            .responsive-button-icon {
                margin: 0 !important;
            }
        }

        @media (max-width: 640px) {
            .hero-title-mobile {
                font-size: 2.5rem !important;
                line-height: 3rem !important;
            }
        }
    </style>
@endpush
@section('content')
    <!-- Hero Section for Search Certificate Page -->
    <div class="relative overflow-hidden min-h-[700px]">
        <!-- Background Image -->
        <div class="absolute left-0 bottom-0 z-0">
            <img src="{{ asset('frontend/images') }}/hero-instructors-background.png" alt="Background" />
        </div>

        <!-- Background Gradient Overlay -->
        <div class="absolute inset-0">
            <svg
                class="w-full h-full"
                viewBox="0 0 1600 808"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
                preserveAspectRatio="xMidYMid slice"
            >
                <path
                    d="M0 0H1600V808H0V0Z"
                    fill="url(#paint0_linear_gradient_overlay)"
                />
                <defs>
                    <linearGradient
                        id="paint0_linear_gradient_overlay"
                        x1="205.022"
                        y1="0"
                        x2="1573.65"
                        y2="664.405"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop offset="0%" stop-color="#0C2959" stop-opacity="0.45" />
                        <stop offset="18.28%" stop-color="#0C2959" stop-opacity="0.55" />
                        <stop offset="31.41%" stop-color="#0C2959" stop-opacity="0.62" />
                        <stop offset="49.65%" stop-color="#0C2959" stop-opacity="0.72" />
                        <stop offset="74.35%" stop-color="#0C2959" stop-opacity="0.86" />
                        <stop offset="100%" stop-color="#0C2959" />
                    </linearGradient>
                </defs>
            </svg>
        </div>

        <!-- Background Ellipses -->
        <div class="absolute -top-96 -left-96">
            <img
                src="{{ asset('frontend/images') }}/hero-background.png"
                alt="Background Ellipses"
                class="w-[1179px] h-[1101px] object-contain"
            />
        </div>

        <!-- Wave at bottom -->
        <div class="absolute bottom-0 left-0 w-full">
            <svg
                class="w-full h-52"
                viewBox="0 0 1600 202"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
                preserveAspectRatio="none"
            >
                <path
                    fill-rule="evenodd"
                    clip-rule="evenodd"
                    d="M0 79.458C0 79.458 226.389 186.741 381.052 178.06C535.714 169.378 628.364 133.594 798.309 151.486C968.253 169.378 1461.17 124.238 1600 0V209.034H0V79.458Z"
                    fill="#FDFDFF"
                />
            </svg>
        </div>
        <!-- Content Container -->
        <div
            class="relative z-10 pt-32 pb-32 px-4 md:px-8 lg:px-16 min-h-[700px] flex items-center justify-center"
        >
            <div class="max-w-4xl mx-auto text-center">
                <!-- Breadcrumb Navigation -->
                <div class="flex items-center justify-center gap-2 mb-6">
                    <a
                        class="font-tajawal font-medium text-white text-base"
                        href="{{ route('home_page') }}"
                    >
                        الرئيسية
                    </a>
                    <div class="w-6 h-6 flex items-center justify-center">
                        <svg
                            width="6"
                            height="10"
                            viewBox="0 0 6 10"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                            style="transform: rotate(180deg)"
                        >
                            <path
                                d="M1 1L5 5L1 9"
                                stroke="white"
                                stroke-width="1.5"
                                stroke-linecap="round"
                                stroke-linejoin="round"
                            />
                        </svg>
                    </div>
                    <div class="font-tajawal font-medium text-[#00B34F] text-base">
                        المحاضرين
                    </div>
                </div>

                <!-- Main Title -->
                <h1
                    class="font-tajawal font-bold text-white leading-tight tracking-tight mb-4 text-4xl hero-title-mobile"
                >
                    المحاضرين
                </h1>

                <!-- Subtitle -->
                <p class="font-tajawal font-medium text-[#DEDEDE] text-lg mb-8">
                    تعرف اكثر عن المحاضرين و خبراتهم
                </p>
            </div>
        </div>
    </div>

    <!-- Our Trainers Section -->
    <section
        class="bg-[#FDFDFF] py-16 lg:py-20 px-4 md:px-8 lg:px-16"
        dir="rtl"
    >
        <div class="max-w-7xl mx-auto">
            <!-- Section Title -->
            <h2
                class="font-alexandria font-bold text-[#000000] text-3xl lg:text-4xl xl:text-[40px] leading-tight text-center mb-6"
            >
                جميع المدربين لدينا
            </h2>

            <!-- Trainers Grid -->
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mt-12">
                @foreach($instructors as $instructor)
                <!-- Trainer Card 1 -->
                <a href="{{ route('instructor_page',$instructor->url) }}" class="trainer-card overflow-hidden">
                    <div
                        class="trainer-image-container aspect-[352/377] relative bg-[#F2F4F9] rounded-lg border border-[#D0D5DD]"
                    >
                        <img
                            src="{{ asset('assets/images/'.$instructor->pic) }}"
                            alt="{{ $instructor->name }}"
                            class="w-full h-full object-cover mt-2"
                            loading="lazy"
                        />
                    </div>
                    <div class="trainer-info py-2 px-1 text-right">
                        <div class="trainer-details mb-4">
                            <h3
                                class="trainer-name font-alexandria font-bold text-[#000000] text-lg mb-2"
                            >
                                {{ $instructor->name }}
                            </h3>
                            <p
                                class="trainer-title font-alexandria font-normal text-[#144394] text-base mb-4"
                            >
                                {{ $instructor->title }}
                            </p>
                        </div>
                        <p
                            class="trainer-description font-alexandria font-normal text-[#667085] text-sm leading-relaxed mb-4"
                        >
                            {{ $instructor->short_description }}
                        </p>
                        <div class="social-icons flex items-center gap-5 justify-start">
                            @if($instructor->linkedin)
                            <a target="_blank" href="{{ $instructor->linkedin }}" class="social-link">
                                <img src="{{ asset('frontend/images') }}/linkedin-icon.svg" alt="LinkedIn" />
                            </a>
                            @endif
                            @if($instructor->facebook)
                            <a target="_blank" href="{{ $instructor->facebook }}" class="social-link">
                                <img src="{{ asset('frontend/images') }}/facebook-icon.svg" alt="Facebook" />
                            </a>
                            @endif
                        </div>
                    </div>
                </a>
                @endforeach
            </div>
            <!-- Pagination -->
            <div class="flex items-center justify-center gap-2 mt-8">
                {!! $instructors->appends(request()->only('search'))->links('vendor.pagination.custom-tailwind') !!}
            </div>
        </div>
    </section>
@endsection
@push('footerScript')
@endpush
