@extends('frontend.layouts.app')
@push('headScript')
    <!-- Tailwind Configuration -->
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        alexandria: ["Alexandria", "sans-serif"],
                        tajawal: ["Tajawal", "sans-serif"],
                    },
                    colors: {
                        "brand-success": "#00B34F",
                        "brand-secondary-normal": "#00B34F",
                        "brand-secondary-light": "#E6F7ED",
                        "brand-primary-normal": "#144394",
                        "brand-primary-light": "#E8ECF4",
                    },
                },
            },
        };
    </script>

    <style>
        body {
            font-family: "Alexandria", sans-serif;
        }
    </style>
@endpush
@section('content')
    <!-- Hero Section for Search Certificate Page -->
    <div class="relative overflow-hidden min-h-[700px]">
        <!-- Background Image -->
        <div class="absolute left-0 bottom-0 z-0">
            <img src="{{ asset('frontend/images') }}/hero-instructors-background.png" alt="Background" />
        </div>

        <!-- Background Gradient Overlay -->
        <div class="absolute inset-0">
            <svg class="w-full h-full" viewBox="0 0 1600 808" fill="none" xmlns="http://www.w3.org/2000/svg"
                 preserveAspectRatio="xMidYMid slice">
                <path d="M0 0H1600V808H0V0Z" fill="url(#paint0_linear_gradient_overlay)" />
                <defs>
                    <linearGradient id="paint0_linear_gradient_overlay" x1="205.022" y1="0" x2="1573.65" y2="664.405"
                                    gradientUnits="userSpaceOnUse">
                        <stop offset="0%" stop-color="#0C2959" stop-opacity="0.45" />
                        <stop offset="18.28%" stop-color="#0C2959" stop-opacity="0.55" />
                        <stop offset="31.41%" stop-color="#0C2959" stop-opacity="0.62" />
                        <stop offset="49.65%" stop-color="#0C2959" stop-opacity="0.72" />
                        <stop offset="74.35%" stop-color="#0C2959" stop-opacity="0.86" />
                        <stop offset="100%" stop-color="#0C2959" />
                    </linearGradient>
                </defs>
            </svg>
        </div>

        <!-- Background Ellipses -->
        <div class="absolute -top-96 -left-96">
            <img src="{{ asset('frontend/images') }}/hero-background.png" alt="Background Ellipses"
                 class="w-[1179px] h-[1101px] object-contain" />
        </div>

        <!-- Wave at bottom -->
        <div class="absolute bottom-0 left-0 w-full">
            <svg class="w-full h-52" viewBox="0 0 1600 202" fill="none" xmlns="http://www.w3.org/2000/svg"
                 preserveAspectRatio="none">
                <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M0 79.458C0 79.458 226.389 186.741 381.052 178.06C535.714 169.378 628.364 133.594 798.309 151.486C968.253 169.378 1461.17 124.238 1600 0V209.034H0V79.458Z"
                      fill="#FDFDFF" />
            </svg>
        </div>
        <!-- Content Container -->
        <div class="relative z-10 pt-32 pb-32 px-4 md:px-8 lg:px-16 min-h-[700px] flex items-center justify-center">
            <div class="max-w-4xl mx-auto text-center">
                <!-- Breadcrumb Navigation -->
                <div class="flex items-center justify-center gap-2 mb-6">
                    <a class="font-tajawal font-medium text-white text-base" href="{{ route('home_page') }}">
                        الرئيسية
                    </a>
                    <div class="w-6 h-6 flex items-center justify-center">
                        <svg width="6" height="10" viewBox="0 0 6 10" fill="none" xmlns="http://www.w3.org/2000/svg"
                             style="transform: rotate(180deg)">
                            <path d="M1 1L5 5L1 9" stroke="white" stroke-width="1.5" stroke-linecap="round"
                                  stroke-linejoin="round" />
                        </svg>
                    </div>
                    <div class="font-tajawal font-medium text-[#00B34F] text-base">
                       {{ $instructor->name }}
                    </div>
                </div>

                <!-- Main Title -->
                <h1
                    class="font-tajawal font-bold text-white leading-tight tracking-tight mb-4 text-4xl hero-title-mobile">
                    {{ $instructor->name }}
                </h1>

                <!-- Subtitle -->
                <p class="font-tajawal font-medium text-[#DEDEDE] text-lg mb-8">
                    تعرف اكثر عن المحاضرين و خبراتهم
                </p>
            </div>
        </div>
    </div>

    <!-- Instructor Details Section -->
    <section class="py-16 px-4 md:px-8 lg:px-16 bg-[#FDFDFF]" dir="rtl">
        <div class="max-w-7xl mx-auto">

            <!-- Section Title -->
            <h2 class="font-tajawal font-medium text-4xl text-black text-right mb-12 tracking-tight">
                تفاصيل عن المحاضر:
            </h2>

            <!-- Main Content Container -->
            <div
                class="bg-[#F2F4F9] rounded-lg p-8 lg:p-16 flex flex-col lg:flex-row items-start justify-between gap-8 lg:gap-16">


                <!-- Instructor Image and Social Links (Left Side) -->
                <div class="flex flex-col gap-6 w-full lg:w-2/5">

                    <!-- Instructor Image -->
                    <div class="relative">
                        <div class="bg-[#E8ECF2] rounded-lg p-6 pb-0 h-[600px] flex items-center justify-center">
                            <!-- Placeholder for instructor image -->
                            <img src="{{ asset('assets/images/'.$instructor->image) }}" alt="{{ $instructor->name }}"
                                 class="w-full h-full object-cover rounded-lg mx-4" />
                        </div>
                    </div>

                    <!-- Social Media Links -->
                    <div class="flex flex-col sm:flex-row gap-4 w-full max-w-md">
                        @if($instructor->facebook)
                        <!-- Facebook Link -->
                        <a href="{{ $instructor->facebook }}" target="_blank"
                           class="flex items-center justify-start gap-2 px-4 py-3 bg-brand-primary-light rounded-lg hover:bg-opacity-80 transition-colors">
                            <div class="w-10 h-10 flex-shrink-0 relative">
                                <img src="{{ asset('frontend/images') }}/course-details/facebook-icon.png" alt="Facebook Icon"
                                     class="w-8 h-8 absolute top-1 left-1" style="color: #144394" />
                            </div>

                            <span class="font-alexandria text-sm text-colors-base-black">
                                تابعني على فيسبوك
                            </span>
                        </a>
                        @endif
                        @if($instructor->linkedin)
                        <!-- LinkedIn Link -->
                        <a href="{{ $instructor->linkedin }}" target="_blank"
                           class="flex items-center justify-start gap-2 px-4 py-3 bg-brand-primary-light rounded-lg hover:bg-opacity-80 transition-colors">
                            <svg width="44" height="44" viewBox="0 0 44 44" fill="none"
                                 xmlns="http://www.w3.org/2000/svg" class="w-10 h-10 flex-shrink-0">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M8.80221 6.49292C7.58642 6.49292 6.60083 7.47851 6.60083 8.6943V35.3054C6.60083 36.5212 7.58642 37.5068 8.80221 37.5068H35.4134C36.6292 37.5068 37.6148 36.5212 37.6148 35.3054V8.6943C37.6148 7.47851 36.6292 6.49292 35.4134 6.49292H8.80221ZM13.562 16.1243C15.0479 16.1243 16.2525 14.9198 16.2525 13.4339C16.2525 11.948 15.0479 10.7434 13.562 10.7434C12.0761 10.7434 10.8716 11.948 10.8716 13.4339C10.8716 14.9198 12.0761 16.1243 13.562 16.1243ZM18.7165 18.1126H23.1755V20.1553C23.1755 20.1553 24.3854 17.7353 27.6777 17.7353C30.6145 17.7353 33.0473 19.1821 33.0473 23.5918V32.8908H28.4266V24.7186C28.4266 22.1173 27.0378 21.8312 25.9795 21.8312C23.7832 21.8312 23.4072 23.7256 23.4072 25.058V32.8908H18.7165V18.1126ZM15.9074 18.1127H11.2167V32.8909H15.9074V18.1127Z"
                                      fill="#144394" />
                            </svg>

                            <span class="font-alexandria text-sm text-colors-base-black">
                                تابعني على ليكند ان
                            </span>
                        </a>
                            @endif
                    </div>
                </div>

                <!-- Instructor Information (Right Side) -->
                <div class="flex flex-col gap-6 w-full lg:w-3/5">

                    <!-- Instructor Name and Title -->
                    <div class="flex flex-col gap-2 text-right">
                        <h3 class="font-tajawal font-bold text-3xl text-[#111111] leading-tight">
                           {{ $instructor->name }}
                        </h3>
                        <p class="font-tajawal font-medium text-xl text-[#7B7B7B] leading-relaxed">
                            {{ $instructor->title }}
                        </p>
                    </div>

                    <!-- Education Information -->
                    <div class="flex flex-col gap-5">
                            {!! $instructor->description !!}
{{--                        <!-- Education Item 1 -->--}}
{{--                        <div class="flex gap-4 items-start">--}}
{{--                            <div--}}
{{--                                class="flex-shrink-0 w-8 h-8 bg-[#E8ECF4] rounded-full flex items-center justify-center mt-1">--}}
{{--                                <img src="{{ asset('frontend/images') }}/course-details/certificate.png" alt="شهادة" />--}}
{{--                            </div>--}}
{{--                            <p--}}
{{--                                class="font-tajawal font-medium text-lg text-[#141414] text-right leading-relaxed flex-1">--}}
{{--                                بكالوريوس الهندسة عام 1999 من جامعة المنصورة.--}}
{{--                            </p>--}}
{{--                        </div>--}}

{{--                        <!-- Education Item 2 -->--}}
{{--                        <div class="flex gap-4 items-start">--}}
{{--                            <div--}}
{{--                                class="flex-shrink-0 w-8 h-8 bg-[#E8ECF4] rounded-full flex items-center justify-center mt-1">--}}
{{--                                <img src="{{ asset('frontend/images') }}/course-details/certificate.png" alt="شهادة" />--}}
{{--                            </div>--}}
{{--                            <p--}}
{{--                                class="font-tajawal font-medium text-lg text-[#141414] text-right leading-relaxed flex-1">--}}
{{--                                ماجيستير إدارة الأعمال MBA من معهد أستراليا لإدارة الأعمال Australian Institute of--}}
{{--                                Business عام 2012.--}}
{{--                            </p>--}}
{{--                        </div>--}}

{{--                        <!-- Education Item 3 -->--}}
{{--                        <div class="flex gap-4 items-start">--}}
{{--                            <div--}}
{{--                                class="flex-shrink-0 w-8 h-8 bg-[#E8ECF4] rounded-full flex items-center justify-center mt-1">--}}
{{--                                <img src="{{ asset('frontend/images') }}/course-details/certificate.png" alt="شهادة" />--}}
{{--                            </div>--}}
{{--                            <p--}}
{{--                                class="font-tajawal font-medium text-lg text-[#141414] text-right leading-relaxed flex-1">--}}
{{--                                دبلومة المحاسبة من أكاديمية "لوجيك"--}}
{{--                            </p>--}}
{{--                        </div>--}}

{{--                        <!-- Education Item 4 -->--}}
{{--                        <div class="flex gap-4 items-start">--}}
{{--                            <div--}}
{{--                                class="flex-shrink-0 w-8 h-8 bg-[#E8ECF4] rounded-full flex items-center justify-center mt-1">--}}
{{--                                <img src="{{ asset('frontend/images') }}/course-details/certificate.png" alt="شهادة" />--}}
{{--                            </div>--}}
{{--                            <p--}}
{{--                                class="font-tajawal font-medium text-lg text-[#141414] text-right leading-relaxed flex-1">--}}
{{--                                دبلومة التسويق من أكاديمية "نولدج".--}}
{{--                            </p>--}}
{{--                        </div>--}}

{{--                        <!-- Education Item 5 -->--}}
{{--                        <div class="flex gap-4 items-start">--}}
{{--                            <div--}}
{{--                                class="flex-shrink-0 w-8 h-8 bg-[#E8ECF4] rounded-full flex items-center justify-center mt-1">--}}
{{--                                <img src="{{ asset('frontend/images') }}/course-details/certificate.png" alt="شهادة" />--}}
{{--                            </div>--}}
{{--                            <p--}}
{{--                                class="font-tajawal font-medium text-lg text-[#141414] text-right leading-relaxed flex-1">--}}
{{--                                المستوي الأول من شهادة مدير محافظ مالية معتمد لدي هيئة سوق المال Certified portfolio--}}
{{--                                Manager من الجمعية المصرية لإدارة الاستثمار EIMA.--}}
{{--                            </p>--}}
{{--                        </div>--}}
                    </div>

                    <!-- Biography Text -->
{{--                    <div class="space-y-4">--}}
{{--                        <p class="font-tajawal font-medium text-lg text-[#141414] text-justify leading-relaxed">--}}
{{--                            اسس الباز أولى شركاته "كمبيوكاسل" Compu-Castle عام 1998، وكانت متخصصة في البرمجيات--}}
{{--                            والإنترنت، وفي عام 2002 أسس شركة "المؤشر للبرمجيات ونشر المعلومات" والتي تم ادراجها في--}}
{{--                            البورصة سنة 2010، كما أسس شركة "الرائد" لتكنولوجيا المعلومات في عام 2005.--}}
{{--                        </p>--}}
{{--                        <p class="font-tajawal font-medium text-lg text-[#141414] text-justify leading-relaxed">--}}
{{--                            تولى العديد من المناصب القيادية في شركاته المختلفة، وحقق نجاحات كبيرة في مجال التكنولوجيا--}}
{{--                            وريادة الأعمال. يُعتبر من رواد الأعمال البارزين في مصر والمنطقة العربية.--}}
{{--                        </p>--}}
{{--                    </div>--}}
                </div>


            </div>
        </div>
    </section>

    <!-- My Courses Section -->
    <section class="py-16 px-4 md:px-8 lg:px-16 bg-[#FDFDFF]" dir="rtl">
        <div class="max-w-7xl mx-auto">
            <!-- Section Title -->
            <h2 class="font-tajawal font-medium text-3xl text-[#344054] text-right mb-12">
                دوراتي (
                {{ $instructor->Courses()->count() }}
                )
            </h2>

            <!-- Course Cards Grid -->
            <div id="coursesGrid" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
                @foreach($instructor->Courses as $course)
                <!-- Course Card 1 -->
                <x-course-card :course="$course"/>
                @endforeach
                <!-- Course Card 2 -->
                <div class="course-card bg-[#FAFAFA] rounded-lg border border-[#EBEBEB] shadow-sm p-4 hover:shadow-md transition-shadow cursor-pointer"
                     data-title="تصميم جرافيك" data-category="تصميم" data-instructor="سارة أحمد"
                     data-description="دورة شاملة في تصميم الجرافيك باستخدام الأدوات الحديثة مثل فوتوشوب وإليستريتور"
                     onclick="window.location.href='course-details.html'">
                    <div class="relative mb-4">
                        <img src="{{ asset('frontend/images') }}/course-card.png" alt="Course Image"
                             class="w-full h-28 object-cover rounded-lg" />
                    </div>

                    <div class="space-y-3">
                        <span class="bg-[#5F43FB] text-[#FFF8EC] px-2 py-1 rounded-lg text-sm font-alexandria">
                            برمجيات
                        </span>

                        <h3 class="font-alexandria text-lg font-medium text-[#1C1C1C] text-right">
                            قانون العمل المصري
                        </h3>
                        <p class="font-alexandria text-sm text-[#757575] text-right leading-relaxed">
                            تتناول دورة مايكروسوفت أوفيس (دورة Microsoft Office) كافة
                            المبادئ و الأدوات التي المبادئ و الأدوات التي يجب استخ...
                        </p>

                        <div class="border-t border-[#EBEBEB] pt-3">
                            <div class="flex items-center justify-between mb-3">
                                <div class="flex items-center gap-2">
                                    <img src="https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=32&h=32&fit=crop&crop=face&auto=format"
                                         alt="تامر رمزي" class="w-8 h-8 rounded-full object-cover" />
                                    <div>
                                        <div class="font-alexandria text-sm font-medium text-[#202020]">
                                            تامر رمزي
                                        </div>
                                        <div class="font-alexandria text-xs text-[#202020]">
                                            مهندسة برمجيات
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="bg-[#F5F5F5] rounded-lg p-3 mb-3">
                                <div class="flex flex-row-reverse items-center justify-between text-sm">
                                    <div class="flex items-center gap-2">
                                        <svg class="w-5 h-5 text-[#2E2E2E]" fill="none" stroke="currentColor"
                                             viewBox="0 0 24 24">
                                            <circle cx="12" cy="12" r="10"></circle>
                                            <polyline points="12,6 12,12 16,14"></polyline>
                                        </svg>
                                        <span class="font-alexandria text-[#2E2E2E]">13 ساعة</span>
                                    </div>
                                    <div class="flex items-center gap-2">
                                        <svg class="w-5 h-5 text-[#2E2E2E]" fill="none" stroke="currentColor"
                                             viewBox="0 0 24 24">
                                            <path
                                                d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                            </path>
                                        </svg>
                                        <span class="font-alexandria text-[#2E2E2E]">30 محاضرات</span>
                                    </div>
                                </div>
                            </div>

                            <div class="flex flex-row-reverse items-center gap-3">
                                <button aria-label="Add to Wishlist"
                                        class="w-8 h-8 bg-[#FDEAEA] rounded-lg flex items-center justify-center"
                                        onclick="event.stopPropagation()">
                                    <svg class="w-5 h-5 text-[#EE3030]" fill="none" stroke="currentColor"
                                         viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                              d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z">
                                        </path>
                                    </svg>
                                </button>
                                <button
                                    class="flex-1 bg-[#00B34F] text-white py-2 px-4 rounded-lg font-alexandria font-medium hover:bg-[#00A047] transition-colors flex items-center justify-between gap-2"
                                    onclick="event.stopPropagation()">
                                    <span>اشترك الآن</span>
                                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                        <path
                                            d="M8.414 13.343L12.364 17.293C12.546 17.482 12.647 17.734 12.645 17.996C12.642 18.259 12.537 18.51 12.352 18.695C12.166 18.88 11.916 18.985 11.653 18.988C11.391 18.99 11.139 18.889 10.95 18.707L5.293 13.05C5.2 12.957 5.126 12.847 5.075 12.726C5.025 12.605 4.999 12.474 4.999 12.343C4.999 12.212 5.025 12.082 5.075 11.96C5.126 11.839 5.2 11.729 5.293 11.636L10.95 5.979C11.042 5.884 11.153 5.807 11.275 5.755C11.397 5.703 11.528 5.675 11.661 5.674C11.793 5.673 11.925 5.698 12.048 5.748C12.171 5.799 12.283 5.873 12.376 5.967C12.47 6.061 12.545 6.172 12.595 6.295C12.645 6.418 12.67 6.55 12.669 6.682C12.668 6.815 12.64 6.946 12.588 7.068C12.536 7.19 12.46 7.301 12.364 7.393L8.414 11.343H18C18.265 11.343 18.52 11.448 18.707 11.636C18.895 11.823 19 12.078 19 12.343C19 12.608 18.895 12.863 18.707 13.05C18.52 13.238 18.265 13.343 18 13.343H8.414Z" />
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Course Card 3 -->
                <div class="course-card bg-[#FAFAFA] rounded-lg border border-[#EBEBEB] shadow-sm p-4 hover:shadow-md transition-shadow cursor-pointer"
                     data-title="إدارة الأعمال" data-category="إدارة" data-instructor="محمد حسن"
                     data-description="أساسيات إدارة الأعمال وريادة الأعمال والتخطيط الاستراتيجي للشركات"
                     onclick="window.location.href='course-details.html'">
                    <div class="relative mb-4">
                        <img src="{{ asset('frontend/images') }}/course-card.png" alt="Course Image"
                             class="w-full h-28 object-cover rounded-lg" />
                    </div>

                    <div class="space-y-3">
                        <span class="bg-[#5F43FB] text-[#FFF8EC] px-2 py-1 rounded-lg text-sm font-alexandria">
                            برمجيات
                        </span>

                        <h3 class="font-alexandria text-lg font-medium text-[#1C1C1C] text-right">
                            قانون العمل المصري
                        </h3>
                        <p class="font-alexandria text-sm text-[#757575] text-right leading-relaxed">
                            تتناول دورة مايكروسوفت أوفيس (دورة Microsoft Office) كافة
                            المبادئ و الأدوات التي المبادئ و الأدوات التي يجب استخ...
                        </p>

                        <div class="border-t border-[#EBEBEB] pt-3">
                            <div class="flex items-center justify-between mb-3">
                                <div class="flex items-center gap-2">
                                    <img src="https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=32&h=32&fit=crop&crop=face&auto=format"
                                         alt="تامر رمزي" class="w-8 h-8 rounded-full object-cover" />
                                    <div>
                                        <div class="font-alexandria text-sm font-medium text-[#202020]">
                                            تامر رمزي
                                        </div>
                                        <div class="font-alexandria text-xs text-[#202020]">
                                            مهندسة برمجيات
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="bg-[#F5F5F5] rounded-lg p-3 mb-3">
                                <div class="flex flex-row-reverse items-center justify-between text-sm">
                                    <div class="flex items-center gap-2">
                                        <svg class="w-5 h-5 text-[#2E2E2E]" fill="none" stroke="currentColor"
                                             viewBox="0 0 24 24">
                                            <circle cx="12" cy="12" r="10"></circle>
                                            <polyline points="12,6 12,12 16,14"></polyline>
                                        </svg>
                                        <span class="font-alexandria text-[#2E2E2E]">13 ساعة</span>
                                    </div>
                                    <div class="flex items-center gap-2">
                                        <svg class="w-5 h-5 text-[#2E2E2E]" fill="none" stroke="currentColor"
                                             viewBox="0 0 24 24">
                                            <path
                                                d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                            </path>
                                        </svg>
                                        <span class="font-alexandria text-[#2E2E2E]">30 محاضرات</span>
                                    </div>
                                </div>
                            </div>

                            <div class="flex flex-row-reverse items-center gap-3">
                                <button class="w-8 h-8 bg-[#FDEAEA] rounded-lg flex items-center justify-center"
                                        onclick="event.stopPropagation()" aria-label="Add to Wishlist">
                                    <svg class="w-5 h-5 text-[#EE3030]" fill="none" stroke="currentColor"
                                         viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                              d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z">
                                        </path>
                                    </svg>
                                </button>
                                <button
                                    class="flex-1 bg-[#00B34F] text-white py-2 px-4 rounded-lg font-alexandria font-medium hover:bg-[#00A047] transition-colors flex items-center justify-between gap-2"
                                    onclick="event.stopPropagation()">
                                    <span>اشترك الآن</span>
                                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                        <path
                                            d="M8.414 13.343L12.364 17.293C12.546 17.482 12.647 17.734 12.645 17.996C12.642 18.259 12.537 18.51 12.352 18.695C12.166 18.88 11.916 18.985 11.653 18.988C11.391 18.99 11.139 18.889 10.95 18.707L5.293 13.05C5.2 12.957 5.126 12.847 5.075 12.726C5.025 12.605 4.999 12.474 4.999 12.343C4.999 12.212 5.025 12.082 5.075 11.96C5.126 11.839 5.2 11.729 5.293 11.636L10.95 5.979C11.042 5.884 11.153 5.807 11.275 5.755C11.397 5.703 11.528 5.675 11.661 5.674C11.793 5.673 11.925 5.698 12.048 5.748C12.171 5.799 12.283 5.873 12.376 5.967C12.47 6.061 12.545 6.172 12.595 6.295C12.645 6.418 12.67 6.55 12.669 6.682C12.668 6.815 12.64 6.946 12.588 7.068C12.536 7.19 12.46 7.301 12.364 7.393L8.414 11.343H18C18.265 11.343 18.52 11.448 18.707 11.636C18.895 11.823 19 12.078 19 12.343C19 12.608 18.895 12.863 18.707 13.05C18.52 13.238 18.265 13.343 18 13.343H8.414Z" />
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Course Card 4 -->
                <div class="course-card bg-[#FAFAFA] rounded-lg border border-[#EBEBEB] shadow-sm p-4 hover:shadow-md transition-shadow cursor-pointer"
                     data-title="التسويق الرقمي" data-category="تسويق" data-instructor="أمل محمود"
                     data-description="استراتيجيات التسويق الرقمي عبر الإنترنت ووسائل التواصل الاجتماعي"
                     onclick="window.location.href='course-details.html'">
                    <div class="relative mb-4">
                        <img src="{{ asset('frontend/images') }}/course-card.png" alt="Course Image"
                             class="w-full h-28 object-cover rounded-lg" />
                    </div>

                    <div class="space-y-3">
                        <span class="bg-[#5F43FB] text-[#FFF8EC] px-2 py-1 rounded-lg text-sm font-alexandria">
                            برمجيات
                        </span>

                        <h3 class="font-alexandria text-lg font-medium text-[#1C1C1C] text-right">
                            قانون العمل المصري
                        </h3>
                        <p class="font-alexandria text-sm text-[#757575] text-right leading-relaxed">
                            تتناول دورة مايكروسوفت أوفيس (دورة Microsoft Office) كافة
                            المبادئ و الأدوات التي المبادئ و الأدوات التي يجب استخ...
                        </p>

                        <div class="border-t border-[#EBEBEB] pt-3">
                            <div class="flex items-center justify-between mb-3">
                                <div class="flex items-center gap-2">
                                    <img src="https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=32&h=32&fit=crop&crop=face&auto=format"
                                         alt="تامر رمزي" class="w-8 h-8 rounded-full object-cover" />
                                    <div>
                                        <div class="font-alexandria text-sm font-medium text-[#202020]">
                                            تامر رمزي
                                        </div>
                                        <div class="font-alexandria text-xs text-[#202020]">
                                            مهندسة برمجيات
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="bg-[#F5F5F5] rounded-lg p-3 mb-3">
                                <div class="flex flex-row-reverse items-center justify-between text-sm">
                                    <div class="flex items-center gap-2">
                                        <svg class="w-5 h-5 text-[#2E2E2E]" fill="none" stroke="currentColor"
                                             viewBox="0 0 24 24">
                                            <circle cx="12" cy="12" r="10"></circle>
                                            <polyline points="12,6 12,12 16,14"></polyline>
                                        </svg>
                                        <span class="font-alexandria text-[#2E2E2E]">13 ساعة</span>
                                    </div>
                                    <div class="flex items-center gap-2">
                                        <svg class="w-5 h-5 text-[#2E2E2E]" fill="none" stroke="currentColor"
                                             viewBox="0 0 24 24">
                                            <path
                                                d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                            </path>
                                        </svg>
                                        <span class="font-alexandria text-[#2E2E2E]">30 محاضرات</span>
                                    </div>
                                </div>
                            </div>

                            <div class="flex flex-row-reverse items-center gap-3">
                                <button aria-label="Add to Wishlist"
                                        class="w-8 h-8 bg-[#FDEAEA] rounded-lg flex items-center justify-center"
                                        onclick="event.stopPropagation()">
                                    <svg class="w-5 h-5 text-[#EE3030]" fill="none" stroke="currentColor"
                                         viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                              d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z">
                                        </path>
                                    </svg>
                                </button>
                                <button
                                    class="flex-1 bg-[#00B34F] text-white py-2 px-4 rounded-lg font-alexandria font-medium hover:bg-[#00A047] transition-colors flex items-center justify-between gap-2"
                                    onclick="event.stopPropagation()">
                                    <span>اشترك الآن</span>
                                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                        <path
                                            d="M8.414 13.343L12.364 17.293C12.546 17.482 12.647 17.734 12.645 17.996C12.642 18.259 12.537 18.51 12.352 18.695C12.166 18.88 11.916 18.985 11.653 18.988C11.391 18.99 11.139 18.889 10.95 18.707L5.293 13.05C5.2 12.957 5.126 12.847 5.075 12.726C5.025 12.605 4.999 12.474 4.999 12.343C4.999 12.212 5.025 12.082 5.075 11.96C5.126 11.839 5.2 11.729 5.293 11.636L10.95 5.979C11.042 5.884 11.153 5.807 11.275 5.755C11.397 5.703 11.528 5.675 11.661 5.674C11.793 5.673 11.925 5.698 12.048 5.748C12.171 5.799 12.283 5.873 12.376 5.967C12.47 6.061 12.545 6.172 12.595 6.295C12.645 6.418 12.67 6.55 12.669 6.682C12.668 6.815 12.64 6.946 12.588 7.068C12.536 7.19 12.46 7.301 12.364 7.393L8.414 11.343H18C18.265 11.343 18.52 11.448 18.707 11.636C18.895 11.823 19 12.078 19 12.343C19 12.608 18.895 12.863 18.707 13.05C18.52 13.238 18.265 13.343 18 13.343H8.414Z" />
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Course Card 5 -->
                <div class="course-card bg-[#FAFAFA] rounded-lg border border-[#EBEBEB] shadow-sm p-4 hover:shadow-md transition-shadow cursor-pointer"
                     data-title="تحليل البيانات" data-category="برمجيات" data-instructor="أحمد علي"
                     data-description="تعلم تحليل البيانات باستخدام Excel وPython لاتخاذ قرارات مدروسة"
                     onclick="window.location.href='course-details.html'">
                    <div class="relative mb-4">
                        <img src="{{ asset('frontend/images') }}/course-card.png" alt="Course Image"
                             class="w-full h-28 object-cover rounded-lg" />
                    </div>

                    <div class="space-y-3">
                        <span class="bg-[#5F43FB] text-[#FFF8EC] px-2 py-1 rounded-lg text-sm font-alexandria">
                            برمجيات
                        </span>

                        <h3 class="font-alexandria text-lg font-medium text-[#1C1C1C] text-right">
                            قانون العمل المصري
                        </h3>
                        <p class="font-alexandria text-sm text-[#757575] text-right leading-relaxed">
                            تتناول دورة مايكروسوفت أوفيس (دورة Microsoft Office) كافة
                            المبادئ و الأدوات التي المبادئ و الأدوات التي يجب استخ...
                        </p>

                        <div class="border-t border-[#EBEBEB] pt-3">
                            <div class="flex items-center justify-between mb-3">
                                <div class="flex items-center gap-2">
                                    <img src="https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=32&h=32&fit=crop&crop=face&auto=format"
                                         alt="تامر رمزي" class="w-8 h-8 rounded-full object-cover" />
                                    <div>
                                        <div class="font-alexandria text-sm font-medium text-[#202020]">
                                            تامر رمزي
                                        </div>
                                        <div class="font-alexandria text-xs text-[#202020]">
                                            مهندسة برمجيات
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="bg-[#F5F5F5] rounded-lg p-3 mb-3">
                                <div class="flex flex-row-reverse items-center justify-between text-sm">
                                    <div class="flex items-center gap-2">
                                        <svg class="w-5 h-5 text-[#2E2E2E]" fill="none" stroke="currentColor"
                                             viewBox="0 0 24 24">
                                            <circle cx="12" cy="12" r="10"></circle>
                                            <polyline points="12,6 12,12 16,14"></polyline>
                                        </svg>
                                        <span class="font-alexandria text-[#2E2E2E]">13 ساعة</span>
                                    </div>
                                    <div class="flex items-center gap-2">
                                        <svg class="w-5 h-5 text-[#2E2E2E]" fill="none" stroke="currentColor"
                                             viewBox="0 0 24 24">
                                            <path
                                                d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                            </path>
                                        </svg>
                                        <span class="font-alexandria text-[#2E2E2E]">30 محاضرات</span>
                                    </div>
                                </div>
                            </div>

                            <div class="flex flex-row-reverse items-center gap-3">
                                <button class="w-8 h-8 bg-[#FDEAEA] rounded-lg flex items-center justify-center"
                                        onclick="event.stopPropagation()" aria-label="Add to Wishlist">
                                    <svg class="w-5 h-5 text-[#EE3030]" fill="none" stroke="currentColor"
                                         viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                              d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z">
                                        </path>
                                    </svg>
                                </button>
                                <button
                                    class="flex-1 bg-[#00B34F] text-white py-2 px-4 rounded-lg font-alexandria font-medium hover:bg-[#00A047] transition-colors flex items-center justify-between gap-2"
                                    onclick="event.stopPropagation()">
                                    <span>اشترك الآن</span>
                                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                        <path
                                            d="M8.414 13.343L12.364 17.293C12.546 17.482 12.647 17.734 12.645 17.996C12.642 18.259 12.537 18.51 12.352 18.695C12.166 18.88 11.916 18.985 11.653 18.988C11.391 18.99 11.139 18.889 10.95 18.707L5.293 13.05C5.2 12.957 5.126 12.847 5.075 12.726C5.025 12.605 4.999 12.474 4.999 12.343C4.999 12.212 5.025 12.082 5.075 11.96C5.126 11.839 5.2 11.729 5.293 11.636L10.95 5.979C11.042 5.884 11.153 5.807 11.275 5.755C11.397 5.703 11.528 5.675 11.661 5.674C11.793 5.673 11.925 5.698 12.048 5.748C12.171 5.799 12.283 5.873 12.376 5.967C12.47 6.061 12.545 6.172 12.595 6.295C12.645 6.418 12.67 6.55 12.669 6.682C12.668 6.815 12.64 6.946 12.588 7.068C12.536 7.19 12.46 7.301 12.364 7.393L8.414 11.343H18C18.265 11.343 18.52 11.448 18.707 11.636C18.895 11.823 19 12.078 19 12.343C19 12.608 18.895 12.863 18.707 13.05C18.52 13.238 18.265 13.343 18 13.343H8.414Z" />
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Course Card 6 -->
                <div class="course-card bg-[#FAFAFA] rounded-lg border border-[#EBEBEB] shadow-sm p-4 hover:shadow-md transition-shadow cursor-pointer"
                     data-title="إدارة الموارد البشرية" data-category="إدارة" data-instructor="فاطمة سعد"
                     data-description="أسس إدارة الموارد البشرية والتوظيف وتطوير الموظفين في الشركات"
                     onclick="window.location.href='course-details.html'">
                    <div class="relative mb-4">
                        <img src="{{ asset('frontend/images') }}/course-card.png" alt="Course Image"
                             class="w-full h-28 object-cover rounded-lg" />
                    </div>

                    <div class="space-y-3">
                        <span class="bg-[#5F43FB] text-[#FFF8EC] px-2 py-1 rounded-lg text-sm font-alexandria">
                            برمجيات
                        </span>

                        <h3 class="font-alexandria text-lg font-medium text-[#1C1C1C] text-right">
                            قانون العمل المصري
                        </h3>
                        <p class="font-alexandria text-sm text-[#757575] text-right leading-relaxed">
                            تتناول دورة مايكروسوفت أوفيس (دورة Microsoft Office) كافة
                            المبادئ و الأدوات التي المبادئ و الأدوات التي يجب استخ...
                        </p>

                        <div class="border-t border-[#EBEBEB] pt-3">
                            <div class="flex items-center justify-between mb-3">
                                <div class="flex items-center gap-2">
                                    <img src="https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=32&h=32&fit=crop&crop=face&auto=format"
                                         alt="تامر رمزي" class="w-8 h-8 rounded-full object-cover" />
                                    <div>
                                        <div class="font-alexandria text-sm font-medium text-[#202020]">
                                            تامر رمزي
                                        </div>
                                        <div class="font-alexandria text-xs text-[#202020]">
                                            مهندسة برمجيات
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="bg-[#F5F5F5] rounded-lg p-3 mb-3">
                                <div class="flex flex-row-reverse items-center justify-between text-sm">
                                    <div class="flex items-center gap-2">
                                        <svg class="w-5 h-5 text-[#2E2E2E]" fill="none" stroke="currentColor"
                                             viewBox="0 0 24 24">
                                            <circle cx="12" cy="12" r="10"></circle>
                                            <polyline points="12,6 12,12 16,14"></polyline>
                                        </svg>
                                        <span class="font-alexandria text-[#2E2E2E]">13 ساعة</span>
                                    </div>
                                    <div class="flex items-center gap-2">
                                        <svg class="w-5 h-5 text-[#2E2E2E]" fill="none" stroke="currentColor"
                                             viewBox="0 0 24 24">
                                            <path
                                                d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                            </path>
                                        </svg>
                                        <span class="font-alexandria text-[#2E2E2E]">30 محاضرات</span>
                                    </div>
                                </div>
                            </div>

                            <div class="flex flex-row-reverse items-center gap-3">
                                <button class="w-8 h-8 bg-[#FDEAEA] rounded-lg flex items-center justify-center"
                                        onclick="event.stopPropagation()" aria-label="Add to Wishlist">
                                    <svg class="w-5 h-5 text-[#EE3030]" fill="none" stroke="currentColor"
                                         viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                              d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z">
                                        </path>
                                    </svg>
                                </button>
                                <button
                                    class="flex-1 bg-[#00B34F] text-white py-2 px-4 rounded-lg font-alexandria font-medium hover:bg-[#00A047] transition-colors flex items-center justify-between gap-2"
                                    onclick="event.stopPropagation()">
                                    <span>اشترك الآن</span>
                                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                        <path
                                            d="M8.414 13.343L12.364 17.293C12.546 17.482 12.647 17.734 12.645 17.996C12.642 18.259 12.537 18.51 12.352 18.695C12.166 18.88 11.916 18.985 11.653 18.988C11.391 18.99 11.139 18.889 10.95 18.707L5.293 13.05C5.2 12.957 5.126 12.847 5.075 12.726C5.025 12.605 4.999 12.474 4.999 12.343C4.999 12.212 5.025 12.082 5.075 11.96C5.126 11.839 5.2 11.729 5.293 11.636L10.95 5.979C11.042 5.884 11.153 5.807 11.275 5.755C11.397 5.703 11.528 5.675 11.661 5.674C11.793 5.673 11.925 5.698 12.048 5.748C12.171 5.799 12.283 5.873 12.376 5.967C12.47 6.061 12.545 6.172 12.595 6.295C12.645 6.418 12.67 6.55 12.669 6.682C12.668 6.815 12.64 6.946 12.588 7.068C12.536 7.19 12.46 7.301 12.364 7.393L8.414 11.343H18C18.265 11.343 18.52 11.448 18.707 11.636C18.895 11.823 19 12.078 19 12.343C19 12.608 18.895 12.863 18.707 13.05C18.52 13.238 18.265 13.343 18 13.343H8.414Z" />
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Course Card 7 -->
                <div class="bg-[#FAFAFA] rounded-lg border border-[#EBEBEB] shadow-sm p-4 hover:shadow-md transition-shadow cursor-pointer"
                     onclick="window.location.href='course-details.html'">
                    <div class="relative mb-4">
                        <img src="{{ asset('frontend/images') }}/course-card.png" alt="Course Image"
                             class="w-full h-28 object-cover rounded-lg" />
                    </div>

                    <div class="space-y-3">
                        <span class="bg-[#5F43FB] text-[#FFF8EC] px-2 py-1 rounded-lg text-sm font-alexandria">
                            برمجيات
                        </span>

                        <h3 class="font-alexandria text-lg font-medium text-[#1C1C1C] text-right">
                            قانون العمل المصري
                        </h3>
                        <p class="font-alexandria text-sm text-[#757575] text-right leading-relaxed">
                            تتناول دورة مايكروسوفت أوفيس (دورة Microsoft Office) كافة
                            المبادئ و الأدوات التي المبادئ و الأدوات التي يجب استخ...
                        </p>

                        <div class="border-t border-[#EBEBEB] pt-3">
                            <div class="flex items-center justify-between mb-3">
                                <div class="flex items-center gap-2">
                                    <img src="https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=32&h=32&fit=crop&crop=face&auto=format"
                                         alt="تامر رمزي" class="w-8 h-8 rounded-full object-cover" />
                                    <div>
                                        <div class="font-alexandria text-sm font-medium text-[#202020]">
                                            تامر رمزي
                                        </div>
                                        <div class="font-alexandria text-xs text-[#202020]">
                                            مهندسة برمجيات
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="bg-[#F5F5F5] rounded-lg p-3 mb-3">
                                <div class="flex flex-row-reverse items-center justify-between text-sm">
                                    <div class="flex items-center gap-2">
                                        <svg class="w-5 h-5 text-[#2E2E2E]" fill="none" stroke="currentColor"
                                             viewBox="0 0 24 24">
                                            <circle cx="12" cy="12" r="10"></circle>
                                            <polyline points="12,6 12,12 16,14"></polyline>
                                        </svg>
                                        <span class="font-alexandria text-[#2E2E2E]">13 ساعة</span>
                                    </div>
                                    <div class="flex items-center gap-2">
                                        <svg class="w-5 h-5 text-[#2E2E2E]" fill="none" stroke="currentColor"
                                             viewBox="0 0 24 24">
                                            <path
                                                d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                            </path>
                                        </svg>
                                        <span class="font-alexandria text-[#2E2E2E]">30 محاضرات</span>
                                    </div>
                                </div>
                            </div>

                            <div class="flex flex-row-reverse items-center gap-3">
                                <button aria-label="Add to Wishlist"
                                        class="w-8 h-8 bg-[#FDEAEA] rounded-lg flex items-center justify-center"
                                        onclick="event.stopPropagation()">
                                    <svg class="w-5 h-5 text-[#EE3030]" fill="none" stroke="currentColor"
                                         viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                              d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z">
                                        </path>
                                    </svg>
                                </button>
                                <button
                                    class="flex-1 bg-[#00B34F] text-white py-2 px-4 rounded-lg font-alexandria font-medium hover:bg-[#00A047] transition-colors flex items-center justify-between gap-2"
                                    onclick="event.stopPropagation()">
                                    <span>اشترك الآن</span>
                                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                        <path
                                            d="M8.414 13.343L12.364 17.293C12.546 17.482 12.647 17.734 12.645 17.996C12.642 18.259 12.537 18.51 12.352 18.695C12.166 18.88 11.916 18.985 11.653 18.988C11.391 18.99 11.139 18.889 10.95 18.707L5.293 13.05C5.2 12.957 5.126 12.847 5.075 12.726C5.025 12.605 4.999 12.474 4.999 12.343C4.999 12.212 5.025 12.082 5.075 11.96C5.126 11.839 5.2 11.729 5.293 11.636L10.95 5.979C11.042 5.884 11.153 5.807 11.275 5.755C11.397 5.703 11.528 5.675 11.661 5.674C11.793 5.673 11.925 5.698 12.048 5.748C12.171 5.799 12.283 5.873 12.376 5.967C12.47 6.061 12.545 6.172 12.595 6.295C12.645 6.418 12.67 6.55 12.669 6.682C12.668 6.815 12.64 6.946 12.588 7.068C12.536 7.19 12.46 7.301 12.364 7.393L8.414 11.343H18C18.265 11.343 18.52 11.448 18.707 11.636C18.895 11.823 19 12.078 19 12.343C19 12.608 18.895 12.863 18.707 13.05C18.52 13.238 18.265 13.343 18 13.343H8.414Z" />
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Course Card 8 -->
                <div class="bg-[#FAFAFA] rounded-lg border border-[#EBEBEB] shadow-sm p-4 hover:shadow-md transition-shadow cursor-pointer"
                     onclick="window.location.href='course-details.html'">
                    <div class="relative mb-4">
                        <img src="{{ asset('frontend/images') }}/course-card.png" alt="Course Image"
                             class="w-full h-28 object-cover rounded-lg" />
                    </div>

                    <div class="space-y-3">
                        <span class="bg-[#5F43FB] text-[#FFF8EC] px-2 py-1 rounded-lg text-sm font-alexandria">
                            برمجيات
                        </span>

                        <h3 class="font-alexandria text-lg font-medium text-[#1C1C1C] text-right">
                            قانون العمل المصري
                        </h3>
                        <p class="font-alexandria text-sm text-[#757575] text-right leading-relaxed">
                            تتناول دورة مايكروسوفت أوفيس (دورة Microsoft Office) كافة
                            المبادئ و الأدوات التي المبادئ و الأدوات التي يجب استخ...
                        </p>

                        <div class="border-t border-[#EBEBEB] pt-3">
                            <div class="flex items-center justify-between mb-3">
                                <div class="flex items-center gap-2">
                                    <img src="https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=32&h=32&fit=crop&crop=face&auto=format"
                                         alt="تامر رمزي" class="w-8 h-8 rounded-full object-cover" />
                                    <div>
                                        <div class="font-alexandria text-sm font-medium text-[#202020]">
                                            تامر رمزي
                                        </div>
                                        <div class="font-alexandria text-xs text-[#202020]">
                                            مهندسة برمجيات
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="bg-[#F5F5F5] rounded-lg p-3 mb-3">
                                <div class="flex flex-row-reverse items-center justify-between text-sm">
                                    <div class="flex items-center gap-2">
                                        <svg class="w-5 h-5 text-[#2E2E2E]" fill="none" stroke="currentColor"
                                             viewBox="0 0 24 24">
                                            <circle cx="12" cy="12" r="10"></circle>
                                            <polyline points="12,6 12,12 16,14"></polyline>
                                        </svg>
                                        <span class="font-alexandria text-[#2E2E2E]">13 ساعة</span>
                                    </div>
                                    <div class="flex items-center gap-2">
                                        <svg class="w-5 h-5 text-[#2E2E2E]" fill="none" stroke="currentColor"
                                             viewBox="0 0 24 24">
                                            <path
                                                d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                            </path>
                                        </svg>
                                        <span class="font-alexandria text-[#2E2E2E]">30 محاضرات</span>
                                    </div>
                                </div>
                            </div>

                            <div class="flex flex-row-reverse items-center gap-3">
                                <button class="w-8 h-8 bg-[#FDEAEA] rounded-lg flex items-center justify-center"
                                        onclick="event.stopPropagation()" aria-label="Add to Wishlist">
                                    <svg class="w-5 h-5 text-[#EE3030]" fill="none" stroke="currentColor"
                                         viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                              d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z">
                                        </path>
                                    </svg>
                                </button>
                                <button
                                    class="flex-1 bg-[#00B34F] text-white py-2 px-4 rounded-lg font-alexandria font-medium hover:bg-[#00A047] transition-colors flex items-center justify-between gap-2"
                                    onclick="event.stopPropagation()">
                                    <span>اشترك الآن</span>
                                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                        <path
                                            d="M8.414 13.343L12.364 17.293C12.546 17.482 12.647 17.734 12.645 17.996C12.642 18.259 12.537 18.51 12.352 18.695C12.166 18.88 11.916 18.985 11.653 18.988C11.391 18.99 11.139 18.889 10.95 18.707L5.293 13.05C5.2 12.957 5.126 12.847 5.075 12.726C5.025 12.605 4.999 12.474 4.999 12.343C4.999 12.212 5.025 12.082 5.075 11.96C5.126 11.839 5.2 11.729 5.293 11.636L10.95 5.979C11.042 5.884 11.153 5.807 11.275 5.755C11.397 5.703 11.528 5.675 11.661 5.674C11.793 5.673 11.925 5.698 12.048 5.748C12.171 5.799 12.283 5.873 12.376 5.967C12.47 6.061 12.545 6.172 12.595 6.295C12.645 6.418 12.67 6.55 12.669 6.682C12.668 6.815 12.64 6.946 12.588 7.068C12.536 7.19 12.46 7.301 12.364 7.393L8.414 11.343H18C18.265 11.343 18.52 11.448 18.707 11.636C18.895 11.823 19 12.078 19 12.343C19 12.608 18.895 12.863 18.707 13.05C18.52 13.238 18.265 13.343 18 13.343H8.414Z" />
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>
    </section>
@endsection
@push('footerScript')
@endpush
