@extends('frontend.layouts.app')
@section('meta')
    <title></title>
@endsection
@push('headScript')
@endpush
@section('content')
    <!-- Hero Section -->
    <div
        class="relative overflow-hidden"
        style="box-shadow: 0 4px 4px rgba(0, 0, 0, 0.25)"
    >
        <!-- Background Image -->
        <div class="absolute inset-0">
            <img
                src="{{ asset('frontend/images/hero-background-1.svg') }}"
                alt="Background"
                class="w-full h-full object-cover"
            />
        </div>

        <!-- Background Ellipses -->
        <div class="absolute inset-0">
            <img
                src="{{ asset('frontend/images/hero-background.png') }}"
                alt="Background Ellipses"
                class="absolute -top-96 -left-96 w-[1179px] h-[1101px] object-contain"
            />
        </div>

        <!-- Team Image -->
        <div class="absolute left-0 bottom-0">
            <img
                src="{{ asset('frontend/images/team.png') }}"
                alt="Team"
                class="w-[780px] h-[500px] object-cover"
                style="margin-left: -112px; margin-bottom: 0px"
            />
        </div>

        <!-- Wave at bottom -->
        <div class="absolute bottom-0 left-0 w-full">
            <svg
                class="w-full h-52"
                viewBox="0 0 1594 171"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
                preserveAspectRatio="none"
            >
                <path
                    fill-rule="evenodd"
                    clip-rule="evenodd"
                    d="M0 79.458C0 79.458 226.389 186.741 381.052 178.06C535.714 169.378 628.364 133.594 798.309 151.486C968.253 169.378 1461.17 124.238 1600 0V209.034H0V79.458Z"
                    fill="#FDFDFF"
                />
            </svg>
        </div>

        <!-- Content Container -->
        <div
            class="relative z-10 pt-32 pb-32 px-4 md:px-8 lg:px-16"
            style="min-height: 808px"
        >
            <div class="max-w-full text-right space-y-6" style="margin-top: 80px">
                <!-- Main Title and Feature Words -->
                <div class="flex items-start gap-8">
                    <!-- Main Title -->
                    <h1
                        class="font-alexandria font-bold text-[#FAFAFA]"
                        style="
                font-size: 64px;
                line-height: 80px;
                letter-spacing: -2px;
                min-width: 335px;
              "
                    >
                        طوّر فريقك
                    </h1>

                    <!-- Animated part of the heading -->
                    <div
                        class="word-slider text-[#00B34F] font-alexandria font-bold"
                        style="
                font-size: 64px;
                line-height: 85px;
                letter-spacing: -2px;
                overflow: hidden;
              "
                    >
                        <div class="word-animator">
                            <!-- The words that will be animated -->
                            <span style="padding-right: 37px">بمهارات حديثة</span>
                            <span style="padding-right: 94px">تدريب فعال</span>
                            <span>محتوي تفاعلي</span>
                            <span style="padding-right: 64px">تعلم مستمر</span>
                            <span>دعم متخصص</span>
                            <!-- The first word is duplicated at the end for a seamless loop -->
                            <span style="padding-right: 37px">بمهارات حديثة</span>
                        </div>
                    </div>
                </div>

                <!-- Description -->
                <p
                    class="font-alexandria text-[1.2rem] text-[#DEDEDE] leading-tight max-w-3xl"
                    style="line-height: 52px; letter-spacing: -2px"
                >
                    منصة اعمل بيزنس تساعد شركتك على تدريب موظفيها من خلال دبلومات
                    احترافية، ولوحات متابعة لحظية لأداء وتقدم الفرق — كل ذلك بشهادات
                    معترف بها دوليًا.
                </p>

                <!-- Check Items -->
                <div class="flex-col flex-wrap gap-4 justify-start max-w-3xl">
                    <div class="flex items-center gap-2">
                        <img
                            src="{{ asset('frontend/images/hero-check-icon.png') }}"
                            alt="Check"
                            class="w-5 h-5"
                        />

                        <span class="font-alexandria text-[#E6F7ED] text-lg"
                        >سعر يناسب حجم شركتك واحتياجاتك</span
                        >
                    </div>
                    <div class="flex items-center gap-2">
                        <div
                            class="w-5 h-5 rounded-full bg-[#00B207] flex items-center justify-center"
                        >
                            <svg
                                width="13"
                                height="13"
                                viewBox="0 0 13 13"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                            >
                                <path
                                    d="M10.4349 3.125L4.70573 8.85417L2.10156 6.25"
                                    stroke="white"
                                    stroke-width="1.5"
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                />
                            </svg>
                        </div>

                        <span class="font-alexandria text-[#E6F7ED] text-lg"
                        >دعم مخصص وتكامل سهل مع شركتك</span
                        >
                    </div>
                    <div class="flex items-center gap-2">
                        <div
                            class="w-5 h-5 rounded-full bg-[#00B207] flex items-center justify-center"
                        >
                            <svg
                                width="13"
                                height="13"
                                viewBox="0 0 13 13"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                            >
                                <path
                                    d="M10.4349 3.125L4.70573 8.85417L2.10156 6.25"
                                    stroke="white"
                                    stroke-width="1.5"
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                />
                            </svg>
                        </div>

                        <span class="font-alexandria text-[#E6F7ED] text-lg"
                        >لوحة تحكم لمتابعة أداء الموظفين
              </span>
                    </div>
                </div>

                <!-- CTA Button -->
                <div class="pt-4">
                    <button
                        class="flex items-center gap-3 px-6 py-3 bg-[#00B34F] border border-[#00B34F] rounded-lg text-white font-alexandria font-medium hover:bg-[#00A047] transition-colors"
                    >
                        <span class="text-base">احجز عرضًا توضيحيًا الآن </span>
                        <svg
                            width="24"
                            height="24"
                            viewBox="0 0 24 24"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                        >
                            <path
                                d="M8.414 13.3431L12.364 17.2931C12.5462 17.4817 12.647 17.7343 12.6447 17.9965C12.6424 18.2587 12.5372 18.5095 12.3518 18.6949C12.1664 18.8803 11.9156 18.9855 11.6534 18.9878C11.3912 18.99 11.1386 18.8892 10.95 18.7071L5.293 13.0501C5.19982 12.9574 5.12587 12.8473 5.07541 12.7259C5.02494 12.6046 4.99897 12.4745 4.99897 12.3431C4.99897 12.2117 5.02494 12.0816 5.07541 11.9602C5.12587 11.8389 5.19982 11.7287 5.293 11.6361L10.95 5.97908C11.0422 5.88357 11.1526 5.80739 11.2746 5.75498C11.3966 5.70257 11.5278 5.67498 11.6606 5.67383C11.7934 5.67268 11.9251 5.69798 12.048 5.74826C12.1709 5.79854 12.2825 5.87279 12.3764 5.96669C12.4703 6.06058 12.5445 6.17223 12.5948 6.29513C12.6451 6.41802 12.6704 6.5497 12.6693 6.68248C12.6681 6.81526 12.6405 6.94648 12.5881 7.06849C12.5357 7.19049 12.4595 7.30083 12.364 7.39308L8.414 11.3431H18C18.2652 11.3431 18.5196 11.4484 18.7071 11.636C18.8946 11.8235 19 12.0779 19 12.3431C19 12.6083 18.8946 12.8627 18.7071 13.0502C18.5196 13.2377 18.2652 13.3431 18 13.3431H8.414Z"
                                fill="white"
                            />
                        </svg>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Section -->
    <div class="py-16 px-6 md:px-8 lg:px-16 relative" dir="rtl">
        <div
            class="max-w-7xl mx-auto lg:absolute inset-0 flex items-center justify-center top-[-80px]"
        >
            <!-- Statistics Container -->
            <div class="bg-[#F2F4F9] rounded-lg py-8 px-6 md:px-12">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-8 items-center">
                    <!-- Stat 1 - 40% -->
                    <div class="flex flex-col items-center text-center">
                        <div class="mb-3">
                            <div
                                class="text-6xl font-bold text-[#144394] font-alexandria"
                                style="line-height: 72px; letter-spacing: -1.2px"
                            >
                                40%
                            </div>
                        </div>
                        <div class="space-y-2">
                            <h3
                                class="font-alexandria text-lg font-medium text-[#1C1C1C]"
                                style="line-height: 28px"
                            >
                                تفوق في محتوي الاكاديمية
                            </h3>
                            <p
                                class="font-alexandria text-base text-[#757575]"
                                style="line-height: 24px"
                            >
                                نحن نتفوق بنسبة 40٪ في تنوع المحتوى لأننا نقدم أكثر من 400+
                                دورة في جميع المجالات
                            </p>
                        </div>
                    </div>

                    <!-- Stat 2 - 50% -->
                    <div class="flex flex-col items-center text-center">
                        <div class="mb-3">
                            <div
                                class="text-6xl font-bold text-[#144394] font-alexandria"
                                style="line-height: 72px; letter-spacing: -1.2px"
                            >
                                50%
                            </div>
                        </div>
                        <div class="space-y-2">
                            <h3
                                class="font-alexandria text-lg font-medium text-[#1C1C1C]"
                                style="line-height: 28px"
                            >
                                اقل سعرا في السوق
                            </h3>
                            <p
                                class="font-alexandria text-base text-[#757575]"
                                style="line-height: 24px"
                            >
                                أقل بنسبة 50٪ مقارنة بالسوق، مع تقديم نفس الجودة وأكثر من 400
                                دورة تدريبية
                            </p>
                        </div>
                    </div>

                    <!-- Stat 3 - 70% -->
                    <div class="flex flex-col items-center text-center">
                        <div class="mb-3">
                            <div
                                class="text-6xl font-bold text-[#144394] font-alexandria"
                                style="line-height: 72px; letter-spacing: -1.2px"
                            >
                                70%
                            </div>
                        </div>
                        <div class="space-y-2">
                            <h3
                                class="font-alexandria text-lg font-medium text-[#1C1C1C]"
                                style="line-height: 28px"
                            >
                                تأثيرا في التعليم الإلكتروني
                            </h3>
                            <p
                                class="font-alexandria text-base text-[#757575]"
                                style="line-height: 24px"
                            >
                                برامجنا حققت تأثيرًا ملموسًا في التعليم<br />الإلكتروني، مما
                                ساعد الشركات على تطوير فرقها بكفاءة أعلى
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Industries/Fields Section -->
    <div class="bg-white lg:py-16 py-8  px-4 md:px-8 lg:px-16 mt-14" dir="rtl">
        <div class="max-w-7xl mx-auto">
            <div class="flex flex-col items-center gap-8 lg:gap-12">
                <!-- Section Title -->
                <h2
                    class="font-alexandria text-3xl md:text-4xl lg:text-5xl font-semibold text-[#2E2E2E] text-center leading-tight"
                >
                    استكشف جميع مجالاتنا
                </h2>

                <!-- Cards Grid -->
                <div
                    class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 w-full"
                >
                    @foreach($categories as $category)
                    <!-- Card {{ $loop->index+1}} - {{ $category->name }} -->
                    <div
                        class="relative bg-white rounded-lg border border-[#DEDEDE] shadow-sm hover:shadow-md transition-shadow h-[351px]"
                    >
                        <!-- Background Graphics -->
                        <div class="absolute top-0 left-0 overflow-hidden">
                            <svg
                                width="130"
                                height="158"
                                viewBox="0 0 130 158"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                            >
                                <ellipse
                                    opacity="0.0361096"
                                    cx="-31.8092"
                                    cy="29.2682"
                                    rx="72.8676"
                                    ry="68.0729"
                                    fill="#5AFF91"
                                />
                                <ellipse
                                    opacity="0.0458287"
                                    cx="-33.075"
                                    cy="26.9039"
                                    rx="104.142"
                                    ry="97.23"
                                    fill="#5AFF91"
                                />
                                <ellipse
                                    opacity="0.050665"
                                    cx="-12"
                                    cy="24.5972"
                                    rx="142"
                                    ry="132.597"
                                    fill="#BDFFC4"
                                />
                            </svg>
                        </div>

                        <!-- Product Image -->
                        <div class="relative p-4 flex justify-center">
                            <img
                                src="{{ asset($category->icon) }}"
                                alt="E3 Business"
                                class="w-24 h-24 object-contain"
                            />

                            <!-- Badge -->
                            <div class="absolute top-4 right-4">
                                <div
                                    class="{{ $category->badge_class }} px-2 py-1 rounded-full text-xs font-medium"
                                >
                                   {{ $category->badge }}
                                </div>
                            </div>
                        </div>

                        <!-- Content Container -->
                        <div
                            class="absolute bottom-0 left-0 right-0 bg-[#F2F4F9] rounded-t-3xl p-4 shadow-lg border-t"
                        >
                            <div class="space-y-4 text-center">
                                <div class="flex flex-col justify-center items-center">
                                    <h3
                                        class="font-alexandria text-base font-medium text-[#144394] mb-2"
                                    >
                                        {{ $category->name }}
                                    </h3>
                                    <p
                                        class="font-alexandria text-sm text-[#3B3B3B] leading-relaxed w-2/3"
                                    >
                                      {{ $category->description }}
                                    </p>
                                </div>

                                <a href="{{ route('category_courses_page',$category->url) }}"
                                    class="flex items-center justify-center gap-2 w-full p-3 text-[#144394] hover:bg-gray-50 transition-colors"
                                >
                    <span class="font-alexandria text-sm font-medium underline"
                    >تصفح جميع الدورات</span
                    >
                                    <svg
                                        width="24"
                                        height="24"
                                        viewBox="0 0 25 24"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                    >
                                        <path
                                            d="M8.914 13.3431L12.864 17.2931C13.0462 17.4817 13.147 17.7343 13.1447 17.9965C13.1424 18.2587 13.0372 18.5095 12.8518 18.6949C12.6664 18.8803 12.4156 18.9855 12.1534 18.9878C11.8912 18.99 11.6386 18.8892 11.45 18.7071L5.793 13.0501C5.69982 12.9574 5.62587 12.8473 5.57541 12.7259C5.52494 12.6046 5.49897 12.4745 5.49897 12.3431C5.49897 12.2117 5.52494 12.0816 5.57541 11.9602C5.62587 11.8389 5.69982 11.7287 5.793 11.6361L11.45 5.97908C11.5422 5.88357 11.6526 5.80739 11.7746 5.75498C11.8966 5.70257 12.0278 5.67498 12.1606 5.67383C12.2934 5.67268 12.4251 5.69798 12.548 5.74826C12.6709 5.79854 12.7825 5.87279 12.8764 5.96669C12.9703 6.06058 13.0445 6.17223 13.0948 6.29513C13.1451 6.41802 13.1704 6.5497 13.1693 6.68248C13.1681 6.81526 13.1405 6.94648 13.0881 7.06849C13.0357 7.19049 12.9595 7.30083 12.864 7.39308L8.914 11.3431H18.5C18.7652 11.3431 19.0196 11.4484 19.2071 11.636C19.3946 11.8235 19.5 12.0779 19.5 12.3431C19.5 12.6083 19.3946 12.8627 19.2071 13.0502C19.0196 13.2377 18.7652 13.3431 18.5 13.3431H8.914Z"
                                            fill="#144394"
                                        />
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>

    <!-- Client Logos Section -->
    <div class="bg-[#F4F7FA] py-16 px-4 md:px-8 lg:px-16">
        <div class="max-w-7xl mx-auto">
            <div
                class="flex flex-col lg:flex-row-reverse items-center lg:items-start gap-12 lg:gap-16"
            >
                <!-- Content -->
                <div
                    class="flex flex-col items-start text-right gap-6 lg:gap-8 flex-1 order-1 lg:order-2"
                >
                    <!-- Title -->
                    <div
                        class="font-alexandria text-lg font-semibold text-[#144394] text-right"
                    >
                        عملاؤنا المميزون
                    </div>

                    <!-- Subtitle -->
                    <h2
                        class="font-alexandria text-3xl md:text-4xl lg:text-5xl font-semibold text-[#2E2E2E] text-right line-height: 2.5 md:leading-tight lg:leading-tight"
                    >
                        انضم إلى الشركات الرائدة التي تعتمد علينا لتطوير مهارات موظفيها
                    </h2>

                    <!-- CTA Button -->
                    <button
                        class="flex items-center gap-4 px-6 py-3 bg-brand-success border border-brand-success rounded-lg hover:bg-brand-secondary-normal transition-colors"
                    >
              <span
                  class="font-alexandria text-white font-medium text-sm md:text-base"
              >
                احجز عرضًا توضيحيًا الآن
              </span>
                        <svg
                            width="24"
                            height="24"
                            viewBox="0 0 24 25"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                        >
                            <path
                                d="M8.41394 13.843L12.3639 17.793C12.5461 17.9816 12.6469 18.2342 12.6446 18.4964C12.6423 18.7586 12.5372 19.0094 12.3518 19.1948C12.1663 19.3802 11.9155 19.4854 11.6533 19.4876C11.3911 19.4899 11.1385 19.3891 10.9499 19.207L5.29294 13.55C5.19975 13.4573 5.1258 13.3471 5.07534 13.2258C5.02488 13.1045 4.99891 12.9744 4.99891 12.843C4.99891 12.7116 5.02488 12.5814 5.07534 12.4601C5.1258 12.3388 5.19975 12.2286 5.29294 12.136L10.9499 6.47896C11.0422 6.38345 11.1525 6.30727 11.2745 6.25486C11.3965 6.20245 11.5278 6.17486 11.6605 6.17371C11.7933 6.17255 11.925 6.19786 12.0479 6.24814C12.1708 6.29842 12.2824 6.37267 12.3763 6.46656C12.4702 6.56046 12.5445 6.67211 12.5948 6.795C12.645 6.9179 12.6703 7.04958 12.6692 7.18236C12.668 7.31514 12.6404 7.44636 12.588 7.56836C12.5356 7.69037 12.4594 7.80071 12.3639 7.89296L8.41394 11.843H17.9999C18.2652 11.843 18.5195 11.9483 18.707 12.1359C18.8946 12.3234 18.9999 12.5777 18.9999 12.843C18.9999 13.1082 18.8946 13.3625 18.707 13.5501C18.5195 13.7376 18.2652 13.843 17.9999 13.843H8.41394Z"
                                fill="white"
                            />
                        </svg>
                    </button>
                </div>

                <!-- Logos Grid -->
                <div
                    class="grid grid-cols-3 gap-0 w-full max-w-md lg:max-w-lg order-2 lg:order-1"
                >
                    <!-- Row 1 -->
                    <div
                        class="border border-[#B6C5DE] bg-[#E8ECF4] p-6 flex items-center justify-center min-h-[120px]"
                    >
                        <img
                            src="{{ asset('frontend') }}/images/client-logo-1.png"
                            alt="Client Logo"
                            class="max-w-full max-h-full object-contain"
                        />
                    </div>
                    <div
                        class="border border-[#B6C5DE] bg-[#E8ECF4] p-6 flex items-center justify-center min-h-[120px]"
                    >
                        <img
                            src="{{ asset('frontend') }}/images/client-logo-2.png"
                            alt="Client Logo"
                            class="max-w-full max-h-full object-contain"
                        />
                    </div>
                    <div
                        class="border border-[#B6C5DE] bg-[#E8ECF4] p-6 flex items-center justify-center min-h-[120px]"
                    >
                        <img
                            src="{{ asset('frontend') }}/images/client-logo-3.png"
                            alt="Client Logo"
                            class="max-w-full max-h-full object-contain"
                        />
                    </div>

                    <!-- Row 2 -->
                    <div
                        class="border border-[#B6C5DE] bg-[#E8ECF4] p-6 flex items-center justify-center min-h-[120px]"
                    >
                        <img
                            src="{{ asset('frontend') }}/images/client-logo-4.png"
                            alt="Client Logo"
                            class="max-w-full max-h-full object-contain"
                        />
                    </div>
                    <div
                        class="border border-[#B6C5DE] bg-[#E8ECF4] p-6 flex items-center justify-center min-h-[120px]"
                    >
                        <img
                            src="{{ asset('frontend') }}/images/client-logo-5.png"
                            alt="Client Logo"
                            class="max-w-full max-h-full object-contain"
                        />
                    </div>
                    <div
                        class="border border-[#B6C5DE] bg-[#E8ECF4] p-6 flex items-center justify-center min-h-[120px]"
                    >
                        <img
                            src="{{ asset('frontend') }}/images/client-logo-4.png"
                            alt="Client Logo"
                            class="max-w-full max-h-full object-contain"
                        />
                    </div>

                    <!-- Row 3 -->
                    <div
                        class="border border-[#B6C5DE] bg-[#E8ECF4] p-6 flex items-center justify-center min-h-[120px]"
                    >
                        <img
                            src="{{ asset('frontend') }}/images/client-logo-6.png"
                            alt="Client Logo"
                            class="max-w-full max-h-full object-contain"
                        />
                    </div>
                    <div
                        class="border border-[#B6C5DE] bg-[#E8ECF4] p-6 flex items-center justify-center min-h-[120px]"
                    >
                        <img
                            src="{{ asset('frontend') }}/images/client-logo-6.png"
                            alt="Client Logo"
                            class="max-w-full max-h-full object-contain"
                        />
                    </div>
                    <div
                        class="border border-[#B6C5DE] bg-[#E8ECF4] p-6 flex items-center justify-center min-h-[120px]"
                    >
                        <img
                            src="{{ asset('frontend') }}/images/client-logo-5.png"
                            alt="Client Logo"
                            class="max-w-full max-h-full object-contain"
                        />
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Features Section -->

    <div class="bg-white py-16 lg:py-24 px-4 md:px-8 lg:px-16" dir="rtl">
        <div class="max-w-7xl mx-auto">
            <div class="flex flex-col items-start gap-10 lg:gap-16">
                <!-- Section Header -->
                <div class="flex flex-col items-start gap-2 text-right">
                    <div class="font-alexandria text-lg font-semibold text-[#144394]">
                        اهم ما نتميز به
                    </div>
                    <h2
                        class="font-alexandria text-3xl md:text-4xl lg:text-5xl font-medium text-[#1C1C1C] leading-tight max-w-4xl"
                    >
                        كل ما تحتاجه لتدريب ومتابعة أداء فريقك بسهولة
                    </h2>
                    <p
                        class="font-alexandria text-lg text-[#4A4A4A] leading-relaxed max-w-3xl mt-2"
                    >
                        كل ما تحتاجه لتخصيص الدورات، متابعة الأداء، وضمان نتائج تدريب
                        ملموسة — في مكان واحد.
                    </p>
                </div>

                <!-- Main Content -->
                <div
                    class="flex flex-col lg:flex-row items-center gap-12 lg:gap-16 w-full"
                >
                    <!-- Screen Mockup -->
                    <div
                        class="relative w-full max-w-lg lg:max-w-xl order-2 lg:order-2"
                    >
                        <div class="relative">
                            <!-- Shadow -->
                            <div
                                class="absolute top-16 left-1 w-[92%] h-[68%] bg-[#101828] rounded-lg shadow-2xl opacity-20"
                            ></div>
                            <!-- Main Image -->
                            <img
                                src="{{ asset('frontend') }}/images/dashboard-preview.png"
                                alt="Dashboard Preview"
                                class="relative w-full h-auto rounded-lg border border-[#F2F4F7] shadow-lg"
                            />
                        </div>
                    </div>

                    <!-- Features List -->
                    <div class="w-full lg:max-w-2xl order-1 lg:order-1">
                        <div class="space-y-6">
                            <!-- Feature 1 - Active -->
                            <div class="relative">
                                <div
                                    class="bg-[#DCE3EF] rounded-lg shadow-md border-r-4 border-[#144394] p-6"
                                >
                                    <div class="text-right">
                                        <h3
                                            class="font-alexandria text-lg font-medium text-[#144394] mb-2"
                                        >
                                            لوحات تحكم تحليلية شاملة
                                        </h3>
                                        <p
                                            class="font-alexandria text-base text-[#0C2859] leading-relaxed"
                                        >
                                            احصل على نظرة فورية لأداء الموظفين ونتائجهم التدريبية
                                            عبر تقارير مرئية مفصّلة
                                        </p>
                                    </div>
                                </div>
                            </div>

                            <!-- Feature 2 -->
                            <div class="relative">
                                <div
                                    class="bg-white rounded-lg border-r-4 border-[#E8ECF4] p-6 hover:bg-gray-50 transition-colors cursor-pointer"
                                >
                                    <div class="text-right">
                                        <h3
                                            class="font-alexandria text-lg font-medium text-[#2E2E2E] mb-2"
                                        >
                                            تعيين الدورات حسب الفريق أو الموظف
                                        </h3>
                                        <p
                                            class="font-alexandria text-base text-[#4A4A4A] leading-relaxed"
                                        >
                                            سهولة في تخصيص الدبلومات التدريبية لكل موظف حسب الاحتياج
                                            والوظيفة
                                        </p>
                                    </div>
                                </div>
                            </div>

                            <!-- Feature 3 -->
                            <div class="relative">
                                <div
                                    class="bg-white rounded-lg border-r-4 border-[#E8ECF4] p-6 hover:bg-gray-50 transition-colors cursor-pointer"
                                >
                                    <div class="text-right">
                                        <h3
                                            class="font-alexandria text-lg font-medium text-[#2E2E2E] mb-2"
                                        >
                                            متابعة تطوّر كل موظف لحظيًا
                                        </h3>
                                        <p
                                            class="font-alexandria text-base text-[#4A4A4A] leading-relaxed"
                                        >
                                            راقب تقدم الفرق ونجاح كل موظف على مستوى كل دورة تدريبية
                                        </p>
                                    </div>
                                </div>
                            </div>

                            <!-- Feature 4 -->
                            <div class="relative">
                                <div
                                    class="bg-white rounded-lg border-r-4 border-[#E8ECF4] p-6 hover:bg-gray-50 transition-colors cursor-pointer"
                                >
                                    <div class="text-right">
                                        <h3
                                            class="font-alexandria text-lg font-medium text-[#2E2E2E] mb-2"
                                        >
                                            صلاحيات مخصصة لكل مستخدم
                                        </h3>
                                        <p
                                            class="font-alexandria text-base text-[#4A4A4A] leading-relaxed"
                                        >
                                            وصول آمن ومنفصل لكل من المدير والموظف لعرض المحتوى
                                            والمعلومات المناسبة
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Training Fields Section -->
    <div
        class="bg-[#F2F4F9] py-16 lg:pb-[140px] lg:pt-[180px] px-4 md:px-8 lg:px-16 relative overflow-hidden"
        dir="rtl"
    >
        <!-- Decorative dots pattern -->
        <div class="absolute -top-6 -left-12 opacity-20">
            <img
                src="{{ asset('frontend') }}/images/decorative-dots.svg"
                alt="Decorative Dots"
                class="w-[141px] h-auto"
            />
        </div>

        <div
            class="grid grid-cols-1 lg:grid-cols-2 gap-12 lg:gap-16 items-center"
        >
            <!-- Responsive Image Grid -->
            <div
                class="grid grid-cols-1 md:grid-cols-2 gap-6 lg:gap-8 order-2 lg:order-2"
            >
                <!-- Digital Marketing Card -->
                <div
                    class="relative group overflow-hidden rounded-lg h-80 md:h-96 lg:h-[420px]"
                >
                    <div
                        class="absolute inset-0 bg-gradient-to-b from-black/20 to-black/35 transition-all duration-300 group-hover:from-black/10 group-hover:to-black/25"
                        style="
                            background-image: url('{{ asset('frontend') }}/images/digital-marketing-course.png');
                            background-size: cover;
                            background-position: center;
                            "
                    ></div>
                    <div class="absolute inset-0 flex items-center justify-center">
                        <h3
                            class="font-alexandria font-bold text-2xl md:text-3xl lg:text-4xl text-[#E8ECF4] text-center leading-tight px-6 transform transition-transform duration-300 group-hover:scale-105"
                        >
                            التسويق<br />الإلكتروني
                        </h3>
                    </div>
                </div>

                <!-- Artificial Intelligence Card -->
                <div
                    class="relative group overflow-hidden rounded-lg h-80 md:h-96 lg:h-[420px] md:-mt-8 lg:-mt-12"
                >
                    <div
                        class="absolute inset-0 bg-gradient-to-b from-black/20 to-black/35 transition-all duration-300 group-hover:from-black/10 group-hover:to-black/25"
                        style="
                            background-image: url('{{ asset('frontend') }}/images/ai-course-card.png');
                            background-size: cover;
                            background-position: center;
                            "
                    ></div>
                    <div class="absolute inset-0 flex items-center justify-center">
                        <h3
                            class="font-alexandria font-bold text-2xl md:text-3xl lg:text-4xl text-[#E8ECF4] text-center leading-tight px-6 transform transition-transform duration-300 group-hover:scale-105"
                        >
                            الذكاء
                            <br />
                            الاصطناعي
                        </h3>
                    </div>
                </div>

                <!-- Business Management Card -->
                <div
                    class="relative group overflow-hidden rounded-lg h-80 md:h-96 lg:h-[420px]"
                >
                    <div
                        class="absolute inset-0 bg-gradient-to-b from-black/20 to-black/35 transition-all duration-300 group-hover:from-black/10 group-hover:to-black/25"
                        style="
                            background-image: url('{{ asset('frontend') }}/images/business-management-course-card.png');
                            background-size: cover;
                            background-position: center;
                            "
                    ></div>
                    <div class="absolute inset-0 flex items-center justify-center">
                        <h3
                            class="font-alexandria font-bold text-2xl md:text-3xl lg:text-4xl text-[#E8ECF4] text-center leading-tight px-6 transform transition-transform duration-300 group-hover:scale-105"
                        >
                            إدارة
                            <br />
                            الاعمال
                        </h3>
                    </div>
                </div>

                <!-- Human Resources Card -->
                <div
                    class="relative group overflow-hidden rounded-lg h-80 md:h-96 lg:h-[420px] md:-mt-8 lg:-mt-12"
                >
                    <div
                        class="absolute inset-0 bg-gradient-to-b from-black/20 to-black/35 transition-all duration-300 group-hover:from-black/10 group-hover:to-black/25"
                        style="
                            background-image: url('{{ asset('frontend') }}/images/human-resources-course.png');
                            background-size: cover;
                            background-position: center;
                            "
                    ></div>
                    <div class="absolute inset-0 flex items-center justify-center">
                        <h3
                            class="font-alexandria font-bold text-2xl md:text-3xl lg:text-4xl text-[#E8ECF4] text-center leading-tight px-6 transform transition-transform duration-300 group-hover:scale-105"
                        >
                            الموارد
                            <br />
                            البشرية
                        </h3>
                    </div>
                </div>
            </div>

            <!-- Content Container -->
            <div class="text-right space-y-6 order-1 lg:order-1">
                <!-- Badge -->
                <div class="text-[#144394] font-alexandria font-semibold text-lg">
                    خططنا للتقدم
                </div>

                <!-- Main Title -->
                <h2
                    class="font-alexandria font-bold text-3xl md:text-4xl lg:text-5xl text-[#161C2D] md:w-3/5 lg:w-2/3"
                >
                    لدينا خطط لجميع المجالات
                </h2>

                <!-- Description -->
                <p
                    class="font-alexandria text-lg text-[#161C2D]/70 leading-relaxed max-w-lg"
                >
                    اختر الخطة التي تخدم أهداف شركتك، مهما كان مجالها أو حجمها.
                </p>

                <!-- Feature List -->
                <div class="space-y-4">
                    <div class="flex items-center gap-3 justify-start">
                        <div
                            class="w-6 h-6 bg-[#D1FADF] rounded-full flex items-center justify-center flex-shrink-0"
                        >
                            <svg
                                width="16"
                                height="16"
                                viewBox="0 0 24 24"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                            >
                                <path
                                    fill-rule="evenodd"
                                    clip-rule="evenodd"
                                    d="M16.096 7.38967L8.93602 14.2997L7.03602 12.2697C6.68602 11.9397 6.13602 11.9197 5.73602 12.1997C5.34602 12.4897 5.23602 12.9997 5.47602 13.4097L7.72602 17.0697C7.94602 17.4097 8.32601 17.6197 8.75601 17.6197C9.16601 17.6197 9.55602 17.4097 9.77602 17.0697C10.136 16.5997 17.006 8.40967 17.006 8.40967C17.906 7.48967 16.816 6.67967 16.096 7.37967V7.38967Z"
                                    fill="#12B76A"
                                />
                            </svg>
                        </div>
                        <span class="font-alexandria text-[#353F55] text-lg"
                        >سعر يناسب حجم شركتك واحتياجاتك</span
                        >
                    </div>
                    <div class="flex items-center gap-3 justify-start">
                        <div
                            class="w-6 h-6 bg-[#D1FADF] rounded-full flex items-center justify-center flex-shrink-0"
                        >
                            <svg
                                width="16"
                                height="16"
                                viewBox="0 0 24 24"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                            >
                                <path
                                    fill-rule="evenodd"
                                    clip-rule="evenodd"
                                    d="M16.096 7.38967L8.93602 14.2997L7.03602 12.2697C6.68602 11.9397 6.13602 11.9197 5.73602 12.1997C5.34602 12.4897 5.23602 12.9997 5.47602 13.4097L7.72602 17.0697C7.94602 17.4097 8.32601 17.6197 8.75601 17.6197C9.16601 17.6197 9.55602 17.4097 9.77602 17.0697C10.136 16.5997 17.006 8.40967 17.006 8.40967C17.906 7.48967 16.816 6.67967 16.096 7.37967V7.38967Z"
                                    fill="#12B76A"
                                />
                            </svg>
                        </div>
                        <span class="font-alexandria text-[#353F55] text-lg"
                        >سعر يناسب حجم شركتك واحتياجاتك</span
                        >
                    </div>
                    <div class="flex items-center gap-3 justify-start">
                        <div
                            class="w-6 h-6 bg-[#D1FADF] rounded-full flex items-center justify-center flex-shrink-0"
                        >
                            <svg
                                width="16"
                                height="16"
                                viewBox="0 0 24 24"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                            >
                                <path
                                    fill-rule="evenodd"
                                    clip-rule="evenodd"
                                    d="M16.096 7.38967L8.93602 14.2997L7.03602 12.2697C6.68602 11.9397 6.13602 11.9197 5.73602 12.1997C5.34602 12.4897 5.23602 12.9997 5.47602 13.4097L7.72602 17.0697C7.94602 17.4097 8.32601 17.6197 8.75601 17.6197C9.16601 17.6197 9.55602 17.4097 9.77602 17.0697C10.136 16.5997 17.006 8.40967 17.006 8.40967C17.906 7.48967 16.816 6.67967 16.096 7.37967V7.38967Z"
                                    fill="#12B76A"
                                />
                            </svg>
                        </div>
                        <span class="font-alexandria text-[#353F55] text-lg"
                        >سعر يناسب حجم شركتك واحتياجاتك</span
                        >
                    </div>
                    <div class="flex items-center gap-3 justify-start">
                        <div
                            class="w-6 h-6 bg-[#D1FADF] rounded-full flex items-center justify-center flex-shrink-0"
                        >
                            <svg
                                width="16"
                                height="16"
                                viewBox="0 0 24 24"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                            >
                                <path
                                    fill-rule="evenodd"
                                    clip-rule="evenodd"
                                    d="M16.096 7.38967L8.93602 14.2997L7.03602 12.2697C6.68602 11.9397 6.13602 11.9197 5.73602 12.1997C5.34602 12.4897 5.23602 12.9997 5.47602 13.4097L7.72602 17.0697C7.94602 17.4097 8.32601 17.6197 8.75601 17.6197C9.16601 17.6197 9.55602 17.4097 9.77602 17.0697C10.136 16.5997 17.006 8.40967 17.006 8.40967C17.906 7.48967 16.816 6.67967 16.096 7.37967V7.38967Z"
                                    fill="#12B76A"
                                />
                            </svg>
                        </div>
                        <span class="font-alexandria text-[#353F55] text-lg"
                        >سعر يناسب حجم شركتك واحتياجاتك</span
                        >
                    </div>
                </div>

                <!-- CTA Button -->
                <div class="pt-4">
                    <button
                        class="flex items-center gap-3 px-6 py-3 bg-[#00B34F] border border-[#00B34F] rounded-lg hover:bg-[#00A047] transition-colors"
                    >
              <span class="font-alexandria text-white font-medium text-base">
                احجز عرضًا توضيحيًا الآن
              </span>

                        <svg
                            width="24"
                            height="24"
                            viewBox="0 0 24 24"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                        >
                            <path
                                d="M8.414 13.343L12.364 17.293C12.5462 17.4816 12.647 17.7342 12.6447 17.9964C12.6424 18.2586 12.5372 18.5094 12.3518 18.6948C12.1664 18.8802 11.9156 18.9854 11.6534 18.9877C11.3912 18.99 11.1386 18.8892 10.95 18.707L5.293 13.05C5.19982 12.9573 5.12587 12.8472 5.07541 12.7259C5.02494 12.6045 4.99897 12.4744 4.99897 12.343C4.99897 12.2116 5.02494 12.0815 5.07541 11.9601C5.12587 11.8388 5.19982 11.7287 5.293 11.636L10.95 5.979C11.0422 5.88349 11.1526 5.80731 11.2746 5.7549C11.3966 5.70249 11.5278 5.6749 11.6606 5.67375C11.7934 5.6726 11.9251 5.6979 12.048 5.74818C12.1709 5.79846 12.2825 5.87271 12.3764 5.96661C12.4703 6.0605 12.5445 6.17215 12.5948 6.29505C12.6451 6.41794 12.6704 6.54962 12.6693 6.6824C12.6681 6.81518 12.6405 6.9464 12.5881 7.0684C12.5357 7.19041 12.4595 7.30075 12.364 7.393L8.414 11.343H18C18.2652 11.343 18.5196 11.4484 18.7071 11.6359C18.8946 11.8234 19 12.0778 19 12.343C19 12.6082 18.8946 12.8626 18.7071 13.0501C18.5196 13.2376 18.2652 13.343 18 13.343H8.414Z"
                                fill="white"
                            />
                        </svg>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!--============================ Latest Courses Section ==============================-->
    <div
        class="relative overflow-hidden lg:my-24"
        style="
        background: linear-gradient(
          104deg,
          rgba(12, 41, 89, 0.45) 10.29%,
          rgba(12, 41, 89, 0.55) 25.8%,
          rgba(12, 41, 89, 0.62) 36.96%,
          rgba(12, 41, 89, 0.72) 52.44%,
          rgba(12, 41, 89, 0.86) 73.41%,
          #0c2959 95.18%
        );
      "
    >
        <!-- Background Shapes -->
        <div class="absolute top-0 left-0">
            <img
                src="{{ asset('frontend') }}/images/background-shapes.svg"
                alt="Background Shapes"
                class="w-full h-auto"
            />
        </div>

        <div class="relative z-10 py-16 lg:pb-32 px-4 md:px-8 lg:px-16" dir="rtl">
            <div class="max-w-9xl mx-auto">
                <div class="flex flex-col items-center gap-6 lg:gap-8">
                    <!-- Header Section -->
                    <div
                        class="text-right space-y-4 w-full flex flex-col items-start justify-start"
                    >
                        <!-- Badge Group -->
                        <div
                            class="flex-row-reverse flex items-center justify-center gap-3 bg-[#E6F7ED] rounded-2xl px-4 py-2 w-fit"
                        >
                <span class="text-[#003F1C] font-medium text-sm"
                >مجالات تمت إضافتها حديثا</span
                >
                            <div
                                class="bg-[#00B34F] text-white px-3 py-1 rounded-2xl text-sm font-medium"
                            >
                                تحديثات في المجالات
                            </div>
                        </div>

                        <!-- Main Title -->
                        <h2
                            class="font-alexandria font-bold text-3xl md:text-4xl lg:text-5xl text-[#FAFAFA] leading-tight mt-4 pt-4"
                        >
                            اكتشف أحدث الدورات المضافة للأكاديمية
                        </h2>
                    </div>

                    <!-- Course Cards Grid -->
                    <div
                        class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 w-full"
                    >
                        <!-- AI Course Card -->
                        <div
                            class="bg-white rounded-3xl border border-[#BFBFBF] p-4 shadow-md hover:shadow-lg transition-shadow order-4"
                        >
                            <div class="space-y-4">
                                <div class="aspect-[4/3] overflow-hidden rounded-3xl">
                                    <img
                                        src="{{ asset('frontend') }}/images/ai-course.png"
                                        alt="الذكاء الاصطناعي"
                                        class="w-full h-full object-cover"
                                    />
                                </div>
                                <div class="text-right space-y-2">
                                    <h3
                                        class="font-alexandria font-bold text-lg text-[#06241B]"
                                        style="line-height: 32px"
                                    >
                                        الذكاء الاصطناعي
                                    </h3>
                                    <p
                                        class="font-alexandria text-sm text-[#79797B]"
                                        style="line-height: 24px"
                                    >
                                        تتناول دورة مايكروسوفت أوفيس (دورة Microsoft Office) كافة
                                        المبادئ و الأدوات التي يجب استخ...
                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- Graphic Design Course Card -->
                        <div
                            class="bg-white rounded-3xl border border-[#BFBFBF] p-4 shadow-md hover:shadow-lg transition-shadow order-3"
                        >
                            <div class="space-y-4">
                                <div class="aspect-[4/3] overflow-hidden rounded-3xl">
                                    <img
                                        src="{{ asset('frontend') }}/images/graphic-design-course.png"
                                        alt="تصميم الجرافيك"
                                        class="w-full h-full object-cover"
                                    />
                                </div>
                                <div class="text-right space-y-2">
                                    <h3
                                        class="font-alexandria font-bold text-lg text-[#06241B]"
                                        style="line-height: 32px"
                                    >
                                        تصميم الجرافيك
                                    </h3>
                                    <p
                                        class="font-alexandria text-sm text-[#79797B]"
                                        style="line-height: 24px"
                                    >
                                        تشمل دورة تصميم الجرافيك (Graphic Design) المبادئ الأساسية
                                        لتصميم الشعارات والمواد الترويجية باستخدام أدوات مثل
                                        أدوبي...
                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- Data Analysis Course Card -->
                        <div
                            class="bg-white rounded-3xl border border-[#BFBFBF] p-4 shadow-md hover:shadow-lg transition-shadow order-2"
                        >
                            <div class="space-y-4">
                                <div class="aspect-[4/3] overflow-hidden rounded-3xl">
                                    <img
                                        src="{{ asset('frontend') }}/images/data-analysis-course.png"
                                        alt="تحليل البيانات"
                                        class="w-full h-full object-cover"
                                    />
                                </div>
                                <div class="text-right space-y-2">
                                    <h3
                                        class="font-alexandria font-bold text-lg text-[#06241B]"
                                        style="line-height: 32px"
                                    >
                                        تحليل البيانات
                                    </h3>
                                    <p
                                        class="font-alexandria text-sm text-[#79797B]"
                                        style="line-height: 24px"
                                    >
                                        تقدم دورة تحليل البيانات باستخدام برنامج إكسل (Excel)
                                        تقنيات متقدمة لتحليل المعلومات و...
                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- Business Management Course Card -->
                        <div
                            class="bg-white rounded-3xl border border-[#BFBFBF] p-4 shadow-md hover:shadow-lg transition-shadow order-1"
                        >
                            <div class="space-y-4">
                                <div class="aspect-[4/3] overflow-hidden rounded-3xl">
                                    <img
                                        src="{{ asset('frontend') }}/images/business-management-course.png"
                                        alt="ادارة اعمال"
                                        class="w-full h-full object-cover"
                                    />
                                </div>
                                <div class="text-right space-y-2">
                                    <h3
                                        class="font-alexandria font-bold text-lg text-[#06241B]"
                                        style="line-height: 32px"
                                    >
                                        ادارة اعمال
                                    </h3>
                                    <p
                                        class="font-alexandria text-sm text-[#79797B]"
                                        style="line-height: 24px"
                                    >
                                        تتناول دورة مايكروسوفت أوفيس (دورة Microsoft Office) كافة
                                        المبادئ و الأدوات التي يجب استخ...
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- CTA Button -->
                    <div class="pt-6">
                        <button
                            class="flex items-center gap-3 px-6 py-3 text-[#E8ECF4] hover:bg-white/10 rounded-lg transition-colors"
                        >
                <span
                    class="font-alexandria text-sm font-medium underline"
                    style="line-height: 24px; letter-spacing: 0.5px"
                >
                  تصفح الدورات المضافة حديثا
                </span>

                            <svg
                                width="24"
                                height="24"
                                viewBox="0 0 24 24"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                            >
                                <path
                                    d="M8.414 13.343L12.364 17.293C12.5462 17.4816 12.647 17.7342 12.6447 17.9964C12.6424 18.2586 12.5372 18.5094 12.3518 18.6948C12.1664 18.8802 11.9156 18.9854 11.6534 18.9876C11.3912 18.9899 11.1386 18.8891 10.95 18.707L5.293 13.05C5.19982 12.9573 5.12587 12.8471 5.07541 12.7258C5.02494 12.6045 4.99897 12.4744 4.99897 12.343C4.99897 12.2116 5.02494 12.0814 5.07541 11.9601C5.12587 11.8388 5.19982 11.7286 5.293 11.636L10.95 5.97896C11.0422 5.88345 11.1526 5.80727 11.2746 5.75486C11.3966 5.70245 11.5278 5.67486 11.6606 5.67371C11.7934 5.67255 11.9251 5.69786 12.048 5.74814C12.1709 5.79842 12.2825 5.87267 12.3764 5.96656C12.4703 6.06046 12.5445 6.17211 12.5948 6.295C12.6451 6.4179 12.6704 6.54958 12.6693 6.68236C12.6681 6.81514 12.6405 6.94636 12.5881 7.06836C12.5357 7.19037 12.4595 7.30071 12.364 7.39296L8.414 11.343H18C18.2652 11.343 18.5196 11.4483 18.7071 11.6359C18.8946 11.8234 19 12.0777 19 12.343C19 12.6082 18.8946 12.8625 18.7071 13.0501C18.5196 13.2376 18.2652 13.343 18 13.343H8.414Z"
                                    fill="#E8ECF4"
                                />
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Wave Shape at bottom of Latest Courses Section -->
        <div class="absolute bottom-[-13px] left-0 w-full">
            <svg
                class="w-full h-auto"
                viewBox="0 0 1600 218"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
                preserveAspectRatio="none"
            >
                <g filter="url(#filter0_d_wave)">
                    <path
                        fill-rule="evenodd"
                        clip-rule="evenodd"
                        d="M0 79.458C0 79.458 226.389 186.741 381.052 178.06C535.714 169.378 628.364 133.594 798.309 151.486C968.253 169.378 1461.17 124.238 1600 0V209.034H0V79.458Z"
                        fill="#FDFDFF"
                    />
                </g>
                <defs>
                    <filter
                        id="filter0_d_wave"
                        x="-4"
                        y="0"
                        width="1608"
                        height="217.034"
                        filterUnits="userSpaceOnUse"
                        color-interpolation-filters="sRGB"
                    >
                        <feFlood flood-opacity="0" result="BackgroundImageFix" />
                        <feColorMatrix
                            in="SourceAlpha"
                            type="matrix"
                            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                            result="hardAlpha"
                        />
                        <feOffset dy="4" />
                        <feGaussianBlur stdDeviation="2" />
                        <feComposite in2="hardAlpha" operator="out" />
                        <feColorMatrix
                            type="matrix"
                            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"
                        />
                        <feBlend
                            mode="normal"
                            in2="BackgroundImageFix"
                            result="effect1_dropShadow_wave"
                        />
                        <feBlend
                            mode="normal"
                            in="SourceGraphic"
                            in2="effect1_dropShadow_wave"
                            result="shape"
                        />
                    </filter>
                </defs>
            </svg>
        </div>
    </div>

    <!-- ====================================== Pricing Section ===================================-->
    <div
        class="bg-[#F4F7FA] pt-16 pb-[200px] px-4 md:px-8 lg:px-16 relative overflow-hidden"
        dir="rtl"
    >
        <!-- Decorative Pattern -->
        <div class="absolute bottom-0 right-0">
            <img
                src="{{ asset('frontend') }}/images/decorative-pattern.png"
                alt="Decorative Pattern"
                class="w-36 h-36 fill-[#68D585]"
            />
        </div>

        <div class="max-w-7xl mx-auto relative z-10">
            <!-- Header Section -->
            <div class="text-center mb-16 space-y-5">
                <h2
                    class="font-alexandria font-semibold text-4xl md:text-5xl text-[#1C1C1C] leading-tight"
                    style="letter-spacing: -1.8px"
                >
                    اختر الخطة الأنسب لنمو شركتك
                </h2>
                <p
                    class="font-alexandria text-lg text-[#3B3B3B]/70 max-w-4xl mx-auto leading-relaxed"
                    style="letter-spacing: -0.2px"
                >
                    خطط مصممة لتناسب احتياجات المؤسسات من مختلف الأحجام — مع إمكانية
                    التوسع، والمزيد من التحكم، وتجربة تدريب احترافية.
                </p>
            </div>

            <!-- Pricing Cards Grid -->
            <div
                class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 max-w-6xl mx-auto"
            >
                <!-- Corporate Plan -->
                <div
                    class="bg-white rounded-lg border border-[#EAECF0] shadow-lg p-8 space-y-6 h-fit order-3"
                    style="
              box-shadow: 0 12px 16px -4px rgba(16, 24, 40, 0.08),
                0 4px 6px -2px rgba(16, 24, 40, 0.03);
            "
                >
                    <!-- Header -->
                    <div class="text-center space-y-4">
                        <div class="">
                            <img
                                src="{{ asset('frontend') }}/images/corporate-plan-icon.png"
                                alt="Corporate Plan Icon"
                                class="w-[56px] h-[56px] mx-auto mb-2"
                            />
                        </div>
                        <div>
                            <h3
                                class="font-alexandria font-semibold text-2xl text-[#101828] mb-2"
                            >
                                خطة الشركات الكبرى
                            </h3>
                            <p class="font-alexandria text-base text-[#667085]">
                                طوّر فرقك بخطة مرنة                </p>
                        </div>
                    </div>

                    <!-- Features -->
                    <div class="space-y-4">
                        <div class="flex items-start gap-3 justify-start">
                            <div
                                class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0"
                            >
                                <svg
                                    width="16"
                                    height="16"
                                    viewBox="0 0 16 16"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg"
                                >
                                    <path
                                        d="M10.6667 12.6673H13.3333C13.5101 12.6673 13.6797 12.5971 13.8047 12.4721C13.9298 12.347 14 12.1775 14 12.0007V11.334C14 10.8036 13.7893 10.2948 13.4142 9.91977C13.0391 9.5447 12.5304 9.33399 12 9.33399H10.6667M9.176 6.66732C9.44603 6.96922 9.80137 7.18202 10.195 7.27756C10.5886 7.37309 11.002 7.34686 11.3804 7.20233C11.7587 7.0578 12.0843 6.80178 12.314 6.46816C12.5437 6.13454 12.6667 5.73904 12.6667 5.33398C12.6667 4.92893 12.5437 4.53343 12.314 4.19981C12.0843 3.86619 11.7587 3.61017 11.3804 3.46564C11.002 3.32111 10.5886 3.29488 10.195 3.39041C9.80137 3.48594 9.44603 3.69874 9.176 4.00065M2 12.0007V11.334C2 10.8036 2.21071 10.2948 2.58579 9.91977C2.96086 9.5447 3.46957 9.33399 4 9.33399H6.66667C7.1971 9.33399 7.70581 9.5447 8.08088 9.91977C8.45595 10.2948 8.66667 10.8036 8.66667 11.334V12.0007C8.66667 12.1775 8.59643 12.347 8.4714 12.4721C8.34638 12.5971 8.17681 12.6673 8 12.6673H2.66667C2.48986 12.6673 2.32029 12.5971 2.19526 12.4721C2.07024 12.347 2 12.1775 2 12.0007ZM7.33333 5.33398C7.33333 5.86442 7.12262 6.37313 6.74755 6.7482C6.37247 7.12327 5.86377 7.33398 5.33333 7.33398C4.8029 7.33398 4.29419 7.12327 3.91912 6.7482C3.54405 6.37313 3.33333 5.86442 3.33333 5.33398C3.33333 4.80355 3.54405 4.29484 3.91912 3.91977C4.29419 3.5447 4.8029 3.33398 5.33333 3.33398C5.86377 3.33398 6.37247 3.5447 6.74755 3.91977C7.12262 4.29484 7.33333 4.80355 7.33333 5.33398Z"
                                        stroke="#00B34F"
                                        stroke-linecap="round"
                                    />
                                </svg>
                            </div>
                            <span class="font-alexandria text-sm text-[#575757] text-right"
                            >عدد المستخدمين: 15 مستخدم</span
                            >
                        </div>

                        <div class="flex items-start gap-3 justify-start">
                            <div
                                class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0"
                            >
                                <svg
                                    width="16"
                                    height="16"
                                    viewBox="0 0 16 16"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg"
                                >
                                    <path
                                        d="M8.00001 14V8M8.00001 4.66667H5.30001C3.45334 4.66667 3.34001 2 5.30001 2C7.40001 2 8.00001 4.66667 8.00001 4.66667ZM8.00001 4.66667H10.7C12.6307 4.66667 12.6307 2 10.7 2C8.60001 2 8.00001 4.66667 8.00001 4.66667Z"
                                        stroke="#00B34F"
                                        stroke-linecap="round"
                                        stroke-linejoin="round"
                                    />
                                    <path
                                        d="M13.3333 7.99935V12.666C13.3333 13.0196 13.1929 13.3588 12.9428 13.6088C12.6928 13.8589 12.3536 13.9993 12 13.9993H4C3.64638 13.9993 3.30724 13.8589 3.05719 13.6088C2.80714 13.3588 2.66667 13.0196 2.66667 12.666V7.99935M14 7.99935V5.99935C14 5.64573 13.8595 5.30659 13.6095 5.05654C13.3594 4.80649 13.0203 4.66602 12.6667 4.66602H3.33333C2.97971 4.66602 2.64057 4.80649 2.39052 5.05654C2.14048 5.30659 2 5.64573 2 5.99935V7.99935H14Z"
                                        stroke="#00B34F"
                                        stroke-linecap="round"
                                        stroke-linejoin="round"
                                    />
                                </svg>
                            </div>
                            <span class="font-alexandria text-sm text-[#575757] text-right"
                            >مستخدمين مجانيين: 5 مجانا</span
                            >
                        </div>

                        <div class="flex items-start gap-3 justify-start">
                            <div
                                class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0"
                            >
                                <svg
                                    width="16"
                                    height="16"
                                    viewBox="0 0 16 16"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg"
                                >
                                    <path
                                        d="M7.99967 3.33398V12.6673M3.33301 8.00065H12.6663"
                                        stroke="#00B34F"
                                        stroke-linecap="round"
                                        stroke-linejoin="round"
                                    />
                                </svg>
                            </div>
                            <span class="font-alexandria text-sm text-[#575757] text-right"
                            >رسوم المستخدم الإضافي: 174$</span
                            >
                        </div>

                        <div class="flex items-start gap-3 justify-start">
                            <div
                                class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0"
                            >
                                <svg
                                    width="16"
                                    height="16"
                                    viewBox="0 0 16 16"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg"
                                >
                                    <path
                                        d="M13.3 7.33329C13.1314 6.04712 12.4999 4.86648 11.5235 4.01237C10.5472 3.15827 9.29313 2.68926 7.99596 2.69314C6.69879 2.69702 5.4475 3.17352 4.47632 4.03345C3.50514 4.89337 2.88065 6.07777 2.71976 7.36493C2.55886 8.65209 2.87259 9.95376 3.60221 11.0263C4.33183 12.0988 5.42733 12.8687 6.68363 13.1917C7.93994 13.5148 9.27091 13.3689 10.4274 12.7814C11.5839 12.1939 12.4867 11.2051 12.9667 9.99996M13.3 13.3333V9.99996H9.96667"
                                        stroke="#00B34F"
                                        stroke-linecap="round"
                                        stroke-linejoin="round"
                                    />
                                </svg>
                            </div>
                            <span class="font-alexandria text-sm text-[#575757] text-right"
                            >عدد مرات الاستبدال: مرة واحدة لكل مستخدم</span
                            >
                        </div>
                    </div>

                    <!-- CTA Button -->
                    <button
                        class="w-full flex items-center justify-center gap-3 px-6 py-3 bg-[#00B34F] border border-[#00B34F] rounded-lg text-white font-alexandria font-medium hover:bg-[#00A047] transition-colors"
                    >
                        <span class="text-base">احجز عرضًا توضيحيًا الآن</span>

                        <svg
                            width="24"
                            height="24"
                            viewBox="0 0 24 24"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                        >
                            <path
                                d="M8.414 13.3431L12.364 17.2931C12.5462 17.4817 12.647 17.7343 12.6447 17.9965C12.6424 18.2587 12.5372 18.5095 12.3518 18.6949C12.1664 18.8803 11.9156 18.9855 11.6534 18.9878C11.3912 18.99 11.1386 18.8892 10.95 18.7071L5.293 13.0501C5.19982 12.9574 5.12587 12.8473 5.07541 12.7259C5.02494 12.6046 4.99897 12.4745 4.99897 12.3431C4.99897 12.2117 5.02494 12.0816 5.07541 11.9602C5.12587 11.8389 5.19982 11.7287 5.293 11.6361L10.95 5.97908C11.0422 5.88357 11.1526 5.80739 11.2746 5.75498C11.3966 5.70257 11.5278 5.67498 11.6606 5.67383C11.7934 5.67268 11.9251 5.69798 12.048 5.74826C12.1709 5.79854 12.2825 5.87279 12.3764 5.96669C12.4703 6.06058 12.5445 6.17223 12.5948 6.29513C12.6451 6.41802 12.6704 6.5497 12.6693 6.68248C12.6681 6.81526 12.6405 6.94648 12.5881 7.06849C12.5357 7.19049 12.4595 7.30083 12.364 7.39308L8.414 11.3431H18C18.2652 11.3431 18.5196 11.4484 18.7071 11.636C18.8946 11.8235 19 12.0779 19 12.3431C19 12.6083 18.8946 12.8627 18.7071 13.0502C18.5196 13.2377 18.2652 13.3431 18 13.3431H8.414Z"
                                fill="white"
                            />
                        </svg>
                    </button>
                </div>

                <!-- Business Plan -->
                <div
                    class="bg-white rounded-lg border border-[#EAECF0] shadow-lg p-8 space-y-6 h-fit order-2"
                    style="
              box-shadow: 0 12px 16px -4px rgba(16, 24, 40, 0.08),
                0 4px 6px -2px rgba(16, 24, 40, 0.03);
            "
                >
                    <!-- Header -->
                    <div class="text-center space-y-4 flex flex-col items-center">
                        <div class="">
                            <img
                                src="{{ asset('frontend') }}/images/business-plan-icon.png"
                                alt="Business Plan Icon"
                                class="w-[60px] h-[60px] mx-auto"
                            />
                        </div>
                        <div>
                            <h3
                                class="font-alexandria font-semibold text-2xl text-[#101828] mb-2"
                            >
                                خطة الأعمال
                            </h3>
                            <p class="font-alexandria text-base text-[#667085]">
                                خطة ذكية لنمو مستدام
                            </p>
                        </div>
                    </div>

                    <!-- Features -->
                    <div class="space-y-4">
                        <div class="flex items-start gap-3 justify-start">
                            <div
                                class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0"
                            >
                                <svg
                                    width="16"
                                    height="16"
                                    viewBox="0 0 16 16"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg"
                                >
                                    <path
                                        d="M10.6667 12.6673H13.3333C13.5101 12.6673 13.6797 12.5971 13.8047 12.4721C13.9298 12.347 14 12.1775 14 12.0007V11.334C14 10.8036 13.7893 10.2948 13.4142 9.91977C13.0391 9.5447 12.5304 9.33399 12 9.33399H10.6667M9.176 6.66732C9.44603 6.96922 9.80137 7.18202 10.195 7.27756C10.5886 7.37309 11.002 7.34686 11.3804 7.20233C11.7587 7.0578 12.0843 6.80178 12.314 6.46816C12.5437 6.13454 12.6667 5.73904 12.6667 5.33398C12.6667 4.92893 12.5437 4.53343 12.314 4.19981C12.0843 3.86619 11.7587 3.61017 11.3804 3.46564C11.002 3.32111 10.5886 3.29488 10.195 3.39041C9.80137 3.48594 9.44603 3.69874 9.176 4.00065M2 12.0007V11.334C2 10.8036 2.21071 10.2948 2.58579 9.91977C2.96086 9.5447 3.46957 9.33399 4 9.33399H6.66667C7.1971 9.33399 7.70581 9.5447 8.08088 9.91977C8.45595 10.2948 8.66667 10.8036 8.66667 11.334V12.0007C8.66667 12.1775 8.59643 12.347 8.4714 12.4721C8.34638 12.5971 8.17681 12.6673 8 12.6673H2.66667C2.48986 12.6673 2.32029 12.5971 2.19526 12.4721C2.07024 12.347 2 12.1775 2 12.0007ZM7.33333 5.33398C7.33333 5.86442 7.12262 6.37313 6.74755 6.7482C6.37247 7.12327 5.86377 7.33398 5.33333 7.33398C4.8029 7.33398 4.29419 7.12327 3.91912 6.7482C3.54405 6.37313 3.33333 5.86442 3.33333 5.33398C3.33333 4.80355 3.54405 4.29484 3.91912 3.91977C4.29419 3.5447 4.8029 3.33398 5.33333 3.33398C5.86377 3.33398 6.37247 3.5447 6.74755 3.91977C7.12262 4.29484 7.33333 4.80355 7.33333 5.33398Z"
                                        stroke="#00B34F"
                                        stroke-linecap="round"
                                    />
                                </svg>
                            </div>
                            <span class="font-alexandria text-sm text-[#575757] text-right"
                            >عدد المستخدمين: 15 مستخدم</span
                            >
                        </div>

                        <div class="flex items-start gap-3 justify-start">
                            <div
                                class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0"
                            >
                                <svg
                                    width="16"
                                    height="16"
                                    viewBox="0 0 16 16"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg"
                                >
                                    <path
                                        d="M8.00001 14V8M8.00001 4.66667H5.30001C3.45334 4.66667 3.34001 2 5.30001 2C7.40001 2 8.00001 4.66667 8.00001 4.66667ZM8.00001 4.66667H10.7C12.6307 4.66667 12.6307 2 10.7 2C8.60001 2 8.00001 4.66667 8.00001 4.66667Z"
                                        stroke="#00B34F"
                                        stroke-linecap="round"
                                        stroke-linejoin="round"
                                    />
                                    <path
                                        d="M13.3333 7.99935V12.666C13.3333 13.0196 13.1929 13.3588 12.9428 13.6088C12.6928 13.8589 12.3536 13.9993 12 13.9993H4C3.64638 13.9993 3.30724 13.8589 3.05719 13.6088C2.80714 13.3588 2.66667 13.0196 2.66667 12.666V7.99935M14 7.99935V5.99935C14 5.64573 13.8595 5.30659 13.6095 5.05654C13.3594 4.80649 13.0203 4.66602 12.6667 4.66602H3.33333C2.97971 4.66602 2.64057 4.80649 2.39052 5.05654C2.14048 5.30659 2 5.64573 2 5.99935V7.99935H14Z"
                                        stroke="#00B34F"
                                        stroke-linecap="round"
                                        stroke-linejoin="round"
                                    />
                                </svg>
                            </div>
                            <span class="font-alexandria text-sm text-[#575757] text-right"
                            >مستخدمين مجانيين: 5 مجانا</span
                            >
                        </div>

                        <div class="flex items-start gap-3 justify-start">
                            <div
                                class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0"
                            >
                                <svg
                                    width="16"
                                    height="16"
                                    viewBox="0 0 16 16"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg"
                                >
                                    <path
                                        d="M7.99967 3.33398V12.6673M3.33301 8.00065H12.6663"
                                        stroke="#00B34F"
                                        stroke-linecap="round"
                                        stroke-linejoin="round"
                                    />
                                </svg>
                            </div>
                            <span class="font-alexandria text-sm text-[#575757] text-right"
                            >رسوم المستخدم الإضافي: 174$</span
                            >
                        </div>

                        <div class="flex items-start gap-3 justify-start">
                            <div
                                class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0"
                            >
                                <svg
                                    width="16"
                                    height="16"
                                    viewBox="0 0 16 16"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg"
                                >
                                    <path
                                        d="M13.3 7.33329C13.1314 6.04712 12.4999 4.86648 11.5235 4.01237C10.5472 3.15827 9.29313 2.68926 7.99596 2.69314C6.69879 2.69702 5.4475 3.17352 4.47632 4.03345C3.50514 4.89337 2.88065 6.07777 2.71976 7.36493C2.55886 8.65209 2.87259 9.95376 3.60221 11.0263C4.33183 12.0988 5.42733 12.8687 6.68363 13.1917C7.93994 13.5148 9.27091 13.3689 10.4274 12.7814C11.5839 12.1939 12.4867 11.2051 12.9667 9.99996M13.3 13.3333V9.99996H9.96667"
                                        stroke="#00B34F"
                                        stroke-linecap="round"
                                        stroke-linejoin="round"
                                    />
                                </svg>
                            </div>
                            <span class="font-alexandria text-sm text-[#575757] text-right"
                            >عدد مرات الاستبدال: مرة واحدة لكل مستخدم</span
                            >
                        </div>
                    </div>

                    <!-- CTA Button -->
                    <button
                        class="w-full flex items-center justify-center gap-3 px-6 py-3 bg-[#00B34F] border border-[#00B34F] rounded-lg text-white font-alexandria font-medium hover:bg-[#00A047] transition-colors"
                    >
                        <span class="text-base">احجز عرضًا توضيحيًا الآن</span>

                        <svg
                            width="24"
                            height="24"
                            viewBox="0 0 24 24"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                        >
                            <path
                                d="M8.414 13.3431L12.364 17.2931C12.5462 17.4817 12.647 17.7343 12.6447 17.9965C12.6424 18.2587 12.5372 18.5095 12.3518 18.6949C12.1664 18.8803 11.9156 18.9855 11.6534 18.9878C11.3912 18.99 11.1386 18.8892 10.95 18.7071L5.293 13.0501C5.19982 12.9574 5.12587 12.8473 5.07541 12.7259C5.02494 12.6046 4.99897 12.4745 4.99897 12.3431C4.99897 12.2117 5.02494 12.0816 5.07541 11.9602C5.12587 11.8389 5.19982 11.7287 5.293 11.6361L10.95 5.97908C11.0422 5.88357 11.1526 5.80739 11.2746 5.75498C11.3966 5.70257 11.5278 5.67498 11.6606 5.67383C11.7934 5.67268 11.9251 5.69798 12.048 5.74826C12.1709 5.79854 12.2825 5.87279 12.3764 5.96669C12.4703 6.06058 12.5445 6.17223 12.5948 6.29513C12.6451 6.41802 12.6704 6.5497 12.6693 6.68248C12.6681 6.81526 12.6405 6.94648 12.5881 7.06849C12.5357 7.19049 12.4595 7.30083 12.364 7.39308L8.414 11.3431H18C18.2652 11.3431 18.5196 11.4484 18.7071 11.636C18.8946 11.8235 19 12.0779 19 12.3431C19 12.6083 18.8946 12.8627 18.7071 13.0502C18.5196 13.2377 18.2652 13.3431 18 13.3431H8.414Z"
                                fill="white"
                            />
                        </svg>
                    </button>
                </div>

                <!-- Basic Plan (Most Popular) -->
                <div
                    class="bg-white rounded-lg border border-[#EAECF0] shadow-lg p-8 space-y-6 relative h-fit -order-1 relative
            style="box-shadow: 0 12px 16px -4px rgba(16, 24, 40, 0.08),0 4px 6px -2px rgba(16, 24, 40, 0.03);"
                >
                <!-- Popular Badge -->
                <div class="absolute absolute -top-[74px] -right-[24px]">
                    <div class="">
                <span
                    class="px-2 py-1 rounded text-[#144394] text-sm font-alexandria font-medium relative"
                >الاكثر شهرة لدينا</span
                >
                        <img
                            src="{{ asset('frontend') }}/images/popular-arrow.png"
                            alt="Popular Badge"
                            class="w-[40px] h-[40px] absolute left-[-40px] "
                        />
                    </div>
                </div>

                <!-- Header -->
                <div class="text-center">
                    <div
                        class="text-[#144394] font-alexandria font-semibold text-5xl leading-tight"
                        style="letter-spacing: -0.96px"
                    >
                        2,600$
                    </div>
                    <div>
                        <h3
                            class="font-alexandria font-semibold text-2xl text-[#101828] mb-2"
                        >
                            الخطة الأساسية
                        </h3>
                        <p class="font-alexandria text-base text-[#667085]">
                            انطلق بتدريب فريقك
                        </p>
                    </div>
                </div>

                <!-- Features -->
                <div class="space-y-4">
                    <div class="flex items-start gap-3 justify-start">
                        <div
                            class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0"
                        >
                            <svg
                                width="16"
                                height="16"
                                viewBox="0 0 16 16"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                            >
                                <path
                                    d="M10.6667 12.6673H13.3333C13.5101 12.6673 13.6797 12.5971 13.8047 12.4721C13.9298 12.347 14 12.1775 14 12.0007V11.334C14 10.8036 13.7893 10.2948 13.4142 9.91977C13.0391 9.5447 12.5304 9.33399 12 9.33399H10.6667M9.176 6.66732C9.44603 6.96922 9.80137 7.18202 10.195 7.27756C10.5886 7.37309 11.002 7.34686 11.3804 7.20233C11.7587 7.0578 12.0843 6.80178 12.314 6.46816C12.5437 6.13454 12.6667 5.73904 12.6667 5.33398C12.6667 4.92893 12.5437 4.53343 12.314 4.19981C12.0843 3.86619 11.7587 3.61017 11.3804 3.46564C11.002 3.32111 10.5886 3.29488 10.195 3.39041C9.80137 3.48594 9.44603 3.69874 9.176 4.00065M2 12.0007V11.334C2 10.8036 2.21071 10.2948 2.58579 9.91977C2.96086 9.5447 3.46957 9.33399 4 9.33399H6.66667C7.1971 9.33399 7.70581 9.5447 8.08088 9.91977C8.45595 10.2948 8.66667 10.8036 8.66667 11.334V12.0007C8.66667 12.1775 8.59643 12.347 8.4714 12.4721C8.34638 12.5971 8.17681 12.6673 8 12.6673H2.66667C2.48986 12.6673 2.32029 12.5971 2.19526 12.4721C2.07024 12.347 2 12.1775 2 12.0007ZM7.33333 5.33398C7.33333 5.86442 7.12262 6.37313 6.74755 6.7482C6.37247 7.12327 5.86377 7.33398 5.33333 7.33398C4.8029 7.33398 4.29419 7.12327 3.91912 6.7482C3.54405 6.37313 3.33333 5.86442 3.33333 5.33398C3.33333 4.80355 3.54405 4.29484 3.91912 3.91977C4.29419 3.5447 4.8029 3.33398 5.33333 3.33398C5.86377 3.33398 6.37247 3.5447 6.74755 3.91977C7.12262 4.29484 7.33333 4.80355 7.33333 5.33398Z"
                                    stroke="#00B34F"
                                    stroke-linecap="round"
                                />
                            </svg>
                        </div>
                        <span class="font-alexandria text-sm text-[#575757] text-right"
                        >عدد المستخدمين: 15 مستخدم</span
                        >
                    </div>

                    <div class="flex items-start gap-3 justify-start">
                        <div
                            class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0"
                        >
                            <svg
                                width="16"
                                height="16"
                                viewBox="0 0 16 16"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                            >
                                <path
                                    d="M8.00001 14V8M8.00001 4.66667H5.30001C3.45334 4.66667 3.34001 2 5.30001 2C7.40001 2 8.00001 4.66667 8.00001 4.66667ZM8.00001 4.66667H10.7C12.6307 4.66667 12.6307 2 10.7 2C8.60001 2 8.00001 4.66667 8.00001 4.66667Z"
                                    stroke="#00B34F"
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                />
                                <path
                                    d="M13.3333 7.99935V12.666C13.3333 13.0196 13.1929 13.3588 12.9428 13.6088C12.6928 13.8589 12.3536 13.9993 12 13.9993H4C3.64638 13.9993 3.30724 13.8589 3.05719 13.6088C2.80714 13.3588 2.66667 13.0196 2.66667 12.666V7.99935M14 7.99935V5.99935C14 5.64573 13.8595 5.30659 13.6095 5.05654C13.3594 4.80649 13.0203 4.66602 12.6667 4.66602H3.33333C2.97971 4.66602 2.64057 4.80649 2.39052 5.05654C2.14048 5.30659 2 5.64573 2 5.99935V7.99935H14Z"
                                    stroke="#00B34F"
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                />
                            </svg>
                        </div>
                        <span class="font-alexandria text-sm text-[#575757] text-right"
                        >مستخدمين مجانيين: 5 مجانا</span
                        >
                    </div>

                    <div class="flex items-start gap-3 justify-start">
                        <div
                            class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0"
                        >
                            <svg
                                width="16"
                                height="16"
                                viewBox="0 0 16 16"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                            >
                                <path
                                    d="M7.99967 3.33398V12.6673M3.33301 8.00065H12.6663"
                                    stroke="#00B34F"
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                />
                            </svg>
                        </div>
                        <span class="font-alexandria text-sm text-[#575757] text-right"
                        >رسوم المستخدم الإضافي: 174$</span
                        >
                    </div>

                    <div class="flex items-start gap-3 justify-start">
                        <div
                            class="w-6 h-6 bg-[#E6F7ED] rounded-xl flex items-center justify-center flex-shrink-0"
                        >
                            <svg
                                width="16"
                                height="16"
                                viewBox="0 0 16 16"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                            >
                                <path
                                    d="M13.3 7.33329C13.1314 6.04712 12.4999 4.86648 11.5235 4.01237C10.5472 3.15827 9.29313 2.68926 7.99596 2.69314C6.69879 2.69702 5.4475 3.17352 4.47632 4.03345C3.50514 4.89337 2.88065 6.07777 2.71976 7.36493C2.55886 8.65209 2.87259 9.95376 3.60221 11.0263C4.33183 12.0988 5.42733 12.8687 6.68363 13.1917C7.93994 13.5148 9.27091 13.3689 10.4274 12.7814C11.5839 12.1939 12.4867 11.2051 12.9667 9.99996M13.3 13.3333V9.99996H9.96667"
                                    stroke="#00B34F"
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                />
                            </svg>
                        </div>
                        <span class="font-alexandria text-sm text-[#575757] text-right"
                        >عدد مرات الاستبدال: مرة واحدة لكل مستخدم</span
                        >
                    </div>
                </div>

                <!-- CTA Button -->
                <button
                    class="w-full flex items-center justify-center gap-3 px-6 py-3 bg-[#144394] border border-[#144394] rounded-lg text-white font-alexandria font-medium hover:bg-[#0f3677] transition-colors"
                >
                    <span class="text-base">احجز عرضًا توضيحيًا الآن</span>

                    <svg
                        width="24"
                        height="24"
                        viewBox="0 0 24 24"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                    >
                        <path
                            d="M8.414 13.3431L12.364 17.2931C12.5462 17.4817 12.647 17.7343 12.6447 17.9965C12.6424 18.2587 12.5372 18.5095 12.3518 18.6949C12.1664 18.8803 11.9156 18.9855 11.6534 18.9878C11.3912 18.99 11.1386 18.8892 10.95 18.7071L5.293 13.0501C5.19982 12.9574 5.12587 12.8473 5.07541 12.7259C5.02494 12.6046 4.99897 12.4745 4.99897 12.3431C4.99897 12.2117 5.02494 12.0816 5.07541 11.9602C5.12587 11.8389 5.19982 11.7287 5.293 11.6361L10.95 5.97908C11.0422 5.88357 11.1526 5.80739 11.2746 5.75498C11.3966 5.70257 11.5278 5.67498 11.6606 5.67383C11.7934 5.67268 11.9251 5.69798 12.048 5.74826C12.1709 5.79854 12.2825 5.87279 12.3764 5.96669C12.4703 6.06058 12.5445 6.17223 12.5948 6.29513C12.6451 6.41802 12.6704 6.5497 12.6693 6.68248C12.6681 6.81526 12.6405 6.94648 12.5881 7.06849C12.5357 7.19049 12.4595 7.30083 12.364 7.39308L8.414 11.3431H18C18.2652 11.3431 18.5196 11.4484 18.7071 11.636C18.8946 11.8235 19 12.0779 19 12.3431C19 12.6083 18.8946 12.8627 18.7071 13.0502C18.5196 13.2377 18.2652 13.3431 18 13.3431H8.414Z"
                            fill="white"
                        />
                    </svg>
                </button>
            </div>
        </div>
    </div>



    <!-- ====================================== Contact Section ====================================== -->
    <div class="bg-[#E8ECF4] rounded-lg w-full max-w-[95%] mx-auto  relative" dir="rtl">
        <div class="grid grid-cols-1 lg:grid-cols-2 min-h-screen mt-[-100px] mb-16">

            <!-- Right Side - Hero Content -->
            <div
                class="relative overflow-hidden"
                style="
            background: linear-gradient(
              104deg,
              rgba(12, 41, 89, 0.45) 10.29%,
              rgba(12, 41, 89, 0.55) 25.8%,
              rgba(12, 41, 89, 0.62) 36.96%,
              rgba(12, 41, 89, 0.72) 52.44%,
              rgba(12, 41, 89, 0.86) 73.41%,
              #0c2959 95.18%
            );
          "
            >



                <div class="absolute bottom-0 left-0 z-10">
                    <img
                        src="{{ asset('frontend') }}/images/business-team.png"
                        alt="Business Team"
                        class="w-[721px] h-[514px] object-cover"
                    />
                </div>


                <!-- circle background container -->
                <div class="absolute inset-0 flex items-center justify-end z-0 left-0 top-0">
                    <img
                        src="{{ asset('frontend') }}/images/circle-background-contact.svg"
                        alt="Circle Background"
                        class="w-full h-full object-cover"
                    />
                </div>

                <!-- Content -->
                <div
                    class="relative z-10 flex items-start justify-start h-full px-8 lg:px-8 py-24 space-y-10 rounded-[40px] overflow-hidden"
                >
                    <div class="max-w-2xl text-right space-y-10 rounded-[40px]">
                        <!-- Main Title -->
                        <h2
                            class="font-alexandria font-semibold text-4xl md:text-5xl text-[#E8ECF4] leading-tight"
                            style="letter-spacing: -1.2px"
                        >
                            هل أنت مستعد لقيادة شركتك نحو التغيير؟
                        </h2>

                        <!-- Description -->
                        <p
                            class="font-alexandria text-xl text-white/70 leading-relaxed"
                            style="letter-spacing: -0.2px"
                        >
                            دعنا نتواصل لنتحدث عن كيف يمكن لـ اعمل بيزنس مساعدتك في:
                        </p>

                        <!-- Benefits List -->
                        <div class="space-y-8">
                            <div class="flex items-center gap-3 justify-start">
                                <div
                                    class="w-6 h-6 bg-[#D1FADF] rounded-full flex items-center justify-center flex-shrink-0"
                                >
                                    <img
                                        src="{{ asset('frontend') }}/images/check-icon.png"
                                        alt="Check Icon"
                                    />
                                </div>
                                <span class="font-alexandria text-lg text-[#E6F7ED]"
                                >تسريع التحول الرقمي لشركتك</span
                                >
                            </div>

                            <div class="flex items-center gap-3 justify-start">
                                <div
                                    class="w-6 h-6 bg-[#D1FADF] rounded-full flex items-center justify-center flex-shrink-0"
                                >
                                    <img
                                        src="{{ asset('frontend') }}/images/check-icon.png"
                                        alt="Check Icon"
                                    />
                                </div>
                                <span class="font-alexandria text-lg text-[#E6F7ED]"
                                >تحسين مرونة شركتك في مواجهة التحديات</span
                                >
                            </div>

                            <div class="flex items-center gap-3 justify-start">
                                <div
                                    class="w-6 h-6 bg-[#D1FADF] rounded-full flex items-center justify-center flex-shrink-0"
                                >
                                    <img
                                        src="{{ asset('frontend') }}/images/check-icon.png"
                                        alt="Check Icon"
                                    />
                                </div>
                                <span class="font-alexandria text-lg text-[#E6F7ED]"
                                >تعزيز إنتاجية الموظفين وتشجيع الابتكار</span
                                >
                            </div>

                            <div class="flex items-center gap-3 justify-start">
                                <div
                                    class="w-6 h-6 bg-[#D1FADF] rounded-full flex items-center justify-center flex-shrink-0"
                                >
                                    <img
                                        src="{{ asset('frontend') }}/images/check-icon.png"
                                        alt="Check Icon"
                                    />
                                </div>
                                <span class="font-alexandria text-lg text-[#E6F7ED]"
                                >تمكين الموظفين لدفع النمو المستدام</span
                                >
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Left Side - Contact Form -->
            <div class="flex items-center py-24">
                <div class="w-full  space-y-12 lg:mx-[85px] mx-[15px]">
                    <!-- Header -->
                    <div>
                        <h2
                            class="font-alexandria font-semibold text-4xl md:text-5xl text-[#144394] leading-tight text-right"
                            style="letter-spacing: -0.96px"
                        >
                            نجاحك يبدأ من هنا، معًا
                        </h2>
                    </div>

                    <!-- Contact Form -->
                    <form class="space-y-8">
                        <!-- Form Fields -->
                        <div class="space-y-6">
                            <!-- Name Field -->
                            <div class="space-y-2">
                                <label
                                    class="flex items-center justify-start gap-2 text-sm font-medium text-[#2E2E2E] font-alexandria"
                                >
                                    <svg
                                        width="10"
                                        height="9"
                                        viewBox="0 0 10 9"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                    >
                                        <path
                                            d="M8.37943 5.35553H5.9147L7.66989 7.11072L7.14707 7.63354L5.39188 5.87835V8.34309H4.64499V5.84101L2.88981 7.5962L2.36698 7.07338L4.04748 5.35553H1.65744V4.60865H4.12217L2.36698 2.85346L2.88981 2.33064L4.64499 4.08582V1.62109H5.39188V4.01113L7.10972 2.29329L7.63254 2.85346L5.87736 4.60865H8.37943V5.35553Z"
                                            fill="#DA0000"
                                        />
                                    </svg>
                                    <span>الاسم</span>

                                </label>
                                <div class="relative">
                                    <input
                                        type="text"
                                        placeholder="اكتب اسمك"
                                        class="w-full pl-4 pr-12 py-3 border border-[#CBD5E1] rounded-lg text-right placeholder-[#BFBFBF] font-alexandria text-sm focus:outline-none focus:border-[#144394]"
                                    />
                                    <svg
                                        class="absolute right-3 top-1/2 transform -translate-y-1/2 w-5 h-5"
                                        width="19"
                                        height="18"
                                        viewBox="0 0 19 18"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                    >
                                        <path
                                            d="M9.53742 7.25971C10.9811 7.25971 12.1515 6.08933 12.1515 4.6456C12.1515 3.20187 10.9811 2.03149 9.53742 2.03149C8.09369 2.03149 6.92331 3.20187 6.92331 4.6456C6.92331 6.08933 8.09369 7.25971 9.53742 7.25971Z"
                                            stroke="#BFBFBF"
                                            stroke-width="1.49378"
                                            stroke-linecap="round"
                                            stroke-linejoin="round"
                                        />
                                        <path
                                            d="M2.06882 15.8484C2.06882 12.5483 5.0784 9.87329 8.79081 9.87329M12.1518 16.2218L15.8862 12.4874L14.3925 10.9936L10.658 14.7281V16.2218H12.1518Z"
                                            stroke="#BFBFBF"
                                            stroke-width="1.49378"
                                            stroke-linecap="round"
                                            stroke-linejoin="ro</div>und"
                                        />
                                    </svg>
                                </div>
                            </div>

                            <!-- Email Field -->
                            <div class="space-y-2">
                                <label
                                    class="flex items-center justify-start gap-2 text-sm font-medium text-[#2E2E2E] font-alexandria"
                                >
                                    <svg
                                        width="10"
                                        height="9"
                                        viewBox="0 0 10 9"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                    >
                                        <path
                                            d="M8.37943 5.35553H5.9147L7.66989 7.11072L7.14707 7.63354L5.39188 5.87835V8.34309H4.64499V5.84101L2.88981 7.5962L2.36698 7.07338L4.04748 5.35553H1.65744V4.60865H4.12217L2.36698 2.85346L2.88981 2.33064L4.64499 4.08582V1.62109H5.39188V4.01113L7.10972 2.29329L7.63254 2.85346L5.87736 4.60865H8.37943V5.35553Z"
                                            fill="#DA0000"
                                        />
                                    </svg>
                                    <span>بريدك الإلكتروني </span>

                                </label>
                                <div class="relative">
                                    <input
                                        type="email"
                                        placeholder="بريد ألكتروني للتواصل"
                                        class="w-full pl-4 pr-12 py-3 border border-[#CBD5E1] rounded-lg text-right placeholder-[#BFBFBF] font-alexandria text-sm focus:outline-none focus:border-[#144394]"
                                    />
                                    <svg
                                        class="absolute right-3 top-1/2 transform -translate-y-1/2 w-5 h-5"
                                        width="19"
                                        height="18"
                                        viewBox="0 0 19 18"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                    >
                                        <path
                                            fill-rule="evenodd"
                                            clip-rule="evenodd"
                                            d="M17.3236 4.43766L10.251 10.2948C10.05 10.4613 9.79721 10.5524 9.53621 10.5524C9.27522 10.5524 9.02242 10.4613 8.82144 10.2948L1.75215 4.43766C1.71421 4.55184 1.69492 4.67138 1.69501 4.79169V13.7543C1.69501 14.0515 1.81304 14.3364 2.02315 14.5465C2.23325 14.7566 2.51821 14.8747 2.81534 14.8747H16.2593C16.5565 14.8747 16.8414 14.7566 17.0515 14.5465C17.2616 14.3364 17.3797 14.0515 17.3797 13.7543V4.79169C17.3801 4.67144 17.3612 4.5519 17.3236 4.43766ZM2.81534 2.55103H16.2593C16.8536 2.55103 17.4235 2.78709 17.8437 3.2073C18.2639 3.62751 18.5 4.19743 18.5 4.79169V13.7543C18.5 14.3486 18.2639 14.9185 17.8437 15.3387C17.4235 15.7589 16.8536 15.995 16.2593 15.995H2.81534C2.22108 15.995 1.65116 15.7589 1.23095 15.3387C0.810746 14.9185 0.574677 14.3486 0.574677 13.7543V4.79169C0.574677 4.19743 0.810746 3.62751 1.23095 3.2073C1.65116 2.78709 2.22108 2.55103 2.81534 2.55103ZM2.58007 3.67136L8.82704 8.82825C9.02712 8.9935 9.27835 9.08418 9.53785 9.08479C9.79735 9.0854 10.049 8.99591 10.2499 8.83161L16.5596 3.67136H2.58007Z"
                                            fill="#BFBFBF"
                                        />
                                    </svg>
                                </div>
                            </div>

                            <!-- Phone Field -->
                            <div class="space-y-2">
                                <label
                                    class="flex items-center justify-start gap-2 text-sm font-medium text-[#2E2E2E] font-alexandria"
                                >
                                    <svg
                                        width="10"
                                        height="9"
                                        viewBox="0 0 10 9"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                    >
                                        <path
                                            d="M8.37943 5.35553H5.9147L7.66989 7.11072L7.14707 7.63354L5.39188 5.8783</div>5V8.34309H4.64499V5.84101L2.88981 7.5962L2.36698 7.07338L4.04748 5.35553H1.65744V4.60865H4.12217L2.36698 2.85346L2.88981 2.33064L4.64499 4.08582V1.62109H5.39188V4.01113L7.10972 2.29329L7.63254 2.85346L5.87736 4.60865H8.37943V5.35553Z"
                                            fill="#DA0000"
                                        />
                                    </svg>
                                    <span>هاتف للتواصل</span>

                                </label>
                                <div class="relative">
                                    <input
                                        type="tel"
                                        placeholder="اكتب هاتف للتواصل"
                                        class="w-full pl-4 pr-12 py-3 border border-[#CBD5E1] rounded-lg text-right placeholder-[#BFBFBF] font-alexandria text-sm focus:outline-none focus:border-[#144394]"
                                    />
                                    <svg
                                        class="absolute right-3 top-1/2 transform -translate-y-1/2 w-5 h-5"
                                        width="19"
                                        height="18"
                                        viewBox="0 0 19 18"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                    >
                                        <path
                                            fill-rule="evenodd"
                                            clip-rule="evenodd"
                                            d="M4.85695 1.83494C5.76592 0.931201 7.26268 1.09178 8.02376 2.10904L8.96633 3.3668C9.58625 4.19435 9.53098 5.35054 8.79529 6.08174L8.61753 6.2595C8.59738 6.33412 8.59533 6.41248 8.61156 6.48805C8.65861 6.79278 8.9133 7.43809 9.97986 8.49867C11.0464 9.55925 11.6962 9.81319 12.0054 9.86099C12.0833 9.87666 12.1638 9.87436 12.2407 9.85427L12.5454 9.55103C13.1997 8.90124 14.2035 8.7795 15.0131 9.21942L16.4397 9.99618C17.6623 10.6594 17.9708 12.3205 16.97 13.3161L15.9087 14.3707C15.574 14.7031 15.1244 14.9802 14.5762 15.0317C13.2243 15.1579 10.0747 14.9966 6.76376 11.7051C3.67388 8.63236 3.08085 5.95253 3.00542 4.63203C2.96807 3.96431 3.28326 3.39967 3.68509 3.00083L4.85695 1.83494ZM7.12749 2.7805C6.74882 2.27485 6.04376 2.23452 5.64641 2.62962L4.4738 3.79477C4.22733 4.03975 4.10932 4.31012 4.12426 4.56855C4.18401 5.61792 4.66202 8.0356 7.55397 10.9111C10.5878 13.9271 13.3894 14.0174 14.4724 13.9158C14.6935 13.8957 14.9131 13.7807 15.1184 13.5768L16.179 12.5214C16.6107 12.0927 16.5159 11.3115 15.9049 10.9798L14.4784 10.2038C14.084 9.99021 13.6224 10.0604 13.3356 10.3457L12.9958 10.6841L12.5999 10.2867C12.9958 10.6841 12.995 10.6848 12.9943 10.6848L12.9936 10.6863L12.9913 10.6885L12.9861 10.693L12.9749 10.7035C12.9434 10.7327 12.9094 10.7592 12.8733 10.7827C12.8136 10.8222 12.7344 10.8663 12.635 10.9029C12.4334 10.9783 12.166 11.0187 11.8359 10.9679C11.1883 10.8685 10.3301 10.4271 9.18965 9.29336C8.0499 8.15958 7.60475 7.30664 7.50467 6.65983C7.45314 6.32971 7.49422 6.06232 7.5704 5.86066C7.61233 5.74719 7.67236 5.64125 7.74816 5.54697L7.77206 5.52083L7.78251 5.50962L7.787 5.50514L7.78924 5.5029L7.79073 5.50141L8.00583 5.2878C8.3255 4.96888 8.37032 4.44083 8.06932 4.03825L7.12749 2.7805Z"
                                            fill="#BFBFBF"
                                        />
                                    </svg>
                                </div>
                            </div>

                            <!-- Company Name Field -->
                            <div class="space-y-2">
                                <label
                                    class="flex items-center justify-start gap-2 text-sm font-medium text-[#2E2E2E] font-alexandria"
                                >
                                    <svg
                                        width="10"
                                        height="9"
                                        viewBox="0 0 10 9"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                    >
                                        <path
                                            d="M8.37943 4.85553H5.9147L7.66989 6.61072L7.14707 7.13354L5.39188 5.37835V7.84309H4.64499V5.34101L2.88981 7.0962L2.36698 6.57338L4.04748 4.85553H1.65744V4.10865H4.12217L2.36698 2.35346L2.88981 1.83064L4.64499 3.58582V1.12109H5.39188V3.51113L7.10972 1.79329L7.63254 2.35346L5.87736 4.10865H8.37943V4.85553Z"
                                            fill="#DA0000"
                                        />
                                    </svg>

                                    <span>اسم الشركة </span>


                                </label>
                                <div class="relative">
                                    <input
                                        type="text"
                                        placeholder="اسم شركتك"
                                        class="w-full pl-4 pr-12 py-3 border border-[#CBD5E1] rounded-lg text-right placeholder-[#BFBFBF] font-alexandria text-sm focus:outline-none focus:border-[#144394]"
                                    />
                                    <svg
                                        class="absolute right-3 top-1/2 transform -translate-y-1/2 w-5 h-5"
                                        width="19"
                                        height="19"
                                        viewBox="0 0 19 19"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                    >
                                        <path
                                            d="M2.81491 16.2216H16.2589M7.29624 6.51203H8.04313M7.29624 9.49958H8.04313M7.29624 12.4871H8.04313M11.0307 6.51203H11.7776M11.0307 9.49958H11.7776M11.0307 12.4871H11.7776M4.30869 16.2216V4.27136C4.30869 3.87519 4.46607 3.49524 4.7462 3.2151C5.02634 2.93497 5.40629 2.77759 5.80246 2.77759H13.2713C13.6675 2.77759 14.0475 2.93497 14.3276 3.2151C14.6077 3.49524 14.7651 3.87519 14.7651 4.27136V16.2216"
                                            stroke="#BFBFBF"
                                            stroke-width="1.49378"
                                            stroke-linecap="round"
                                            stroke-linejoin="round"
                                        />
                                    </svg>
                                </div>
                            </div>
                        </div>

                        <!-- Areas of Interest -->
                        <div class="space-y-4">
                            <label
                                class="text-sm font-medium text-[#344054] font-alexandria text-right block"
                            >
                                المجالات التي ترغب بها
                            </label>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">

                                <!-- Right Column -->
                                <div class="space-y-4">
                                    <label
                                        class="flex items-center justify-start gap-3 cursor-pointer"
                                    >
                                        <input
                                            type="checkbox"
                                            class="w-5 h-5 border border-[#D0D5DD] rounded bg-white focus:ring-2 focus:ring-[#00B34F]"
                                        />
                                        <span class="text-sm text-[#344054] font-alexandria"
                                        >التسويق الإلكتروني</span
                                        >
                                    </label>
                                    <label
                                        class="flex items-center justify-start gap-3 cursor-pointer"
                                    >
                                        <input
                                            type="checkbox"
                                            class="w-5 h-5 border border-[#D0D5DD] rounded bg-white focus:ring-2 focus:ring-[#00B34F]"
                                        />
                                        <span class="text-sm text-[#344054] font-alexandria"
                                        >الموارد البشرية</span
                                        >
                                    </label>
                                    <label
                                        class="flex items-center justify-start gap-3 cursor-pointer"
                                    >
                                        <input
                                            type="checkbox"
                                            class="w-5 h-5 border border-[#D0D5DD] rounded bg-white focus:ring-2 focus:ring-[#00B34F]"
                                        />
                                        <span class="text-sm text-[#344054] font-alexandria"
                                        >الذكاء الإصطناعي</span
                                        >
                                    </label>
                                </div>

                                <!-- Left Column -->
                                <div class="space-y-4">
                                    <label
                                        class="flex items-center justify-start gap-3 cursor-pointer"
                                    >
                                        <input
                                            type="checkbox"
                                            class="w-5 h-5 border border-[#D0D5DD] rounded bg-white focus:ring-2 focus:ring-[#00B34F]"
                                        />
                                        <span class="text-sm text-[#344054] font-alexandria"
                                        >الإدارة و القيادة</span
                                        >
                                    </label>
                                    <label
                                        class="flex items-center justify-start gap-3 cursor-pointer"
                                    >
                                        <input
                                            type="checkbox"
                                            class="w-5 h-5 border border-[#D0D5DD] rounded bg-white focus:ring-2 focus:ring-[#00B34F]"
                                        />
                                        <span class="text-sm text-[#344054] font-alexandria"
                                        >الموارد البشرية</span
                                        >
                                    </label>
                                    <label
                                        class="flex items-center justify-start gap-3 cursor-pointer"
                                    >
                                        <input
                                            type="checkbox"
                                            class="w-5 h-5 border border-[#D0D5DD] rounded bg-white focus:ring-2 focus:ring-[#00B34F]"
                                        />
                                        <span class="text-sm text-[#344054] font-alexandria"
                                        >التسويق الإلكتروني</span
                                        >
                                    </label>
                                </div>

                            </div>
                        </div>

                        <!-- Submit Button -->
                        <button
                            type="submit"
                            class="w-full flex items-center justify-space-between gap-3 px-6 py-3 bg-[#00B34F] rounded-lg text-white font-alexandria font-medium hover:bg-[#00A047] transition-colors"
                        >

                            <span class="text-base">احجز عرضًا توضيحيًا الآن</span>


                            <svg
                                width="24"
                                height="24"
                                viewBox="0 0 24 24"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                                class="mr-auto"
                            >
                                <path
                                    d="M8.914 13.3431L12.864 17.2931C13.0462 17.4817 13.147 17.7343 13.1447 17.9965C13.1424 18.2587 13.0372 18.5095 12.8518 18.6949C12.6664 18.8803 12.4156 18.9855 12.1534 18.9878C11.8912 18.99 11.6386 18.8892 11.45 18.7071L5.793 13.0501C5.69982 12.9574 5.62587 12.8473 5.57541 12.7259C5.52494 12.6046 5.49897 12.4745 5.49897 12.3431C5.49897 12.2117 5.52494 12.0816 5.57541 11.9602C5.62587 11.8389 5.69982 11.7287 5.793 11.6361L11.45 5.97908C11.5422 5.88357 11.6526 5.80739 11.7746 5.75498C11.8966 5.70257 12.0278 5.67498 12.1606 5.67383C12.2934 5.67268 12.4251 5.69798 12.548 5.74826C12.6709 5.79854 12.7825 5.87279 12.8764 5.96669C12.9703 6.06058 13.0445 6.17223 13.0948 6.29513C13.1451 6.41802 13.1704 6.5497 13.1693 6.68248C13.1681 6.81526 13.1405 6.94648 13.0881 7.06849C13.0357 7.19049 12.9595 7.30083 12.864 7.39308L8.914 11.3431H18.5C18.7652 11.3431 19.0196 11.4484 19.2071 11.636C19.3946 11.8235 19.5 12.0779 19.5 12.3431C19.5 12.6083 19.3946 12.8627 19.2071 13.0502C19.0196 13.2377 18.7652 13.3431 18.5 13.3431H8.914Z"
                                    fill="white"
                                />
                            </svg>
                        </button>
                    </form>
                </div>
            </div>


        </div>
    </div>

    <!-- ============================= End Of Courses Section ============================= -->
@endsection
@push('footerScript')
@endpush
