@foreach($course->Comments()->whereNotNull('approved_at')->when(auth()->check(),function($q){$q->orWhere('user_id',auth()->id());})->get() as $comment)
    <!-- Comment {{ $loop->index+1 }} -->
    <div class="flex flex-col items-start gap-4">
        <div class="flex items-center gap-4">
            <div class="flex items-center gap-3">
                <div class="w-8 h-8 rounded-lg bg-gray-400 flex-shrink-0">
                    <img class="w-full h-full object-cover rounded-lg"
                         src="{{ $comment->User->image?asset('assets/images/'.$comment->User->image):asset('frontend/images/course-curriculum/comment1.png') }}" alt="User Avatar" />
                </div>
                <div class="text-[#1c1c1c] font-tajawal text-base font-medium leading-6">
                    {{ $comment->User->FullName }}
                </div>
            </div>
            <div class="text-[#858585] font-tajawal text-sm font-medium leading-5 text-right">
                {{ $comment->created_at->diffForHumans() }}
            </div>
        </div>
        <div
            class="text-[#1c1c1c] text-right font-tajawal text-lg font-medium leading-7 w-full max-w-[1394px] max-md:text-base max-md:leading-6">
            {{ $comment->comment }}
        </div>
    </div>
@endforeach
