@extends('frontend.layouts.app')
@push('headScript')
    <!-- Tailwind Configuration -->
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        alexandria: ["Alexandria", "sans-serif"],
                        tajawal: ["Tajawal", "sans-serif"],
                    },
                    colors: {
                        "brand-success": "#00B34F",
                        "brand-secondary-normal": "#00B34F",
                        "brand-secondary-light": "#E6F7ED",
                        "brand-primary-normal": "#144394",
                        "brand-primary-light": "#E8ECF4",
                    },
                },
            },
        };
    </script>

    <style>
        body {
            font-family: "Alexandria", sans-serif;
        }

        /* Mobile Menu Styles */
        .mobile-menu {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.4s ease-in-out, opacity 0.3s ease-in-out;
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
        }

        .mobile-menu.open {
            max-height: 600px;
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        /* Ensure mobile menu is above other elements */
        .mobile-menu .bg-white\/95 {
            background-color: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
        }

        /* Mobile menu animation */
        .mobile-menu .mobile-menu-content {
            transform: translateY(-20px);
            transition: transform 0.3s ease-out;
        }

        .mobile-menu.open .mobile-menu-content {
            transform: translateY(0);
        }

        /* Mobile responsive button adjustments */
        @media (max-width: 768px) {
            .responsive-button-text {
                display: none;
            }

            .responsive-button-icon {
                margin: 0 !important;
            }
        }

        @media (max-width: 640px) {
            .hero-title-mobile {
                font-size: 2.5rem !important;
                line-height: 3rem !important;
            }
        }
    </style>
@endpush
@section('content')
    <!-- Hero Section for Search Certificate Page -->
    <div class="relative overflow-hidden min-h-[700px]">
        <!-- Background Image -->
        <div class="absolute left-0 bottom-0 z-0">
            <img src="{{ asset('frontend/images') }}/hero-fqa-background.png" alt="Background" />
        </div>

        <!-- Background Gradient Overlay -->
        <div class="absolute inset-0">
            <svg
                class="w-full h-full"
                viewBox="0 0 1600 808"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
                preserveAspectRatio="xMidYMid slice"
            >
                <path
                    d="M0 0H1600V808H0V0Z"
                    fill="url(#paint0_linear_gradient_overlay)"
                />
                <defs>
                    <linearGradient
                        id="paint0_linear_gradient_overlay"
                        x1="205.022"
                        y1="0"
                        x2="1573.65"
                        y2="664.405"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop offset="0%" stop-color="#0C2959" stop-opacity="0.45" />
                        <stop offset="18.28%" stop-color="#0C2959" stop-opacity="0.55" />
                        <stop offset="31.41%" stop-color="#0C2959" stop-opacity="0.62" />
                        <stop offset="49.65%" stop-color="#0C2959" stop-opacity="0.72" />
                        <stop offset="74.35%" stop-color="#0C2959" stop-opacity="0.86" />
                        <stop offset="100%" stop-color="#0C2959" />
                    </linearGradient>
                </defs>
            </svg>
        </div>

        <!-- Background Ellipses -->
        <div class="absolute -top-96 -left-96">
            <img
                src="{{ asset('frontend/images') }}/hero-background.png"
                alt="Background Ellipses"
                class="w-[1179px] h-[1101px] object-contain"
            />
        </div>

        <!-- Wave at bottom -->
        <div class="absolute bottom-0 left-0 w-full">
            <svg
                class="w-full h-52"
                viewBox="0 0 1600 202"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
                preserveAspectRatio="none"
            >
                <path
                    fill-rule="evenodd"
                    clip-rule="evenodd"
                    d="M0 79.458C0 79.458 226.389 186.741 381.052 178.06C535.714 169.378 628.364 133.594 798.309 151.486C968.253 169.378 1461.17 124.238 1600 0V209.034H0V79.458Z"
                    fill="#FDFDFF"
                />
            </svg>
        </div>
        <!-- Content Container -->
        <div
            class="relative z-10 pt-32 pb-32 px-4 md:px-8 lg:px-16 min-h-[700px] flex items-center justify-center"
        >
            <div class="max-w-4xl mx-auto text-center">
                <!-- Breadcrumb Navigation -->
                <div class="flex items-center justify-center gap-2 mb-6">
                    <a
                        class="font-tajawal font-medium text-white text-base"
                        href="/index.html"
                    >
                        الرئيسية
                    </a>
                    <div class="w-6 h-6 flex items-center justify-center">
                        <svg
                            width="6"
                            height="10"
                            viewBox="0 0 6 10"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                            style="transform: rotate(180deg)"
                        >
                            <path
                                d="M1 1L5 5L1 9"
                                stroke="white"
                                stroke-width="1.5"
                                stroke-linecap="round"
                                stroke-linejoin="round"
                            />
                        </svg>
                    </div>
                    <div class="font-tajawal font-medium text-[#00B34F] text-base">
                        الاسئلة الشائعة
                    </div>
                </div>

                <!-- Main Title -->
                <h1
                    class="font-tajawal font-bold text-white leading-tight tracking-tight mb-4 text-4xl hero-title-mobile"
                >
                    الاسئلة الشائعة
                </h1>

                <!-- Subtitle -->
                <p class="font-tajawal font-medium text-[#DEDEDE] text-lg mb-8">
                    إجابات سريعة وواضحة لأكثر استفساراتكم شيوعًا
                </p>
            </div>
        </div>
    </div>

    <!-- FAQ Section -->
    <section class="bg-[#FDFDFF] py-16 lg:py-20" dir="rtl">
        <div class="max-w-7xl mx-auto px-4 md:px-8 lg:px-16">
            <!-- Filter Tabs -->
            <div class="flex flex-wrap items-center justify-center gap-6 mb-16">
                <button
                    id="general-tab"
                    class="tab-button bg-[#144394] rounded-full px-6 py-4 text-white font-tajawal font-medium text-lg hover:text-[#111111]"
                    onclick="switchTab('general')"
                >
                    اسئلة عامة
                </button>
                <button
                    id="subscription-tab"
                    class="tab-button bg-white border border-[#E8ECF4] rounded-full px-6 py-4 text-[#111111] font-tajawal font-medium text-lg hover:bg-[#F2F4F9] transition-colors hover:text-[#111111]"
                    onclick="switchTab('subscription')"
                >
                    الإشتراك السنوى
                </button>
                <button
                    id="programs-tab"
                    class="tab-button bg-white border border-[#E8ECF4] rounded-full px-6 py-4 text-[#111111] font-tajawal font-medium text-lg hover:bg-[#F2F4F9] transition-colors hover:text-[#111111]"
                    onclick="switchTab('programs')"
                >
                    اسئلة البرامج
                </button>
            </div>

            <!-- FAQ Content -->
            <div class="max-w-4xl mx-auto">
                <!-- Section Header -->
                <div class="text-center mb-16">
                    <h2
                        id="section-title"
                        class="font-tajawal font-medium text-[#111111] text-4xl leading-[44px] tracking-[-0.72px] mb-5"
                    >
                        اسئلة عامة
                    </h2>
                    <p
                        id="section-subtitle"
                        class="font-tajawal font-medium text-[#7B7B7B] text-xl leading-[30px]"
                    >
                        كل شئ تريد معرفته عن البرنامج
                    </p>
                </div>

                <!-- General Questions Tab Content -->
                <div id="general-content" class="tab-content space-y-4">
                    <!-- FAQ Item 1 - Expanded by default -->
                    <div class="bg-[#F2F4F9] rounded-2xl p-8">
                        <button class="w-full text-right" onclick="toggleFAQ(this)">
                            <div
                                class="flex flex-row-reverse items-start justify-between gap-6"
                            >
                                <div class="flex-shrink-0 pt-1">
                                    <img
                                        src="{{ asset('frontend/images') }}/minus-icon.svg"
                                        alt="Collapse"
                                        class="w-6 h-6 minus-icon"
                                    />
                                    <img
                                        src="{{ asset('frontend/images') }}/plus-icon.svg"
                                        alt="Expand"
                                        class="w-6 h-6 plus-icon hidden"
                                    />
                                </div>
                                <div class="flex-1">
                                    <h3
                                        class="font-tajawal font-medium text-[#111111] text-xl leading-[30px] mb-2"
                                    >
                                        هل هناك نسخة تجريبية مجانية متاحة؟
                                    </h3>
                                    <div class="faq-answer">
                                        <p
                                            class="font-tajawal font-medium text-[#7B7B7B] text-lg leading-[28px]"
                                        >
                                            نعم، يمكنك تجربتها مجانًا لمدة 30 يومًا. إذا كنت تريد
                                            ذلك، فسنزودك بمكالمة تأهيل مجانية وشخصية مدتها 30 دقيقة
                                            لإعدادك وتشغيلك في أقرب وقت ممكن.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </button>
                    </div>

                    <!-- FAQ Item 2 -->
                    <div class="rounded-2xl p-8 hover:bg-[#F9F9F9] transition-colors">
                        <button class="w-full text-right" onclick="toggleFAQ(this)">
                            <div
                                class="flex flex-row-reverse items-start justify-between gap-6"
                            >
                                <div class="flex-shrink-0 pt-1">
                                    <img
                                        src="{{ asset('frontend/images') }}/minus-icon.svg"
                                        alt="Collapse"
                                        class="w-6 h-6 minus-icon hidden"
                                    />
                                    <img
                                        src="{{ asset('frontend/images') }}/plus-icon.svg"
                                        alt="Expand"
                                        class="w-6 h-6 plus-icon"
                                    />
                                </div>
                                <div class="flex-1">
                                    <h3
                                        class="font-tajawal font-medium text-[#111111] text-xl leading-[30px]"
                                    >
                                        ما هي أهداف الأكاديمية؟
                                    </h3>
                                    <div class="faq-answer hidden">
                                        <p
                                            class="font-tajawal font-medium text-[#7B7B7B] text-lg leading-[28px] mt-2"
                                        >
                                            تهدف أكاديمية إعمل بيزنس إلى تقديم تعليم عملي ومتخصص في
                                            مجال ريادة الأعمال وإدارة المشاريع، مع التركيز على
                                            المهارات العملية التي يحتاجها رواد الأعمال.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </button>
                    </div>

                    <!-- FAQ Item 3 -->
                    <div class="rounded-2xl p-8 hover:bg-[#F9F9F9] transition-colors">
                        <button class="w-full text-right" onclick="toggleFAQ(this)">
                            <div
                                class="flex flex-row-reverse items-start justify-between gap-6"
                            >
                                <div class="flex-shrink-0 pt-1">
                                    <img
                                        src="{{ asset('frontend/images') }}/minus-icon.svg"
                                        alt="Collapse"
                                        class="w-6 h-6 minus-icon hidden"
                                    />
                                    <img
                                        src="{{ asset('frontend/images') }}/plus-icon.svg"
                                        alt="Expand"
                                        class="w-6 h-6 plus-icon"
                                    />
                                </div>
                                <div class="flex-1">
                                    <h3
                                        class="font-tajawal font-medium text-[#111111] text-xl leading-[30px]"
                                    >
                                        هل الأكاديمية معتمدة؟
                                    </h3>
                                    <div class="faq-answer hidden">
                                        <p
                                            class="font-tajawal font-medium text-[#7B7B7B] text-lg leading-[28px] mt-2"
                                        >
                                            نعم، أكاديمية إعمل بيزنس معتمدة ومرخصة رسمياً، وتقدم
                                            شهادات معتمدة في جميع البرامج التدريبية.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </button>
                    </div>

                    <!-- FAQ Item 4 -->
                    <div class="rounded-2xl p-8 hover:bg-[#F9F9F9] transition-colors">
                        <button class="w-full text-right" onclick="toggleFAQ(this)">
                            <div
                                class="flex flex-row-reverse items-start justify-between gap-6"
                            >
                                <div class="flex-shrink-0 pt-1">
                                    <img
                                        src="{{ asset('frontend/images') }}/minus-icon.svg"
                                        alt="Collapse"
                                        class="w-6 h-6 minus-icon hidden"
                                    />
                                    <img
                                        src="{{ asset('frontend/images') }}/plus-icon.svg"
                                        alt="Expand"
                                        class="w-6 h-6 plus-icon"
                                    />
                                </div>
                                <div class="flex-1">
                                    <h3
                                        class="font-tajawal font-medium text-[#111111] text-xl leading-[30px]"
                                    >
                                        كم عدد الطلاب المسجلين في الأكاديمية؟
                                    </h3>
                                    <div class="faq-answer hidden">
                                        <p
                                            class="font-tajawal font-medium text-[#7B7B7B] text-lg leading-[28px] mt-2"
                                        >
                                            يدرس في أكاديمية إعمل بيزنس أكثر من 50,000 طالب من مختلف
                                            البلدان العربية، مما يجعلها واحدة من أكبر الأكاديميات
                                            المتخصصة في ريادة الأعمال.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </button>
                    </div>
                </div>

                <!-- Subscription Questions Tab Content -->
                <div id="subscription-content" class="tab-content space-y-4 hidden">
                    <!-- FAQ Item 1 -->
                    <div class="bg-[#F2F4F9] rounded-2xl p-8">
                        <button class="w-full text-right" onclick="toggleFAQ(this)">
                            <div
                                class="flex flex-row-reverse items-start justify-between gap-6"
                            >
                                <div class="flex-shrink-0 pt-1">
                                    <img
                                        src="{{ asset('frontend/images') }}/minus-icon.svg"
                                        alt="Collapse"
                                        class="w-6 h-6 minus-icon"
                                    />
                                    <img
                                        src="{{ asset('frontend/images') }}/plus-icon.svg"
                                        alt="Expand"
                                        class="w-6 h-6 plus-icon hidden"
                                    />
                                </div>
                                <div class="flex-1">
                                    <h3
                                        class="font-tajawal font-medium text-[#111111] text-xl leading-[30px] mb-2"
                                    >
                                        ما هي مميزات الإشتراك السنوي؟
                                    </h3>
                                    <div class="faq-answer">
                                        <p
                                            class="font-tajawal font-medium text-[#7B7B7B] text-lg leading-[28px]"
                                        >
                                            الإشتراك السنوي يتيح لك الوصول إلى جميع الكورسات
                                            والبرامج التدريبية مع خصم يصل إلى 30% مقارنة بالإشتراك
                                            الشهري، بالإضافة إلى إمكانية الوصول إلى المحتوى الحصري
                                            والجلسات المباشرة.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </button>
                    </div>

                    <!-- FAQ Item 2 -->
                    <div class="rounded-2xl p-8 hover:bg-[#F9F9F9] transition-colors">
                        <button class="w-full text-right" onclick="toggleFAQ(this)">
                            <div
                                class="flex flex-row-reverse items-start justify-between gap-6"
                            >
                                <div class="flex-shrink-0 pt-1">
                                    <img
                                        src="{{ asset('frontend/images') }}/minus-icon.svg"
                                        alt="Collapse"
                                        class="w-6 h-6 minus-icon hidden"
                                    />
                                    <img
                                        src="{{ asset('frontend/images') }}/plus-icon.svg"
                                        alt="Expand"
                                        class="w-6 h-6 plus-icon"
                                    />
                                </div>
                                <div class="flex-1">
                                    <h3
                                        class="font-tajawal font-medium text-[#111111] text-xl leading-[30px]"
                                    >
                                        هل يمكنني تغيير خطتي لاحقًا؟
                                    </h3>
                                    <div class="faq-answer hidden">
                                        <p
                                            class="font-tajawal font-medium text-[#7B7B7B] text-lg leading-[28px] mt-2"
                                        >
                                            نعم، يمكنك ترقية أو تخفيض خطتك في أي وقت من خلال إعدادات
                                            الحساب. ستدخل التغييرات حيز التنفيذ في بداية دورة
                                            الفوترة التالية.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </button>
                    </div>

                    <!-- FAQ Item 3 -->
                    <div class="rounded-2xl p-8 hover:bg-[#F9F9F9] transition-colors">
                        <button class="w-full text-right" onclick="toggleFAQ(this)">
                            <div
                                class="flex flex-row-reverse items-start justify-between gap-6"
                            >
                                <div class="flex-shrink-0 pt-1">
                                    <img
                                        src="{{ asset('frontend/images') }}/minus-icon.svg"
                                        alt="Collapse"
                                        class="w-6 h-6 minus-icon hidden"
                                    />
                                    <img
                                        src="{{ asset('frontend/images') }}/plus-icon.svg"
                                        alt="Expand"
                                        class="w-6 h-6 plus-icon"
                                    />
                                </div>
                                <div class="flex-1">
                                    <h3
                                        class="font-tajawal font-medium text-[#111111] text-xl leading-[30px]"
                                    >
                                        ما هي سياسة الإلغاء الخاصة بك؟
                                    </h3>
                                    <div class="faq-answer hidden">
                                        <p
                                            class="font-tajawal font-medium text-[#7B7B7B] text-lg leading-[28px] mt-2"
                                        >
                                            يمكنك إلغاء اشتراكك في أي وقت. عند الإلغاء، ستتمكن من
                                            الوصول إلى جميع الميزات حتى نهاية فترة الفوترة الحالية.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </button>
                    </div>

                    <!-- FAQ Item 4 -->
                    <div class="rounded-2xl p-8 hover:bg-[#F9F9F9] transition-colors">
                        <button class="w-full text-right" onclick="toggleFAQ(this)">
                            <div
                                class="flex flex-row-reverse items-start justify-between gap-6"
                            >
                                <div class="flex-shrink-0 pt-1">
                                    <img
                                        src="{{ asset('frontend/images') }}/minus-icon.svg"
                                        alt="Collapse"
                                        class="w-6 h-6 minus-icon hidden"
                                    />
                                    <img
                                        src="{{ asset('frontend/images') }}/plus-icon.svg"
                                        alt="Expand"
                                        class="w-6 h-6 plus-icon"
                                    />
                                </div>
                                <div class="flex-1">
                                    <h3
                                        class="font-tajawal font-medium text-[#111111] text-xl leading-[30px]"
                                    >
                                        كيف تعمل الفواتير؟
                                    </h3>
                                    <div class="faq-answer hidden">
                                        <p
                                            class="font-tajawal font-medium text-[#7B7B7B] text-lg leading-[28px] mt-2"
                                        >
                                            نرسل الفواتير شهريًا أو سنويًا حسب خطتك المختارة. ستصل
                                            الفاتورة إلى بريدك الإلكتروني ويمكنك تنزيلها من لوحة
                                            التحكم.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </button>
                    </div>
                </div>

                <!-- Programs Questions Tab Content -->
                <div id="programs-content" class="tab-content space-y-4 hidden">
                    <!-- FAQ Item 1 -->
                    <div class="bg-[#F2F4F9] rounded-2xl p-8">
                        <button class="w-full text-right" onclick="toggleFAQ(this)">
                            <div
                                class="flex flex-row-reverse items-start justify-between gap-6"
                            >
                                <div class="flex-shrink-0 pt-1">
                                    <img
                                        src="{{ asset('frontend/images') }}/minus-icon.svg"
                                        alt="Collapse"
                                        class="w-6 h-6 minus-icon"
                                    />
                                    <img
                                        src="{{ asset('frontend/images') }}/plus-icon.svg"
                                        alt="Expand"
                                        class="w-6 h-6 plus-icon hidden"
                                    />
                                </div>
                                <div class="flex-1">
                                    <h3
                                        class="font-tajawal font-medium text-[#111111] text-xl leading-[30px] mb-2"
                                    >
                                        ما هي البرامج المتاحة في الأكاديمية؟
                                    </h3>
                                    <div class="faq-answer">
                                        <p
                                            class="font-tajawal font-medium text-[#7B7B7B] text-lg leading-[28px]"
                                        >
                                            تقدم الأكاديمية برامج متنوعة في ريادة الأعمال، إدارة
                                            المشاريع، التسويق الرقمي، تحليل البيانات، التصميم
                                            الجرافيكي، والذكاء الاصطناعي. جميع البرامج مصممة لتلبية
                                            احتياجات السوق الحالية.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </button>
                    </div>

                    <!-- FAQ Item 2 -->
                    <div class="rounded-2xl p-8 hover:bg-[#F9F9F9] transition-colors">
                        <button class="w-full text-right" onclick="toggleFAQ(this)">
                            <div
                                class="flex flex-row-reverse items-start justify-between gap-6"
                            >
                                <div class="flex-shrink-0 pt-1">
                                    <img
                                        src="{{ asset('frontend/images') }}/minus-icon.svg"
                                        alt="Collapse"
                                        class="w-6 h-6 minus-icon hidden"
                                    />
                                    <img
                                        src="{{ asset('frontend/images') }}/plus-icon.svg"
                                        alt="Expand"
                                        class="w-6 h-6 plus-icon"
                                    />
                                </div>
                                <div class="flex-1">
                                    <h3
                                        class="font-tajawal font-medium text-[#111111] text-xl leading-[30px]"
                                    >
                                        كم تستغرق مدة البرنامج؟
                                    </h3>
                                    <div class="faq-answer hidden">
                                        <p
                                            class="font-tajawal font-medium text-[#7B7B7B] text-lg leading-[28px] mt-2"
                                        >
                                            تتراوح مدة البرامج من 4 إلى 12 أسبوع حسب البرنامج
                                            المختار. كل برنامج مقسم إلى وحدات تعليمية متدرجة يمكنك
                                            إنجازها بالسرعة التي تناسبك.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </button>
                    </div>

                    <!-- FAQ Item 3 -->
                    <div class="rounded-2xl p-8 hover:bg-[#F9F9F9] transition-colors">
                        <button class="w-full text-right" onclick="toggleFAQ(this)">
                            <div
                                class="flex flex-row-reverse items-start justify-between gap-6"
                            >
                                <div class="flex-shrink-0 pt-1">
                                    <img
                                        src="{{ asset('frontend/images') }}/minus-icon.svg"
                                        alt="Collapse"
                                        class="w-6 h-6 minus-icon hidden"
                                    />
                                    <img
                                        src="{{ asset('frontend/images') }}/plus-icon.svg"
                                        alt="Expand"
                                        class="w-6 h-6 plus-icon"
                                    />
                                </div>
                                <div class="flex-1">
                                    <h3
                                        class="font-tajawal font-medium text-[#111111] text-xl leading-[30px]"
                                    >
                                        هل أحصل على شهادة بعد إكمال البرنامج؟
                                    </h3>
                                    <div class="faq-answer hidden">
                                        <p
                                            class="font-tajawal font-medium text-[#7B7B7B] text-lg leading-[28px] mt-2"
                                        >
                                            نعم، ستحصل على شهادة معتمدة من أكاديمية إعمل بيزنس بعد
                                            إكمال البرنامج بنجاح واجتياز جميع التقييمات المطلوبة.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </button>
                    </div>

                    <!-- FAQ Item 4 -->
                    <div class="rounded-2xl p-8 hover:bg-[#F9F9F9] transition-colors">
                        <button class="w-full text-right" onclick="toggleFAQ(this)">
                            <div
                                class="flex flex-row-reverse items-start justify-between gap-6"
                            >
                                <div class="flex-shrink-0 pt-1">
                                    <img
                                        src="{{ asset('frontend/images') }}/minus-icon.svg"
                                        alt="Collapse"
                                        class="w-6 h-6 minus-icon hidden"
                                    />
                                    <img
                                        src="{{ asset('frontend/images') }}/plus-icon.svg"
                                        alt="Expand"
                                        class="w-6 h-6 plus-icon"
                                    />
                                </div>
                                <div class="flex-1">
                                    <h3
                                        class="font-tajawal font-medium text-[#111111] text-xl leading-[30px]"
                                    >
                                        هل يمكنني الحصول على دعم أثناء البرنامج؟
                                    </h3>
                                    <div class="faq-answer hidden">
                                        <p
                                            class="font-tajawal font-medium text-[#7B7B7B] text-lg leading-[28px] mt-2"
                                        >
                                            بالطبع، يتوفر فريق دعم متخصص لمساعدتك في أي استفسارات أو
                                            مشاكل تواجهها أثناء الدراسة. يمكنك التواصل معنا عبر
                                            الدردشة المباشرة أو البريد الإلكتروني.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@push('footerScript')
    <script>
        // FAQ Accordion Functionality
        function toggleFAQ(button) {
            const faqItem = button.closest("div"); // Get the parent div containing the entire FAQ item
            const answer = button.querySelector(".faq-answer");
            const plusIcon = button.querySelector(".plus-icon");
            const minusIcon = button.querySelector(".minus-icon");

            // Close all other FAQ items
            document.querySelectorAll(".faq-answer").forEach((item) => {
                if (item !== answer) {
                    item.classList.add("hidden");
                    // Find the parent FAQ item div
                    const otherFaqItem = item.closest("div[class*='rounded-2xl']");
                    if (otherFaqItem) {
                        otherFaqItem.classList.remove("bg-[#F2F4F9]");
                        if (!otherFaqItem.classList.contains("bg-[#F2F4F9]")) {
                            otherFaqItem.classList.add("hover:bg-[#F9F9F9]");
                        }
                    }
                    // Find the icons in the other FAQ items
                    const otherButton = item.closest("button");
                    if (otherButton) {
                        const otherPlus = otherButton.querySelector(".plus-icon");
                        const otherMinus = otherButton.querySelector(".minus-icon");
                        if (otherPlus) otherPlus.classList.remove("hidden");
                        if (otherMinus) otherMinus.classList.add("hidden");
                    }
                }
            });

            // Toggle current FAQ item
            if (answer && answer.classList.contains("hidden")) {
                // Open the FAQ
                answer.classList.remove("hidden");
                faqItem.classList.add("bg-[#F2F4F9]");
                faqItem.classList.remove("hover:bg-[#F9F9F9]");
                if (plusIcon) plusIcon.classList.add("hidden");
                if (minusIcon) minusIcon.classList.remove("hidden");
            } else if (answer) {
                // Close the FAQ
                answer.classList.add("hidden");
                faqItem.classList.remove("bg-[#F2F4F9]");
                faqItem.classList.add("hover:bg-[#F9F9F9]");
                if (plusIcon) plusIcon.classList.remove("hidden");
                if (minusIcon) minusIcon.classList.add("hidden");
            }
        }

        // Tab Switching Functionality
        function switchTab(tabName) {
            // Tab data
            const tabData = {
                general: {
                    title: "اسئلة عامة",
                    subtitle: "كل شئ تريد معرفته عن البرنامج",
                },
                subscription: {
                    title: "الإشتراك السنوى",
                    subtitle: "كل ما تحتاج لمعرفته عن خطط الاشتراك",
                },
                programs: {
                    title: "اسئلة البرامج",
                    subtitle: "معلومات تفصيلية عن البرامج التدريبية",
                },
            };

            // Remove active class from all tabs
            document.querySelectorAll(".tab-button").forEach((tab) => {
                tab.classList.remove("bg-[#144394]", "text-white");
                tab.classList.add(
                    "bg-white",
                    "border",
                    "border-[#E8ECF4]",
                    "text-[#111111]"
                );
            });

            // Add active class to clicked tab
            const activeTab = document.getElementById(tabName + "-tab");
            if (activeTab) {
                activeTab.classList.add("bg-[#144394]", "text-white");
                activeTab.classList.remove(
                    "bg-white",
                    "border",
                    "border-[#E8ECF4]",
                    "text-[#111111]"
                );
            }

            // Hide all tab contents
            document.querySelectorAll(".tab-content").forEach((content) => {
                content.classList.add("hidden");
            });

            // Show active tab content
            const activeContent = document.getElementById(tabName + "-content");
            if (activeContent) {
                activeContent.classList.remove("hidden");
            }

            // Update section title and subtitle
            const sectionTitle = document.getElementById("section-title");
            const sectionSubtitle = document.getElementById("section-subtitle");

            if (sectionTitle && tabData[tabName]) {
                sectionTitle.textContent = tabData[tabName].title;
            }

            if (sectionSubtitle && tabData[tabName]) {
                sectionSubtitle.textContent = tabData[tabName].subtitle;
            }

            // Close all FAQ items in the new tab
            setTimeout(() => {
                const newTabContent = document.getElementById(tabName + "-content");
                if (newTabContent) {
                    // Find all FAQ items in the new tab
                    const faqItems = newTabContent.querySelectorAll(".faq-answer");
                    const faqContainers = newTabContent.querySelectorAll(
                        'div[class*="rounded-2xl"]'
                    );

                    faqItems.forEach((item, index) => {
                        if (index === 0) {
                            // Keep first item open
                            item.classList.remove("hidden");
                            const container = faqContainers[index];
                            if (container) {
                                container.classList.add("bg-[#F2F4F9]");
                                container.classList.remove("hover:bg-[#F9F9F9]");
                            }
                            // Set icons for first item
                            const button =
                                item.closest("button") ||
                                item.parentElement.closest("button");
                            if (button) {
                                const plus = button.querySelector(".plus-icon");
                                const minus = button.querySelector(".minus-icon");
                                if (plus) plus.classList.add("hidden");
                                if (minus) minus.classList.remove("hidden");
                            }
                        } else {
                            // Close other items
                            item.classList.add("hidden");
                            const container = faqContainers[index];
                            if (container) {
                                container.classList.remove("bg-[#F2F4F9]");
                                container.classList.add("hover:bg-[#F9F9F9]");
                            }
                            // Set icons for other items
                            const button =
                                item.closest("button") ||
                                item.parentElement.closest("button");
                            if (button) {
                                const plus = button.querySelector(".plus-icon");
                                const minus = button.querySelector(".minus-icon");
                                if (plus) plus.classList.remove("hidden");
                                if (minus) minus.classList.add("hidden");
                            }
                        }
                    });
                }
            }, 100);
        }
    </script>
@endpush
