@extends('frontend.layouts.app')
@push('headScript')
    <!-- Tailwind Configuration -->
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        alexandria: ["Alexandria", "sans-serif"],
                        tajawal: ["Tajawal", "sans-serif"],
                    },
                    colors: {
                        "brand-primary-light": "#E8ECF4",
                        "brand-secondary-normal": "#00B34F",
                        "brand-primary-normal": "#144394",
                        "brand-primary-bg": "#F2F4F9",
                        title: "#102844",
                        "neutral-n20": "#F5F5F5",
                        "neutral-n10": "#FAFAFA",
                        "neutral-n100": "#757575",
                        "gray-shade": "#F8F8FB",
                        orange: "#e2a73c",
                        "orange-light": "#FBB943",
                        "orange-bg": "#FFF8EC",
                        "error-light": "#fdeaea",
                        "error-red": "#f15353",
                        "success-light": "#e6f7ed",
                        "success-border": "#d9f4e5",
                    },
                },
            },
        };
    </script>

    <!-- Custom CSS for Circle Animation -->
    <style>
        @keyframes drawProgressCircle {
            0% {
                stroke-dasharray: 0 219.91;
                stroke-dashoffset: 0;
            }
            100% {
                stroke-dasharray: var(--progress-dash) var(--remaining-dash);
                stroke-dashoffset: 0;
            }
        }

        .progress-circle-animated {
            animation: drawProgressCircle 2s ease-in-out forwards;
            transition: stroke 0.5s ease-in-out;
        }

        /* Fallback for browsers that don't support CSS variables in animations */
        .progress-circle-fallback {
            transition: stroke-dasharray 2s ease-in-out, stroke 0.5s ease-in-out;
        }

        .progress-circle-element {
            transform-origin: center;
        }
    </style>

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: "Tajawal", -apple-system, Roboto, Helvetica, sans-serif;
            direction: rtl;
            background-color: #fdfdff;
        }

        /* Mobile Menu Styles */
        .mobile-menu {
            animation-duration: 0.3s;
            animation-timing-function: ease-out;
        }

        .mobile-menu.show {
            animation-name: slideDown;
        }

        .mobile-menu.hide {
            animation-name: slideUp;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes slideUp {
            from {
                opacity: 1;
                transform: translateY(0);
            }

            to {
                opacity: 0;
                transform: translateY(-10px);
            }
        }

        .mobile-menu-backdrop.show {
            animation: fadeIn 0.3s ease-out;
        }

        .mobile-menu-backdrop.hide {
            animation: fadeOut 0.3s ease-out;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        @keyframes fadeOut {
            from {
                opacity: 1;
            }

            to {
                opacity: 0;
            }
        }

        /* Hover effects for navigation links */
        .nav-link:hover {
            transform: translateY(-1px);
            transition: all 0.2s ease;
        }

        .mobile-nav-link:hover {
            background-color: rgba(255, 255, 255, 0.1);
            border-radius: 8px;
        }

        .mobile-cta-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        }

        /* Celebration animations removed */

        /* Success circle animation */

        /* User Avatar */
        .user-avatar {
            background-image: url("./images/user-avatar.png");
        }
    </style>
@endpush
@section('content')
    <div class="max-w-[1536px] mx-auto px-4">
        <!-- Breadcrumb -->
        <nav class="mb-4 md:mb-6 text-right mt-4">
            <div class="w-full overflow-x-auto">
                <div
                    class="flex gap-2 md:gap-[9px] items-center justify-start min-w-max px-2 md:px-0"
                >
                    <!-- Home Link -->
                    <a
                        href="{{ route('home_page') }}"
                        class="font-tajawal text-sm md:text-base font-medium leading-5 md:leading-6 text-[#757575] hover:text-[#00B34F] transition-colors duration-200 whitespace-nowrap flex-shrink-0"
                    >
                        الرئيسية
                    </a>

                    <!-- First Separator -->
                    <div
                        class="w-4 h-4 md:w-6 md:h-6 flex items-center justify-center flex-shrink-0"
                    >
                        <svg
                            class="w-2 h-3 md:w-2 md:h-3.5"
                            viewBox="0 0 8 14"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                        >
                            <path
                                d="M7 13L1 7L7 1"
                                stroke="#858585"
                                stroke-width="2"
                                stroke-linecap="round"
                                stroke-linejoin="round"
                            />
                        </svg>
                    </div>

                    <!-- Test Link -->
                    <div
                        class="font-tajawal text-sm md:text-base font-medium leading-5 md:leading-6 text-[#757575] whitespace-nowrap flex-shrink-0 max-w-[120px] md:max-w-none truncate md:truncate-none"
                        title="اختبار علي المحاضرة الاولي"
                    >
                        <span class="hidden md:inline">تدريب علي
                        {{ $courseCurriculum->name }}</span>
                        <span class="md:hidden">
                            المحاضرة
                            {{ $courseCurriculum->Section->name }}
                        </span>
                    </div>

                    <!-- Second Separator -->
                    <div
                        class="w-4 h-4 md:w-6 md:h-6 flex items-center justify-center flex-shrink-0"
                    >
                        <svg
                            class="w-2 h-3 md:w-2 md:h-3.5"
                            viewBox="0 0 8 14"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                        >
                            <path
                                d="M7 13L1 7L7 1"
                                stroke="#858585"
                                stroke-width="2"
                                stroke-linecap="round"
                                stroke-linejoin="round"
                            />
                        </svg>
                    </div>

                    <!-- Current Page -->
                    <div
                        class="font-tajawal text-sm md:text-base font-medium leading-5 md:leading-6 text-[#00B34F] whitespace-nowrap flex-shrink-0"
                    >
                        نتيجة الإختبار
                    </div>
                </div>
            </div>
        </nav>
    @php($percentage=ceil(($userCourseCurriculumAnswer->right_answers/$userCourseCurriculumAnswer->quetions_numbers)*100))

    <!-- Success Message -->
        <div class="text-center mb-8">
            <h1
                class="font-tajawal text-2xl font-bold leading-8  @if($percentage>=50) text-brand-secondary-normal @else text-[#ee3030] @endif mb-8"
            >
                @if($percentage>=50)
                    تهانينا لقد تم إجتياز الإختبار بنسبة
                    {{ $percentage }}%
                @else
                    ناسف لم تتمكن من إجتياز الإختبار نسبتك هي
                    {{ $percentage }}%
                    يمكنك المحاولة مره اخري
                @endif
            </h1>
        </div>

        <!-- Dynamic Progress Circle -->
        <div class="flex justify-center items-center mb-8">
            <div class="relative w-[180px] h-[180px]" id="progress-container">
                <!-- Background Circle -->
                <div
                    class="absolute inset-0 rounded-full opacity-48"
                    id="background-circle"
                ></div>

                <!-- Progress Circle -->
                <svg class="w-full h-full transform -rotate-90" viewBox="0 0 100 100">
                    <!-- Background Circle -->
                    <circle
                        cx="50"
                        cy="50"
                        r="35"
                        fill="none"
                        stroke="#FDEAEA"
                        stroke-width="8"
                    />
                    <!-- Progress Circle -->
                    <circle
                        cx="50"
                        cy="50"
                        r="35"
                        fill="none"
                        stroke="#A72222"
                        stroke-width="8"
                        stroke-linecap="round"
                        stroke-dasharray="0 219.91"
                        id="progress-circle"
                        class="progress-circle-element"
                    />
                </svg>

                <!-- Percentage Text -->
                <div class="absolute inset-0 flex items-center justify-center">
            <span
                class="font-tajawal text-5xl font-medium transition-colors duration-500"
                id="percentage-text"
            >{{ $percentage }}%</span
            >
                </div>
            </div>
        </div>

        <!-- Result Cards -->
        <div class="max-w-6xl mx-auto space-y-4 mb-8">
            <!-- Time Taken Card -->
            <div
                class="bg-white rounded-lg border border-[#ebebeb] shadow-[0px_1px_4px_0px_rgba(12,12,13,0.05)] p-6"
            >
                <div class="flex flex-row-reverse items-center justify-between">
                    <div
                        class="font-tajawal text-xl font-bold text-brand-secondary-normal"
                    >
                        {{ $userCourseCurriculumAnswer->duration_time }}
                    </div>
                    <div class="flex items-center gap-2">
                        <div class="bg-neutral-50 rounded-lg p-2">
                            <svg
                                width="24"
                                height="24"
                                viewBox="0 0 24 24"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                            >
                                <path
                                    d="M6.99436 19.2778L5.496 21.9813"
                                    stroke="#144394"
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                />
                                <path
                                    d="M15.9863 19.2778L17.4847 21.9814"
                                    stroke="#144394"
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                />
                                <path
                                    d="M11.4901 20.4827C16.4562 20.4827 20.4821 16.4569 20.4821 11.4907C20.4821 6.52453 16.4562 2.49866 11.4901 2.49866C6.52392 2.49866 2.49805 6.52453 2.49805 11.4907C2.49805 16.4569 6.52392 20.4827 11.4901 20.4827Z"
                                    stroke="#144394"
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                />
                                <path
                                    d="M11.4902 6.99463V11.4906"
                                    stroke="#144394"
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                />
                                <path
                                    d="M11.4902 11.4906L14.6694 14.6698"
                                    stroke="#144394"
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                />
                            </svg>
                        </div>

                        <div class="font-tajawal text-lg font-medium text-[#1c1c1c]">
                            الوقت المستغرق للإختبار
                        </div>
                    </div>
                </div>
            </div>

            <!-- Correct Answers Card -->
            <div
                class="bg-white rounded-lg border border-[#ebebeb] shadow-[0px_1px_4px_0px_rgba(12,12,13,0.05)] p-6"
            >
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-2">
                        <div class="bg-neutral-50 rounded-lg p-2">
                            <svg
                                width="24"
                                height="24"
                                viewBox="0 0 24 24"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                            >
                                <path
                                    d="M9.54946 15.8799L18.3515 7.07893C18.4488 6.9816 18.5635 6.9296 18.6955 6.92293C18.8275 6.91626 18.9485 6.96826 19.0585 7.07893C19.1685 7.1896 19.2238 7.3086 19.2245 7.43593C19.2251 7.56326 19.1701 7.68193 19.0595 7.79193L10.1155 16.7419C9.95346 16.9039 9.7648 16.9849 9.54946 16.9849C9.33413 16.9849 9.14546 16.9039 8.98346 16.7419L4.93346 12.6919C4.83613 12.5946 4.78546 12.4789 4.78146 12.3449C4.77746 12.2109 4.83013 12.0889 4.93946 11.9789C5.0488 11.8689 5.16779 11.8139 5.29646 11.8139C5.42513 11.8139 5.54413 11.8689 5.65346 11.9789L9.54946 15.8799Z"
                                    fill="#00B34F"
                                />
                            </svg>
                        </div>
                        <div class="font-tajawal text-lg font-medium text-[#1c1c1c]">
                            الإجابات الصحيحة
                        </div>
                    </div>

                    <div class="font-tajawal font-bold text-brand-secondary-normal">
                        <span class="text-xl text-[#1c1c1c]">{{ $userCourseCurriculumAnswer->quetions_numbers }}</span>
                        <span class="text-xl">/</span>
                        <span class="text-2xl">{{ $userCourseCurriculumAnswer->right_answers }}</span>
                    </div>
                </div>
            </div>

            <!-- Wrong Answers Card -->
            <div
                class="bg-white rounded-lg border border-[#ebebeb] shadow-[0px_1px_4px_0px_rgba(12,12,13,0.05)] p-6"
            >
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-2">
                        <div class="bg-neutral-50 rounded-lg p-2">
                            <svg
                                width="24"
                                height="24"
                                viewBox="0 0 24 24"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                            >
                                <path
                                    d="M5 19L12 12M12 12L19 5M12 12L5 5M12 12L19 19"
                                    stroke="#EE3030"
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                    stroke-width="1.5"
                                />
                            </svg>
                        </div>

                        <div class="font-tajawal text-lg font-medium text-[#1c1c1c]">
                            الإجابات الخاطئة
                        </div>
                    </div>

                    <div class="font-tajawal font-bold">
                        <span class="text-xl text-[#1c1c1c]">{{ $userCourseCurriculumAnswer->quetions_numbers }}</span>
                        <span class="text-xl text-[#ee3030]">/</span>
                        <span class="text-2xl text-[#ee3030]">{{ $userCourseCurriculumAnswer->wrong_answers }}</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Certificate Section -->
        @if($percentage>=50)
            <div class="max-w-6xl mx-auto mb-8">
                <div class="text-center mb-6">
                    <h2 class="font-tajawal text-lg font-medium text-[#1c1c1c] mb-2">
                        لقد قمت بإجتياز الإختبار بنجاح، يمكنك تحميل شهادتك pdf مقدمة من إعمل
                        بيزنس اكاديمي
                    </h2>
                    <p class="font-tajawal text-sm font-medium text-[#757575]">
                        مع كل دورة تدريبية ستحصل علي شهادة مقدمة من الاكاديمية
                    </p>
                </div>

                <!-- Certificate Card -->
                @if($certificate)
                <div
                    class="bg-neutral-50 rounded-lg border border-[#ebebeb] p-4 md:p-6"
                >
                    <div
                        class="flex flex-col md:flex-row md:items-center md:justify-between gap-4"
                    >
                        <div
                            class="flex flex-col sm:flex-row items-start sm:items-center gap-4"
                        >
                            <div
                                class="w-full sm:w-[141px] h-[100px] bg-gray-200 rounded-lg flex items-center justify-center flex-shrink-0"
                            >
                                <img
                                    class="w-full h-full object-cover rounded-lg"
                                    src="{{ asset('frontend/images') }}/certificate-placeholder.png"
                                    alt="شهادة الدورة التدريبية"
                                />
                            </div>

                            <div class="text-right w-full sm:w-auto">
                                <h3
                                    class="font-tajawal text-sm md:text-base font-bold text-[#06241b] mb-1 leading-tight"
                                >
                                    شهادة الدورة التدريبية
                                    {{ $course->name }}
                                </h3>
                                <div
                                    class="flex flex-col sm:flex-row sm:gap-4 gap-1 text-xs sm:text-sm text-[#79797b] mb-2"
                                >
                  <span
                  >المحاضر:
                    <span class="text-[#3b3b3b] font-bold"
                    >{{ $course->Instructor->name }}</span
                    ></span
                  >

                                    <span
                                    >مقدمة من:
                    <span class="text-[#3b3b3b] font-medium"
                    >جامعة EBU</span
                    ></span
                                    >
                                </div>
                                <div
                                    class="inline-block bg-orange-light text-orange-bg text-xs sm:text-sm font-medium px-2.5 py-0.5 rounded-lg"
                                >
                                    {{ $course->Category->name }}
                                </div>
                            </div>
                        </div>

                        <div
                            class="flex flex-col sm:flex-row items-stretch sm:items-center gap-3 w-full sm:w-auto"
                        >
                            <button
                                class="bg-neutral-100 border border-[#ebebeb] rounded-lg px-3 sm:px-4 py-2 flex items-center justify-center gap-2 text-center w-full sm:w-auto"
                            >
                                <svg
                                    width="16"
                                    height="16"
                                    viewBox="0 0 16 16"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg"
                                    class="flex-shrink-0"
                                >
                                    <path
                                        d="M7.5 1C11.947 1 14 5.105 14 5.105C14 5.105 11.947 9.21 7.5 9.21C3.053 9.21 1 5.105 1 5.105C1 5.105 3.053 1 7.5 1Z"
                                        stroke="#00B34F"
                                        stroke-linejoin="round"
                                        stroke-width="0.929"
                                    />
                                    <path
                                        d="M9.44091 5.10547C9.44686 5.37181 9.39955 5.63666 9.30174 5.88446C9.20393 6.13226 9.0576 6.35803 8.87134 6.5485C8.68508 6.73897 8.46265 6.89032 8.21709 6.99364C7.97154 7.09696 7.70781 7.15019 7.44141 7.15019C7.175 7.15019 6.91128 7.09696 6.66572 6.99364C6.42017 6.89032 6.19773 6.73897 6.01147 6.5485C5.82521 6.35803 5.67888 6.13226 5.58107 5.88446C5.48326 5.63666 5.43595 5.37181 5.44191 5.10547C5.44191 4.57504 5.65262 4.06633 6.02769 3.69126C6.40277 3.31618 6.91147 3.10547 7.44191 3.10547C7.97234 3.10547 8.48105 3.31618 8.85612 3.69126C9.23119 4.06633 9.44191 4.57504 9.44191 5.10547H9.44091Z"
                                        stroke="#00B34F"
                                        stroke-linejoin="round"
                                        stroke-width="0.929"
                                    />
                                </svg>
                                <span
                                    class="font-tajawal text-xs sm:text-sm font-medium text-brand-secondary-normal"
                                >عرض سريع للشهادة</span
                                >
                            </button>

                            <button
                                class="bg-brand-primary-light rounded-lg p-2 flex items-center justify-center flex-shrink-0 w-full sm:w-auto"
                                title="تحميل الشهادة"
                                aria-label="تحميل الشهادة"
                            >
                                <svg
                                    width="24"
                                    height="24"
                                    viewBox="0 0 24 24"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg"
                                >
                                    <path
                                        d="M12 15.577L8.461 12.039L9.169 11.319L11.5 13.65V5H12.5V13.65L14.83 11.32L15.539 12.039L12 15.577ZM6.616 19C6.15533 19 5.771 18.846 5.463 18.538C5.155 18.23 5.00067 17.8453 5 17.384V14.961H6V17.384C6 17.538 6.064 17.6793 6.192 17.808C6.32 17.9367 6.461 18.0007 6.615 18H17.385C17.5383 18 17.6793 17.936 17.808 17.808C17.9367 17.68 18.0007 17.5387 18 17.384V14.961H19V17.384C19 17.8447 18.846 18.229 18.538 18.537C18.23 18.845 17.8453 18.9993 17.384 19H6.616Z"
                                        fill="#144394"
                                    />
                                </svg>
                            </button>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        @endif
        <!-- Action Buttons -->
        <div class="flex flex-col items-center gap-6 mb-8">
            <a
                href="{{ route('course_exam_page',['url'=>$course->url,'id'=>$courseCurriculum->id]) }}"
                class="bg-brand-primary-normal text-white px-8 py-3 rounded-lg font-tajawal text-sm font-medium flex items-center gap-2 hover:bg-brand-primary-normal/90 transition-colors"
            >
                <svg
                    width="24"
                    height="24"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <path
                        d="M12 21C10.8907 21 9.85133 20.7913 8.882 20.374C7.91267 19.9567 7.06533 19.3853 6.34 18.66C5.61467 17.9347 5.04333 17.0873 4.626 16.118C4.20867 15.1487 4 14.1093 4 13H5C5 14.95 5.67933 16.6043 7.038 17.963C8.39667 19.3217 10.0507 20.0007 12 20C13.9493 19.9993 15.6037 19.3203 16.963 17.963C18.3223 16.6057 19.0013 14.9513 19 13C18.9987 11.0487 18.3197 9.39467 16.963 8.038C15.6063 6.68133 13.952 6.002 12 6H11.62L13.246 7.627L12.538 8.347L9.692 5.48L12.577 2.614L13.285 3.334L11.619 5H12C13.1093 5 14.1487 5.20867 15.118 5.626C16.0873 6.04333 16.9347 6.61467 17.66 7.34C18.3853 8.06533 18.9567 8.91267 19.374 9.882C19.7913 10.8513 20 11.8907 20 13C20 14.1093 19.7913 15.1487 19.374 16.118C18.9567 17.0873 18.3853 17.935 17.66 18.661C16.9347 19.387 16.0873 19.958 15.118 20.374C14.1487 20.79 13.1093 20.9987 12 21Z"
                        fill="#E8ECF4"
                    />
                </svg>
                إعادة الإختبار
            </a>
            <a href="{{ route('course_page',['url'=>$course->url]) }}"
               class="bg-brand-primary-light text-brand-primary-normal px-8 py-3 rounded-lg font-tajawal text-sm font-medium hover:bg-brand-primary-light/80 transition-colors"
            >
                الرجوع للدورة
            </a>
        </div>
    </div>
@endsection
@push('footerScript')
    <script>
        // Dynamic Progress Circle System
        function updateProgressCircle(percentage) {
            const progressCircle = document.getElementById("progress-circle");
            const backgroundCircle = document.getElementById("background-circle");
            const percentageText = document.getElementById("percentage-text");

            // Ensure percentage is between 0 and 100
            percentage = Math.max(0, Math.min(100, percentage));

            // Calculate circle circumference (2 * π * r, where r = 35)
            const radius = 35;
            const circumference = 2 * Math.PI * radius;
            const progress = (percentage / 100) * circumference;
            const remaining = circumference - progress;

            // Determine colors based on percentage
            let strokeColor, textColor, bgColor;

            if (percentage >= 80) {
                // Excellent - Green
                strokeColor = "#00B34F";
                textColor = "#00B34F";
                bgColor = "#E8F5E8";
            } else if (percentage >= 60) {
                // Good - Blue
                strokeColor = "#144394";
                textColor = "#144394";
                bgColor = "#E8ECF4";
            } else if (percentage >= 40) {
                // Average - Orange
                strokeColor = "#FF8C00";
                textColor = "#FF8C00";
                bgColor = "#FFF4E6";
            } else {
                // Failed - Red
                strokeColor = "#A72222";
                textColor = "#A72222";
                bgColor = "#FDEAEA";
            }

            // Set CSS variables for animation
            progressCircle.style.setProperty("--progress-dash", progress);
            progressCircle.style.setProperty("--remaining-dash", remaining);

            // Apply styles with animation
            progressCircle.style.stroke = strokeColor;
            progressCircle.classList.add("progress-circle-animated");

            // For browsers that don't support CSS variables in keyframes
            if (!CSS.supports("(--foo: bar)")) {
                progressCircle.classList.add("progress-circle-fallback");
                progressCircle.style.strokeDasharray = `${progress} ${remaining}`;
            }

            // Animate percentage text
            let currentPercentage = 0;
            const increment = percentage / 50; // 50 steps for smooth animation
            const textAnimation = setInterval(() => {
                currentPercentage += increment;
                if (currentPercentage >= percentage) {
                    currentPercentage = percentage;
                    clearInterval(textAnimation);
                }
                percentageText.textContent = `${Math.round(currentPercentage)}%`;
            }, 40); // 40ms interval for smooth animation

            percentageText.style.color = textColor;
            backgroundCircle.style.backgroundColor = bgColor;

            // Add smooth transition for background
            backgroundCircle.style.transition = "background-color 0.5s ease-in-out";
        }

        // Initialize with current percentage
        document.addEventListener("DOMContentLoaded", () => {
            // Get the current percentage - for failed test (3 correct out of 30 questions = 10%)
            const currentPercentage = {{ $percentage }}; // This represents the failed test result

            // Animate the progress circle on page load
            setTimeout(() => {
                updateProgressCircle(currentPercentage);
            }, 500);

            // Make the function globally available for external use
            window.updateTestResult = updateProgressCircle;
        });
    </script>
    @if($percentage>=50)
        <script>
            // Celebration animations removed
            document.addEventListener("DOMContentLoaded", () => {
                // Animation effects removed for success message
                // Trigger confetti
                var duration = 5 * 1000;
                var animationEnd = Date.now() + duration;
                var defaults = { startVelocity: 30, spread: 360, ticks: 60, zIndex: 0 };

                function randomInRange(min, max) {
                    return Math.random() * (max - min) + min;
                }

                var interval = setInterval(function () {
                    var timeLeft = animationEnd - Date.now();

                    if (timeLeft <= 0) {
                        return clearInterval(interval);
                    }

                    var particleCount = 50 * (timeLeft / duration);
                    // since particles fall down, start a bit higher than random
                    confetti(
                        Object.assign({}, defaults, {
                            particleCount,
                            origin: { x: randomInRange(0.1, 0.3), y: Math.random() - 0.2 },
                        })
                    );
                    confetti(
                        Object.assign({}, defaults, {
                            particleCount,
                            origin: { x: randomInRange(0.7, 0.9), y: Math.random() - 0.2 },
                        })
                    );
                }, 250);
            });
        </script>
    @endif
@endpush
