@extends('frontend.layouts.app')
@push('headScript')
    <!-- Tailwind Configuration -->
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        alexandria: ["Alexandria", "sans-serif"],
                        tajawal: ["Tajawal", "sans-serif"],
                    },
                    colors: {
                        "brand-primary-light": "#E8ECF4",
                        "brand-secondary-normal": "#00B34F",
                        "brand-primary-normal": "#144394",
                        "brand-primary-bg": "#F2F4F9",
                        title: "#102844",
                        "neutral-n20": "#F5F5F5",
                        "neutral-n10": "#FAFAFA",
                        "neutral-n100": "#757575",
                        "gray-shade": "#F8F8FB",
                    },
                },
            },
        };
    </script>

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            /* border: 1px solid red !important; */
        }

        /* Dropdown transition styles */
        .lesson-content {
            transition: all 0.3s ease-in-out;
            max-height: 1000px;
            overflow: hidden;
        }

        .lesson-content.hidden {
            max-height: 0;
            padding-top: 0;
            padding-bottom: 0;
            margin-top: 0;
            margin-bottom: 0;
        }

        .dropdown-arrow {
            transition: transform 0.3s ease-in-out;
        }

        .lesson-header {
            transition: all 0.3s ease-in-out;
        }

        .lesson-item {
            transition: all 0.3s ease-in-out;
        }

        body {
            font-family: "Tajawal", -apple-system, Roboto, Helvetica, sans-serif;
            direction: rtl;
        }

        /* Mobile Menu Styles */
        .mobile-menu {
            animation-duration: 0.3s;
            animation-timing-function: ease-out;
        }

        .mobile-menu.show {
            animation-name: slideDown;
        }

        .mobile-menu.hide {
            animation-name: slideUp;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes slideUp {
            from {
                opacity: 1;
                transform: translateY(0);
            }

            to {
                opacity: 0;
                transform: translateY(-10px);
            }
        }

        .mobile-menu-backdrop.show {
            animation: fadeIn 0.3s ease-out;
        }

        .mobile-menu-backdrop.hide {
            animation: fadeOut 0.3s ease-out;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        @keyframes fadeOut {
            from {
                opacity: 1;
            }

            to {
                opacity: 0;
            }
        }

        /* Hover effects for navigation links */
        .nav-link:hover {
            transform: translateY(-1px);
            transition: all 0.2s ease;
        }

        .mobile-nav-link:hover {
            background-color: rgba(255, 255, 255, 0.1);
            border-radius: 8px;
        }

        .mobile-cta-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        }

        /* Responsive Design using Tailwind breakpoints */
        @media (max-width: 1200px) {
            .main-layout {
                flex-direction: column;
            }
        }

        @media (max-width: 768px) {
            .nav-bar {
                flex-direction: column;
                gap: 16px;
            }
        }

        /* Tablet specific adjustments */
        @media (min-width: 768px) and (max-width: 1024px) {
            .nav-link {
                font-size: 0.875rem;
                padding: 0.5rem 0.75rem;
            }
        }

        /* Small mobile adjustments */
        @media (max-width: 480px) {
            .mobile-nav-link {
                font-size: 1rem;
                padding: 0.75rem 1rem;
            }

            .mobile-cta-btn {
                font-size: 0.875rem;
                padding: 0.75rem 1rem;
            }
        }
    </style>
    <script type="text/javascript" src="https://c.sproutvideo.com/player_api.js"></script>
    <script type="text/javascript" src="{{ asset('assets/js/js.cookie.js') }}"></script>
@endpush
@section('content')
    <div class="max-w-[1536px] mx-auto px-4">

        <!-- Breadcrumb -->
        <nav class="mb-6 text-right mt-4">
            <div class="flex gap-[9px] items-center justify-start">
                <div class="font-tajawal text-base font-medium leading-6 text-[#757575] text-center">
                    الرئيسية
                </div>

                <div class="w-6 h-6 flex items-center justify-center">
                    <svg width="8" height="14" viewBox="0 0 8 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M7 13L1 7L7 1" stroke="#858585" stroke-width="2" stroke-linecap="round"
                              stroke-linejoin="round" />
                    </svg>
                </div>

                <div class="font-tajawal text-base font-medium leading-6 text-[#00B34F] text-right">
                   {{ $course->name }}
                </div>
            </div>
        </nav>

        <!-- Page Title -->
        <div class="mb-8 text-right">
            <h1 class="text-title font-tajawal text-2xl font-medium leading-8 max-md:text-xl max-md:leading-7">
                {{ $course->name }}
            </h1>
        </div>

        <!-- Main Layout -->
        <div class="main-layout flex gap-10 items-start max-xl:flex-col">
            <!-- Sidebar -->
            <div
                class="w-[314px] bg-brand-primary-bg rounded-lg p-4 min-h-[858px] flex-shrink-0 max-xl:w-full max-xl:h-auto">
                <div class="text-title font-tajawal text-lg font-medium leading-7 mb-4 text-right">
                    جميع المحاضرات
                </div>

                <!-- Lesson Items -->
                @foreach($course->Sections as $section)
                <!-- Lesson {{ $loop->index+1 }} - Expanded by default -->
                <div class="lesson-item bg-white rounded-lg border border-neutral-100 mb-4 max-[480px]:w-full"
                     data-lesson="{{ $loop->index+1 }}">
                    <!-- Header -->
                    <button
                        class="lesson-header flex w-full p-2.5 px-4 justify-between items-center rounded-t-lg bg-brand-primary-bg border-b border-neutral-100 cursor-pointer"
                        onclick="toggleLesson({{ $loop->index+1 }})">
                        <div class="flex items-center gap-2">
                            <div
                                class="flex w-6 h-6 justify-center items-center rounded-lg bg-brand-primary-light text-brand-primary-normal font-tajawal text-base font-medium">
                                {{ $loop->index+1 }}
                            </div>
                            <div
                                class="text-brand-primary-normal font-tajawal text-base font-medium leading-6 text-right flex-1">
                                {{ $section->name }}
                            </div>
                        </div>
                        <div class="w-6 h-6 flex items-center justify-center dropdown-arrow" data-arrow="{{ $loop->index+1 }}">
                            <svg width="12" height="6" viewBox="0 0 12 6" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M10.291 4.29257C10.9214 4.92241 10.4754 6 9.58425 6H2.41268C1.52199 6 1.07572 4.92331 1.70525 4.29321L5.28781 0.707426C5.67815 0.316725 6.31132 0.31644 6.70202 0.706789L10.291 4.29257Z"
                                      fill="#102844" />
                            </svg>
                        </div>
                    </button>
                    <!-- Dropdown Content -->
                    <div class="lesson-content p-4 space-y-4" data-content="{{ $loop->index+1 }}">
                        @foreach($section->Curriculums as $curriculum)
                        <!-- Sub-lesson 1 -->
                        <div
                            class="bg-neutral-50 border border-neutral-100 rounded-lg p-4 flex items-center justify-between flex-row-reverse">

                            <div class="flex items-center gap-1 flex-row-reverse">
                                @if($curriculum->type=='default')
                                <svg width="12" height="12" viewBox="0 0 12 12" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M6.375 6C6.375 6.20711 6.20711 6.375 6 6.375C5.79289 6.375 5.625 6.20711 5.625 6C5.625 5.79289 5.79289 5.625 6 5.625C6.20711 5.625 6.375 5.79289 6.375 6Z"
                                        fill="#144394" />
                                    <path
                                        d="M6.375 6C6.375 6.20711 6.20711 6.375 6 6.375C5.79289 6.375 5.625 6.20711 5.625 6C5.625 5.79289 5.79289 5.625 6 5.625M6.375 6C6.375 5.29289 6.20711 5.625 6 5.625M6.375 6H8.25M6 5.625V3.25M10.5 6C10.5 8.48528 8.48528 10.5 6 10.5C3.51472 10.5 1.5 8.48528 1.5 6C1.5 3.51472 3.51472 1.5 6 1.5C8.48528 1.5 10.5 3.51472 10.5 6Z"
                                        stroke="#144394" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                                <span class="text-brand-primary-normal font-tajawal text-xs font-normal">{{ $curriculum->duration }}</span>
                                @else
                                <a href="{{ route('course_'.$curriculum->type.'_page',['url'=>$course->url,'id'=>$curriculum->id]) }}"
                                    class="bg-[#FBB943] text-[#584117] px-2.5 py-2 rounded-lg font-tajawal text-xs font-normal">
                                    ابدأ الآن
                                </a>
                                @endif
                            </div>


                            <a href="{{ $curriculum->type=='default'?route('course_curriculum_video_page',['url'=>$course->url,'id'=>$curriculum->id]):route('course_'.$curriculum->type.'_page',['url'=>$course->url,'id'=>$curriculum->id]) }}" class="flex items-center gap-2 flex-row-reverse">
                                <div class="text-title font-tajawal text-sm font-normal leading-5 text-right">
                                   {{ $curriculum->name }}  {{ $curriculum->description }}
                                </div>
                                <div class="flex w-6 h-6 justify-center items-center rounded-lg bg-brand-primary-light">
                                    @if($curriculum->type=='default')
                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M9.72132 6.26798C10.7967 7.14532 11.334 7.58332 11.334 8.33332C11.334 9.08332 10.7967 9.52198 9.72132 10.3987C9.44208 10.6287 9.15479 10.8489 8.85998 11.0586C8.62265 11.2253 8.35398 11.3973 8.07598 11.5667C7.00332 12.2187 6.46732 12.5446 5.98665 12.184C5.50532 11.8226 5.46198 11.0673 5.37465 9.55532C5.34978 9.14844 5.33622 8.74095 5.33398 8.33332C5.33398 7.95798 5.34932 7.53865 5.37398 7.11132C5.46198 5.59998 5.50532 4.84398 5.98665 4.48265C6.46732 4.12198 7.00332 4.44798 8.07598 5.09998C8.35398 5.26932 8.62265 5.44132 8.85998 5.60798C9.15479 5.81775 9.44208 6.03789 9.72132 6.26798Z"
                                            stroke="#144394" stroke-linecap="round" stroke-linejoin="round" />
                                    </svg>
                                    @else
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M7.5 5.25C7.89286 3.76969 9.37663 3.01383 12.6071 3C12.6588 2.99982 12.71 3.00939 12.7577 3.02817C12.8055 3.04695 12.8488 3.07456 12.8854 3.10942C12.9219 3.14428 12.9508 3.1857 12.9705 3.23128C12.9902 3.27686 13.0002 3.3257 13 3.375V10.125C13 10.2245 12.9586 10.3198 12.8849 10.3902C12.8113 10.4605 12.7113 10.5 12.6071 10.5C9.46429 10.5 8.25011 11.1049 7.5 12M7.5 5.25C7.10714 3.76969 5.62337 3.01383 2.39286 3C2.34121 2.99982 2.29004 3.00939 2.24229 3.02817C2.19454 3.04695 2.15115 3.07456 2.11463 3.10942C2.07811 3.14428 2.04918 3.1857 2.02951 3.23128C2.00984 3.27686 1.99981 3.3257 2 3.375V10.0798C2 10.3113 2.15027 10.5 2.39286 10.5C5.53572 10.5 6.75431 11.1094 7.5 12M7.5 5.25V12"
                                                stroke="#144394" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    @endif
                                </div>
                            </a>
                        </div>
                        @endforeach
                    </div>
                </div>
                @endforeach
            </div>

            <!-- Content Area -->
            <div class="flex-1 bg-brand-primary-bg rounded-lg p-8 max-w-[1143px] max-xl:max-w-full max-md:p-5">
                <!-- Video Section -->
                <div class="relative w-full h-[428px] rounded-2xl overflow-hidden mb-12 max-md:h-[250px]">
                    <!-- Video Thumbnail (shows initially) -->
{{--                    <div id="videoThumbnail" class="w-full h-full">--}}
{{--                        <img class="w-full h-full object-cover rounded-2xl"--}}
{{--                             src="{{ asset('frontend/images') }}/course-curriculum/course-video.png" alt="Course Video" />--}}
{{--                        <div--}}
{{--                            class="absolute top-0 left-0 w-full h-full bg-black bg-opacity-[0.07] backdrop-blur-[2px] rounded-2xl">--}}
{{--                        </div>--}}
{{--                        <button--}}
{{--                            class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-[70px] h-[70px] bg-white bg-opacity-30 rounded-full flex items-center justify-center cursor-pointer backdrop-blur-[3.5px] border-none"--}}
{{--                            aria-label="Play Video" onclick="loadVideo()">--}}
{{--                            <svg width="42" height="42" viewBox="0 0 42 42" fill="none"--}}
{{--                                 xmlns="http://www.w3.org/2000/svg">--}}
{{--                                <path fill-rule="evenodd" clip-rule="evenodd"--}}
{{--                                      d="M29.2666 19.8181C30.368 20.6167 30.368 22.2581 29.2666 23.0566L17.1739 31.8239C15.8517 32.7825 14 31.8379 14 30.2046V12.6703C14 11.0371 15.8517 10.0924 17.1739 11.0511L29.2666 19.8181Z"--}}
{{--                                      fill="#144394" />--}}
{{--                            </svg>--}}
{{--                        </button>--}}
{{--                        <div class="absolute bottom-6 right-6 flex items-center gap-1 flex-row-reverse py-1.5 px-2--}}
{{--                            bg-white bg-opacity-30 rounded-[10px] backdrop-blur-[75px] text-brand-primary-light--}}
{{--                            text-xs">--}}
{{--                            <span>14:00</span>--}}

{{--                            <svg width="12" height="12" viewBox="0 0 12 12" fill="none"--}}
{{--                                 xmlns="http://www.w3.org/2000/svg">--}}
{{--                                <path--}}
{{--                                    d="M6.375 6C6.375 6.20711 6.20711 6.375 6 6.375C5.79289 6.375 5.625 6.20711 5.625 6C5.625 5.79289 5.79289 5.625 6 5.625C6.20711 5.625 6.375 5.79289 6.375 6Z"--}}
{{--                                    fill="#E8ECF4" />--}}
{{--                                <path--}}
{{--                                    d="M6.375 6C6.375 6.20711 6.20711 6.375 6 6.375C5.79289 6.375 5.625 6.20711 5.625 6C5.625 5.79289 5.79289 5.625 6 5.625M6.375 6C6.375 5.79289 6.20711 5.625 6 5.625M6.375 6H8.25M6 5.625V3.25M10.5 6C10.5 8.48528 8.48528 10.5 6 10.5C3.51472 10.5 1.5 8.48528 1.5 6C1.5 3.51472 3.51472 1.5 6 1.5C8.48528 1.5 10.5 3.51472 10.5 6Z"--}}
{{--                                    stroke="#E8ECF4" stroke-linecap="round" stroke-linejoin="round" />--}}
{{--                            </svg>--}}
{{--                        </div>--}}
{{--                    </div>--}}

                    <!-- Video Iframe (hidden initially) -->
{{--                    <iframe id="videoIframe" title="Course Video Player" class="w-full h-full rounded-2xl hidden"--}}
{{--                            src="about:blank" frameborder="0"--}}
{{--                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"--}}
{{--                            allowfullscreen>--}}
{{--                    </iframe>--}}
                    <iframe id="videoIframe" width="100%" height="100%" class="sproutvideo-player"  src="https:{{ $currentCurriculum->link }}?type=sd&playsInline=true" title="{{ $currentCurriculum->description }}" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

                </div>

                <script>
                    function loadVideo() {
                        const thumbnail = document.getElementById("videoThumbnail");
                        const iframe = document.getElementById("videoIframe");
                        // Hide thumbnail and show iframe
                        thumbnail.style.display = "none";
                        iframe.classList.remove("hidden");
                    }

                    // Function to toggle lesson dropdown
                    function toggleLesson(lessonNumber) {
                        const lessonItem = document.querySelector(
                            `[data-lesson="${lessonNumber}"]`
                        );
                        const content = document.querySelector(
                            `[data-content="${lessonNumber}"]`
                        );
                        const arrow = document.querySelector(
                            `[data-arrow="${lessonNumber}"]`
                        );
                        const header = lessonItem.querySelector(".lesson-header");

                        if (content.classList.contains("hidden")) {
                            // Expand
                            content.classList.remove("hidden");
                            arrow.classList.remove("rotate-180");

                            // Update header styling for expanded state
                            if (lessonNumber === 1) {
                                header.classList.remove("rounded-lg");
                                header.classList.add(
                                    "rounded-t-lg",
                                    "bg-brand-primary-bg",
                                    "border-b",
                                    "border-neutral-100"
                                );
                                lessonItem.classList.add(
                                    "bg-white",
                                    "border",
                                    "border-neutral-100"
                                );
                            } else {
                                header.classList.remove(
                                    "rounded-lg",
                                    "bg-neutral-n10",
                                    "border-neutral-n20"
                                );
                                header.classList.add(
                                    "rounded-t-lg",
                                    "bg-brand-primary-bg",
                                    "border-b",
                                    "border-neutral-100"
                                );
                                lessonItem.classList.add(
                                    "bg-white",
                                    "border",
                                    "border-neutral-100"
                                );
                                lessonItem.classList.remove("bg-neutral-n10");
                            }
                        } else {
                            // Collapse
                            content.classList.add("hidden");
                            arrow.classList.add("rotate-180");

                            // Update header styling for collapsed state
                            header.classList.remove(
                                "rounded-t-lg",
                                "bg-brand-primary-bg",
                                "border-b",
                                "border-neutral-100"
                            );
                            header.classList.add(
                                "rounded-lg",
                                "bg-neutral-n10",
                                "border-neutral-n20"
                            );
                            lessonItem.classList.remove(
                                "bg-white",
                                "border",
                                "border-neutral-100"
                            );
                            lessonItem.classList.add("bg-neutral-n10");
                        }
                    }

                    // Initialize collapsed state for lessons 2-6
                    document.addEventListener("DOMContentLoaded", function () {
                        for (let i = 2; i <= 6; i++) {
                            const content = document.querySelector(`[data-content="${i}"]`);
                            const arrow = document.querySelector(`[data-arrow="${i}"]`);
                            if (content) {
                                content.classList.add("hidden");
                            }
                            if (arrow) {
                                arrow.classList.add("rotate-180");
                            }
                        }
                    });
                </script>

                <!-- Course Info -->
                <div class="text-title font-tajawal text-2xl font-medium leading-8 mb-2.5 text-right max-md:text-xl">
                    {{ $course->name }}
                </div>
                <div class="text-title font-tajawal text-sm font-bold leading-5 mb-1 text-right">
                    المحاضر:
                    {{ $course->Instructor?->name }}
                </div>
                <div class="text-neutral-n100 font-tajawal text-sm font-medium leading-5 mb-8 text-right">
                    {{ $course->Instructor?->title }}
                </div>

                <!-- Progress Section -->
                <div class="bg-gray-shade rounded-2xl p-10 h-[180px] max-md:p-5 max-md:h-auto">
                    <div
                        class="flex justify-between items-center mb-6 max-md:flex-col max-md:gap-4 max-md:items-stretch">
                        <div class="text-right">
                            <div
                                class="text-neutral-n100 font-tajawal text-xs font-medium leading-[18px] opacity-70 mb-2">
                                المحاضرة 1 من
                                {{ $course->Sections()->count() }}
                            </div>
                            <div class="text-title font-tajawal text-sm font-medium leading-5 mb-3">
                                {{ $currentCurriculum->Section?->name }}
                                 -
                                {{ $currentCurriculum->name }} {{ $currentCurriculum->description }}
                            </div>
                            <div
                                class="w-[476px] h-1 bg-brand-primary-light rounded-[10px] relative mb-2.5 max-md:w-full">
                                <div
                                    class="w-[{{$percentage}}%] h-1 bg-brand-primary-normal rounded-[10px] absolute right-0 top-0 max-md:w-[{{$percentage}}%]">
                                </div>
                            </div>
                            <div class="text-title font-tajawal text-xs font-medium leading-[18px]">
                                عن استكمال المحاضرات جميعا ستخضع لإختبار و يجب ان تحوذ علي
                                الاقل 60%
                            </div>
                        </div>

                        <button
                            class="flex py-4 px-8 items-center gap-2 rounded-lg bg-brand-primary-normal text-white border-none cursor-pointer font-tajawal text-sm font-medium">
                            <span>التالي</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tab Section -->
        <div class="mt-10 px-4 max-md:mt-6 max-md:px-2 mb-[7.5rem]">
            <div class="flex flex-col items-start mb-8">
                <div
                    class="flex flex-row-reverse justify-end items-center gap-6 mb-2 max-md:flex-wrap max-md:justify-center max-md:gap-4">
                    <button
                        class="tab-button flex justify-center items-center py-4 px-2 text-neutral-n100 font-tajawal text-base font-medium leading-6 tracking-[0.5px] border-b-2 border-transparent transition-all duration-300 hover:text-brand-primary-normal max-md:py-3 max-md:px-1.5 max-md:text-sm max-md:min-w-0 bg-transparent cursor-pointer"
                        data-tab="question">
                        هل لديك سؤال
                    </button>
                    <button
                        class="tab-button flex justify-center items-center py-4 px-2 text-neutral-n100 font-tajawal text-base font-medium leading-6 tracking-[0.5px] border-b-2 border-transparent transition-all duration-300 hover:text-brand-primary-normal max-md:py-3 max-md:px-1.5 max-md:text-sm max-md:min-w-0 bg-transparent cursor-pointer"
                        data-tab="attachments">
                        الملحقات
                    </button>
                    <button
                        class="tab-button flex justify-center items-center py-4 px-2 text-neutral-n100 font-tajawal text-base font-medium leading-6 tracking-[0.5px] border-b-2 border-transparent transition-all duration-300 hover:text-brand-primary-normal max-md:py-3 max-md:px-1.5 max-md:text-sm max-md:min-w-0 bg-transparent cursor-pointer"
                        data-tab="comments">
                        التعليقات
                    </button>
                    <button
                        class="tab-button active flex justify-center items-center py-4 px-2 text-brand-primary-normal font-tajawal text-base font-medium leading-6 tracking-[0.5px] border-b-2 border-brand-primary-normal min-w-[124px] text-center max-md:py-3 max-md:px-1.5 max-md:text-sm max-md:min-w-0 bg-transparent cursor-pointer"
                        data-tab="content">
                        محتوي الدورة
                    </button>
                </div>
                <div class="h-0.5 w-full bg-neutral-n20"></div>
            </div>

            <div class="tab-content flex flex-col items-start gap-4 max-w-[1473px]" data-content="content">
                <h2
                    class="text-title text-right font-tajawal text-2xl font-medium leading-8 m-0 max-md:text-xl max-md:leading-7">
                    محتوي الدورة
                </h2>
                <div
                    class="text-title text-right font-tajawal text-lg font-medium leading-7 w-full max-md:text-base max-md:leading-6">
                    {!! $course->description !!}
                </div>
            </div>

            <!-- Additional Tab Content Sections -->

            <!-- Attachments Tab Content -->
            <div class="tab-content hidden" data-content="attachments">
                <div class="flex flex-col items-start gap-4 max-w-[1473px] w-full">
                    <h2 class="text-[#1c1c1c] text-right font-tajawal text-lg font-medium leading-7 m-0">
                        جميع الملحقات الخاصة بالدورة التدريبية (
                        {{ $course->Resources()->count() }}
                        ):
                    </h2>

                    <!-- Attachments List -->
                    <div class="flex flex-col gap-5 w-full">
                        @foreach($course->Resources as $resource)
                        <!-- Attachment Item {{ $loop->index+1 }} -->
                        <div class="bg-white border border-[#ebebeb] rounded-lg p-4 flex items-center gap-3 w-full">
                            <div
                                class="w-8 h-8 bg-[#e8ecf4] border-4 border-[#dce3ef] rounded-full flex items-center justify-center relative -ml-0.5 -mt-0.5">
                                <img src="{{ asset('frontend/images') }}/course-curriculum/pdf-icon.svg" alt="تحميل" class="w-4 h-4" />
                            </div>

                            <div class="flex-1 flex gap-4 items-start min-w-0">
                                <div class="flex-1 flex flex-col gap-1 items-end min-w-0">
                                    <div
                                        class="font-inter font-medium text-sm text-[#344054] leading-5 text-right w-full">
                                        {{ $resource->name }}
                                    </div>
                                    @if(file_exists(public_path('assets/images/'.$resource->file)))
                                    <div
                                        class="font-inter font-normal text-sm text-[#667085] leading-5 text-right w-full flex flex-row gap-1 items-end justify-start">
                                        {{ formatFilesize(filesize(public_path('assets/images/'.$resource->file))) }}
                                    </div>
                                    @endif
                                </div>

                                <a href="{{ asset('assets/images/'.$resource->file) }}" target="_blank"
                                    class="bg-[#f2f4f9] rounded-lg p-2.5 flex items-end gap-2.5 shrink-0 flex cursor-pointer hover:bg-[#e1e5ef] transition-colors items-center justify-center">
                                    <span
                                        class="font-tajawal font-medium text-sm text-[#144394] leading-5 text-right">تحميل</span>
                                    <img src="{{ asset('frontend/images') }}/course-curriculum/download-icon.svg" alt="تحميل"
                                         class="w-4 h-4" />
                                </a>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>

            <!-- Question Tab Content -->
            <div class="tab-content hidden" data-content="question">
                <div class="flex flex-col items-start gap-4 max-w-[1473px] w-full">
                    <!-- Title -->
                    <h2 class="text-[#1c1c1c] text-right font-tajawal text-lg font-medium leading-7 w-full">
                        هل لديك سؤال؟
                    </h2>

                    <!-- Form Content -->
                    <form id="saveQuestion" class="flex flex-col items-start gap-8 w-full">
                        <!-- Dropdowns Section -->
                        <div class="flex flex-col lg:flex-row items-start gap-8 justify-start w-full max-lg:gap-6">
                            <!-- Lecture Dropdown -->
                            <div class="flex flex-col items-start gap-1.5 w-full lg:w-[512px]">
                                <label class="text-[#1c1c1c] font-tajawal text-base font-normal leading-6 text-right">
                                    اختر المحاضرة
                                </label>
                                <div class="relative w-full">
                                    <select
                                        id="section_id"
                                        name="section_id"
                                        class="w-full h-11 px-3.5 py-2.5 bg-white border border-[#d0d5dd] rounded-lg shadow-[0_1px_2px_0_rgba(16,24,40,0.05)] text-[#bfbfbf] font-tajawal text-base font-normal leading-6 text-right appearance-none pr-12 pl-3.5 focus:outline-none focus:border-brand-primary-normal focus:ring-1 focus:ring-brand-primary-normal"
                                        aria-label="اختر المحاضرة">
                                        <option value="">اختر المحاضرة</option>
                                        @foreach($course->Sections as $section)
                                        <option value="{{ $section->id }}">{{ $section->name }}</option>
                                        @endforeach
                                    </select>
                                    <div
                                        class="absolute left-3.5 top-1/2 transform -translate-y-1/2 pointer-events-none">
                                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path d="M5 7.5L10 12.5L15 7.5" stroke="#667085" stroke-width="1.66667"
                                                  stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </div>
                                </div>
                            </div>

                            <!-- Video Name Dropdown -->
                            <div class="flex flex-col items-start gap-1.5 w-full lg:w-[512px]">
                                <label class="text-[#1c1c1c] font-tajawal text-base font-normal leading-6 text-right">
                                    اختر اسم الفيديو
                                </label>
                                <div class="relative w-full">
                                    <select
                                        id="curriculum_id"
                                        name="curriculum_id"
                                        class="w-full h-11 px-3.5 py-2.5 bg-white border border-[#d0d5dd] rounded-lg shadow-[0_1px_2px_0_rgba(16,24,40,0.05)] text-[#bfbfbf] font-tajawal text-base font-normal leading-6 text-right appearance-none pr-12 pl-3.5 focus:outline-none focus:border-brand-primary-normal focus:ring-1 focus:ring-brand-primary-normal"
                                        aria-label="اختر اسم الفيديو">
                                        <option value="">اختر اسم الفيديو</option>
                                    </select>
                                    <div
                                        class="absolute left-3.5 top-1/2 transform -translate-y-1/2 pointer-events-none">
                                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path d="M5 7.5L10 12.5L15 7.5" stroke="#667085" stroke-width="1.66667"
                                                  stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Question Text Section -->
                        <div class="flex flex-col items-end gap-4 w-full">
                            <!-- Question Text Label -->
                            <h3 class="text-[#1c1c1c] text-right font-tajawal text-lg font-medium leading-7 w-full">
                                اضف سؤالك هنا
                            </h3>

                            <!-- Question Form -->
                            <div class="flex flex-col items-start gap-4 w-full">
                                <!-- Text Area -->
                                <div class="w-full">
                                    <textarea id="questionText"
                                              name="question"
                                              class="w-full h-[126px] px-3.5 py-2.5 bg-white border border-[#d0d5dd] rounded-lg shadow-[0_1px_2px_0_rgba(16,24,40,0.05)] text-[#a3a3a3] font-tajawal text-sm font-medium leading-5 text-right resize-none focus:outline-none focus:border-brand-primary-normal focus:ring-1 focus:ring-brand-primary-normal focus:text-[#1c1c1c]"
                                              placeholder="اكتب سؤالك هنا..." rows="6" dir="rtl"></textarea>
                                </div>

                                <!-- Submit Button -->
                                <button id="submit"
                                    class="bg-[#144394] flex items-center justify-center h-12 px-[30px] py-4 rounded-lg cursor-pointer hover:bg-[#123b85] transition-colors"
                                    >
                                    <span class="font-tajawal text-sm font-medium text-white">
                                        اضف تعليق
                                    </span>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Comments Tab Content -->
            <div class="tab-content hidden" data-content="comments">
                <div class="flex flex-col items-start gap-4 max-w-[1473px] w-full">
                    <!-- Add New Comment Section -->
                    <h2
                        class="text-title text-right font-tajawal text-2xl font-medium leading-8 m-0 max-md:text-xl max-md:leading-7">
                        التعليقات
                    </h2>
                    <form id="addComment" class="flex flex-col gap-2 items-start w-full mt-6">
                        <div class="flex gap-8 items-start justify-end w-full">
                            <div class="flex-1 flex flex-col h-[121px] items-start justify-start min-w-0">
                                <div class="flex flex-col gap-1.5 items-start w-full">
                                    <div class="flex flex-col gap-1.5 h-[126px] items-start w-full">
                                        <div
                                            class="bg-white h-[126px] rounded-lg w-full border border-[#d0d5dd] shadow-[0px_1px_2px_0px_rgba(16,24,40,0.05)]">
                                            <div
                                                class="flex gap-2 h-[126px] items-start justify-end px-3.5 py-2.5 w-full">
                                                <div class="flex-1 flex gap-2 items-center justify-end min-w-0">
                                                    <textarea id="newCommentText"
                                                              name="comment"
                                                              class="flex-1 font-tajawal text-sm font-medium text-neutral-600 text-right min-w-0 bg-transparent border-none outline-none resize-none h-full"
                                                              placeholder="اكتب تعليقك هنا..." dir="auto"></textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <button type="submit"
                            class="bg-[#144394] flex flex-col gap-2.5 h-12 items-center justify-center px-[30px] py-4 rounded-lg cursor-pointer hover:bg-[#123b85] transition-colors"
                            >
                            <div class="flex gap-2 items-end justify-start">
                                <div class="font-tajawal text-sm font-medium text-white whitespace-nowrap" dir="auto">
                                    اضف تعليق
                                </div>
                            </div>
                        </button>
                    </form>

                    <!-- Comments Section -->
                    <div class="flex flex-col w-full p-4 px-6 gap-4 rounded-lg bg-brand-primary-bg max-md:p-4">
                        <h2 class="text-[#1c1c1c] text-right font-tajawal text-lg font-medium leading-7 m-0">
                            جميع التعليقات
                        </h2>
                        <div id="commentsItems">
                        @include('frontend.include.course_comments')
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('footerScript')
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/jquery.validate.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        window.Toast= Swal.mixin({
            toast: true,
            position: "top-end",
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.onmouseenter = Swal.stopTimer;
                toast.onmouseleave = Swal.resumeTimer;
            }
        });
    </script>
    <script>
        $('#addComment').validate({
            rules: {
                comment: {
                    required: true,
                }
            },
            messages: {
                comment: {
                    required: "يجب ادخال الرسالة",
                },
            },
            errorElement: "p",
            errorClass: "mt-1 text-sm text-red-600", // Tailwind classes for error text
            highlight: function(element) {
                $(element).addClass("border-red-500 focus:border-red-500 focus:ring-red-200");
            },
            unhighlight: function(element) {
                $(element).removeClass("border-red-500 focus:border-red-500 focus:ring-red-200");
            },
            errorPlacement: function(error, element) {
                error.insertAfter(element.parent()); // ضع رسالة الخطأ تحت الـ input
            },
            submitHandler: function(form) {
                $(form).addClass('loading');
                let formData=new FormData(form);
                fetch("{{ route('course_save_comment',$course->url) }}", {
                    method: "POST",
                    body: formData,
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                        "Accept": "application/json"
                    }
                })
                    .then(async response => {
                        // Laravel بيرجع JSON غالبًا
                        // if (!response.ok) {
                        //     throw new Error("يوجد خطء في الوقت الحالي حاول مره اخري لاحقا او تواصل معنا");
                        // }
                        return response.json();
                    })
                    .then(data => {
                        $(form).removeClass('loading')

                        if (data.success) {
                            $(form)[0].reset();
                            $('#commentsItems').html(data.html)
                        }

                        if (typeof data.message === 'object') {
                            for(let key in data.message){
                                $(form).find("[name='"+key+"']").parent().append('<label id="'+key+'-error" class="error" for="'+key+'">'+data.message[key]+'</label>');
                            }
                        }
                        Toast.fire({
                            icon: data.success ? "success" : "error",
                            title: data.message
                        });
                        if(data.redirect){
                            setTimeout(function(){
                                window.location.href=data.redirect;
                            },3000)

                        }

                    })
                    .catch(error => {
                        $(form).removeClass('loading')
                        console.error("Fetch error:", error);
                        Toast.fire({
                            icon: "error",
                            title:error.toString().replaceAll('Error:','')
                        });
                    });
            }
        });
        $(document).on('change','#section_id',function(){
            let section_id=$(this).val();
            if(section_id){
                fetch("{{ route('course_get_curriculums',$course->url) }}", {
                    method: "POST",
                    body:JSON.stringify({section_id}),
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                        "Accept": "application/json"
                    }
                }) .then(async response => {
                    // Laravel بيرجع JSON غالبًا
                    // if (!response.ok) {
                    //     throw new Error("يوجد خطء في الوقت الحالي حاول مره اخري لاحقا او تواصل معنا");
                    // }
                    return response.json();
                })
                    .then(data => {
                       $('#curriculum_id').html(data.html)
                    });
            }

        })
        $('#saveQuestion').validate({
            rules: {
                section_id: {
                    required: true,
                },
                curriculum_id: {
                    required: true,
                },
                question: {
                    required: true,
                }
            },
            messages: {
                section_id: {
                    required: "يجب اختيار المحاضرة",
                },
                curriculum_id: {
                    required: "يجب اختيار الفيديو",
                },
                question: {
                    required: "يجب ادخال السؤال",
                },
            },
            errorElement: "p",
            errorClass: "mt-1 text-sm text-red-600", // Tailwind classes for error text
            highlight: function(element) {
                $(element).addClass("border-red-500 focus:border-red-500 focus:ring-red-200");
            },
            unhighlight: function(element) {
                $(element).removeClass("border-red-500 focus:border-red-500 focus:ring-red-200");
            },
            errorPlacement: function(error, element) {
                error.insertAfter(element.parent()); // ضع رسالة الخطأ تحت الـ input
            },
            submitHandler: function(form) {
                $(form).addClass('loading');
                let formData=new FormData(form);
                fetch("{{ route('course_save_question',$course->url) }}", {
                    method: "POST",
                    body: formData,
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                        "Accept": "application/json"
                    }
                })
                    .then(async response => {
                        // Laravel بيرجع JSON غالبًا
                        // if (!response.ok) {
                        //     throw new Error("يوجد خطء في الوقت الحالي حاول مره اخري لاحقا او تواصل معنا");
                        // }
                        return response.json();
                    })
                    .then(data => {
                        $(form).removeClass('loading')

                        if (data.success) {
                            $(form)[0].reset();
                            $('#commentsItems').html(data.html)
                        }

                        if (typeof data.message === 'object') {
                            for(let key in data.message){
                                $(form).find("[name='"+key+"']").parent().append('<label id="'+key+'-error" class="error" for="'+key+'">'+data.message[key]+'</label>');
                            }
                        }
                        Toast.fire({
                            icon: data.success ? "success" : "error",
                            title: data.message
                        });
                        if(data.redirect){
                            setTimeout(function(){
                                window.location.href=data.redirect;
                            },3000)

                        }

                    })
                    .catch(error => {
                        $(form).removeClass('loading')
                        console.error("Fetch error:", error);
                        Toast.fire({
                            icon: "error",
                            title:error.toString().replaceAll('Error:','')
                        });
                    });
            }
        });
    </script>
    <script>
        <?php $currentCurriculumID=explode('/',$currentCurriculum->link);$currentCurriculumID=(isset($currentCurriculumID[count($currentCurriculumID)-2]))?$currentCurriculumID[count($currentCurriculumID)-2]:'';?>
        var videoID='{{ $currentCurriculumID }}';
        var video_time='{{ $userCourseVideo?$userCourseVideo->video_time:0 }}';
        var current_time='{{ $userCourseVideo?$userCourseVideo->current_time:0 }}';
        var player = new SV.Player({videoId:videoID });
        var curriculum_id='{{ $currentCurriculum->id }}';
        var course_id='{{ $currentCurriculum->course_id }}';
        dataCookies=Cookies.getJSON();
        let saveData =window.saveData=function (){
            dataCookies=Cookies.getJSON();
            fetch('{{route('save_course_progress')}}', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                    "Accept": "application/json"
                },
                body: JSON.stringify({
                    dataCookies: dataCookies
                })
            })
                .then(response => response.text()) // لو السيرفر بيرجع نص
                .then(data => {
                    // نجاح العملية
                    Cookies.remove('curriculum-' + curriculum_id);
                })
                .catch(error => {
                    console.error('Error:', error);
                });
        };
        function closingCode(){
            // do something...
            saveData();
            return null;
        }
        if(typeof Cookies.get('curriculum-'+curriculum_id)=='undefined'){
            Cookies.set('curriculum-'+curriculum_id,{type:'curriculum',course_id:course_id,id:curriculum_id,video_time:parseFloat(video_time),current_time:parseFloat(current_time),max_time:0,completed:0});
        }
        player.bind('ready',function(){
            console.log('ready')
            player.play();
            player.setCurrentTime =current_time;
            if(localStorage.getItem('PLAYER_RATE')){
                player.setPlaybackRate(localStorage.getItem('PLAYER_RATE'))
            }
        });
        player.bind('play',function(){
            console.log('play')
            let videoQualityLevel=localStorage.getItem('videoQualityLevel');
            if(videoQualityLevel){
                player.setQualityLevel(videoQualityLevel)
            }
        });
        player.bind('rateChange',function(e){
            console.log('rateChange')
            localStorage.setItem('PLAYER_RATE',e.data);
        });
        hasRequest=false;
        player.bind('progress',function(){
            console.log('progress')
            durationTime=player.getDuration();
            durationTime=(durationTime>0)?durationTime:video_time;
            currentTime=player.getCurrentTime();
            percentageTime=(currentTime/durationTime)*100
            console.log('percentageTime',percentageTime)
            dataCookies=Cookies.getJSON('curriculum-'+curriculum_id);
            console.log(dataCookies);
            dataCookies.video_time=player.getDuration();
            dataCookies.current_time=player.getCurrentTime();

            dataCookies.max_time=(dataCookies.max_time>dataCookies.current_time)?dataCookies.max_time:player.getCurrentTime();
            if(percentageTime>=70&&!hasRequest){
                dataCookies.completed=1;
            }
            Cookies.set('curriculum_id-'+curriculum_id,dataCookies);
            if(percentageTime>=70&&!hasRequest){
                hasRequest=true;
                saveData();
            }

            console.log(percentageTime)

        });
        player.bind('qualityLevelChange',function({data,target,type}){
            localStorage.setItem('videoQualityLevel',data)
        });
        player.bind('completed',function(){
            console.log('completed')
            dataCookies=Cookies.getJSON('curriculum-'+curriculum_id);
            if (dataCookies) {
                dataCookies.completed+=1;
            }
            Cookies.set('curriculum-'+curriculum_id,dataCookies);
            saveData();
        });
    </script>
    <script>
        // Tab switching functionality
        document.addEventListener("DOMContentLoaded", function () {
            const tabButtons = document.querySelectorAll(".tab-button");
            const tabContents = document.querySelectorAll(".tab-content");

            tabButtons.forEach((button) => {
                button.addEventListener("click", function () {
                    const targetTab = this.getAttribute("data-tab");

                    // Remove active class from all buttons
                    tabButtons.forEach((btn) => {
                        btn.classList.remove("active");
                        btn.classList.remove(
                            "text-brand-primary-normal",
                            "border-brand-primary-normal"
                        );
                        btn.classList.add("text-neutral-n100", "border-transparent");
                    });

                    // Add active class to clicked button
                    this.classList.add("active");
                    this.classList.remove("text-neutral-n100", "border-transparent");
                    this.classList.add(
                        "text-brand-primary-normal",
                        "border-brand-primary-normal"
                    );

                    // Hide all tab contents
                    tabContents.forEach((content) => {
                        content.classList.add("hidden");
                    });

                    // Show target tab content
                    const targetContent = document.querySelector(
                        `[data-content="${targetTab}"]`
                    );
                    if (targetContent) {
                        targetContent.classList.remove("hidden");
                    }
                });
            });
        });








    </script>
@endpush
