@extends('frontend.layouts.app')
@push('headScript')
    <!-- Tailwind Configuration -->
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        alexandria: ["Alexandria", "sans-serif"],
                    },
                    colors: {
                        "brand-success": "#00B34F",
                        "brand-secondary-normal": "#00B34F",
                        "brand-secondary-light": "#E8F5FF",
                        "brand-primary-light": "#E8ECF4",
                    },
                },
            },
        };
    </script>

    <style>
        * {
            /* border: 1px solid red !important; */
        }

        body {
            font-family: "Alexandria", sans-serif;
        }

        /* Mobile Menu Styles */
        .mobile-menu {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.4s ease-in-out, opacity 0.3s ease-in-out;
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
        }

        .mobile-menu.open {
            max-height: 600px;
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        /* Ensure mobile menu is above other elements */
        .mobile-menu .bg-white\/95 {
            background-color: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
        }

        /* Mobile menu animation */
        .mobile-menu .mobile-menu-content {
            transform: translateY(-20px);
            transition: transform 0.3s ease-out;
        }

        .mobile-menu.open .mobile-menu-content {
            transform: translateY(0);
        }

        /* Mobile responsive button adjustments */
        @media (max-width: 768px) {
            .responsive-button-text {
                display: none;
            }

            .responsive-button-icon {
                margin: 0 !important;
            }
        }
    </style>
@endpush
{{--@section('headerScript')--}}
{{--   --}}
{{--@endsection--}}
@section('content')

    <!-- Hero Section -->
    <div class="relative overflow-hidden min-h-screen">
        <!-- Background Image -->
        <div class="absolute inset-0">
            <img src="{{ asset('frontend/images') }}/courses-background.png" alt="Background" class="w-full h-full object-cover" />
        </div>

        <!-- Background Gradient Overlay -->
        <div class="absolute inset-0">
            <svg class="w-full h-full" viewBox="0 0 1600 808" fill="none" xmlns="http://www.w3.org/2000/svg"
                 preserveAspectRatio="xMidYMid slice">
                <path d="M0 0H1600V808H0V0Z" fill="url(#paint0_linear_gradient_overlay)" />
                <defs>
                    <linearGradient id="paint0_linear_gradient_overlay" x1="205.022" y1="0" x2="1573.65" y2="664.405"
                                    gradientUnits="userSpaceOnUse">
                        <stop offset="0%" stop-color="#0C2959" stop-opacity="0.45" />
                        <stop offset="18.28%" stop-color="#0C2959" stop-opacity="0.55" />
                        <stop offset="31.41%" stop-color="#0C2959" stop-opacity="0.62" />
                        <stop offset="49.65%" stop-color="#0C2959" stop-opacity="0.72" />
                        <stop offset="74.35%" stop-color="#0C2959" stop-opacity="0.86" />
                        <stop offset="100%" stop-color="#0C2959" />
                    </linearGradient>
                </defs>
            </svg>
        </div>

        <!-- Background Ellipses -->
        <div class="absolute -top-72 -left-96">
            <svg width="1179" height="1101" viewBox="0 0 427 600" fill="none" xmlns="http://www.w3.org/2000/svg"
                 class="w-[1179px] h-[1101px]">
                <ellipse opacity="0.0361096" cx="-141.91" cy="276.897" rx="302.522" ry="282.616" fill="white" />
                <ellipse opacity="0.0458287" cx="-147.167" cy="267.075" rx="432.363" ry="403.667" fill="white" />
                <ellipse opacity="0.050665" cx="-163.463" cy="257.5" rx="589.537" ry="550.5" fill="white" />
            </svg>
        </div>

        <!-- Wave at bottom -->
        <div class="absolute bottom-0 left-0 w-full">
            <svg class="w-full h-52" viewBox="0 0 1600 202" fill="none" xmlns="http://www.w3.org/2000/svg"
                 preserveAspectRatio="none">
                <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M0 79.458C0 79.458 226.389 186.741 381.052 178.06C535.714 169.378 628.364 133.594 798.309 151.486C968.253 169.378 1461.17 124.238 1600 0V209.034H0V79.458Z"
                      fill="#FDFDFF" />
            </svg>
        </div>
    @include('frontend.include.header')
    <!-- Hero Content -->
        <div class="relative z-10 pt-32 pb-32 px-4 md:px-8 lg:px-16 min-h-screen flex flex-col justify-center">
            <div class="max-w-7xl mx-auto w-full">
                <!-- Breadcrumb and Title Container -->
                <div class="flex flex-col items-start gap-6 text-right">
                    <!-- Breadcrumb -->
                    <div class="flex items-center gap-2 text-[#F5F6F7]">
                        <a href="{{ route('home_page') }}" class="font-alexandria text-[20px]">الرئيسية</a>
                        <svg width="8" height="8" viewBox="0 0 8 8" fill="none" xmlns="http://www.w3.org/2000/svg"
                             class="rotate-180">
                            <path d="M3 1L6 4L3 7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                  stroke-linejoin="round" />
                        </svg>
                        <span class="font-alexandria text-[20px] text-brand-success font-bold">الدورات</span>
                    </div>

                    <!-- Page Title -->
                    <h1 class="font-alexandria text-4xl md:text-5xl lg:text-6xl font-bold text-[#F5F6F7] leading-tight">
                        الدورات التدريبية
                    </h1>
                </div>
            </div>
        </div>
    </div>
    <!-- Course Listing Section -->
    <div class="bg-white py-8 lg:py-16" dir="rtl">
        <div class="max-w-7xl mx-auto">
            <!-- Main Content Layout -->
            <div class="flex flex-col lg:flex-row gap-8">
                <!-- Sidebar Filters -->
                <aside class="lg:w-2/5 xl:w-1/3 border border-[#F0F2F4] rounded-3xl p-4">
                    <form id="filterForm" action="{{ request()->fullUrlWithQuery([]) }}" class="space-y-6">
                        <!-- Search Filter -->
                        <div  class="bg-white rounded-3xl">
                            <div class="relative">
                                <input type="text" name="search" value="{{ request('search') }}" placeholder="ابحث عن ما تريد!"
                                       class="w-full py-3 px-4 pr-12 rounded-full border-2 border-[#F0F2F4] font-alexandria text-base placeholder:text-[#8F99AB]" />
                                <button type="submit"
                                    class="absolute left-3 top-1/2 transform -translate-y-1/2 bg-[#144394] text-white px-4 py-2 rounded-full font-alexandria text-sm font-medium">
                                    ابحث
                                </button>
                                <svg class="absolute right-4 top-1/2 transform -translate-y-1/2 w-6 h-6 text-[#8F99AB]" fill="none"
                                     stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                          d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                </svg>
                            </div>
                        </div>

                        <!-- Course Categories -->
                        <div class="bg-white rounded-2xl border border-[#F0F2F4] p-4">
                            <div class="flex items-center justify-between mb-5">
                                <h3 class="font-alexandria text-xl font-normal text-[#091E43]">
                                    تصنيفات الدورات
                                </h3>
                                <button id="categories-toggle"
                                        class="w-6 h-6 rounded-full bg-[#3E65A7] flex items-center justify-center">
                                    <svg id="categories-arrow" class="text-white transition-transform duration-200" width="12" height="7"
                                         viewBox="0 0 12 7" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M11.3075 0.415898C10.945 0.0552421 10.3594 0.0552421 9.99692 0.415898L6.00931 4.40351L2.0217 0.415898C1.63221 0.0821953 1.04478 0.127758 0.711074 0.517196C0.412715 0.86482 0.412715 1.37885 0.711074 1.72648L5.35864 6.37404C5.72117 6.7347 6.30673 6.7347 6.66926 6.37404L11.3168 1.72648C11.6747 1.36118 11.671 0.775617 11.3075 0.415898Z"
                                            fill="white" />
                                    </svg>
                                </button>
                            </div>
                            <div id="categories-content" class="space-y-2.5">
                                @foreach($categories as $category)
                                <div class="flex items-center justify-center gap-2 py-2.5">
                                    <input type="checkbox" class="w-5 h-5 border-3 border-[#CCC] rounded-sm bg-white" name="categories[]" value="{{ $category->url }}" @if(in_array($category->url,request('categories')??[])) checked @endif />
                                    <div class="flex items-start gap-2 flex-1">
                                        <span class="font-alexandria text-lg font-normal text-[#1A1A1A]">{{ $category->name }}</span>
                                        <span class="font-alexandria text-lg font-normal text-[#808080]">({{ $category->Courses()->count() }})</span>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>

                        <!-- Instructors Filter -->
                        <div class="bg-white rounded-2xl border border-[#F0F2F4] p-4">
                            <div class="flex items-center justify-between mb-5">
                                <h3 class="font-alexandria text-xl font-normal text-[#091E43]">
                                    المحاضرين
                                </h3>
                                <button id="instructors-toggle"
                                        class="w-6 h-6 rounded-full bg-[#3E65A7] flex items-center justify-center">
                                    <svg id="instructors-arrow" class="text-white transition-transform duration-200" width="12" height="7"
                                         viewBox="0 0 12 7" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M11.3075 0.415898C10.945 0.0552421 10.3594 0.0552421 9.99692 0.415898L6.00931 4.40351L2.0217 0.415898C1.63221 0.0821953 1.04478 0.127758 0.711074 0.517196C0.412715 0.86482 0.412715 1.37885 0.711074 1.72648L5.35864 6.37404C5.72117 6.7347 6.30673 6.7347 6.66926 6.37404L11.3168 1.72648C11.6747 1.36118 11.671 0.775617 11.3075 0.415898Z"
                                            fill="white" />
                                    </svg>
                                </button>
                            </div>
                            <div id="instructors-content" class="space-y-2.5">
                                @foreach($instructors as $instructor)
                                <div class="flex items-center justify-center gap-2 py-2.5">
                                    <input type="checkbox" class="w-5 h-5 border-3 border-[#CCC] rounded-sm bg-white"  name="instructors[]" value="{{ $instructor->url }}" @if(in_array($instructor->url,request('instructors')??[])) checked @endif />
                                    <div class="flex items-start gap-2 flex-1">
                                        <span class="font-alexandria text-lg font-normal text-[#1A1A1A]">{{ $instructor->name }}</span>
                                        <span class="font-alexandria text-lg font-normal text-[#808080]">({{ $instructor->Courses()->count() }})</span>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>

                        <!-- Accreditations Filter -->
                        <div class="bg-white rounded-2xl border border-[#F0F2F4] p-4">
                            <div class="flex items-center justify-between mb-5">
                                <h3 class="font-alexandria text-xl font-normal text-[#091E43]">
                                    الإعتمادات
                                </h3>
                                <button id="accreditations-toggle"
                                        class="w-6 h-6 rounded-full bg-[#3E65A7] flex items-center justify-center">
                                    <svg id="accreditations-arrow" class="text-white transition-transform duration-200" width="12"
                                         height="7" viewBox="0 0 12 7" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M11.3075 0.415898C10.945 0.0552421 10.3594 0.0552421 9.99692 0.415898L6.00931 4.40351L2.0217 0.415898C1.63221 0.0821953 1.04478 0.127758 0.711074 0.517196C0.412715 0.86482 0.412715 1.37885 0.711074 1.72648L5.35864 6.37404C5.72117 6.7347 6.30673 6.7347 6.66926 6.37404L11.3168 1.72648C11.6747 1.36118 11.671 0.775617 11.3075 0.415898Z"
                                            fill="white" />
                                    </svg>
                                </button>
                            </div>
                            <div id="accreditations-content" class="space-y-2.5">
                                <div class="flex items-center justify-center gap-2 py-2.5">
                                    <input type="checkbox" class="w-5 h-5 border-3 border-[#CCC] rounded-sm bg-white" />
                                    <div class="flex items-start gap-2 flex-1">
                                        <span class="font-alexandria text-lg font-normal text-[#1A1A1A]">جامعة عجمان</span>
                                        <span class="font-alexandria text-lg font-normal text-[#808080]">(134)</span>
                                    </div>
                                </div>
                                <div class="flex items-center justify-center gap-2 py-2.5">
                                    <input type="checkbox" class="w-5 h-5 border-3 border-[#CCC] rounded-sm bg-white" />
                                    <div class="flex items-start gap-2 flex-1">
                                        <span class="font-alexandria text-lg font-normal text-[#1A1A1A]">جامعة ريادة الأعمال</span>
                                        <span class="font-alexandria text-lg font-normal text-[#808080]">(150)</span>
                                    </div>
                                </div>
                                <div class="flex items-center justify-center gap-2 py-2.5 opacity-80">
                                    <input type="checkbox" class="w-5 h-5 border-3 border-[#CCC] rounded-sm bg-white" />
                                    <div class="flex items-start gap-2 flex-1">
                                        <span class="font-alexandria text-lg font-normal text-[#1A1A1A]">غرفة الخرج</span>
                                        <span class="font-alexandria text-lg font-normal text-[#808080]">(54)</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- PhD Doctorate Banner -->
                        <div
                            class="relative w-full rounded-3xl overflow-hidden shadow-lg bg-gradient-to-br from-gray-800 to-gray-900">
                            <!-- Banner Background -->
                            <div class="relative w-full">
                                <img src="{{ asset('frontend/images') }}/Bannar.png" alt="PhD Doctorate Banner - الحصول على الدكتوراه" class="w-full h-full"
                                     style="object-fit: contain" />

                                <!-- Content Overlay -->
                                <div class="absolute inset-0 bg-black bg-opacity-40 flex items-center justify-center">
                                    <div class="text-center text-white max-w-lg">
                                        <!-- Main Banner Title -->
                                        <h3
                                            class="font-alexandria text-[1.2rem] md:text-xl lg:text-md xl:text-md font-bold leading-tight mb-3 md:mb-4">
                                            يمكنك الآن الحصول علي الدكتوراه معتمدة من اكبر الجامعات!
                                        </h3>

                                        <!-- Subtitle -->
                                        <div class="mb-4 md:mb-6">
                                            <p class="font-alexandria text-sm md:text-base lg:text-lg font-normal">
                                                جديد من <span class="font-bold">إعمل بيزنس</span>
                                            </p>
                                        </div>

                                        <!-- Call to Action Button -->
                                        <button
                                            class="inline-flex items-center gap-2 md:gap-3 bg-transparent border-none text-[#00B34F] hover:text-white transition-all duration-300 transform hover:scale-105 group">
                                            <!-- Button Text -->
                                            <span class="font-alexandria text-sm md:text-base lg:text-lg font-semibold">
                        اشترك الآن
                      </span>

                                            <!-- Arrow Icon -->
                                            <svg class="w-4 h-4 md:w-5 md:h-5 transition-transform duration-300 group-hover:-translate-x-1"
                                                 viewBox="0 0 17 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M1 9.49945H16" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                                      stroke-linejoin="round" />
                                                <path d="M7.05005 15.5245L1.00005 9.50047L7.05005 3.47548" stroke="currentColor"
                                                      stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </aside>

                <!-- Course Cards Grid -->
                <main class="lg:w-3/5 xl:w-2/3">
                    <!-- Page Header -->
                    <div class="text-right mb-8 lg:mb-12">
                        <h1 class="font-alexandria text-3xl lg:text-5xl font-bold text-[#2E2E2E] mb-4">
                            الدورات التدريبية
                        </h1>
                        <p class="font-alexandria text-lg text-[#575757] max-w-2xl ml-auto">
                            اكثر من
                            {{$coursesCount}}
                            + دورة تدريبية متاحة لجميع طلابنا
                        </p>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        @foreach($courses as $course)
                        <!-- Course Card {{ $loop->index+1 }} -->
                            <x-course-card :course="$course"/>
                        @endforeach
                    </div>

                    <!-- Pagination -->
                    <div class="flex items-center justify-center gap-2 mt-8">
                        {!! $courses->appends(request()->only('search'))->links('vendor.pagination.custom-tailwind') !!}
                    </div>
                </main>
            </div>
        </div>
    </div>
    <!-- ============================= End Of Courses Section ============================= -->
@endsection
@push('footerScript')
    <script>
        document.addEventListener('change', function (e) {
            if (
                e.target.matches('input[name="instructors[]"], input[name="categories[]"]')
            ) {
                document.getElementById('filterForm').submit();
            }
        });
        // Filter dropdown functionality
        function toggleDropdown(toggleId, contentId, arrowId) {
            const toggle = document.getElementById(toggleId);
            const content = document.getElementById(contentId);
            const arrow = document.getElementById(arrowId);

            if (toggle && content && arrow) {
                // Set initial state - closed (arrow pointing up)
                arrow.style.transform = "rotate(180deg)";

                toggle.addEventListener("click", function (e) {
                    e.preventDefault();
                    if (content.style.display === "none") {
                        // Opening - show content and point arrow down
                        content.style.display = "block";
                        arrow.style.transform = "rotate(0deg)";
                    } else {
                        // Closing - hide content and point arrow up
                        content.style.display = "none";
                        arrow.style.transform = "rotate(180deg)";
                    }
                });
            }
        }

        // Initialize filter dropdowns when DOM is loaded
        document.addEventListener("DOMContentLoaded", function () {
            toggleDropdown(
                "categories-toggle",
                "categories-content",
                "categories-arrow"
            );
            toggleDropdown(
                "instructors-toggle",
                "instructors-content",
                "instructors-arrow"
            );
            toggleDropdown(
                "accreditations-toggle",
                "accreditations-content",
                "accreditations-arrow"
            );
        });
    </script>
@endpush
