@extends('frontend.layouts.app')
@push('headScript')
    <!-- Tailwind Configuration -->
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        alexandria: ["Alexandria", "sans-serif"],
                    },
                    colors: {
                        "brand-success": "#00B34F",
                        "brand-secondary-normal": "#00B34F",
                        "brand-secondary-light": "#E6F7ED",
                        "brand-primary-light": "#E8ECF4",
                        "brand-primary-normal": "#144394",
                        "brand-primary-bg": "#F2F4F9",
                        "neutral-n800": "#0D0D0D",
                        "neutral-n700": "#1C1C1C",
                        "neutral-n500": "#3B3B3B",
                        "neutral-n10": "#FAFAFA",
                        "neutral-n40": "#DEDEDE",
                        "foundation-neutral-8": "#5F6D85",
                        "colors-base-black": "#000",
                        "colors-text-disabled": "#667085",
                        "colors-text-primary-900": "#101828",
                        "colors-text-secondary-700": "#344054",
                        "gray-scale-gray-500": "#808080",
                        "branding-success": "#00B207",
                    },
                    backgroundImage: {
                        "hero-gradient":
                            "linear-gradient(104deg, rgba(12, 41, 89, 0.45) 10.29%, rgba(12, 41, 89, 0.55) 25.8%, rgba(12, 41, 89, 0.62) 36.96%, rgba(12, 41, 89, 0.72) 52.44%, rgba(12, 41, 89, 0.86) 73.41%, #0C2959 95.18%)",
                    },
                },
            },
        };
    </script>

    <style>
        * {
            /* border: 1px solid red !important; */
        }

        body {
            font-family: "Alexandria", sans-serif;
        }

        /* Mobile Menu Styles */
        .mobile-menu {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.4s ease-in-out, opacity 0.3s ease-in-out;
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
        }

        .mobile-menu.open {
            max-height: 600px;
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        .lecture-content {
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            overflow: hidden;
            height: 80px;
        }
        .lecture-content.expanded {
            height: auto;
        }

        .lecture-arrow {
            transition: transform 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .lecture-arrow.rotate-180 {
            transform: rotate(180deg);
        }

        /* Mobile responsive button adjustments */
        @media (max-width: 768px) {
            .responsive-button-text {
                display: none;
            }

            .responsive-button-icon {
                margin: 0 !important;
            }
        }
    </style>
@endpush
{{--@section('headerScript')--}}
{{--  --}}
{{--@endsection--}}
@section('content')
    <!-- Hero Section -->
    <div class="relative overflow-hidden min-h-screen">
        <!-- Background Image -->
        <div class="absolute top-0 left-0 w-full h-full z-0">
            <img src="{{ asset('assets/images/'.$course->image) }}" alt="AI Background" class="absolute bottom-0 left-0 z-0" />
        </div>

        <!-- top left wave shape  -->
        <div>
            <img src="{{ asset('frontend/images') }}/course-details/ai-wave-shape.svg" alt="AI Wave Shape" class="absolute top-0 left-0 z-2" />
        </div>

        <!-- Background Gradient Overlay -->
        <div class="absolute inset-0 z-10 bg-hero-gradient"></div>

        <!-- Background Ellipses -->
        <div class="absolute -top-96 -left-96 z-20 opacity-40">
            <svg width="1179" height="1101" viewBox="0 0 503 687" fill="none" xmlns="http://www.w3.org/2000/svg"
                 class="w-[1179px] h-[1101px]">
                <ellipse opacity="0.0361096" cx="-65.9103" cy="155.897" rx="302.522" ry="282.616" fill="white" />
                <ellipse opacity="0.0458287" cx="-71.1668" cy="146.075" rx="432.363" ry="403.667" fill="white" />
                <ellipse opacity="0.050665" cx="-87.4625" cy="136.5" rx="589.537" ry="550.5" fill="white" />
            </svg>
        </div>

    <!-- Hero Content -->
        <div class="relative z-30 min-h-screen flex items-center px-4 md:px-16"
             style="padding-top: 187px; padding-bottom: 187px">
            <div class="max-w-7xl mx-auto w-full">
                <div class="flex items-end justify-start">
                    <!-- Content Container -->
                    <div class="w-full max-w-3xl text-right space-y-6">
                        <!-- Category Chip -->
                        <div class="flex justify-start">
                            <div class="bg-[#E4DFFF] px-3 py-1 rounded-lg inline-block">
                                <span class="font-alexandria text-sm font-medium text-neutral-n800">{{ $course->Category?->name }}</span>
                            </div>
                        </div>

                        <!-- Course Title -->
                        <h1 class="font-alexandria text-4xl md:text-5xl lg:text-5xl font-bold text-neutral-n10 leading-tight">
                            {{ $course->name }}
                        </h1>

                        <!-- Course Description -->
                        <p class="font-alexandria text-lg text-neutral-n40 leading-relaxed max-w-2xl text-justify">
                            {{ $course->short_description }}
                        </p>

                        <!-- Skills Tags -->
                        <div class="flex flex-wrap gap-4 justify-end items-start flex-row-reverse">
                            @foreach($course->Tags as $tag)
                                <div class="border-2 border-neutral-n10 rounded-full px-4 py-2">
                                    <span class="font-alexandria text-sm font-medium text-neutral-n10">{{ $tag->name }}</span>
                                </div>
                            @endforeach
                        </div>
                    @if(!hasCourse($course->id))
                        <!-- CTA Button -->
                            <div class="flex justify-start">
                                <a href="{{ route('book_demo_page') }}"
                                   class="flex items-center gap-3 px-6 py-3 bg-brand-success border border-brand-success rounded-lg text-white font-alexandria hover:bg-[#00A047] transition-colors">
                                    <span class="text-base font-medium">احجز عرضًا توضيحيًا الآن</span>
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M8.414 13.343L12.364 17.293C12.5462 17.4817 12.647 17.7343 12.6447 17.9965C12.6424 18.2587 12.5372 18.5095 12.3518 18.6949C12.1664 18.8803 11.9156 18.9855 11.6534 18.9878C11.3912 18.99 11.1386 18.8892 10.95 18.7071L5.293 13.0501C5.19982 12.9574 5.12587 12.8473 5.07541 12.7259C5.02494 12.6046 4.99897 12.4745 4.99897 12.343C4.99897 12.2117 5.02494 12.0816 5.07541 11.9602C5.12587 11.8389 5.19982 11.7287 5.293 11.6361L10.95 5.97908C11.0422 5.88357 11.1526 5.80739 11.2746 5.75498C11.3966 5.70257 11.5278 5.67498 11.6606 5.67383C11.7934 5.67268 11.9251 5.69798 12.048 5.74826C12.1709 5.79854 12.2825 5.87279 12.3764 5.96669C12.4703 6.06058 12.5445 6.17223 12.5948 6.29513C12.6451 6.41802 12.6704 6.5497 12.6693 6.68248C12.6681 6.81526 12.6405 6.94648 12.5881 7.06849C12.5357 7.19049 12.4595 7.30083 12.364 7.39308L8.414 11.343H18C18.2652 11.343 18.5196 11.4484 18.7071 11.636C18.8946 11.8235 19 12.0779 19 12.343C19 12.6083 18.8946 12.8627 18.7071 13.0502C18.5196 13.2377 18.2652 13.343 18 13.343H8.414Z"
                                            fill="white" />
                                    </svg>
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Wave at bottom -->
        <div class="absolute bottom-0 left-0 w-full z-20">
            <svg class="w-full h-52" viewBox="0 0 1600 172" fill="none" xmlns="http://www.w3.org/2000/svg"
                 preserveAspectRatio="none">
                <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M0 79.458C0 79.458 226.389 186.741 381.052 178.06C535.714 169.378 628.364 133.594 798.309 151.486C968.253 169.378 1461.17 124.238 1600 0V209.034H0V79.458Z"
                      fill="#FDFDFF" />
            </svg>
        </div>
    </div>
    <!-- Program Content Section -->
    <div class="bg-white py-16 lg:py-20 px-4 md:px-8 lg:px-16" dir="rtl">
        <div class="max-w-7xl mx-auto">
            <div class="flex flex-col items-center gap-8 lg:gap-12">
                <!-- Section Title -->
                <h2
                    class="font-alexandria text-3xl md:text-4xl lg:text-5xl font-medium text-neutral-n700 text-center leading-tight">
                    محتوي البرنامج
                </h2>

                <!-- Cards Container -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 w-full">
                    <!-- Card 1 - Certified Certificate -->
                    <div
                        class="order-3 flex flex-col items-center justify-center p-6 rounded-lg border border-neutral-n40 bg-brand-primary-bg shadow-md hover:shadow-lg transition-shadow">
                        <div class="flex flex-col items-center gap-6 w-full max-w-xs">
                            <!-- Icon Container -->
                            <div class="relative w-20 h-20 filter drop-shadow-sm">
                                <!-- Background Circle -->
                                <div class="absolute inset-0 w-20 h-20 bg-[#DCE3EF] rounded-full"></div>
                                <!-- Certificate Icon -->
                                <div class="absolute inset-0 flex items-center justify-center">
                                    <img src="{{ asset('frontend/images') }}/course-details/certificate-icon.png" alt="شهادة معتمدة" class="w-12 h-12" />
                                </div>
                            </div>

                            <!-- Text Content -->
                            <div class="flex flex-col items-center gap-2 text-center">
                                <h3 class="font-alexandria text-base font-bold text-brand-primary-normal leading-7">
                                    شهادة معتمدة
                                </h3>
                                <p class="font-alexandria text-sm text-neutral-n500 leading-7">
                                    شهادة إتمام معتمدة تُمنح بعد إكمال الدورة بنجاح.
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Card 2 - Accessibility -->
                    <div
                        class="order-2 flex flex-col items-center justify-center p-6 rounded-lg border border-neutral-n40 bg-brand-primary-bg shadow-md hover:shadow-lg transition-shadow">
                        <div class="flex flex-col items-center gap-6 w-full max-w-xs">
                            <!-- Icon Container -->
                            <div class="relative w-20 h-20 filter drop-shadow-sm">
                                <!-- Background Circle -->
                                <div class="absolute inset-0 w-20 h-20 bg-[#DCE3EF] rounded-full"></div>
                                <!-- Accessibility Icon -->
                                <div class="absolute inset-0 flex items-center justify-center">
                                    <img src="{{ asset('frontend/images') }}/course-details/accessibility-icon.png" alt="إمكانية الوصول" class="w-12 h-12" />
                                </div>
                            </div>

                            <!-- Text Content -->
                            <div class="flex flex-col items-center gap-2 text-center">
                                <h3 class="font-alexandria text-base font-bold text-brand-primary-normal leading-7">
                                    إمكانية الوصول
                                </h3>
                                <p class="font-alexandria text-sm text-neutral-n500 leading-7">
                                    إمكانية الوصول الكامل للدورة عبر الهاتف أو التابلت
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Card 3 - Short Tests -->
                    <div
                        class="order-1 flex flex-col items-center justify-center p-6 rounded-lg border border-neutral-n40 bg-brand-primary-bg shadow-md hover:shadow-lg transition-shadow">
                        <div class="flex flex-col items-center gap-6 w-full max-w-xs">
                            <!-- Icon Container -->
                            <div class="relative w-20 h-20 filter drop-shadow-sm">
                                <!-- Background Circle -->
                                <div class="absolute inset-0 w-20 h-20 bg-[#DCE3EF] rounded-full"></div>
                                <!-- Quiz Icon -->
                                <div class="absolute inset-0 flex items-center justify-center">
                                    <img src="{{ asset('frontend/images') }}/course-details/quiz-icon.png" alt="Quiz Icon" class="w-14 h-14" />
                                </div>
                            </div>

                            <!-- Text Content -->
                            <div class="flex flex-col items-center gap-2 text-center">
                                <h3 class="font-alexandria text-base font-bold text-brand-primary-normal leading-7">
                                    اختبارات قصيرة
                                </h3>
                                <p class="font-alexandria text-sm text-neutral-n500 leading-7">
                                    اختبارات قصيرة لتقييم فهمك بعد كل وحدة دراسية
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Card 4 - Project File -->
                    <div
                        class="order-0 flex flex-col items-center justify-center p-6 rounded-lg border border-neutral-n40 bg-brand-primary-bg shadow-md hover:shadow-lg transition-shadow">
                        <div class="flex flex-col items-center gap-6 w-full max-w-xs">
                            <!-- Icon Container -->
                            <div class="relative w-20 h-20 filter drop-shadow-sm">
                                <!-- Background Circle -->
                                <div class="absolute inset-0 w-20 h-20 bg-[#DCE3EF] rounded-full"></div>
                                <!-- Folder Icon -->
                                <div class="absolute inset-0 flex items-center justify-center">
                                    <img src="{{ asset('frontend/images') }}/course-details/folder-icon.png" alt="ملف مشروع" class="w-12 h-12" />
                                </div>
                            </div>

                            <!-- Text Content -->
                            <div class="flex flex-col items-center gap-2 text-center">
                                <h3 class="font-alexandria text-base font-bold text-brand-primary-normal leading-7">
                                    ملف مشروع
                                </h3>
                                <p class="font-alexandria text-sm text-neutral-n500 leading-7">
                                    ملف مشروع عملي لتطبيق ما تعلّمته خطوة بخطوة.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Course Description Section -->
    <div class="bg-white py-16 lg:py-20 px-4 md:px-8 lg:px-16" dir="rtl">
        <div class="max-w-7xl mx-auto">
            <div class="flex flex-col items-center gap-8 lg:gap-12">
                <!-- Section Title -->
                <h2
                    class="font-alexandria text-3xl md:text-4xl lg:text-5xl font-medium text-neutral-n700 text-center leading-tight">
                    وصف الدورة التدريبية
                </h2>

                <!-- Content Container -->
                <div class="flex flex-col lg:flex-row items-stretch gap-6 lg:gap-8 w-full">
                    <!-- Description Container -->
                    <div class="w-full lg:w-1/2 flex flex-col justify-center">
                        <div class="w-full max-w-2xl">
                            {!! $course->description !!}
                        </div>
                    </div>

                    <!-- Video Container -->
                    <div class="w-full lg:w-1/2 flex flex-col items-center justify-center">
                        <div class="relative w-full max-w-2xl h-full">
                            <iframe width="100%" height="350" class="video-src d-block sproutvideo-player" src="https://{{ $course->intro_vedio }}?autoplay=false&amp;playsInline=false" title="YouTube video player" frameborder="0" allow="accelerometer;  clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen=""></iframe>
                            <!-- Video Thumbnail -->
                            {{--                            <img src="{{ asset('frontend/images') }}/course-details/course-video-thumbnail.png" alt="Course Video Thumbnail"--}}
                            {{--                                 class="w-full h-full rounded-lg object-cover" />--}}

                            {{--                            <!-- Play Button Overlay -->--}}
                            {{--                            <button class="absolute inset-0 flex items-center justify-center group" aria-label="Play Course Video">--}}
                            {{--                                <div class="relative">--}}
                            {{--                                    <!-- Play Button Background -->--}}
                            {{--                                    <div--}}
                            {{--                                        class="w-24 h-24 md:w-28 md:h-28 lg:w-32 lg:h-32 rounded-full bg-black bg-opacity-64 flex items-center justify-center group-hover:bg-opacity-75 transition-all duration-300">--}}
                            {{--                                        <!-- Play Icon -->--}}
                            {{--                                        <svg class="w-8 h-8 md:w-10 md:h-10 lg:w-12 lg:h-12 text-white ml-1" fill="currentColor"--}}
                            {{--                                             viewBox="0 0 24 24">--}}
                            {{--                                            <path d="M8 5v14l11-7z" />--}}
                            {{--                                        </svg>--}}
                            {{--                                    </div>--}}
                            {{--                                </div>--}}
                            {{--                            </button>--}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- About the Instructor Section -->
    @if($course->Instructor)
        <div class="bg-brand-primary-bg py-16 lg:py-20 px-4 md:px-8 lg:px-16 max-w-[95%] mx-auto" dir="rtl">
            <div class="max-w-7xl mx-auto">
                <div class="flex flex-col lg:flex-row items-center lg:items-start gap-12 lg:gap-16">
                    <!-- Instructor Image and Social Media -->
                    <div class="w-full lg:w-2/5 flex flex-col items-center lg:items-start gap-6">
                        <!-- Instructor Image -->
                        <div class="relative w-full max-w-md">
                            <!-- Background -->
                            <div class="absolute inset-0 w-full h-full bg-brand-primary-light rounded-lg"
                                 style="transform: translateX(-5px) translateY(-5px)"></div>
                            <!-- Main Image -->
                            <div class="relative w-full">
                                <img src="{{ asset('assets/images/'.$course->Instructor->pic) }}" alt="{{ $course->Instructor->name }}"
                                     class="w-full h-auto rounded-lg object-cover" style="aspect-ratio: 422/573" />
                            </div>
                        </div>

                        <!-- Social Media Links -->
                        <div class="flex flex-col sm:flex-row gap-4 w-full max-w-md">
                        @if($course->Instructor->facebook)
                            <!-- Facebook Link -->
                                <a href="{{ $course->Instructor->facebook }}" target="_blank"
                                   class="flex items-center justify-start gap-2 px-4 py-3 bg-brand-primary-light rounded-lg hover:bg-opacity-80 transition-colors">
                                    <div class="w-10 h-10 flex-shrink-0 relative">
                                        <img src="{{ asset('frontend/images') }}/course-details/facebook-icon.png" alt="Facebook Icon"
                                             class="w-8 h-8 absolute top-1 left-1" style="color: #144394" />
                                    </div>

                                    <span class="font-alexandria text-sm text-colors-base-black">
                تابعني على فيسبوك
              </span>
                                </a>
                        @endif
                        @if($course->Instructor->linkedin)
                            <!-- LinkedIn Link -->
                                <a href="{{ $course->Instructor->linkedin }}" target="_blank"
                                   class="flex items-center justify-start gap-2 px-4 py-3 bg-brand-primary-light rounded-lg hover:bg-opacity-80 transition-colors">
                                    <svg width="44" height="44" viewBox="0 0 44 44" fill="none" xmlns="http://www.w3.org/2000/svg"
                                         class="w-10 h-10 flex-shrink-0">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                              d="M8.80221 6.49292C7.58642 6.49292 6.60083 7.47851 6.60083 8.6943V35.3054C6.60083 36.5212 7.58642 37.5068 8.80221 37.5068H35.4134C36.6292 37.5068 37.6148 36.5212 37.6148 35.3054V8.6943C37.6148 7.47851 36.6292 6.49292 35.4134 6.49292H8.80221ZM13.562 16.1243C15.0479 16.1243 16.2525 14.9198 16.2525 13.4339C16.2525 11.948 15.0479 10.7434 13.562 10.7434C12.0761 10.7434 10.8716 11.948 10.8716 13.4339C10.8716 14.9198 12.0761 16.1243 13.562 16.1243ZM18.7165 18.1126H23.1755V20.1553C23.1755 20.1553 24.3854 17.7353 27.6777 17.7353C30.6145 17.7353 33.0473 19.1821 33.0473 23.5918V32.8908H28.4266V24.7186C28.4266 22.1173 27.0378 21.8312 25.9795 21.8312C23.7832 21.8312 23.4072 23.7256 23.4072 25.058V32.8908H18.7165V18.1126ZM15.9074 18.1127H11.2167V32.8909H15.9074V18.1127Z"
                                              fill="#144394" />
                                    </svg>

                                    <span class="font-alexandria text-sm text-colors-base-black">
                تابعني على ليكند ان
              </span>
                                </a>
                            @endif
                        </div>
                    </div>

                    <!-- Instructor Info -->
                    <div class="w-full lg:w-3/5 flex flex-col items-start gap-6 lg:gap-8">
                        <!-- Instructor Name and Title -->
                        <div class="flex flex-col items-start gap-2 w-full text-right">
                            <h2 class="font-alexandria text-3xl md:text-4xl lg:text-5xl font-bold text-colors-base-black leading-tight">
                                {{ $course->Instructor->name }}
                            </h2>
                            <p class="font-alexandria text-lg md:text-xl text-colors-text-disabled leading-relaxed max-w-2xl"
                               style="line-height: 34px">
                                {{ $course->Instructor->title }}
                            </p>
                        </div>

                        <!-- Education Info -->
                        <div class="flex flex-col items-start gap-5 w-full">
                            {!! $course->short_description !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
    <!-- Skills and Course Modules Section -->
    <div class="bg-brand-primary-bg py-12 lg:py-16 px-4 md:px-8 lg:px-16 my-24" dir="rtl">
        <div class="max-w-7xl mx-auto">
            <div class="flex flex-col lg:flex-row items-start justify-center gap-8 lg:gap-16 xl:gap-32">
                <!-- Course Modules Section -->
                <div class="w-full lg:w-auto flex flex-col items-start gap-6">
                    <!-- Section Title -->
                    <h2 class="font-alexandria text-2xl md:text-3xl lg:text-4xl font-bold text-colors-base-black text-right"
                        style="line-height: 140%">
                        محاور الدورة التدريبية
                    </h2>

                    <!-- Features List -->
                    <div class="flex flex-col items-start gap-4">
                        {!! $course->get_from_course !!}
                    </div>
                </div>

                <!-- Skills Section -->
                <div class="w-full lg:w-auto flex flex-col items-start gap-6">
                    <!-- Section Title -->
                    <h2 class="font-alexandria text-2xl md:text-3xl lg:text-4xl font-bold text-colors-base-black text-right"
                        style="line-height: 140%">
                        مراجع مساعدة

                    </h2>

                    <!-- Features List -->
                    <div class="flex flex-col items-start gap-4">
                        {!! $course->references !!}
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Course Lectures Section -->
    <div class="bg-white py-16 lg:py-20 px-4 md:px-8 lg:px-16" dir="rtl">
        <div class="max-w-6xl mx-auto">
            <div class="flex flex-col items-center gap-[72px]">
                <!-- Section Header -->
                <div class="h-[46px] relative w-[426px]">
                    <h2
                        class="font-tajawal text-[36px] font-medium text-[#111111] text-center leading-[44px] tracking-[-0.72px]"
                    >
                        جميع محاضراتك بالدورة
                    </h2>
                </div>

                <!-- Content -->
                <div class="flex flex-col gap-9 items-start w-full">
                @foreach($course->Sections as $section)
                    <!-- Lecture {{ $loop->index+1 }} - Expanded -->
                        <div class="bg-[#f2f4f9] border border-[#f0f2f4] rounded-lg w-full">
                            <div
                                class="flex flex-col gap-4 items-end p-9 w-full overflow-hidden lecture-content @if($loop->index==0) expanded @endif"
                            >
                                <!-- Header Container -->
                                <div
                                    class="flex items-center justify-between w-full lecture-header cursor-pointer"
                                >
                                    <h3
                                        class="font-tajawal text-[20px] font-medium text-[#111111] text-right leading-[30px]"
                                    >
                                        {{ $section->name }}
                                    </h3>
                                    <div class="flex items-center justify-center">
                                        <svg
                                            class="w-6 h-6 transform scale-y-[-100%] lecture-arrow rotate-180"
                                            viewBox="0 0 24 24"
                                            fill="none"
                                            xmlns="http://www.w3.org/2000/svg"
                                        >
                                            <path
                                                d="M6 9L12 15L18 9"
                                                stroke="#111111"
                                                stroke-width="2"
                                                stroke-linecap="round"
                                                stroke-linejoin="round"
                                            />
                                        </svg>
                                    </div>
                                </div>

                                <!-- Badges -->
                                <div class="flex gap-4 items-start justify-start w-full">
                                    @if($duration=$section->Curriculums()->selectRaw("TIME_FORMAT(
            SEC_TO_TIME(
                SUM(
                    TIME_TO_SEC(
                        CASE
                            WHEN duration LIKE '%دقيقة%' THEN CONCAT('00:', LPAD(SUBSTRING_INDEX(duration, ' ', 1), 2, '0'), ':00')
                            WHEN LENGTH(duration) = 5 AND duration LIKE '__:__' THEN CONCAT('00:', duration)
                            WHEN LENGTH(duration) = 8 AND duration LIKE '__:__:__' THEN duration
                            WHEN LOCATE(':', duration) > 0 AND LENGTH(duration) = 7 THEN CONCAT(LPAD(SUBSTRING_INDEX(duration, ':', 1), 2, '0'), ':', SUBSTRING_INDEX(SUBSTRING_INDEX(duration, ':', -2), ':', 1), ':', SUBSTRING_INDEX(duration, ':', -1))
                            WHEN LOCATE(':', duration) > 0 AND LENGTH(duration) = 4 THEN CONCAT('00:0', duration)
                            ELSE CONCAT('00:', duration)
                        END
                    )
                )
            ), '%H:%i:%s'
        ) as duration")->where('type','default')->first()->duration)
                                        <div class="bg-[#dce3ef] px-2.5 py-0.5 rounded-lg">

                    <span
                        class="font-tajawal text-[14px] font-medium text-[#144394] leading-[20px]"
                    >
                      مدة المحاضرة:
                        {{ $duration }}
                    </span>

                                        </div>
                                    @endif
                                    @if($section->type!='exam')
                                    <div class="bg-[#5f43fb] px-2.5 py-0.5 rounded-lg">
                                        <span
                                            class="font-tajawal text-[14px] font-medium text-[#fff8ec] leading-[20px]"
                                        >
                                          نظري و عملي
                                        </span>
                                    </div>
                                        @endif
                                </div>


                                <!-- Divider -->
                                <div class="bg-[#e8e8e8] h-px w-full"></div>
                            @foreach($section->Curriculums as $curriculum)
                                <!-- Lecture Item {{ $loop->index+1 }} -->
                                    <div
                                        class="bg-[#e8ecf4] border border-[#f0f2f4] rounded-lg w-full"
                                    >
                                        <div class="flex flex-col gap-2.5 items-end p-4 w-full">
                                            <div class="flex items-center justify-between w-full">
                                                <div class="flex gap-2 items-center">
                                                    @if($curriculum->type=='default')
                                                        <img
                                                            src="{{ asset('frontend/images') }}/course-details/lecture-video-icon.png"
                                                            alt="Lecture Icon"
                                                            class="w-8 h-8"
                                                        />
                                                    @else
                                                        <svg width="32" height="32" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path fill="#144494" d="M512 64a448 448 0 1 1 0 896 448 448 0 0 1 0-896zm23.744 191.488c-52.096 0-92.928 14.784-123.2 44.352-30.976 29.568-45.76 70.4-45.76 122.496h80.256c0-29.568 5.632-52.8 17.6-68.992 13.376-19.712 35.2-28.864 66.176-28.864 23.936 0 42.944 6.336 56.32 19.712 12.672 13.376 19.712 31.68 19.712 54.912 0 17.6-6.336 34.496-19.008 49.984l-8.448 9.856c-45.76 40.832-73.216 70.4-82.368 89.408-9.856 19.008-14.08 42.24-14.08 68.992v9.856h80.96v-9.856c0-16.896 3.52-31.68 10.56-45.76 6.336-12.672 15.488-24.64 28.16-35.2 33.792-29.568 54.208-48.576 60.544-55.616 16.896-22.528 26.048-51.392 26.048-86.592 0-42.944-14.08-76.736-42.24-101.376-28.16-25.344-65.472-37.312-111.232-37.312zm-12.672 406.208a54.272 54.272 0 0 0-38.72 14.784 49.408 49.408 0 0 0-15.488 38.016c0 15.488 4.928 28.16 15.488 38.016A54.848 54.848 0 0 0 523.072 768c15.488 0 28.16-4.928 38.72-14.784a51.52 51.52 0 0 0 16.192-38.72 51.968 51.968 0 0 0-15.488-38.016 55.936 55.936 0 0 0-39.424-14.784z"/></svg>
                                                    @endif
                                                    <span
                                                        class="font-tajawal text-[20px] font-medium text-black text-right leading-[30px]"
                                                    >
                          {{ $curriculum->name }} {{ $curriculum->description }}
                                                        @if($curriculum->isfree=='yes')
                                                            (مشاهدة مجانا)
                                                        @endif
                        </span>
                                                </div>

                                                <div class="flex gap-[11px] items-center">
                                                    @if($curriculum->type=='default')
                                                        <a href="@if(hasCourse($course->id)||$curriculum->isfree=='yes'){{ route('course_curriculum_audio_page',['url'=>$course->url,'id'=>$curriculum->id]) }}@elseif(!auth()->check()){{ 'javascript:void(0)' }}@elseif(!hasCourse($course->id)){{ 'javascript:void(0)' }}@endif"
                                                           class="@if(hasCourse($course->id)||$curriculum->isfree=='yes'){{ 'canAccess' }}@elseif(!auth()->check()){{ 'needLogin' }}@elseif(!hasCourse($course->id)){{ 'needSubscribe' }}@endif  bg-[#dce3ef] flex gap-2 items-center justify-center p-2 rounded-md w-12 h-12"
                                                        >
                                                            <img
                                                                src="{{ asset('frontend/images') }}/course-details/sound-icon.png"
                                                                alt="Sound Icon"
                                                                class="w-6 h-6"
                                                            />
                                                        </a>

                                                        <div
                                                            class="@if(hasCourse($course->id)||$curriculum->isfree=='yes'){{ 'canAccess' }}@elseif(!auth()->check()){{ 'needLogin' }}@elseif(!hasCourse($course->id)){{ 'needSubscribe' }}@endif bg-[#dce3ef] flex gap-2 items-center justify-center p-3 rounded-md w-12 h-12"
                                                        >
                                                            <a href="@if(hasCourse($course->id)||$curriculum->isfree=='yes'){{ route('course_curriculum_video_page',['url'=>$course->url,'id'=>$curriculum->id]) }}@elseif(!auth()->check()){{ 'javascript:void(0)' }}@elseif(!hasCourse($course->id)){{ 'javascript:void(0)' }}@endif">
                                                                <img
                                                                    src="{{ asset('frontend/images') }}/course-details/cc-icon.png"
                                                                    alt="CC Icon"
                                                                    class="w-6 h-6"
                                                                />
                                                            </a>

                                                        </div>

                                                        <div
                                                            class="bg-[#dce3ef] flex gap-2 items-center px-3.5 py-3 rounded-md"
                                                        >
                                                            <img
                                                                src="{{ asset('frontend/images') }}/course-details/clock-icon.png"
                                                                alt="Clock Icon"
                                                                class="w-6 h-6"
                                                            />
                                                            <span
                                                                class="font-tajawal text-[20px] font-medium text-black text-right leading-[30px] w-[71px]"
                                                            >
                            {{ $curriculum->duration }}
                          </span>
                                                        </div>
                                                    @else
                                                        <a href="@if(!auth()->check()){{ 'javascript:void(0)' }}@elseif(!hasCourse($course->id)){{ 'javascript:void(0)' }}@elseif(hasCourse($course->id)){{ route('course_'.$curriculum->type.'_page',['url'=>$course->url,'id'=>$curriculum->id]) }}@endif"
                                                           class="@if(hasCourse($course->id)||$curriculum->isfree=='yes'){{ 'canAccess' }}@elseif(!auth()->check()){{ 'needLogin' }}@elseif(!hasCourse($course->id)){{ 'needSubscribe' }}@endif bg-[#dce3ef] flex gap-2 items-center justify-center p-2 rounded-md h-12"
                                                        >
                                                            ابدء الأن
                                                        </a>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Divider -->
                                    <div class="bg-[#e8e8e8] h-px w-full"></div>
                            @endforeach

                            @if($count=$section->Resources()->count())
                                <!-- References Section -->
                                    <div
                                        class="font-tajawal text-[20px] font-medium text-[#111111] text-right leading-[30px] w-full"
                                    >
                                        المراجع المتوفرة للمحاضرة: (
                                        {{ $count }}
                                        )
                                    </div>
                                @foreach($section->Resources as $resource)
                                    <!-- Reference File {{ $loop->index+1 }} -->
                                        <div
                                            class="bg-white border border-[#ebebeb] flex gap-1 items-center p-4 rounded-lg w-full justify-between"
                                        >
                                            <div class="flex gap-4 items-start">
                                                <div
                                                    class="flex flex-row gap-2 items-center flex-1 justify-center"
                                                >
                                                    <div
                                                        class="bg-[#e8ecf4] border-4 border-[#dce3ef] rounded-full"
                                                    >
                                                        <img
                                                            src="{{ asset('frontend/images') }}/course-details/pdf-icon.png"
                                                            alt="PDF Icon"
                                                            class="w-8 p-[2px]"
                                                        />
                                                    </div>

                                                    <div
                                                        class="flex flex-col items-start text-[14px] text-right w-full"
                                                    >
                        <span
                            class="font-inter font-medium text-[#344054] leading-[20px]"
                        >{{ $resource->name }}</span
                        >
                                                        <span
                                                            class="font-inter font-normal text-[#667085] leading-[20px]"
                                                        >{{file_exists(public_path('assets/images/'.$resource->file))?formatFilesize(filesize(public_path('assets/images/'.$resource->file))):''}}</span
                                                        >
                                                    </div>
                                                </div>
                                            </div>

                                            <div
                                                class="bg-[#f2f4f9] flex gap-[9px] items-end p-2.5 rounded-lg"
                                            >
                                                <a href="@if(hasCourse($course->id)){{ asset('assets/images/'.$resource->file) }}@elseif(!auth()->check()){{ 'javascript:void(0)' }}@elseif(!hasCourse($course->id)){{ 'javascript:void(0)' }}@endif"
                                                   class="@if(hasCourse($course->id)||$curriculum->isfree=='yes'){{ 'canAccess' }}@elseif(!auth()->check()){{ 'needLogin' }}@elseif(!hasCourse($course->id)){{ 'needSubscribe' }}@endif font-tajawal text-[14px] font-medium text-[#144394] text-right leading-[20px]"
                                                >
                                                    تحميل
                                                </a>

                                                <img
                                                    src="{{ asset('frontend/images') }}/course-details/download-icon.png"
                                                    alt="Download Icon"
                                                />
                                            </div>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>

    <!-- Course References Section -->
    @if($course->Resources()->count())
        <div class="bg-white py-16 lg:py-20 px-4 md:px-8 lg:px-16" dir="rtl">
            <div class="max-w-6xl mx-auto">
                <div class="flex flex-col items-center gap-9">
                    <!-- Section Header -->
                    @if($course->Resources()->whereHas('Section')->count())
                        <div class="flex flex-col items-center gap-6 text-center">
                            <h2 class="font-alexandria text-3xl md:text-4xl lg:text-5xl font-bold text-[#091E43] leading-tight">
                                جميع المراجع المتوفرة لهذه الدورة
                            </h2>
                            <div class="max-w-4xl">
                                <p class="font-alexandria text-base text-[#808080] leading-relaxed">
                                    تقدم لك هذه الدورة التدريبية المعلومات الأساسية والضرورية التي
                                    يحتاجها كل متعلم لفهم الموضوع من جميع الجوانب بطريقة مبسطة
                                    وشاملة.
                                </p>
                            </div>
                        </div>

                        <!-- Reference Items -->
                        <div class="w-full space-y-4 md:space-y-6">
                        @foreach($course->Resources()->whereHas('Section')->get() as $resource)
                            <!-- Reference Item 1 -->
                                <div
                                    class="flex flex-col sm:flex-row sm:items-center gap-4 sm:gap-6 p-4 sm:p-6 bg-[#F2F4F9] border border-[#F2F4F9] rounded-lg">

                                    <!-- Reference Content -->
                                    <div class="flex flex-col gap-2 flex-1 text-right order-2 sm:order-1">
                                        <h3 class="font-alexandria text-lg sm:text-xl font-medium text-[#1C1C1C]">
                                            {{ $resource->Section->name }}
                                        </h3>
                                        <a href="@if(hasCourse($course->id)){{ asset('assets/images/'.$resource->file) }}@elseif(!auth()->check()){{ 'javascript:void(0)' }}@elseif(!hasCourse($course->id)){{ 'javascript:void(0)' }}@endif"
                                           class="@if(hasCourse($course->id)){{ 'canAccess' }}@elseif(!auth()->check()){{ 'needLogin' }}@elseif(!hasCourse($course->id)){{ 'needSubscribe' }}@endif font-alexandria text-sm sm:text-lg md:text-xl text-[#144394] underline break-all hover:text-[#0F2B5C] transition-colors duration-200"
                                           target="_blank" rel="noopener noreferrer">
                                            {{ $resource->description }}
                                        </a>
                                    </div>


                                    <!-- Duration Badge -->
                                    {{--                        <div--}}
                                    {{--                            class="flex items-center justify-center sm:justify-start gap-1 px-3 sm:px-4 py-2 sm:py-3 bg-[#E8ECF4] rounded-md order-1 sm:order-2 flex-shrink-0">--}}
                                    {{--                            <img src="{{ asset('frontend/images') }}/course-details/duration-icon.svg" alt="Duration Icon" class="w-5 h-5 sm:w-6 sm:h-6" />--}}
                                    {{--                            <span class="font-alexandria text-sm sm:text-lg text-[#59595A] whitespace-nowrap">3 دقائق قراءة</span>--}}
                                    {{--                        </div>--}}
                                </div>
                            @endforeach
                        </div>
                @endif
                    @if($course->Faq()->count())
                <!-- Expandable Sections -->
                    <div class="w-full bg-[#F2F4F9] rounded-lg overflow-hidden">
                        <!-- Main Section Header -->
                        <div class="expandable-section-header bg-[#B6C5DE] p-6 cursor-pointer flex items-center justify-between"
                             onclick="toggleMainSection(this)">
                            <h3 class="font-alexandria text-lg font-medium text-[#FAFAFA]">
                                كيف ستستفيد من
                                {{ $course->name }}
                            </h3>

                            <svg class="main-chevron-icon w-6 h-6 transition-transform duration-300" style="transform: rotate(180deg)"
                                 viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M6 15.5L12 9.5L18 15.5" stroke="#144394" stroke-width="2" stroke-linecap="round"
                                      stroke-linejoin="round" />
                            </svg>
                        </div>

                        <!-- Main Section Content -->
                        <div class="main-section-content p-6 space-y-4">
                            @foreach($course->Faq as $faq)
                            <!-- Expandable Card {{ $loop->index+1 }} -->
                            <div class="expandable-card bg-[#E8ECF4] border border-[#F0F2F4] rounded-lg">
                                <div class="expandable-card-header p-6 cursor-pointer flex items-center justify-between"
                                     onclick="toggleExpandableCard(this)">
                                    <h4 class="font-alexandria text-lg text-[#1C1C1C]">
                                        {{ $faq->question }}
                                    </h4>

                                    <svg class="card-chevron-icon w-6 h-6 transition-transform duration-300" viewBox="0 0 24 25" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6 9.5L12 15.5L18 9.5" stroke="#144394" stroke-width="2" stroke-linecap="round"
                                              stroke-linejoin="round" />
                                    </svg>
                                </div>
                                <div class="expandable-card-content hidden px-6 pb-6">
                                    <div class="border-t border-[#F0F2F4] pt-4">
                                        <p class="font-alexandria text-base text-[#6B7280] leading-relaxed">
                                            {{ $faq->answer }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    @endif
    <!-- Testimonial Section -->
    {{--    <section class="testimonial-section bg-brand-primary-bg py-20 lg:py-24 px-4 md:px-8 lg:px-16 my-24" dir="rtl">--}}
    {{--        <div class="max-w-7xl mx-auto">--}}
    {{--            <div class="flex flex-col items-center gap-16">--}}
    {{--                <!-- Section Title -->--}}
    {{--                <div class="text-center">--}}
    {{--                    <h2 class="font-alexandria text-3xl md:text-4xl lg:text-5xl font-bold text-neutral-n700 leading-tight">--}}
    {{--                        عن البرنامج--}}
    {{--                    </h2>--}}
    {{--                </div>--}}

    {{--                <!-- Content Container -->--}}
    {{--                <div class="flex flex-col lg:flex-row items-center gap-16 lg:gap-20 w-full">--}}
    {{--                    <!-- Testimonial Container -->--}}
    {{--                    <div class="w-full lg:w-1/2 order-1 lg:order-1 flex flex-col items-start gap-8">--}}
    {{--                        <!-- Quote -->--}}
    {{--                        <div class="w-full max-w-2xl">--}}
    {{--                            <p--}}
    {{--                                class="font-alexandria text-xl md:text-3xl font-medium text-neutral-n700 text-right leading-[60px] tracking-[-0.48px]">--}}
    {{--                                لقد تغيرت حياتي بعد ذلك البرنامج العظيم، حصلت علي وظيفة احلامي--}}
    {{--                                اود حقا ان اشكر القائمين علي ذلك--}}
    {{--                            </p>--}}
    {{--                        </div>--}}

    {{--                        <!-- Avatar and User Info -->--}}
    {{--                        <div class="flex items-center gap-4 flex-row-reverse">--}}
    {{--                            <!-- User Info -->--}}
    {{--                            <div class="flex flex-col items-start gap-1">--}}
    {{--                                <h3 class="font-alexandria text-lg font-bold text-neutral-n700">--}}
    {{--                                    سلمى مصطفى--}}
    {{--                                </h3>--}}
    {{--                                <p class="font-alexandria text-base text-neutral-n500">--}}
    {{--                                    مصممة جرافيك--}}
    {{--                                </p>--}}

    {{--                                <!-- Star Rating -->--}}
    {{--                                <div class="flex items-center gap-1 mt-1">--}}
    {{--                                    <!-- 5 Stars -->--}}
    {{--                                    <img src="{{ asset('frontend/images') }}/course-details/star-icon.svg" alt="Star Icon"--}}
    {{--                                         class="text-yellow-400 fill-current" />--}}
    {{--                                    <img src="{{ asset('frontend/images') }}/course-details/star-icon.svg" alt="Star Icon"--}}
    {{--                                         class="text-yellow-400 fill-current" />--}}
    {{--                                    <img src="{{ asset('frontend/images') }}/course-details/star-icon.svg" alt="Star Icon"--}}
    {{--                                         class="text-yellow-400 fill-current" />--}}
    {{--                                    <img src="{{ asset('frontend/images') }}/course-details/star-icon.svg" alt="Star Icon"--}}
    {{--                                         class="text-yellow-400 fill-current" />--}}
    {{--                                    <img src="{{ asset('frontend/images') }}/course-details/star-icon.svg" alt="Star Icon"--}}
    {{--                                         class="text-yellow-400 fill-current" />--}}
    {{--                                </div>--}}
    {{--                            </div>--}}

    {{--                            <!-- Avatar -->--}}
    {{--                            <div--}}
    {{--                                class="user-avatar w-12 h-12 md:w-16 md:h-16 rounded-full bg-gradient-to-br from-gray-300 to-gray-400 overflow-hidden flex-shrink-0">--}}
    {{--                                <img src="{{ asset('frontend/images') }}/course-details/user-avatar.png" alt="سلمى مصطفى" class="w-full h-full object-cover"--}}
    {{--                                     onerror="this.style.display='none'" />--}}
    {{--                            </div>--}}
    {{--                        </div>--}}
    {{--                    </div>--}}

    {{--                    <!-- Video Container -->--}}
    {{--                    <div class="w-full lg:w-1/2 order-2 lg:order-2">--}}
    {{--                        <div class="relative w-full max-w-2xl mx-auto">--}}
    {{--                            <!-- Video Thumbnail -->--}}
    {{--                            <div class="relative aspect-video rounded-[37px] overflow-hidden bg-gray-300">--}}
    {{--                                <img src="{{ asset('frontend/images') }}/course-details/video-thumbnail.png" alt="Video Preview"--}}
    {{--                                     class="w-full h-full object-cover" />--}}

    {{--                                <!-- Play Button Overlay -->--}}
    {{--                                <button class="absolute inset-0 flex items-center justify-center group" aria-label="Play Video">--}}
    {{--                                    <!-- Play Icon -->--}}
    {{--                                    <img src="{{ asset('frontend/images') }}/course-details/play-icon.png" alt="Play Icon" class="w-12 h-12 md:w-16 md:h-16" />--}}
    {{--                                </button>--}}
    {{--                            </div>--}}
    {{--                        </div>--}}
    {{--                    </div>--}}
    {{--                </div>--}}
    {{--            </div>--}}
    {{--        </div>--}}
    {{--    </section>--}}
    @if(!auth()->check())
    <!-- CTA Section -->
    <section class="cta-section bg-[#E8ECF4] py-16 px-4 md:px-8 lg:px-16" dir="rtl">
        <div class="max-w-4xl mx-auto">
            <div class="flex flex-col items-center gap-8 text-center">
                <!-- Heading -->
                <h2 class="font-alexandria text-xl md:text-2xl lg:text-3xl font-bold text-[#1C1C1C] leading-tight max-w-2xl">
                    يمكنك الآن تنمية فريقك في اي مجال
                </h2>

                <!-- Supporting text -->
                <p class="font-alexandria text-lg md:text-xl text-[#2E2E2E] leading-relaxed max-w-xl">
                    تعلّم وتطوّر في الموارد البشرية، الإدارة، التسويق، وغيرها.
                </p>

                <!-- CTA Button -->
                <a href="{{ route('book_demo_page') }}"
                   class="flex items-center gap-3 px-6 py-3 bg-[#00B34F] border border-[#00B34F] rounded-lg text-white font-alexandria hover:bg-[#00A047] transition-colors">
                    <!-- Button Text -->
                    <span class="text-base font-medium">احجز عرضًا توضيحيًا الآن</span>

                    <!-- Arrow Icon -->
                    <svg width="24" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M8.91412 13.3431L12.8641 17.2931C13.0463 17.4817 13.1471 17.7343 13.1448 17.9965C13.1425 18.2587 13.0373 18.5095 12.8519 18.6949C12.6665 18.8803 12.4157 18.9855 12.1535 18.9878C11.8913 18.99 11.6387 18.8892 11.4501 18.7071L5.79312 13.0501C5.69994 12.9574 5.62599 12.8473 5.57553 12.7259C5.52507 12.6046 5.49909 12.4745 5.49909 12.3431C5.49909 12.2117 5.52507 12.0816 5.57553 11.9602C5.62599 11.8389 5.69994 11.7287 5.79312 11.6361L11.4501 5.97908C11.5424 5.88357 11.6527 5.80739 11.7747 5.75498C11.8967 5.70257 12.0279 5.67498 12.1607 5.67383C12.2935 5.67268 12.4252 5.69798 12.5481 5.74826C12.671 5.79854 12.7826 5.87279 12.8765 5.96669C12.9704 6.06058 13.0447 6.17223 13.0949 6.29513C13.1452 6.41802 13.1705 6.5497 13.1694 6.68248C13.1682 6.81526 13.1406 6.94648 13.0882 7.06849C13.0358 7.19049 12.9596 7.30083 12.8641 7.39308L8.91412 11.3431H18.5001C18.7653 11.3431 19.0197 11.4484 19.2072 11.636C19.3948 11.8235 19.5001 12.0779 19.5001 12.3431C19.5001 12.6083 19.3948 12.8627 19.2072 13.0502C19.0197 13.2377 18.7653 13.3431 18.5001 13.3431H8.91412Z"
                            fill="white" />
                    </svg>
                </a>
            </div>
        </div>
    </section>
    @endif
    <!-- Related Courses Section -->
    <div class="bg-white py-16 lg:py-20 px-4 md:px-8 lg:px-16" dir="rtl">
        <div class="max-w-7xl mx-auto">
            <div class="flex flex-col items-center gap-12">
                <!-- Section Title -->
                <div class="text-center space-y-4">
                    <h2 class="font-alexandria text-3xl md:text-4xl lg:text-5xl font-bold text-[#2E2E2E] leading-tight">
                        دورات لها صلة
                    </h2>
                    <p class="font-alexandria text-lg text-[#575757] leading-relaxed max-w-md">
                        اكثر من
                        {{ $coursesCount }}
                        + دورة تدريبية متاحة لجميع طلابنا
                    </p>
                </div>

                <!-- Course Cards Container -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 lg:gap-9 w-full">
                @foreach($relatedCourses as $relatedCourse)
                    <!-- Course Card {{ $loop->index+1 }} -->
                        <x-course-card :course="$relatedCourse"/>
                    @endforeach
                </div>
            </div>
        </div>
    </div>

    <!-- ============================= End Of Courses Section ============================= -->
@endsection
@push('footerScript')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        window.Toast= Swal.mixin({
            toast: true,
            position: "top-end",
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.onmouseenter = Swal.stopTimer;
                toast.onmouseleave = Swal.resumeTimer;
            }
        });
    </script>
    <!-- handel lecture lecture-expanded -->
    <script>
        @if(session('error'))
        Toast.fire({
            icon: "error",
            title: "{{ session('error') }}"
        });
        @endif
        document.querySelectorAll('.needLogin').forEach(function(el) {
            el.addEventListener('click', function(e) {
                e.preventDefault();
                Toast.fire({
                    icon: "error",
                    title: "@lang('You must login first')"
                });
            });
        });
        document.querySelectorAll('.needSubscribe').forEach(function(el) {
            el.addEventListener('click', function(e) {
                e.preventDefault();
                Toast.fire({
                    icon: "error",
                    title: "@lang('You must subscribe first')"
                });
            });
        });
        function toggleExpandableCard(el){
            const contentElement = el.parentElement.querySelector('.expandable-card-content');
            if (contentElement) {
                contentElement.classList.toggle('hidden');
            }
        }
        document.addEventListener("DOMContentLoaded", function () {
            const lectureHeaders = document.querySelectorAll(".lecture-header");

            lectureHeaders.forEach((header) => {
                header.addEventListener("click", () => {
                    const lecture = header.parentElement;
                    const arrowIcon = header.querySelector(".lecture-arrow");
                    const isExpanded = lecture.classList.contains("expanded");

                    if (isExpanded) {
                        // Collapsing - first get current height then animate to collapsed height
                        const currentHeight = lecture.scrollHeight;
                        lecture.style.height = currentHeight + "px";

                        // Force reflow
                        lecture.offsetHeight;

                        // Remove expanded class and set height to collapsed state
                        lecture.classList.remove("expanded");
                        lecture.style.height = "130px";

                        // Remove inline height after transition
                        lecture.style.height = "";
                    } else {
                        // Expanding - set height from collapsed to full content height
                        const targetHeight = lecture.scrollHeight;
                        lecture.style.height = "130px";

                        // Force reflow
                        lecture.offsetHeight;

                        // Add expanded class and set target height
                        lecture.classList.add("expanded");
                        lecture.style.height = targetHeight + "px";

                        // Remove inline height after transition to allow dynamic content
                        setTimeout(() => {
                            lecture.style.height = "";
                        }, 400);
                    }

                    // Rotate arrow icon with smooth animation
                    if (arrowIcon) {
                        arrowIcon.classList.toggle("rotate-180");
                    }
                });
            });

            // Handle lecture item clicks for navigation
            document.querySelectorAll("div").forEach((div) => {
                // Check if this div contains the specific lecture text
                const lectureTextSpan = div.querySelector("span");
                if (
                    lectureTextSpan &&
                    lectureTextSpan.textContent &&
                    lectureTextSpan.textContent.includes(
                        "المحاسبة الإداراية و اساسيتها (مشاهدة مجانا)"
                    ) &&
                    div.classList.contains("bg-[#e8ecf4]")
                ) {
                    div.style.cursor = "pointer";
                    div.addEventListener("click", function (event) {
                        // Don't trigger if clicking on control buttons (sound, cc, clock icons)
                        const clickedElement = event.target;
                        const isControlButton =
                            clickedElement.closest(".bg-\\[\\#dce3ef\\]") ||
                            clickedElement.closest('img[alt="Sound Icon"]') ||
                            clickedElement.closest('img[alt="CC Icon"]') ||
                            clickedElement.closest('img[alt="Clock Icon"]');

                        if (!isControlButton) {
                            window.location.href = "course-curriculum.html";
                        }
                    });
                }
            });
        });
    </script>
@endpush
