@extends('frontend.layouts.app')
@push('headScript')
    <!-- Tailwind Configuration -->
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        alexandria: ["Alexandria", "sans-serif"],
                        tajawal: ["Tajawal", "sans-serif"],
                    },
                    colors: {
                        "brand-success": "#00B34F",
                        "brand-secondary-normal": "#00B34F",
                        "brand-secondary-light": "#E6F7ED",
                        "brand-primary-normal": "#144394",
                        "brand-primary-light": "#E8ECF4",
                    },
                },
            },
        };
    </script>

    <style>

        body {
            font-family: "Alexandria", sans-serif;
        }

        /* Mobile Menu Styles */
        .mobile-menu {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.4s ease-in-out, opacity 0.3s ease-in-out;
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
        }

        .mobile-menu.open {
            max-height: 600px;
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        /* Ensure mobile menu is above other elements */
        .mobile-menu .bg-white\/95 {
            background-color: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
        }

        /* Mobile menu animation */
        .mobile-menu .mobile-menu-content {
            transform: translateY(-20px);
            transition: transform 0.3s ease-out;
        }

        .mobile-menu.open .mobile-menu-content {
            transform: translateY(0);
        }

        /* Mobile responsive button adjustments */
        @media (max-width: 768px) {
            .responsive-button-text {
                display: none;
            }

            .responsive-button-icon {
                margin: 0 !important;
            }
        }

        @media (max-width: 640px) {
            .hero-title-mobile {
                font-size: 2.5rem !important;
                line-height: 3rem !important;
            }
        }
    </style>
@endpush
@section('content')
    <!-- Hero Section for Search Certificate Page -->
    <div class="relative overflow-hidden min-h-[700px]">
        <!-- Background Image -->
        <div class="absolute left-0 bottom-0 z-0">
            <img
                src="{{ asset('frontend/images') }}/about-academy/hero-about-academy.png"
                alt="Background"
            />
        </div>

        <!-- Background Gradient Overlay -->
        <div class="absolute inset-0">
            <svg
                class="w-full h-full"
                viewBox="0 0 1600 808"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
                preserveAspectRatio="xMidYMid slice"
            >
                <path
                    d="M0 0H1600V808H0V0Z"
                    fill="url(#paint0_linear_gradient_overlay)"
                />
                <defs>
                    <linearGradient
                        id="paint0_linear_gradient_overlay"
                        x1="205.022"
                        y1="0"
                        x2="1573.65"
                        y2="664.405"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop offset="0%" stop-color="#0C2959" stop-opacity="0.45" />
                        <stop offset="18.28%" stop-color="#0C2959" stop-opacity="0.55" />
                        <stop offset="31.41%" stop-color="#0C2959" stop-opacity="0.62" />
                        <stop offset="49.65%" stop-color="#0C2959" stop-opacity="0.72" />
                        <stop offset="74.35%" stop-color="#0C2959" stop-opacity="0.86" />
                        <stop offset="100%" stop-color="#0C2959" />
                    </linearGradient>
                </defs>
            </svg>
        </div>

        <!-- Background Ellipses -->
        <div class="absolute -top-96 -left-96">
            <img
                src="{{ asset('frontend/images') }}/hero-background.png"
                alt="Background Ellipses"
                class="w-[1179px] h-[1101px] object-contain"
            />
        </div>

        <!-- Wave at bottom -->
        <div class="absolute bottom-0 left-0 w-full">
            <svg
                class="w-full h-52"
                viewBox="0 0 1600 202"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
                preserveAspectRatio="none"
            >
                <path
                    fill-rule="evenodd"
                    clip-rule="evenodd"
                    d="M0 79.458C0 79.458 226.389 186.741 381.052 178.06C535.714 169.378 628.364 133.594 798.309 151.486C968.253 169.378 1461.17 124.238 1600 0V209.034H0V79.458Z"
                    fill="#FDFDFF"
                />
            </svg>
        </div>
        <!-- Content Container -->
        <div
            class="relative z-10 pt-32 pb-32 px-4 md:px-8 lg:px-16 min-h-[700px] flex items-center justify-center"
        >
            <div class="max-w-4xl mx-auto text-center">
                <!-- Breadcrumb Navigation -->
                <div class="flex items-center justify-center gap-2 mb-6">
                    <div class="font-tajawal font-medium text-white text-base">
                        الرئيسية
                    </div>
                    <div class="w-6 h-6 flex items-center justify-center">
                        <svg
                            width="6"
                            height="10"
                            viewBox="0 0 6 10"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                            style="transform: rotate(180deg)"
                        >
                            <path
                                d="M1 1L5 5L1 9"
                                stroke="white"
                                stroke-width="1.5"
                                stroke-linecap="round"
                                stroke-linejoin="round"
                            />
                        </svg>
                    </div>
                    <div class="font-tajawal font-medium text-[#00B34F] text-base">
                        عن الأكاديمية
                    </div>
                </div>

                <!-- Main Title -->
                <h1
                    class="font-tajawal font-bold text-white leading-tight tracking-tight mb-4 text-4xl hero-title-mobile"
                >
                    عن الأكاديمية
                </h1>

                <!-- Subtitle -->
                <p class="font-tajawal font-medium text-[#DEDEDE] text-lg mb-8">
                    تعرف علينا اكثر و كن شريك معنا
                </p>
            </div>
        </div>
    </div>

    <!-- About Academy Section -->
    <section
        class="bg-[#FDFDFF] py-16 lg:py-20 px-4 md:px-8 lg:px-16"
        dir="rtl"
    >
        <div class="max-w-7xl mx-auto">
            <div
                class="flex flex-col lg:flex-row items-center justify-between gap-8 lg:gap-12"
            >
                <!-- Right Side - Content -->
                <div class="w-full lg:w-1/2 flex flex-col items-end text-right">
                    <div class="max-w-[732px] w-full space-y-6">
                        <!-- Main Title -->
                        <h2
                            class="font-alexandria font-semibold text-[#1C1C1C] text-3xl lg:text-4xl xl:text-[42px] leading-tight"
                        >
                            عن أكاديمية إعمل بيزنس
                        </h2>

                        <!-- Description Paragraphs -->
                        <div class="space-y-6">
                            <p
                                class="font-alexandria font-normal text-[#575757] text-lg lg:text-xl leading-relaxed"
                            >
                                بدأت أكاديمية إعمل بيزنس سنة 2013 كصفحة على الفيسبوك بإسم
                                "إعمل بيزنس" هدفها الأساسى هو تبسيط ونشر علوم إدارة البيزنس
                                لسد الفجوة الموجودة بين دراسة علوم البيزنس وتطبيقها فى العالم
                                العربى واستمرت إعمل بيزنس كفكرة مجانية تماماّ من خلال قنوات
                                السوشيال ميديا المختلفة حتى عام 2016.
                            </p>

                            <p
                                class="font-alexandria font-normal text-[#575757] text-lg lg:text-xl leading-relaxed"
                            >
                                بدأت أكاديمية إعمل بيزنس سنة 2013 كصفحة على الفيسبوك بإسم
                                "إعمل بيزنس" هدفها الأساسى هو تبسيط ونشر علوم إدارة البيزنس
                                لسد الفجوة الموجودة بين
                            </p>
                        </div>

                        <!-- Download Button -->
                        <button
                            class="flex items-center justify-between gap-3 bg-[#00B34F] hover:bg-[#00A047] text-white px-4 py-3 rounded-lg transition-colors font-alexandria font-medium text-base w-full"
                        >
                            <span class="text-right">حمل الملف التعريفي</span>
                            <svg
                                width="24"
                                height="24"
                                viewBox="0 0 24 24"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                                class="flex-shrink-0"
                            >
                                <path
                                    d="M12 15.577L8.461 12.039L9.169 11.319L11.5 13.65V5H12.5V13.65L14.83 11.32L15.539 12.039L12 15.577ZM6.616 19C6.15533 19 5.771 18.846 5.463 18.538C5.155 18.23 5.00067 17.8453 5 17.384V14.961H6V17.384C6 17.538 6.064 17.6793 6.192 17.808C6.32 17.9367 6.461 18.0007 6.615 18H17.385C17.5383 18 17.6793 17.936 17.808 17.808C17.9367 17.68 18.0007 17.5387 18 17.384V14.961H19V17.384C19 17.8447 18.846 18.229 18.538 18.537C18.23 18.845 17.8453 18.9993 17.384 19H6.616Z"
                                    fill="#FAFAFA"
                                />
                            </svg>
                        </button>
                    </div>
                </div>

                <!-- Left Side - Computer Image -->
                <div class="w-full lg:w-1/2 flex justify-center lg:justify-start">
                    <div class="relative max-w-[684px] w-full">
                        <img
                            src="{{ asset('frontend/images') }}/about-academy/about-academy-computer.png"
                            alt="أكاديمية إعمل بيزنس - الكمبيوتر"
                            class="w-full h-auto object-contain"
                            loading="lazy"
                        />
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Academy Evolution Section -->
    <section
        class="bg-[#FDFDFF] py-16 lg:py-20 px-4 md:px-8 lg:px-16"
        dir="rtl"
    >
        <div class="max-w-7xl mx-auto">
            <div
                class="flex flex-col lg:flex-row items-center justify-between gap-8 lg:gap-12"
            >
                <!-- Left Side - Businessman Image -->
                <div
                    class="relative lg:w-1/2 w-full h-[400px] sm:h-[500px] md:h-[600px] flex items-start justify-center lg:justify-start overflow-hidden"
                >
                    <!-- Layer 1: The Blue Blob (Bottom Layer). -->
                    <div class="absolute inset-0 z-10 text-blue-800">
                        <img
                            src="{{ asset('frontend/images') }}/about-academy/businessman-mobile-bg-blue.svg"
                            alt="خلفية رجل أعمال"
                            class="w-full h-auto"
                            loading="lazy"
                        />
                    </div>

                    <!-- Layer 2: The Man Image (Middle Layer). The container is now full size and masked. -->
                    <div
                        class="absolute inset-0 z-20"
                        style="
                -webkit-mask-image: url('{{ asset('frontend/images') }}/about-academy/businessman-mobile-bg-blue.svg');
                mask-image: url('{{ asset('frontend/images') }}/about-academy/businessman-mobile-bg-blue.svg');
                -webkit-mask-size: cover;
                mask-size: cover;
                -webkit-mask-repeat: no-repeat;
                -webkit-mask-position: center;
              "
                    >
                        <!-- The image itself is now inside a div that is positioned where it was before. -->
                        <div
                            class="absolute  left-1/2 -translate-x-1/2 w-[100%] h-[100%] top-[20px]"
                        >
                            <img
                                src="{{ asset('frontend/images') }}/about-academy/Mask group.png"
                                alt="رجل أعمال يستخدم الهاتف"
                                class="w-full h-full object-contain object-bottom"
                            />
                        </div>
                    </div>

                    <!-- Layer 3: The Green Star (Top Layer). -->
                    <div class="absolute top-[80px] right-[50px] z-30 text-green-500">
                        <img
                            src="{{ asset('frontend/images') }}/about-academy/star-green.svg"
                            alt="نجمة خضراء"
                            class="w-full h-full object-cover"
                            loading="lazy"
                        />
                    </div>
                </div>

                <!-- Right Side - Content -->
                <div class="w-full lg:w-1/2 flex flex-col items-end text-right">
                    <div class="max-w-[642px] w-full space-y-6">
                        <!-- Description Paragraphs -->
                        <div class="space-y-6">
                            <p
                                class="font-alexandria font-normal text-[#575757] text-lg lg:text-xl leading-relaxed"
                            >
                                فى عام 2016 استقبلنا أكتر من طلب من متابعينا بنشر فيديوهات
                                متكاملة عن علوم ادارة البيزنس ومن هنا بدأت فكرة وجود كيان علمى
                                يضم كل محتوى علمى شامل لكل راغبى دراسة البيزنس تظهر بقوة وبعد
                                كتير من المناقشات قررنا اطلاق "أكاديمية إعمل بيزنس"
                            </p>

                            <p
                                class="font-alexandria font-normal text-[#575757] text-lg lg:text-xl leading-relaxed"
                            >
                                كأول أكاديمية عربية متخصصة فى علوم ادارة البيزنس أونلاين.
                            </p>

                            <p
                                class="font-alexandria font-normal text-[#575757] text-lg lg:text-xl leading-relaxed"
                            >
                                ظهور أكاديمية إعمل بيزنس عزز وجودنا فى عالم البيزنس وسهل
                                وصولنا للكثير من راغبى العلم فى مختلف أنحاء العالم ونسعى
                                دائماَ لتغطية أكبر قدر من العلوم الخاصة بالبيزنس لدعم كل صاحب
                                مشروع، رائد أعمال وجميع راغبى دراسة البيزنس بشكل مفصل.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Our Beginning Section -->
    <section class="bg-[#F2F4F9] py-16 lg:py-20 " dir="rtl">
        <div class="">
            <div class="flex flex-col lg:flex-row items-center justify-between gap-8 lg:gap-12">

                <!-- Right Side - Content -->
                <div class="w-full lg:w-1/2 flex flex-col items-end text-right">
                    <div class="max-w-[654px] w-full space-y-6">
                        <!-- Main Title -->
                        <h2 class="font-alexandria font-bold text-[#1C1C1C] text-3xl lg:text-4xl xl:text-[40px] leading-tight">
                            بدايتتنا
                        </h2>

                        <!-- Description -->
                        <div class="space-y-6">
                            <p class="font-alexandria font-normal text-[#575757] text-lg lg:text-xl xl:text-2xl leading-relaxed xl:leading-[48px]">
                                نسعى لتوفير مجموعة شاملة من الدورات بأعلى مستويات الجودة لتقديم أفضل قيمة لشركائنا ودعم أعمالهم الأساسية وضمان نجاحهم في مسيرتهم، كما نسعى لنشر ثقافة البيزنس في أبسط صورها وإشباع رغبة كل محب لبدء عمله الخاص
                            </p>

                            <p class="font-alexandria font-normal text-[#575757] text-lg lg:text-xl xl:text-2xl leading-relaxed xl:leading-[48px]">
                                سواء كان صاحب مشروع صغير أو متوسط في التعلم والتطوير المستمر لقدراته ومهاراته من خلال ما نقدمه من موضوعات مختلفة إيماناً بدورنا في المجتمع من خلال تقديم دورات أونلاين متخصصة في علوم الإدارة المختلفة.
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Left Side - Decorative Shape and Image -->
                <div class="relative w-full lg:w-1/2 flex justify-center lg:justify-end">
                    <div class="relative w-full max-w-[732px] h-[400px] sm:h-[500px] md:h-[649px]">
                        <!-- Blue Decorative Shape -->
                        <div class="absolute left-0 top-1/2 -translate-y-1/2 z-10">
                            <svg
                                width="453"
                                height="625"
                                viewBox="0 0 453 625"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                                class="w-[300px] h-[400px] sm:w-[400px] sm:h-[500px] md:w-[453px] md:h-[625px]"
                            >
                                <path
                                    d="M104.431 9.78428C126.898 -2.53919 154.102 -2.53917 176.569 9.7843L242.156 45.7598C246.939 48.3835 251.995 50.4774 257.232 52.0045L329.048 72.9431C353.648 80.1157 372.884 99.3517 380.057 123.952L400.995 195.768C402.523 201.005 404.617 206.061 407.24 210.844L443.216 276.431C455.539 298.898 455.539 326.102 443.216 348.569L407.24 414.156C404.617 418.939 402.523 423.995 400.995 429.232L380.057 501.048C372.884 525.648 353.648 544.884 329.048 552.057L257.232 572.995C251.995 574.523 246.939 576.617 242.156 579.24L176.569 615.216C154.102 627.539 126.898 627.539 104.431 615.216L38.8439 579.24C34.0606 576.617 29.0054 574.523 23.768 572.995L-48.0478 552.057C-72.6484 544.884 -91.8843 525.648 -99.0569 501.048L-119.996 429.232C-121.523 423.995 -123.616 418.939 -126.24 414.156L-162.216 348.569C-174.539 326.102 -174.539 298.898 -162.216 276.431L-126.24 210.844C-123.616 206.061 -121.523 201.005 -119.996 195.768L-99.0569 123.952C-91.8843 99.3516 -72.6483 80.1157 -48.0478 72.9431L23.768 52.0045C29.0054 50.4774 34.0606 48.3835 38.8439 45.7598L104.431 9.78428Z"
                                    fill="#144394"
                                />
                            </svg>
                        </div>

                        <!-- Man with Laptop Image -->
                        <div class="absolute right-0 top-1/2 -translate-y-1/2 z-20">
                            <img
                                src="{{ asset('frontend/images') }}/about-academy/man-with-laptop.png"
                                alt="رجل يعمل على الكمبيوتر المحمول"
                                class="w-[350px] h-[350px] sm:w-[450px] sm:h-[450px] md:w-[550px] md:h-[550px] lg:w-[732px] lg:h-[649px] object-contain"
                                loading="lazy"
                            />
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </section>

    <!-- Our Trainers Section -->
    <section class="bg-[#FDFDFF] py-16 lg:py-20 px-4 md:px-8 lg:px-16" dir="rtl">
        <div class="max-w-7xl mx-auto">
            <!-- Section Title -->
            <h2 class="font-alexandria font-bold text-[#000000] text-3xl lg:text-4xl xl:text-[40px] leading-tight text-center mb-6">
                بعض المدربين لدينا
            </h2>

            <!-- Trainers Grid -->
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mt-12">
                @foreach($instructors as $instructor)
                <!-- Trainer Card {{ $loop->index+1 }} -->
                <div class="trainer-card overflow-hidden">
                    <div
                        class="trainer-image-container aspect-[352/377] relative bg-[#F2F4F9] rounded-lg border border-[#D0D5DD]"
                    >
                        <img
                            src="{{ asset('assets/images/'.$instructor->pic) }}"
                            alt="{{ $instructor->name }}"
                            class="w-full h-full object-cover mt-2"
                            loading="lazy"
                        />
                    </div>
                    <div class="trainer-info py-2 px-1 text-right">
                        <div class="trainer-details mb-4">
                            <h3
                                class="trainer-name font-alexandria font-bold text-[#000000] text-lg mb-2"
                            >
                                {{ $instructor->name }}
                            </h3>
                            <p
                                class="trainer-title font-alexandria font-normal text-[#144394] text-base mb-4"
                            >
                                {{ $instructor->title }}
                            </p>
                        </div>
                        <p
                            class="trainer-description font-alexandria font-normal text-[#667085] text-sm leading-relaxed mb-4"
                        >
                            {{ $instructor->short_description }}
                        </p>
                        <div class="social-icons flex items-center gap-5 justify-start">
                            @if($instructor->linkedin)
                            <a href="{{ $instructor->linkedin }}" target="_blank" class="social-link">
                                <img src="{{ asset('frontend/images') }}/linkedin-icon.svg" alt="LinkedIn" />
                            </a>
                            @endif
                                @if($instructor->facebook)
                            <a href="{{ $instructor->facebook }}" target="_blank" class="social-link">
                                <img src="{{ asset('frontend/images') }}/facebook-icon.svg" alt="Facebook" />
                            </a>
                                    @endif
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </section>
@endsection
@push('footerScript')
@endpush
