<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Course extends Model
{
    //
    use SoftDeletes;
    public $timestamps=false;
    protected $guarded=['id'];
    public function Instructor(){
        return $this->belongsTo(Instructor::class,'instractor');
    }
    public function  Sections(){
        return $this->hasMany(CourseSection::class,'course_id')->where('published','yes');
    }
    public function Curriculums(){
        return $this->hasMany(CourseCurriculum::class,'course_id')->where('published','yes');
    }
    public function Resources(){
        return $this->hasMany(CourseResource::class,'course_id')->where('published','yes');
    }
    public function Category(){
        return $this->hasOneThrough(Category::class,CoursesCategories::class,'course_id','id','id','category_id');
    }
    public function Tags(){
        return $this->hasManyThrough(CourseTag::class,CoursesTags::class,'course_id','id','id','course_tag_id');
    }

    public function Comments(){
        return $this->hasMany(CourseComment::class,'course_id');
    }
    public function Faq(){
        return  $this->hasMany(ProductsFaq::class,'product_id')->where('product','courses')->where('published','yes')->orderBy('sort','ASC');
    }
}
