<?php

namespace App\Http\Middleware;

use App\Models\SessionUser;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class FrontendMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if(auth()->check()){
           if(!$request->cookies->get(config('app.SESSION_COOKIE_NAME'))){
               $sessionUser=SessionUser::create([
                   'user_id'=>auth()->id(),
                   'ip_address'=>$request->ip(),
                   'information'=>$request->userAgent(),
                   'createdtime'=>now(),
               ]);
               $request->cookies->set(config('app.SESSION_COOKIE_NAME'),$sessionUser->id);
           }

        }
        return $next($request);
    }
}
