<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Country;
use App\Models\User;
use Illuminate\Http\Request;

class RegisterPageController extends Controller
{
    //
    public function bookDemo(){
        if(auth()->check()){
            return redirect()->route('home_page');
        }
        $countries=\App\Models\Country::select('iso','name')->orderBy('sort')->get();
        return view('frontend.book_demo',compact('countries'));
    }
    public function index(){
        if(auth()->check()){
            return redirect()->route('home_page');
        }
        return view('frontend.register');
    }
    public function save(Request $request){
        $array=[
            'name'=>'required',
            'email'=>'required|email',
            'phone'=>'required|min:6',
        ];
        if($request->type=='book-demo'){
            $array['company']='required';
        }
        $request->validate($array);
        $user=User::where('Email',$request->email)->first();
        if($user){
            return response()->json(['success'=>false,'message'=>__('This email is already taken')]);
        }
        $user=User::where('Mobile',$request->phone)->first();
        if($user){
            return response()->json(['success'=>false,'message'=>__('This phone is already taken')]);
        }
        $country=Country::where('iso',$request->country)->first();
        $user=User::create([
            'FullName'=>$request->name,
            'Email'=>$request->email,
            'Mobile'=>$request->phone,
            'country'=>$country->id,
            'RegisterDate'=>now(),
            'RegisterIP'=>$request->ip(),
            'duplicateIP'=>User::where('RegisterIP',$request->ip())->count()?1:0,
            'RegisterReferrer'=>$request->headers->get('referer'),
            'leadsource'=>$request->type=='book-demo'?'website-book-demo':'website-register',
            'utm_campaign'=>$request->utm_campaign,
            'utm_medium'=>$request->utm_medium,
            'utm_source'=>$request->utm_source,
            'company'=>$request->company,
            'message'=>$request->categories?implode(',',$request->categories):null,
        ]);
        $this->transferDataToCrm($user);
        return response()->json(['success'=>true,'message'=>$request->type=='book-demo'?__('Your request sent successfully'):__('You have register successfully')]);
    }
    public function transferDataToCrm($user){
        $data=[
            'id' => $user->id,
            'name' => $user->FullName,
            'email' => $user->Email,
            'phone' => $user->Mobile,
            'linkedin' => $user->linkedin,
            'facebook' => $user->facebook,
            'registerdate' => $user->RegisterDate,
            'register_link' => urlencode($user->RegisterReferrer),
            'country' => $user->countryname,
            'countrycode' => $user->country,
            'registerip' => $user->RegisterIP,
            'affiliat_reseller_id' => $user->affiliat_reseller_id,
            'affiliat_product_id' => $user->affiliat_product_id,
            'affiliat_user_id' => $user->id,
            'sponsorId' => $user->sponsorId,
            'leadsource' => $user->leadsource,
        ];
        //        //$url = "http://crmegy.e3melbusiness.com/webservice/new_lead.php";
//
//        if ($data['countrycode'] == '64') {
//            $url = "http://crmegy.e3melbusiness.com/webservice/new_lead.php";
//        } else {
//            $url = "http://ksanew.almoasherbiz.com/webservice/new_lead.php";
//        }
//        //print_r($data);
//        //echo $url;die();
//        /*  if ( self::lastrotate()=='ksa')
//         {
//                 $url = "http://ksanew.almoasherbiz.com/webservice/new_lead.php";
//         }else
//         {
//            $url = "http://crmegy.e3melbusiness.com/webservice/new_lead.php";
//         }*/
//        //echo $url;echo self::ip_info2();
//        $content = "";
//        foreach ($data as $key => $value) {
//            $content .= $key . '=' . $value . '&';
//        }
//        //echo $content;
//        $curl = curl_init($url);
//        curl_setopt($curl, CURLOPT_HEADER, false);
//        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
//        curl_setopt($curl, CURLOPT_POST, true);
//        curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
//        $json_response = curl_exec($curl);
//        //echo $json_response;
//        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
//        curl_close($curl);
//        //echo $url;
//        //echo $status;
    }
}
