<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class LoginPageController extends Controller
{
    //
    public function index(){
        if(auth()->check()){
            return redirect()->route('home_page');
        }
        return view('frontend.login');
    }
    public function login(Request $request){
        $request->validate([
            'email'=>'required',
            'password'=>'required',
        ]);
        $key   = 'login_attempts_' .$request->ip();
        // لو فيه block
        if (Cache::has($key . '_blocked_until')) {
            $blockedUntil = Cache::get($key . '_blocked_until');

            if (Carbon::now()->lessThan($blockedUntil)) {
                return response()->json(['success'=>false,'message'=>__('Too many login attempts. Try again after :time',['time'=>$blockedUntil->diffForHumans(),])]);
            } else {
                // مسح الحظر بعد انتهاء المدة
                Cache::forget($key);
                Cache::forget($key . '_blocked_until');
            }
        }
        $user=User::where($request->only('email','password'))->first();
        if($user){
            // نجاح → إعادة تعيين المحاولات
            Cache::forget($key);
            auth()->login($user);
            return response()->json(['success'=>true,'message'=>__('Login successfully'),'redirect'=>route('home_page')]);
        }
        // فشل → زيادة العدّاد
        $attempts = Cache::get($key, 0) + 1;
        Cache::put($key, $attempts, now()->addMinutes(10)); // تخزين 10 دقائق

        if ($attempts >= 10) {
            // بلوك 5 دقائق
            Cache::put($key . '_blocked_until', Carbon::now()->addMinutes(10), now()->addMinutes(10));
            return response()->json(['success'=>false,'message'=>__('Too many login attempts. Please try again after 10 minutes.')]);
        }
        return response()->json(['success'=>false,'message'=>__('Invalid credentials. Attempt :attempts of 10.',['attempts'=>$attempts])]);
    }
}
