<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Course;
use Illuminate\Http\Request;

class HomePageController extends Controller
{
    //
    public function index(){
        $categories=Category::select('id','name','description','badge','badge_class','url','icon')->where('published','yes')->orderBy('sort','ASC')->get();
        $courses=Course::where('published','yes')->take(4)->orderBy('id','DESC')->get();
        $countries=\App\Models\Country::select('iso','name')->orderBy('sort')->get();
        return view('frontend.index',compact('categories','courses','countries'));
    }
}
