<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Course;
use App\Models\CourseComment;
use App\Models\CourseCurriculum;
use App\Models\CourseQuestion;
use App\Models\CoursesCurriculumCertificate;
use App\Models\CurriculumQuestion;
use App\Models\FuturexIntegrationCourse;
use App\Models\FuturexTag;
use App\Models\Instructor;
use App\Models\UsersCoursesVideo;
use App\Models\UsersCourseViewCompleted;
use App\Models\UsersCurriculumAnswer;
use App\Models\UsersCurriculumQuestion;
use App\Models\UsersCurriculumQuestionsDetail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CoursesPageController extends Controller
{
    //
    public function index(){
        $categories=Category::where('published','yes')->get();
        $instructors=Instructor::where('published','yes')->get();
        $courses=Course::where('published','yes')
            ->when(request('search'),function($q){
               $q
                   ->where('name','LIKE','%'.request('search').'%')
                   ->orWhere('short_description','LIKE','%'.request('search').'%')
                   ->orWhere('description','LIKE','%'.request('search').'%')
                   ->orWhere('references','LIKE','%'.request('search').'%')
                   ->orWhere('requirements','LIKE','%'.request('search').'%')
                   ->orWhere('get_from_course','LIKE','%'.request('search').'%')
                   ->orWhere('target_audience','LIKE','%'.request('search').'%')
                   ->orWhereHas('Category',function($q){
                       $q->where('name','LIKE','%'.request('search').'%')
                           ->orWhere('short_description','LIKE','%'.request('search').'%')
                           ->orWhere('description','LIKE','%'.request('search').'%')
                           ;
                   })
                   ->orWhereHas('Instructor',function($q){
                       $q->where('name','LIKE','%'.request('search').'%')
                           ->orWhere('title','LIKE','%'.request('search').'%')
                           ->orWhere('short_description','LIKE','%'.request('search').'%')
                           ->orWhere('description','LIKE','%'.request('search').'%')
                           ;
                   })
               ;
            })
            ->when(request('categories'),function($q){
                $q->whereHas('Category',function($q){
                    $q->whereIn('url',request('categories'));
                });
            })
            ->when(request('instructors'),function($q){
                $q->whereHas('Instructor',function($q){
                    $q->whereIn('url',request('instructors'));
                });
            })
            ->paginate(8);
        $coursesCount=Course::where('published','yes')->count();
        return view('frontend.courses',compact('courses','categories','instructors','coursesCount'));
    }
    public function search(Request $request){

        $courses=Course::where('published','yes')
            ->when(request('search'),function($q){
               $q
                   ->where('name','LIKE','%'.request('search').'%')
                   ->orWhere('short_description','LIKE','%'.request('search').'%')
                   ->orWhere('description','LIKE','%'.request('search').'%')
                   ->orWhere('references','LIKE','%'.request('search').'%')
                   ->orWhere('requirements','LIKE','%'.request('search').'%')
                   ->orWhere('get_from_course','LIKE','%'.request('search').'%')
                   ->orWhere('target_audience','LIKE','%'.request('search').'%')
                   ->orWhereHas('Category',function($q){
                       $q->where('name','LIKE','%'.request('search').'%')
                           ->orWhere('short_description','LIKE','%'.request('search').'%')
                           ->orWhere('description','LIKE','%'.request('search').'%')
                           ;
                   })
                   ->orWhereHas('Instructor',function($q){
                       $q->where('name','LIKE','%'.request('search').'%')
                           ->orWhere('title','LIKE','%'.request('search').'%')
                           ->orWhere('short_description','LIKE','%'.request('search').'%')
                           ->orWhere('description','LIKE','%'.request('search').'%')
                           ;
                   })
               ;
            })
            ->when(request('categories'),function($q){
                $q->whereHas('Category',function($q){
                    $q->whereIn('url',request('categories'));
                });
            })
            ->when(request('instructors'),function($q){
                $q->whereHas('Instructor',function($q){
                    $q->whereIn('url',request('instructors'));
                });
            });
        if($request->searchData){
            $coursesCount=clone $courses;
            $coursesCount=$coursesCount->count();
            $courses=$courses->take(20)->get();
            return response()->json(['success'=>true,'html'=>view('frontend.include.search_courses',compact('courses'))->render(),'count'=>$coursesCount]);
        }
        $courses=$courses    ->paginate(8);
        $coursesCount=Course::where('published','yes')->count();
        return view('frontend.search',compact('courses','coursesCount'));
    }
    public function single($url){
        $course=Course::where('published','yes')->where('url',$url)->firstOrFail();
        $relatedCourses=Course::where('id','!=',$course->id)->whereHas('Tags',function($q)use($course){
           $q->whereIn('course_tags.id',$course->Tags()->pluck('course_tags.id')->toArray());
        });
        $coursesCount=Course::where('published','yes')->count();
        $relatedCourses=$relatedCourses->take(3)->get();
//        dd($course);
//        dd(getEloquentSqlWithBindings($course->Category()));

//        $tags=[];
//        $skills=[];
//        $futcherxIntegrationCourse=FuturexIntegrationCourse::where('course_id',$course->id)->first();
//        if($futcherxIntegrationCourse){
//            $tags=FuturexTag::whereIn('id',$futcherxIntegrationCourse->futurex_tags_ids)->pluck('name')->toArray();
//            $skills=FuturexTag::whereIn('id',$futcherxIntegrationCourse->futurex_skills_ids)->pluck('name')->toArray();
//        }
//        $allTagsSkills=array_merge($tags,$skills);
        return view('frontend.course',compact('course','relatedCourses','coursesCount'));
    }
    public function singleCurriculum($url,$id){
        $course=Course::where('published','yes')->where('url',$url)->firstOrFail();
        $currentCurriculum=CourseCurriculum::where('course_id',$course->id)->where('type','default')->findOrFail($id);
        if($currentCurriculum->isfree!='yes'){
            if(!auth()->check()){
                return redirect()->route('course_page',$course->url)->with('error',__('You must login first'));
            }
            if(!hasCourse($course->id)){
                return redirect()->route('course_page',$course->url)->with('error',__('You must subscribe first'));
            }
        }
        $userCourseVideo=null;
        $percentage=0;
        if(auth()->check()){
            $array=['user_id'=>auth()->id(),'course_id'=>$course->id];
            $completed=UsersCourseViewCompleted::where($array)->first();
            if($completed){
                $percentage=($completed->completed/$completed->total)*100;
            }
            $userCourseVideo=UsersCoursesVideo::where($array)->first();
        }
        return  view('frontend.curriculum',compact('course','currentCurriculum','percentage','userCourseVideo'));
    }
    public function saveProgress(Request $request){
        if(auth()->check()){
            $user_id=auth()->id();
            $dataCookies = $request->json('dataCookies');
            foreach ($dataCookies as $key=>$item){
                if(str_contains($key,'curriculum_id')){
                    $array=[
                        'user_id'=>$user_id,
                        'course_id'=>$item['course_id'],
                        'type'=>'curriculum',
                        'type_id'=>$item['id'],
                    ];
                    $createUpdateData=[
                        'session_user_id'=>$request->cookies->get(config('app.SESSION_COOKIE_NAME')),
                        'video_time'=>$item['video_time'],
                        'current_time'=>$item['current_time'],
                        'max_time'=>$item['max_time'],
                        'completed'=>$item['completed'],
                    ];
                    $userCourseVideo=UsersCoursesVideo::where($array)->first();
                    if(!$userCourseVideo){
                        if($createUpdateData['completed']){
                            $createUpdateData['completed_date']=now();
                        }
                        $userCourseVideo=UsersCoursesVideo::create(array_merge($array,$createUpdateData,['created_date'=>now()]));
                    }else{
                        if($userCourseVideo->completed==0&&$createUpdateData['completed']){
                            $createUpdateData['completed_date']=now();
                        }
                        $userCourseVideo->update(array_merge($createUpdateData,['lastupdated_date'=>now()]));
                    }
                }
            }
        }

    }
    public function saveComment($url,Request $request){
        if(!auth()->check()){
            return  abort(404);
        }
        $course=Course::where('published','yes')->where('url',$url)->firstOrFail();
        CourseComment::create([
            'user_id'=>auth()->id(),
            'course_id'=>$course->id,
            'comment'=>$request->comment,
        ]);
        return response()->json(['success'=>true,'message'=>__('Comment added successfully'),'html'=>view('frontend.include.course_comments',compact('course'))->render()]);
    }

    public function getCurriculums($url,Request $request){
        $course=Course::where('published','yes')->where('url',$url)->firstOrFail();
        $html='<option value="">اختر اسم الفيديو</option>';
        foreach ($course->Curriculums()->where('section_id',$request->section_id??$request->json('section_id'))->select('id',DB::raw("CONCAT(name,' ',description) AS name"))->pluck('name','id')->toArray() as $id=>$name){
            $html.='<option value="'.$id.'">'.$name.'</option>';
        }
        return response()->json(['success'=>true,'html'=>$html]);
    }
    public function saveQuestion($url,Request $request){
        if(!auth()->check()){
            return  abort(404);
        }
        $course=Course::where('published','yes')->where('url',$url)->firstOrFail();
        CourseQuestion::create([
            'user_id'=>auth()->id(),
            'course_id'=>$course->id,
            'curriculum_id'=>$request->curriculum_id,
            'section_id'=>$request->section_id,
            'question'=>$request->question,
            'createdtime'=>now(),
        ]);
        return response()->json(['success'=>true,'message'=>__('Question added successfully'),'html'=>view('frontend.include.course_comments',compact('course'))->render()]);
    }


    public function singleTraining($url,$id){

        $course=Course::where('published','yes')->where('url',$url)->firstOrFail();
        $currentCurriculum=CourseCurriculum::where('course_id',$course->id)->where('type','training')->findOrFail($id);
        if(!auth()->check()){
            return redirect()->route('course_page',$course->url)->with('error',__('You must login first'));
        }
        if(!hasCourse($course->id)){
            return redirect()->route('course_page',$course->url)->with('error',__('You must subscribe first'));
        }
        $questions=CurriculumQuestion::where('curriculum_id',$currentCurriculum->id)->take($currentCurriculum->questions_numbers)->inRandomOrder()->get();
        return  view('frontend.training',compact('course','currentCurriculum','questions'));
    }
    public function endTraining($url,$id,Request $request){
        $course=Course::where('published','yes')->where('url',$url)->firstOrFail();
        $courseCurriculum=CourseCurriculum::where('course_id',$course->id)->where('type','training')->findOrFail($id);
        if(!auth()->check()){
            return redirect()->route('course_page',$course->url)->with('error',__('You must login first'));
        }
        if(!hasCourse($course->id)){
            return redirect()->route('course_page',$course->url)->with('error',__('You must subscribe first'));
        }
        $writeAnswers=0;
        $wrongAnswers=0;
        $userCourseCurriculumAnswerQuestionsCreate=[];
        foreach ($request->questions as $question_id=>$answer){
            $courseCurriculumQuestion=CurriculumQuestion::where('curriculum_id',$courseCurriculum->id)->find($question_id);
            if(!$courseCurriculumQuestion){
                return response()->json(['success'=>false,'message'=>__('Question not found')]);
            }
            $isWriteAnswer=false;
            if($courseCurriculumQuestion->type=='chose_multiple'){
                $ids=$courseCurriculumQuestion->Details()->where('answer',1)->pluck('id')->toArray();
                sort($ids);sort($answer);
                if($ids==$answer) {
                    $isWriteAnswer=true;
                    $writeAnswers++;
                }else{
                    $wrongAnswers++;
                }
            }elseif($courseCurriculumQuestion->type=='chose_single'){
                if($answer==$courseCurriculumQuestion->Details()->where('answer',1)->first()->id){
                    $isWriteAnswer=true;
                    $writeAnswers++;
                }else{
                    $wrongAnswers++;
                }
            }elseif($courseCurriculumQuestion->type=='true_false'){
                if($courseCurriculumQuestion->Details->answer==$answer){
                    $isWriteAnswer=true;
                    $writeAnswers++;
                }else{
                    $wrongAnswers++;
                }
            }

            $userCourseCurriculumAnswerQuestionDetailsCreate=[];
            if($courseCurriculumQuestion->type=='true_false'){
                $detail=$courseCurriculumQuestion->Details;
                $user_answer=0;
                if($courseCurriculumQuestion->type=='true_false'){
                    $user_answer=$answer;
                }
                $userCourseCurriculumAnswerQuestionDetailsCreate[]=[
                    'user_quetion_id'=>0,
                    'questions_detail_id'=>$detail->id,
                    'name'=>$detail->name,
                    'answer'=>$detail->answer??0,
                    'user_answer'=>$user_answer,
                    'createdtime'=>now(),
                ];
            }else{
                foreach ($courseCurriculumQuestion->Details as $detail){
                    $user_answer=0;
                    if($courseCurriculumQuestion->type=='chose_single'){
                        if($answer==$detail->id){
                            $user_answer=1;
                        }
                    }
                    if($courseCurriculumQuestion->type=='chose_multiple'){
                        if(in_array($detail->id,$answer)){
                            $user_answer=1;
                        }
                    }
                    $userCourseCurriculumAnswerQuestionDetailsCreate[]=[
                        'user_quetion_id'=>0,
                        'questions_detail_id'=>$detail->id,
                        'name'=>$detail->name,
                        'answer'=>$detail->answer??0,
                        'user_answer'=>$user_answer,
                        'createdtime'=>now(),
                    ];
                }
            }
            $userCourseCurriculumAnswerQuestionsCreate[]=[
                'answer_id'=>0,
                'curriculum_id'=>$courseCurriculum->id,
                'question_id'=>$courseCurriculumQuestion->id,
                'type'=>$courseCurriculumQuestion->type,
                'name'=>$courseCurriculumQuestion->name,
                'answer'=>$isWriteAnswer?1:0,
                'details'=>$userCourseCurriculumAnswerQuestionDetailsCreate,
                'createdtime'=>now(),
                'modifiedtime'=>now(),
            ];

        }
        $userCourseCurriculumAnswerDataCreate=[
            'user_id'=>auth()->id(),
            'session_user_id'=>$request->cookies->get(config('app.SESSION_COOKIE_NAME')),
            'curriculum_id'=>$courseCurriculum->id,
            'curriculum_type'=>$courseCurriculum->type,
            'questions_count'=>$courseCurriculum->questions_count,
            'quetions_numbers'=>$courseCurriculum->questions_numbers,
            'question_time'=>$courseCurriculum->question_time,
            'right_answers'=>$writeAnswers,
            'wrong_answers'=>$wrongAnswers,
            'duration_time'=>$request->duration_time??'',
            'createdtime'=>now(),
            'added_date'=>now(),
            'course_id'=>$course->id,
            'ref'=>'website',
            'data_sent_json'=>$request->questions,
        ];
        $userCourseCurriculumAnswer=UsersCurriculumAnswer::create($userCourseCurriculumAnswerDataCreate);
        foreach ($userCourseCurriculumAnswerQuestionsCreate as $create){
            $create['answer_id']=$userCourseCurriculumAnswer->id;
            $userCourseCurriculumAnswerQuestion=UsersCurriculumQuestion::create($create);
            foreach ($create['details'] as $dCreate){
                $dCreate['user_quetion_id']=$userCourseCurriculumAnswerQuestion->id;
                UsersCurriculumQuestionsDetail::create($dCreate);
            }
        }
        return response()->json(['success'=>true,'message'=>__('Your training ended successfully'),
            'redirect'=>route('course_training_result_page',['url'=>$course->url,'id'=>$courseCurriculum->id,'resultId'=>$userCourseCurriculumAnswer->id])
        ]);
    }
    public function singleTrainingResult($url,$id,$resultId){
        $course=Course::where('published','yes')->where('url',$url)->firstOrFail();
        $courseCurriculum=CourseCurriculum::where('course_id',$course->id)->where('type','training')->findOrFail($id);
        if(!auth()->check()){
            return redirect()->route('course_page',$course->url)->with('error',__('You must login first'));
        }
        if(!hasCourse($course->id)){
            return redirect()->route('course_page',$course->url)->with('error',__('You must subscribe first'));
        }
        $userCourseCurriculumAnswer=UsersCurriculumAnswer::where('curriculum_id',$courseCurriculum->id)->findOrFail($resultId);
        return view('frontend.training_result',compact('course','courseCurriculum','userCourseCurriculumAnswer'));
    }



    public function singleExam($url,$id){

        $course=Course::where('published','yes')->where('url',$url)->firstOrFail();
        $currentCurriculum=CourseCurriculum::where('course_id',$course->id)->where('type','exam')->findOrFail($id);
        if(!auth()->check()){
            return redirect()->route('course_page',$course->url)->with('error',__('You must login first'));
        }
        if(!hasCourse($course->id)){
            return redirect()->route('course_page',$course->url)->with('error',__('You must subscribe first'));
        }
        $questions=CurriculumQuestion::where('curriculum_id',$currentCurriculum->id)->take($currentCurriculum->questions_numbers)->inRandomOrder()->get();
        return  view('frontend.exam',compact('course','currentCurriculum','questions'));
    }
    public function endExam($url,$id,Request $request){
        $course=Course::where('published','yes')->where('url',$url)->firstOrFail();
        $courseCurriculum=CourseCurriculum::where('course_id',$course->id)->where('type','exam')->findOrFail($id);
        if(!auth()->check()){
            return redirect()->route('course_page',$course->url)->with('error',__('You must login first'));
        }
        if(!hasCourse($course->id)){
            return redirect()->route('course_page',$course->url)->with('error',__('You must subscribe first'));
        }
        $writeAnswers=0;
        $wrongAnswers=0;
        $userCourseCurriculumAnswerQuestionsCreate=[];
        foreach ($request->questions as $question_id=>$answer){
            $courseCurriculumQuestion=CurriculumQuestion::where('curriculum_id',$courseCurriculum->id)->find($question_id);
            if(!$courseCurriculumQuestion){
                return response()->json(['success'=>false,'message'=>__('Question not found')]);
            }
            $isWriteAnswer=false;
            if($courseCurriculumQuestion->type=='chose_multiple'){
                $ids=$courseCurriculumQuestion->Details()->where('answer',1)->pluck('id')->toArray();
                sort($ids);sort($answer);
                if($ids==$answer) {
                    $isWriteAnswer=true;
                    $writeAnswers++;
                }else{
                    $wrongAnswers++;
                }
            }elseif($courseCurriculumQuestion->type=='chose_single'){
                if($answer==$courseCurriculumQuestion->Details()->where('answer',1)->first()->id){
                    $isWriteAnswer=true;
                    $writeAnswers++;
                }else{
                    $wrongAnswers++;
                }
            }elseif($courseCurriculumQuestion->type=='true_false'){
                if($courseCurriculumQuestion->Details->answer==$answer){
                    $isWriteAnswer=true;
                    $writeAnswers++;
                }else{
                    $wrongAnswers++;
                }
            }

            $userCourseCurriculumAnswerQuestionDetailsCreate=[];
            if($courseCurriculumQuestion->type=='true_false'){
                $detail=$courseCurriculumQuestion->Details;
                $user_answer=0;
                if($courseCurriculumQuestion->type=='true_false'){
                    $user_answer=$answer;
                }
                $userCourseCurriculumAnswerQuestionDetailsCreate[]=[
                    'user_quetion_id'=>0,
                    'questions_detail_id'=>$detail->id,
                    'name'=>$detail->name,
                    'answer'=>$detail->answer??0,
                    'user_answer'=>$user_answer,
                    'createdtime'=>now(),
                ];
            }else{
                foreach ($courseCurriculumQuestion->Details as $detail){
                    $user_answer=0;
                    if($courseCurriculumQuestion->type=='chose_single'){
                        if($answer==$detail->id){
                            $user_answer=1;
                        }
                    }
                    if($courseCurriculumQuestion->type=='chose_multiple'){
                        if(in_array($detail->id,$answer)){
                            $user_answer=1;
                        }
                    }
                    $userCourseCurriculumAnswerQuestionDetailsCreate[]=[
                        'user_quetion_id'=>0,
                        'questions_detail_id'=>$detail->id,
                        'name'=>$detail->name,
                        'answer'=>$detail->answer??0,
                        'user_answer'=>$user_answer,
                        'createdtime'=>now(),
                    ];
                }
            }
            $userCourseCurriculumAnswerQuestionsCreate[]=[
                'answer_id'=>0,
                'curriculum_id'=>$courseCurriculum->id,
                'question_id'=>$courseCurriculumQuestion->id,
                'type'=>$courseCurriculumQuestion->type,
                'name'=>$courseCurriculumQuestion->name,
                'answer'=>$isWriteAnswer?1:0,
                'details'=>$userCourseCurriculumAnswerQuestionDetailsCreate,
                'createdtime'=>now(),
                'modifiedtime'=>now(),
            ];

        }
        $userCourseCurriculumAnswerDataCreate=[
            'user_id'=>auth()->id(),
            'session_user_id'=>$request->cookies->get(config('app.SESSION_COOKIE_NAME')),
            'curriculum_id'=>$courseCurriculum->id,
            'curriculum_type'=>$courseCurriculum->type,
            'questions_count'=>$courseCurriculum->questions_count,
            'quetions_numbers'=>$courseCurriculum->questions_numbers,
            'question_time'=>$courseCurriculum->question_time,
            'right_answers'=>$writeAnswers,
            'wrong_answers'=>$wrongAnswers,
            'duration_time'=>$request->duration_time??'',
            'createdtime'=>now(),
            'added_date'=>now(),
            'course_id'=>$course->id,
            'ref'=>'website',
            'data_sent_json'=>$request->questions,
        ];
        $userCourseCurriculumAnswer=UsersCurriculumAnswer::create($userCourseCurriculumAnswerDataCreate);
        foreach ($userCourseCurriculumAnswerQuestionsCreate as $create){
            $create['answer_id']=$userCourseCurriculumAnswer->id;
            $userCourseCurriculumAnswerQuestion=UsersCurriculumQuestion::create($create);
            foreach ($create['details'] as $dCreate){
                $dCreate['user_quetion_id']=$userCourseCurriculumAnswerQuestion->id;
                UsersCurriculumQuestionsDetail::create($dCreate);
            }
        }
        $percentage=ceil(($userCourseCurriculumAnswer->right_answers/$userCourseCurriculumAnswer->quetions_numbers)*100);
        if($percentage>=50){
            $course->increment('certificate_increment');
            switch(strlen($course->certificate_increment)){
                case 1:
                    $serial= strtoupper($course->code).'000'.$course->certificate_increment;
                    break;
                case 2:
                    $serial= strtoupper($course->code).'00'.$course->certificate_increment;
                    break;
                case 3:
                    $serial= strtoupper($course->code).'0'.$course->certificate_increment;
                    break;
                case 4:
                    $serial= strtoupper($course->code).$course->certificate_increment;
                    break;
            }
            $array=['course_id'=>$course->id,'user_id'=>auth()->id()];
            if(!CoursesCurriculumCertificate::where($array)->count()){
                CoursesCurriculumCertificate::create(array_merge($array,[
                    'serial_number'=>$serial,
                    'user_name_en'=>auth()->user()->name_en,
                    'user_name'=>auth()->user()->FullName,
                    'session_user_id'=>$request->cookies->get(config('app.SESSION_COOKIE_NAME')),
                    'curriculum_id'=>$courseCurriculum->id,
                    'users_curriculum_answer_id'=>$userCourseCurriculumAnswer->id,
                    'createdtime'=>now(),
                    'added_date'=>now(),
                ]));
            }
        }
        return response()->json(['success'=>true,'message'=>__('Your exam ended successfully'),
            'redirect'=>route('course_exam_result_page',['url'=>$course->url,'id'=>$courseCurriculum->id,'resultId'=>$userCourseCurriculumAnswer->id])
        ]);
    }
    public function singleExamResult($url,$id,$resultId){
        $course=Course::where('published','yes')->where('url',$url)->firstOrFail();
        $courseCurriculum=CourseCurriculum::where('course_id',$course->id)->where('type','exam')->findOrFail($id);
        if(!auth()->check()){
            return redirect()->route('course_page',$course->url)->with('error',__('You must login first'));
        }
        if(!hasCourse($course->id)){
            return redirect()->route('course_page',$course->url)->with('error',__('You must subscribe first'));
        }
        $userCourseCurriculumAnswer=UsersCurriculumAnswer::where('curriculum_id',$courseCurriculum->id)->findOrFail($resultId);
        $certificate=CoursesCurriculumCertificate::where('course_id',$course->id)->where('user_id',auth()->id())->first();
        return view('frontend.exam_result',compact('course','courseCurriculum','userCourseCurriculumAnswer','certificate'));
    }
}
