<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Course;
use Illuminate\Http\Request;

class CategoriesPageController extends Controller
{
    //
    public function categoryCourses(Request $request,$url){
        $category=Category::where('published','yes')->where('url',$url)->firstOrFail();
        $courses=Course::where('published','yes')->whereRaw("id IN(SELECT course_id FROM courses_categories WHERE category_id=?)",[$category->id]);
        $coursesCount=clone $courses;
        $coursesCount=$coursesCount->count();
        if(request('search')){
            $courses=$courses->where(function($q){
               $q
                   ->where('name','LIKE','%'.request('search').'%')
                   ->orWhere('short_description','LIKE','%'.request('search').'%')
                   ->orWhere('description','LIKE','%'.request('search').'%')
                   ->orWhereHas('Instructor',function($q){
                       $q
                           ->where('name','LIKE','%'.request('search').'%')
                           ->orWhere('title','LIKE','%'.request('search').'%')
                           ->orWhere('short_description','LIKE','%'.request('search').'%')
                           ->orWhere('description','LIKE','%'.request('search').'%');
                   });
           });
        }
//        dd(getEloquentSqlWithBindings($courses));
        $courses=$courses->orderBy('sort','ASC')->paginate(8);
        return view('frontend.category_courses',compact('category','courses','coursesCount'));
    }
}
