<?php

function getEloquentSqlWithBindings($query)
{
    return vsprintf(str_replace('?', '%s', $query->toSql()), collect($query->getBindings())->map(function ($binding) {
        return is_numeric($binding) ? $binding : "'{$binding}'";
    })->toArray());
}
function fileNewName($name, $filePath)
{

    $actual_name = pathinfo(rawurlencode($name), PATHINFO_FILENAME);
    $original_name = rawurldecode($actual_name);
    $extension = pathinfo($name, PATHINFO_EXTENSION);
    $i = 1;
    while (file_exists($filePath . $name)) {
        $actual_name = (string)$original_name . '(' . $i . ')';
        $name = $actual_name . "." . $extension;
        $i++;
    }

    return $name;
}
function uploadImage($file,$folder_name='users',$input='image',$returnName='image'){
    $path = '/images/' . $folder_name . '/' . date('Y/m/d') . '/';
    if (!file_exists(public_path() . $path)) {
        File::makeDirectory(public_path() . $path, $mode = 0777, true, true);
    }
    //file new name
    //file old name
    $old_name = $file->getClientOriginalName();
    $mastername=fileNewName($old_name,$path);
    //convert the size of the file
    //$size = ImageUploader::GetSize($file->getSize());
    //get the mime type of the file
    $mimtype = $file->getMimeType();
    //making the new name with extension
    list($width, $height) = getimagesize($_FILES[$input]['tmp_name']);
    $file->move(public_path() . $path, $mastername);
    return[$returnName.'_dir'=>$path,$returnName=>$mastername,
        //'original_image'=>$old_name,'original_width'=>$width,'original_height'=>$height,'original_mimtype'=>$mimtype
    ];
}
function formatFilesize($bytes) {
    $units = ['B', 'KB', 'MB', 'GB', 'TB'];
    for ($i = 0; $bytes >= 1024 && $i < 4; $i++) {
        $bytes /= 1024;
    }
    return round($bytes, 2) . ' ' . $units[$i];
}
function public_website_path($path=''){
//    return str_replace('contivaadmin.','contivawebsite.',public_path($path));
    return public_path($path);
}
function website_url($path=''){
    return env('WEBSITE_URL').$path;
}
function getComponentFileName($key){
    if(str_contains($key,'editor')){
        return 'ckeditor5';
    }
    if(str_contains($key,'lucide_icon')){
        return 'lucide-icon';
    }

    if(str_contains($key,'image')||str_contains($key,'logo')){
        return 'file';
    }
    if(str_contains($key,'description')||str_contains($key,'text')){
        return 'textarea';
    }
    return 'input';
}
function getSetting($key=''){
    if($setting=\App\Models\Setting::where('key',$key)->first()){
        return $setting->value;
    }
    return null;
}
function getFirstLetterOfEachWord($text) {
    if (!is_string($text) || empty(trim($text))) {
        return "";
    }
    // تقسيم النص إلى كلمات بناءً على المسافات
    $words = preg_split('/\s+/', trim($text));

    // أخذ أول حرف من كل كلمة
    $letters = array_map(function($word) {
        return mb_substr($word, 0, 1);
    }, $words);

    // دمج الأحرف
    return implode('', $letters);
}
function hasCourse(){
    if(!auth()->check()){
        return false;
    }
    $date=now()->format('Y-m-d');
    $charge_transaction=\App\Models\ChargeTransaction::where('user_id',auth()->id())->whereRaw("'$date' BETWEEN DATE(start_date) AND DATE(end_date)")->where('suspend',0)->first();
    if($charge_transaction){
        return true;
    }
    return false;
}
